/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.query;

import java.util.Collection;
import java.util.Iterator;
import org.datanucleus.FetchPlan;
import org.datanucleus.ObjectManager;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.Extent;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.expression.BooleanExpression;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.query.Queryable;
import org.datanucleus.store.query.ResultObjectFactory;
import org.datanucleus.util.Localiser;

public class CollectionCandidates
implements Queryable {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.Localisation", (ClassLoader)(class$org$datanucleus$ObjectManagerFactoryImpl == null ? (class$org$datanucleus$ObjectManagerFactoryImpl = CollectionCandidates.class$("org.datanucleus.ObjectManagerFactoryImpl")) : class$org$datanucleus$ObjectManagerFactoryImpl).getClassLoader());
    private Collection userCandidates;
    private Extent extent;
    static /* synthetic */ Class class$org$datanucleus$ObjectManagerFactoryImpl;

    public CollectionCandidates(ObjectManager om, Class candidateClass, Collection candidates) {
        if (candidates == null) {
            throw new NucleusException(LOCALISER.msg("021072")).setFatal();
        }
        this.userCandidates = candidates;
        this.extent = om.getExtent(candidateClass, true);
    }

    public Collection getUserCandidates() {
        return this.userCandidates;
    }

    public FetchPlan getFetchPlan() {
        return this.extent.getFetchPlan();
    }

    public QueryExpression newQueryStatement() {
        return ((Queryable)this.extent).newQueryStatement();
    }

    public QueryExpression newQueryStatement(Class candidateClass, DatastoreIdentifier candidateAlias) {
        QueryExpression stmt = ((Queryable)this.extent).newQueryStatement(candidateClass, candidateAlias);
        ObjectManager om = this.extent.getObjectManager();
        MappedStoreManager storeMgr = (MappedStoreManager)om.getStoreManager();
        JavaTypeMapping m = storeMgr.getDatastoreClass(candidateClass.getName(), om.getClassLoaderResolver()).getIDMapping();
        BooleanExpression elementsExpr = null;
        Iterator it = this.userCandidates.iterator();
        while (it.hasNext()) {
            Object candidateValue = it.next();
            ScalarExpression expr = m.newScalarExpression(stmt, stmt.getMainTableExpression());
            BooleanExpression keyExpr = expr.eq(m.newLiteral(stmt, candidateValue));
            if (elementsExpr == null) {
                elementsExpr = keyExpr;
                continue;
            }
            elementsExpr = elementsExpr.ior(keyExpr);
        }
        if (elementsExpr != null) {
            stmt.andCondition(elementsExpr, true);
        }
        return stmt;
    }

    public ResultObjectFactory newResultObjectFactory(QueryExpression stmt, boolean ignoreCache, Class resultClass, boolean useFetchPlan) {
        return ((Queryable)this.extent).newResultObjectFactory(stmt, ignoreCache, resultClass, useFetchPlan);
    }

    public boolean isEmpty() {
        return this.userCandidates.isEmpty();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

