/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.mapping;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ObjectManager;
import org.datanucleus.ObjectManagerHelper;
import org.datanucleus.StateManager;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.EmbeddedMetaData;
import org.datanucleus.metadata.FieldPersistenceModifier;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.state.StateManagerFactory;
import org.datanucleus.store.mapped.DatastoreAdapter;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreField;
import org.datanucleus.store.mapped.expression.LogicSetExpression;
import org.datanucleus.store.mapped.expression.ObjectExpression;
import org.datanucleus.store.mapped.expression.ObjectLiteral;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.mapping.BigIntegerMapping;
import org.datanucleus.store.mapped.mapping.DatastoreMapping;
import org.datanucleus.store.mapped.mapping.EmbeddedPCMapping;
import org.datanucleus.store.mapped.mapping.IntegerMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.LongMapping;
import org.datanucleus.store.mapped.mapping.ShortMapping;
import org.datanucleus.store.mapped.mapping.SimpleDatastoreRepresentation;
import org.datanucleus.store.mapped.mapping.SingleFieldMapping;

public abstract class EmbeddedMapping
extends SingleFieldMapping
implements SimpleDatastoreRepresentation {
    protected List javaTypeMappings;
    protected ClassLoaderResolver clr;
    protected EmbeddedMetaData emd;
    protected String typeName;
    protected int objectType = -1;
    protected AbstractClassMetaData embCmd = null;

    public void initialize(DatastoreAdapter dba, AbstractMemberMetaData fmd, DatastoreContainerObject container, ClassLoaderResolver clr) {
        throw new NucleusException("subclass must override this method").setFatal();
    }

    public void initialize(DatastoreAdapter dba, AbstractMemberMetaData fmd, DatastoreContainerObject datastoreContainer, ClassLoaderResolver clr, EmbeddedMetaData emd, String typeName, int objectType) {
        super.initialize(dba, fmd, datastoreContainer, clr);
        this.clr = clr;
        this.emd = emd;
        this.typeName = typeName;
        this.objectType = objectType;
        MetaDataManager mmgr = fmd.getAbstractClassMetaData().getMetaDataManager();
        AbstractClassMetaData pcCmd = mmgr.getMetaDataForClass(typeName, clr);
        if (pcCmd == null) {
            if (fmd != null) {
                String[] fieldTypes = fmd.getFieldTypes();
                if (fieldTypes != null && fieldTypes.length == 1) {
                    pcCmd = mmgr.getMetaDataForClass(fieldTypes[0], clr);
                } else if (fieldTypes != null && fieldTypes.length > 1) {
                    throw new NucleusUserException("Field " + fmd.getFullFieldName() + " is a reference field that is embedded. " + "JPOX doesnt support embedded reference fields that have more than 1 implementation");
                }
            }
            if (pcCmd == null && (pcCmd = mmgr.getMetaDataForInterface(clr.classForName(typeName), clr)) == null && fmd.getFieldTypes() != null && fmd.getFieldTypes().length == 1) {
                pcCmd = mmgr.getMetaDataForInterface(clr.classForName(fmd.getFieldTypes()[0]), clr);
            }
        }
        this.embCmd = pcCmd;
        AbstractMemberMetaData[] embFmds = emd == null && pcCmd.isEmbeddedOnly() ? pcCmd.getManagedMembers() : emd.getFieldMetaData();
        int[] pcFieldNumbers = pcCmd.getAllMemberPositions();
        for (int i = 0; i < pcFieldNumbers.length; ++i) {
            AbstractMemberMetaData pcFmd = pcCmd.getMetaDataForManagedMemberAtAbsolutePosition(pcFieldNumbers[i]);
            if (pcFmd.getPersistenceModifier() != FieldPersistenceModifier.PERSISTENT || emd != null && emd.getOwnerMember() != null && emd.getOwnerMember().equals(pcFmd.getName())) continue;
            AbstractMemberMetaData embeddedFmd = null;
            for (int j = 0; j < embFmds.length; ++j) {
                if (embFmds[j] == null) {
                    throw new RuntimeException("embFmds[j] is null" + pcCmd.toString() + " type " + typeName);
                }
                if (pcCmd.getMetaDataForMember(embFmds[j].getName()) == null) {
                    throw new RuntimeException("pcCmd.getField(embFmds[j].getName()) is null" + pcCmd.toString() + " type " + typeName + " embFmds[j].getName() " + embFmds[j].getName());
                }
                if (pcCmd.getMetaDataForMember(embFmds[j].getName()).getAbsoluteFieldNumber() != pcFieldNumbers[i]) continue;
                embeddedFmd = embFmds[j];
                break;
            }
            JavaTypeMapping embFmdMapping = embeddedFmd != null ? dba.getMappingManager().getMapping(datastoreContainer, embeddedFmd, dba, clr, 0) : dba.getMappingManager().getMapping(datastoreContainer, pcFmd, dba, clr, 0);
            this.addJavaTypeMapping(embFmdMapping);
            for (int j = 0; j < embFmdMapping.getNumberOfDatastoreFields(); ++j) {
                DatastoreField datastoreFld;
                DatastoreMapping datastoreMapping = embFmdMapping.getDataStoreMapping(j);
                this.addDataStoreMapping(datastoreMapping);
                if (!fmd.isPrimaryKey() || (datastoreFld = datastoreMapping.getDatastoreField()) == null) continue;
                datastoreFld.setAsPrimaryKey();
            }
        }
    }

    protected void prepareDatastoreMapping() {
    }

    public void addJavaTypeMapping(JavaTypeMapping mapping) {
        if (this.javaTypeMappings == null) {
            this.javaTypeMappings = new ArrayList();
        }
        if (mapping == null) {
            throw new NucleusException("mapping argument in EmbeddedMapping.addJavaTypeMapping is null").setFatal();
        }
        this.javaTypeMappings.add(mapping);
    }

    public int getNumberOfJavaTypeMappings() {
        return this.javaTypeMappings != null ? this.javaTypeMappings.size() : 0;
    }

    public JavaTypeMapping getJavaTypeMapping(int i) {
        if (this.javaTypeMappings == null) {
            return null;
        }
        return (JavaTypeMapping)this.javaTypeMappings.get(i);
    }

    public JavaTypeMapping getJavaTypeMapping(String fieldName) {
        if (this.javaTypeMappings == null) {
            return null;
        }
        Iterator iter = this.javaTypeMappings.iterator();
        while (iter.hasNext()) {
            JavaTypeMapping m = (JavaTypeMapping)iter.next();
            if (!m.getFieldMetaData().getName().equals(fieldName)) continue;
            return m;
        }
        return null;
    }

    public void setObject(ObjectManager om, Object ps, int[] param, Object value) {
        this.setObject(om, ps, param, value, null, -1);
    }

    public void setObject(ObjectManager om, Object ps, int[] param, Object value, StateManager ownerSM, int ownerFieldNumber) {
        if (value == null) {
            int n = 0;
            String nullColumn = null;
            String nullValue = null;
            if (this.emd != null) {
                nullColumn = this.emd.getNullIndicatorColumn();
                nullValue = this.emd.getNullIndicatorValue();
            }
            for (int i = 0; i < this.javaTypeMappings.size(); ++i) {
                JavaTypeMapping mapping = (JavaTypeMapping)this.javaTypeMappings.get(i);
                int[] posMapping = new int[mapping.getNumberOfDatastoreFields()];
                for (int j = 0; j < posMapping.length; ++j) {
                    posMapping[j] = param[n++];
                }
                if (nullColumn != null && nullValue != null && mapping.getFieldMetaData().getColumnMetaData().length > 0 && mapping.getFieldMetaData().getColumnMetaData()[0].getName().equals(nullColumn)) {
                    if (mapping instanceof IntegerMapping || mapping instanceof BigIntegerMapping || mapping instanceof LongMapping || mapping instanceof ShortMapping) {
                        Number convertedValue = null;
                        try {
                            if (mapping instanceof IntegerMapping || mapping instanceof ShortMapping) {
                                convertedValue = new Integer(nullValue);
                            } else if (mapping instanceof LongMapping || mapping instanceof BigIntegerMapping) {
                                convertedValue = new Long(nullValue);
                            }
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        mapping.setObject(om, ps, posMapping, convertedValue);
                        continue;
                    }
                    mapping.setObject(om, ps, posMapping, nullValue);
                    continue;
                }
                if (mapping.getNumberOfDatastoreFields() <= 0) continue;
                mapping.setObject(om, ps, posMapping, null);
            }
        } else {
            ApiAdapter api = om.getApiAdapter();
            if (!api.isPersistable(value)) {
                throw new NucleusException(JavaTypeMapping.LOCALISER.msg("041016", value.getClass(), value)).setFatal();
            }
            AbstractClassMetaData embCmd = om.getMetaDataManager().getMetaDataForClass(value.getClass(), om.getClassLoaderResolver());
            StateManager embSM = om.findStateManager(value);
            if (embSM == null || ObjectManagerHelper.getObjectManager((Object)value) == null) {
                embSM = StateManagerFactory.newStateManagerForEmbedded((ObjectManager)om, (Object)value, (boolean)false);
                embSM.addEmbeddedOwner(ownerSM, ownerFieldNumber);
                embSM.setPcObjectType(this.objectType);
            }
            int n = 0;
            for (int i = 0; i < this.javaTypeMappings.size(); ++i) {
                JavaTypeMapping mapping = (JavaTypeMapping)this.javaTypeMappings.get(i);
                int[] posMapping = new int[mapping.getNumberOfDatastoreFields()];
                for (int j = 0; j < posMapping.length; ++j) {
                    posMapping[j] = param[n++];
                }
                int embAbsFieldNum = embCmd.getAbsolutePositionOfMember(mapping.getFieldMetaData().getName());
                Object fieldValue = embSM.provideField(embAbsFieldNum);
                if (mapping instanceof EmbeddedPCMapping) {
                    mapping.setObject(om, ps, posMapping, fieldValue, embSM, embAbsFieldNum);
                    continue;
                }
                if (mapping.getNumberOfDatastoreFields() <= 0) continue;
                mapping.setObject(om, ps, posMapping, fieldValue);
            }
        }
    }

    public Object getObject(ObjectManager om, Object rs, int[] param) {
        return this.getObject(om, rs, param, null, -1);
    }

    public Object getObject(ObjectManager om, Object rs, int[] param, StateManager ownerSM, int ownerFieldNumber) {
        int ownerFieldNumberInElement;
        String ownerField;
        Object value = null;
        Class embeddedType = this.getJavaType();
        if (this.fmd.getFieldTypes() != null && this.fmd.getFieldTypes().length > 0) {
            embeddedType = om.getClassLoaderResolver().classForName(this.fmd.getFieldTypes()[0]);
        }
        StateManager embSM = StateManagerFactory.newStateManagerForHollow((ObjectManager)om, (Class)embeddedType, (Object)null);
        embSM.setPcObjectType(this.objectType);
        value = embSM.getObject();
        String nullColumn = null;
        String nullValue = null;
        if (this.emd != null) {
            nullColumn = this.emd.getNullIndicatorColumn();
            nullValue = this.emd.getNullIndicatorValue();
        }
        int n = 0;
        for (int i = 0; i < this.javaTypeMappings.size(); ++i) {
            JavaTypeMapping mapping = (JavaTypeMapping)this.javaTypeMappings.get(i);
            int embAbsFieldNum = this.embCmd.getAbsolutePositionOfMember(mapping.getFieldMetaData().getName());
            if (mapping instanceof EmbeddedPCMapping) {
                int numSubParams = mapping.getNumberOfDatastoreFields();
                int[] subParam = new int[numSubParams];
                int k = 0;
                for (int j = n; j < n + numSubParams; ++j) {
                    subParam[k++] = param[j];
                }
                n += numSubParams;
                Object subValue = mapping.getObject(om, rs, subParam, embSM, embAbsFieldNum);
                if (subValue == null) continue;
                embSM.replaceField(embAbsFieldNum, subValue, true);
                continue;
            }
            int[] posMapping = new int[mapping.getNumberOfDatastoreFields()];
            for (int j = 0; j < posMapping.length; ++j) {
                posMapping[j] = param[n++];
            }
            Object fieldValue = mapping.getObject(om, rs, posMapping);
            if (fieldValue != null) {
                embSM.replaceField(embAbsFieldNum, fieldValue, true);
            } else {
                AbstractMemberMetaData embFmd = this.embCmd.getMetaDataForManagedMemberAtAbsolutePosition(embAbsFieldNum);
                if (!embFmd.getType().isPrimitive()) {
                    embSM.replaceField(embAbsFieldNum, fieldValue, true);
                }
            }
            if (nullColumn == null || !mapping.getFieldMetaData().getColumnMetaData()[0].getName().equals(nullColumn) || (nullValue != null || fieldValue != null) && (nullValue == null || !fieldValue.toString().equals(nullValue))) continue;
            value = null;
            break;
        }
        if (this.emd != null && (ownerField = this.emd.getOwnerMember()) != null && (ownerFieldNumberInElement = this.embCmd.getAbsolutePositionOfMember(ownerField)) >= 0) {
            embSM.replaceField(ownerFieldNumberInElement, ownerSM.getObject(), true);
        }
        if (value != null && ownerSM != null) {
            embSM.addEmbeddedOwner(ownerSM, ownerFieldNumber);
        }
        return value;
    }

    public Object getSampleValue(ClassLoaderResolver clr) {
        return null;
    }

    public Class getJavaType() {
        return this.clr.classForName(this.typeName);
    }

    public ScalarExpression newLiteral(QueryExpression qs, Object value) {
        ObjectLiteral expr = new ObjectLiteral(qs, this, value, this.getType());
        return expr;
    }

    public ScalarExpression newScalarExpression(QueryExpression qs, LogicSetExpression te) {
        ObjectExpression expr = new ObjectExpression(qs, this, te);
        return expr;
    }
}

