/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.query;

import java.util.Iterator;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.query.StatementText;
import org.datanucleus.store.rdbms.query.QueryStatement;

public class SAPDBQueryStatement
extends QueryStatement {
    private int[] orderingColumnIndexes;

    public SAPDBQueryStatement(DatastoreContainerObject initialTable, ClassLoaderResolver clr) {
        super(initialTable, clr);
    }

    public SAPDBQueryStatement(DatastoreContainerObject initialTable, DatastoreIdentifier alias, ClassLoaderResolver clr) {
        super(initialTable, alias, clr);
    }

    protected StatementText generateOrderingStatement() {
        StatementText orderByStmt = null;
        if (this.orderingExpressions != null && this.orderingExpressions.length > 0) {
            orderByStmt = new StatementText();
            for (int i = 0; i < this.orderingExpressions.length; ++i) {
                if (i > 0) {
                    orderByStmt.append(',');
                }
                orderByStmt.append(Integer.toString(this.orderingColumnIndexes[i]));
                if (!this.orderingDirections[i]) continue;
                orderByStmt.append(" DESC");
            }
        }
        return orderByStmt;
    }

    protected void addOrderingColumnsToSelect() {
        if (this.orderingExpressions != null) {
            this.orderingColumnIndexes = new int[this.orderingExpressions.length];
            for (int i = 0; i < this.orderingExpressions.length; ++i) {
                this.selected.add(this.orderingExpressions[i].toStatementText(ScalarExpression.PROJECTION));
                this.orderingColumnIndexes[i] = this.selected.size();
                Iterator iterator = this.union.iterator();
                while (iterator.hasNext()) {
                    QueryStatement qs = (QueryStatement)iterator.next();
                    qs.selectScalarExpression(this.orderingExpressions[i]);
                }
            }
        }
    }
}

