/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.expression;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.mapped.expression.NullLiteral;
import org.datanucleus.store.mapped.expression.NumericExpression;
import org.datanucleus.store.mapped.expression.ObjectExpression;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.mapping.IntegerMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.ShortMapping;

public class AggregateExpression
extends NumericExpression {
    boolean distinct = false;
    static /* synthetic */ Class class$java$lang$Long;

    public AggregateExpression(QueryExpression qs) {
        super(qs);
    }

    protected AggregateExpression(JavaTypeMapping mapping, String functionName, List args, boolean distinct) {
        super(functionName, args);
        this.st.clearStatement();
        this.st.append(functionName).append('(');
        if (distinct) {
            this.st.append("DISTINCT ");
        }
        ListIterator i = args.listIterator();
        ScalarExpression arg = (ScalarExpression)i.next();
        this.te = arg.getLogicSetExpression();
        this.st.append(arg);
        while (i.hasNext()) {
            arg = (ScalarExpression)i.next();
            this.st.append(',').append(arg);
        }
        this.st.append(')');
        this.expressionList.addExpression(this);
        this.mapping = mapping;
    }

    public void setDistinct() {
        this.distinct = true;
    }

    public ScalarExpression maxMethod(ScalarExpression expr) {
        if (this.distinct) {
            throw new NucleusUserException(ScalarExpression.LOCALISER.msg("037012", (Object)"MAX"));
        }
        return this.getFunctionExpression("MAX", expr, expr.getMapping());
    }

    public ScalarExpression minMethod(ScalarExpression expr) {
        if (this.distinct) {
            throw new NucleusUserException(ScalarExpression.LOCALISER.msg("037012", (Object)"MIN"));
        }
        return this.getFunctionExpression("MIN", expr, expr.getMapping());
    }

    public ScalarExpression sumMethod(ScalarExpression expr) {
        if (!(expr instanceof NumericExpression)) {
            throw new NucleusUserException(ScalarExpression.LOCALISER.msg("037011", (Object)"SUM"));
        }
        JavaTypeMapping sumMapping = expr.getMapping();
        if (sumMapping instanceof IntegerMapping || sumMapping instanceof ShortMapping) {
            sumMapping = this.qs.getStoreManager().getDatastoreAdapter().getMapping(class$java$lang$Long == null ? (class$java$lang$Long = AggregateExpression.class$("java.lang.Long")) : class$java$lang$Long, this.qs.getStoreManager(), this.qs.getClassLoaderResolver());
        }
        return this.getFunctionExpression("SUM", expr, sumMapping);
    }

    public ScalarExpression avgMethod(ScalarExpression expr) {
        return this.getFunctionExpression("AVG", expr, expr.getMapping());
    }

    public ScalarExpression countMethod(ScalarExpression expr) {
        if (expr instanceof ObjectExpression && expr.getMapping().getNumberOfDatastoreFields() > 1) {
            ((ObjectExpression)expr).useFirstDatastoreFieldOnly();
        }
        return this.getFunctionExpression("COUNT", expr, this.qs.getStoreManager().getDatastoreAdapter().getMapping(class$java$lang$Long == null ? (class$java$lang$Long = AggregateExpression.class$("java.lang.Long")) : class$java$lang$Long, this.qs.getStoreManager(), this.qs.getClassLoaderResolver()));
    }

    private ScalarExpression getFunctionExpression(String functionName, ScalarExpression expr, JavaTypeMapping mapping) {
        if (expr == null) {
            return new NullLiteral(this.qs);
        }
        ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
        args.add(expr);
        AggregateExpression numExpr = new AggregateExpression(mapping, functionName, args, this.distinct);
        return numExpr;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

