/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.table;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.ColumnMetaDataContainer;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.metadata.IdentityStrategy;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.MetaData;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.plugin.ConfigurationElement;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreField;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.MappingConsumer;
import org.datanucleus.store.mapped.mapping.OIDMapping;
import org.datanucleus.store.mapped.mapping.PersistenceCapableMapping;
import org.datanucleus.store.rdbms.RDBMSManager;
import org.datanucleus.store.rdbms.table.AbstractTable;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.store.rdbms.table.TableImpl;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public abstract class AbstractClassTable
extends TableImpl {
    protected Map fieldMappingsMap = new HashMap();
    protected JavaTypeMapping datastoreIDMapping;
    protected JavaTypeMapping[] pkMappings;
    protected JavaTypeMapping idMapping;
    protected JavaTypeMapping versionMapping;
    protected VersionMetaData versionMetaData;
    protected DiscriminatorMetaData discriminatorMetaData;
    protected JavaTypeMapping discriminatorMapping;
    protected int highestFieldNumber = 0;
    static /* synthetic */ Class class$org$datanucleus$identity$OID;
    static /* synthetic */ Class class$java$lang$Long;

    public AbstractClassTable(DatastoreIdentifier tableName, RDBMSManager storeMgr) {
        super(tableName, storeMgr);
    }

    public DatastoreContainerObject getPrimaryDatastoreContainerObject() {
        return this;
    }

    protected abstract void initializePK(ClassLoaderResolver var1);

    public boolean managesField(String fieldName) {
        if (fieldName == null) {
            return false;
        }
        return this.getMappingForFieldName(fieldName) != null;
    }

    protected JavaTypeMapping getMappingForFieldName(String fieldName) {
        Set fields = this.fieldMappingsMap.keySet();
        Iterator fieldsIter = fields.iterator();
        while (fieldsIter.hasNext()) {
            AbstractMemberMetaData fmd = (AbstractMemberMetaData)fieldsIter.next();
            if (!fmd.getFullFieldName().equals(fieldName)) continue;
            return (JavaTypeMapping)this.fieldMappingsMap.get(fmd);
        }
        return null;
    }

    final void addApplicationIdUsingClassTableId(ColumnMetaDataContainer columnContainer, DatastoreClass refTable, ClassLoaderResolver clr, AbstractClassMetaData cmd) {
        ColumnMetaData[] userdefinedCols = null;
        int nextUserdefinedCol = 0;
        if (columnContainer != null) {
            userdefinedCols = columnContainer.getColumnMetaData();
        }
        this.pkMappings = new JavaTypeMapping[cmd.getPKMemberPositions().length];
        for (int i = 0; i < cmd.getPKMemberPositions().length; ++i) {
            AbstractMemberMetaData fmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(cmd.getPKMemberPositions()[i]);
            JavaTypeMapping mapping = refTable.getFieldMapping(fmd);
            if (mapping == null) {
                throw new NucleusUserException("Cannot find mapping for field " + fmd.getFullFieldName() + " in table " + ((Object)refTable).toString() + " " + StringUtils.objectArrayToString((Object[])refTable.getDatastoreFieldsMetaData()));
            }
            JavaTypeMapping masterMapping = this.dba.getMapping(clr.classForName(mapping.getType()), this.storeMgr);
            masterMapping.setFieldInformation(fmd, this);
            this.pkMappings[i] = masterMapping;
            for (int j = 0; j < mapping.getNumberOfDatastoreFields(); ++j) {
                JavaTypeMapping m = masterMapping;
                DatastoreField refColumn = mapping.getDataStoreMapping(j).getDatastoreField();
                if (mapping instanceof PersistenceCapableMapping) {
                    m = this.dba.getMapping(clr.classForName(refColumn.getMapping().getType()), this.storeMgr);
                    ((PersistenceCapableMapping)masterMapping).addJavaTypeMapping(m);
                }
                ColumnMetaData userdefinedColumn = null;
                if (userdefinedCols != null) {
                    for (int k = 0; k < userdefinedCols.length; ++k) {
                        if (!((Object)refColumn.getIdentifier()).toString().equals(userdefinedCols[k].getTarget())) continue;
                        userdefinedColumn = userdefinedCols[k];
                        break;
                    }
                    if (userdefinedColumn == null && nextUserdefinedCol < userdefinedCols.length) {
                        userdefinedColumn = userdefinedCols[nextUserdefinedCol++];
                    }
                }
                DatastoreField idColumn = null;
                idColumn = userdefinedColumn != null ? this.addDatastoreField(refColumn.getStoredJavaType(), this.storeMgr.getIdentifierFactory().newIdentifier(1, userdefinedColumn.getName()), m, refColumn.getMetaData()) : this.addDatastoreField(refColumn.getStoredJavaType(), refColumn.getIdentifier(), m, refColumn.getMetaData());
                if (mapping != null && mapping.getDataStoreMapping(j).getDatastoreField().getMetaData() != null) {
                    refColumn.copyConfigurationTo(idColumn);
                }
                idColumn.setAsPrimaryKey();
                this.getStoreManager().getMappingManager().createDatastoreMapping(m, this.storeMgr, idColumn, refColumn.getMapping().getType());
            }
            int absoluteFieldNumber = fmd.getAbsoluteFieldNumber();
            if (absoluteFieldNumber <= this.highestFieldNumber) continue;
            this.highestFieldNumber = absoluteFieldNumber;
        }
    }

    void addDatastoreId(ColumnMetaDataContainer columnContainer, DatastoreClass refTable, AbstractClassMetaData cmd) {
        this.datastoreIDMapping = new OIDMapping();
        this.datastoreIDMapping.initialize(this.dba, cmd.getFullClassName());
        ColumnMetaData colmd = null;
        colmd = columnContainer == null ? new ColumnMetaData(null, (String)null) : (columnContainer.getColumnMetaData().length < 1 ? new ColumnMetaData((MetaData)columnContainer, (String)null) : columnContainer.getColumnMetaData()[0]);
        if (colmd.getName() == null) {
            if (refTable != null) {
                colmd.setName(this.storeMgr.getIdentifierFactory().newDatastoreFieldIdentifier(refTable.getIdentifier().getIdentifier(), this.storeMgr.getOMFContext().getTypeManager().isDefaultEmbeddedType(class$org$datanucleus$identity$OID == null ? (class$org$datanucleus$identity$OID = AbstractClassTable.class$("org.datanucleus.identity.OID")) : class$org$datanucleus$identity$OID), 1).getIdentifier());
            } else {
                colmd.setName(this.storeMgr.getIdentifierFactory().newDatastoreFieldIdentifier(this.identifier.getIdentifier(), this.storeMgr.getOMFContext().getTypeManager().isDefaultEmbeddedType(class$org$datanucleus$identity$OID == null ? (class$org$datanucleus$identity$OID = AbstractClassTable.class$("org.datanucleus.identity.OID")) : class$org$datanucleus$identity$OID), 0).getIdentifier());
            }
        }
        Column idColumn = (Column)this.addDatastoreField((class$org$datanucleus$identity$OID == null ? (class$org$datanucleus$identity$OID = AbstractClassTable.class$("org.datanucleus.identity.OID")) : class$org$datanucleus$identity$OID).getName(), this.storeMgr.getIdentifierFactory().newIdentifier(1, colmd.getName()), this.datastoreIDMapping, (MetaData)colmd);
        idColumn.setAsPrimaryKey();
        String strategyName = cmd.getIdentityMetaData().getValueStrategy().toString();
        if (cmd.getIdentityMetaData().getValueStrategy().equals((Object)IdentityStrategy.CUSTOM)) {
            strategyName = cmd.getIdentityMetaData().getValueStrategy().getCustomName();
        }
        Class poidClass = class$java$lang$Long == null ? (class$java$lang$Long = AbstractClassTable.class$("java.lang.Long")) : class$java$lang$Long;
        ConfigurationElement elem = this.storeMgr.getOMFContext().getPluginManager().getConfigurationElementForExtension("org.datanucleus.store_valuegenerator", new String[]{"name", "unique"}, new String[]{strategyName, "true"});
        if (elem == null) {
            elem = this.storeMgr.getOMFContext().getPluginManager().getConfigurationElementForExtension("org.datanucleus.store_valuegenerator", new String[]{"name", "datastore"}, new String[]{strategyName, this.storeMgr.getStoreManagerKey()});
        }
        if (elem != null) {
            String generatorClassName = elem.getAttribute("class-name");
            Class generatorClass = this.getStoreManager().getOMFContext().getClassLoaderResolver(null).classForName(generatorClassName);
            try {
                Method storageClassMethod = generatorClass.getMethod("getStorageClass", null);
                poidClass = (Class)storageClassMethod.invoke(null, null);
            }
            catch (Exception e) {
                NucleusLogger.VALUEGENERATION.warn((Object)("Error retrieving storage class for POID generator " + generatorClassName + " " + e.getMessage()));
            }
        }
        this.dba.getMappingManager().createDatastoreMapping(this.datastoreIDMapping, this.storeMgr, idColumn, poidClass.getName());
        if (this.isObjectIDDatastoreAttributed() && this instanceof DatastoreClass && ((DatastoreClass)((Object)this)).isBaseDatastoreClass()) {
            idColumn.setAutoIncrement(true);
        }
        if (idColumn.isAutoIncrement() && !this.dba.supportsOption("IdentityColumns")) {
            throw new NucleusException(AbstractTable.LOCALISER.msg("057020", (Object)cmd.getFullClassName(), (Object)"datastore-identity")).setFatal();
        }
    }

    protected void addFieldMapping(JavaTypeMapping fieldMapping) {
        AbstractMemberMetaData fmd = fieldMapping.getFieldMetaData();
        if (NucleusLogger.DATASTORE_SCHEMA.isDebugEnabled()) {
            StringBuffer columnsStr = new StringBuffer();
            for (int i = 0; i < fieldMapping.getNumberOfDatastoreFields(); ++i) {
                if (i > 0) {
                    columnsStr.append(",");
                }
                columnsStr.append(fieldMapping.getDataStoreMapping(i).getDatastoreField());
            }
            if (fieldMapping.getNumberOfDatastoreFields() == 0) {
                columnsStr.append("[none]");
            }
            StringBuffer datastoreMappingTypes = new StringBuffer();
            for (int i = 0; i < fieldMapping.getNumberOfDatastoreFields(); ++i) {
                if (i > 0) {
                    datastoreMappingTypes.append(',');
                }
                datastoreMappingTypes.append(fieldMapping.getDataStoreMapping(i).getClass().getName());
            }
            NucleusLogger.DATASTORE_SCHEMA.debug((Object)AbstractTable.LOCALISER.msg("057010", (Object)fmd.getFullFieldName(), (Object)columnsStr.toString(), (Object)fieldMapping.getClass().getName(), (Object)datastoreMappingTypes.toString()));
        }
        this.fieldMappingsMap.put(fmd, fieldMapping);
        int absoluteFieldNumber = fmd.getAbsoluteFieldNumber();
        if (absoluteFieldNumber > this.highestFieldNumber) {
            this.highestFieldNumber = absoluteFieldNumber;
        }
    }

    public abstract IdentityType getIdentityType();

    public abstract boolean isObjectIDDatastoreAttributed();

    public JavaTypeMapping getDataStoreObjectIdMapping() {
        this.assertIsInitialized();
        return this.datastoreIDMapping;
    }

    public JavaTypeMapping getVersionMapping(boolean allowSuperclasses) {
        return this.versionMapping;
    }

    public JavaTypeMapping getDiscriminatorMapping(boolean allowSuperclasses) {
        return this.discriminatorMapping;
    }

    public final void provideDatastoreIdMappings(MappingConsumer consumer) {
        consumer.preConsumeMapping(this.highestFieldNumber + 1);
        if (this.getIdentityType() == IdentityType.DATASTORE) {
            consumer.consumeMapping(this.getDataStoreObjectIdMapping(), 2);
        }
    }

    public abstract void providePrimaryKeyMappings(MappingConsumer var1);

    public final void provideNonPrimaryKeyMappings(MappingConsumer consumer) {
        consumer.preConsumeMapping(this.highestFieldNumber + 1);
        Set fieldNumbersSet = this.fieldMappingsMap.keySet();
        Iterator iter = fieldNumbersSet.iterator();
        while (iter.hasNext()) {
            AbstractMemberMetaData fmd = (AbstractMemberMetaData)iter.next();
            JavaTypeMapping fieldMapping = (JavaTypeMapping)this.fieldMappingsMap.get(fmd);
            if (fieldMapping == null || fmd.isPrimaryKey()) continue;
            consumer.consumeMapping(fieldMapping, fmd);
        }
    }

    public void provideMappingsForFields(MappingConsumer consumer, AbstractMemberMetaData[] fieldMetaData, boolean includeSecondaryTables) {
        consumer.preConsumeMapping(this.highestFieldNumber + 1);
        for (int i = 0; i < fieldMetaData.length; ++i) {
            JavaTypeMapping fieldMapping = (JavaTypeMapping)this.fieldMappingsMap.get(fieldMetaData[i]);
            if (fieldMapping == null || fieldMetaData[i].isPrimaryKey()) continue;
            consumer.consumeMapping(fieldMapping, fieldMetaData[i]);
        }
    }

    public final void provideVersionMappings(MappingConsumer consumer) {
        consumer.preConsumeMapping(this.highestFieldNumber + 1);
        if (this.getVersionMapping(false) != null) {
            consumer.consumeMapping(this.getVersionMapping(false), 1);
        }
    }

    public final void provideDiscriminatorMappings(MappingConsumer consumer) {
        consumer.preConsumeMapping(this.highestFieldNumber + 1);
        if (this.getDiscriminatorMapping(false) != null) {
            consumer.consumeMapping(this.getDiscriminatorMapping(false), 3);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

