/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.query2;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ManagedConnection;
import org.datanucleus.ObjectManager;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.query.compiler.QueryCompilation;
import org.datanucleus.query.evaluator.JDOQLEvaluator;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.query.StatementText;
import org.datanucleus.store.query.AbstractJDOQLQuery;
import org.datanucleus.store.query.AbstractJavaQuery;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.rdbms.RDBMSManager;
import org.datanucleus.store.rdbms.SQLController;
import org.datanucleus.store.rdbms.query.QueryStatement;
import org.datanucleus.store.rdbms.query.RDBMSQueryUtils;
import org.datanucleus.util.NucleusLogger;

public class JDOQLQuery2
extends AbstractJDOQLQuery {
    public JDOQLQuery2(ObjectManager om) {
        this(om, (JDOQLQuery2)null);
    }

    public JDOQLQuery2(ObjectManager om, JDOQLQuery2 q) {
        super(om, (AbstractJDOQLQuery)q);
    }

    public JDOQLQuery2(ObjectManager om, String query) {
        super(om, query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object performExecute(Map parameters) {
        ClassLoaderResolver clr = ((Query)this).om.getClassLoaderResolver();
        if (((AbstractJavaQuery)this).candidateCollection != null && ((AbstractJavaQuery)this).candidateCollection.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        boolean inMemory = false;
        String queryInMemoryStr = (String)this.getExtension("datanucleus.query.evaluateInMemory");
        if (queryInMemoryStr != null && queryInMemoryStr.equalsIgnoreCase("true")) {
            inMemory = true;
        }
        ManagedConnection mconn = ((Query)this).om.getStoreManager().getConnection(((Query)this).om);
        try {
            boolean orderingInMemory;
            boolean filterInMemory;
            ArrayList candidates;
            long startTime;
            block18: {
                block19: {
                    startTime = System.currentTimeMillis();
                    if (NucleusLogger.QUERY.isDebugEnabled()) {
                        NucleusLogger.QUERY.debug((Object)Query.LOCALISER.msg("021046", (Object)"JDOQL", (Object)this.getSingleStringQuery(), null));
                    }
                    candidates = null;
                    filterInMemory = false;
                    orderingInMemory = false;
                    if (((AbstractJavaQuery)this).candidateCollection != null) break block19;
                    if (inMemory) {
                        filterInMemory = true;
                        orderingInMemory = true;
                        break block18;
                    } else {
                        QueryStatement qs = this.getNativeQueryForCompiledQuery(((Query)this).compilation, parameters);
                        boolean useUpdateLock = RDBMSQueryUtils.useUpdateLockForQuery((Query)this);
                        StatementText stmtText = null;
                        if (((Query)this).type == 0) {
                            stmtText = qs.toStatementText(useUpdateLock);
                        } else {
                            if (((Query)this).type == 1) {
                                stmtText = qs.toUpdateStatementText();
                                throw new NucleusException("DataNucleus doesnt currently support bulk update statements");
                            }
                            if (((Query)this).type == 2) {
                                stmtText = qs.toDeleteStatementText();
                                throw new NucleusException("DataNucleus doesnt currently support bulk delete statements");
                            }
                        }
                        NucleusLogger.QUERY.debug((Object)(">> statement=" + stmtText));
                        try {
                            SQLController sqlControl = ((RDBMSManager)this.getStoreManager()).getSQLController();
                            PreparedStatement ps = RDBMSQueryUtils.getPreparedStatementForQuery(mconn, stmtText, (Query)this);
                            try {
                                RDBMSQueryUtils.prepareStatementForExecution(ps, (Query)this);
                                if (((Query)this).type == 0) {
                                    sqlControl.executeStatementQuery(mconn, stmtText.toString(), ps);
                                }
                                break block18;
                            }
                            catch (SQLException sqle) {
                                throw new NucleusException("Exception thrown in query", (Throwable)sqle);
                            }
                        }
                        catch (SQLException sqle) {
                            throw new NucleusException("Exception thrown in query", (Throwable)sqle);
                        }
                    }
                }
                candidates = new ArrayList(((AbstractJavaQuery)this).candidateCollection);
                filterInMemory = true;
                orderingInMemory = true;
            }
            JDOQLEvaluator resultMapper = new JDOQLEvaluator((Query)this, candidates, ((Query)this).compilation, clr);
            Collection results = resultMapper.execute(filterInMemory, orderingInMemory, true, true, true);
            if (NucleusLogger.QUERY.isDebugEnabled()) {
                NucleusLogger.QUERY.debug((Object)Query.LOCALISER.msg("021074", (Object)"JDOQL", (Object)("" + (System.currentTimeMillis() - startTime))));
            }
            Collection collection = results;
            return collection;
        }
        finally {
            mconn.release();
        }
    }

    private QueryStatement getNativeQueryForCompiledQuery(QueryCompilation compilation, Map parameters) {
        QueryStatement qs = null;
        RDBMSManager storeMgr = (RDBMSManager)this.getStoreManager();
        ClassLoaderResolver clr = this.getObjectManager().getClassLoaderResolver();
        if (((AbstractJavaQuery)this).candidateCollection == null) {
            DatastoreClass candidateTable = storeMgr.getDatastoreClass(((Query)this).candidateClass.getName(), clr);
            qs = new QueryStatement(candidateTable, clr);
            if (((Query)this).result != null) {
                // empty if block
            }
        }
        return qs;
    }
}

