/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManagerFactory;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.OMFContext;
import org.datanucleus.ObjectManager;
import org.datanucleus.ObjectManagerFactoryImpl;
import org.datanucleus.PersistenceConfiguration;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.jdo.JDOPersistenceManager;
import org.datanucleus.metadata.FileMetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.rdbms.RDBMSManager;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.CommandLine;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class SchemaTool
extends PersistenceConfiguration {
    private static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.store.rdbms.Localisation", (ClassLoader)(class$org$datanucleus$store$rdbms$RDBMSManager == null ? (class$org$datanucleus$store$rdbms$RDBMSManager = SchemaTool.class$("org.datanucleus.store.rdbms.RDBMSManager")) : class$org$datanucleus$store$rdbms$RDBMSManager).getClassLoader());
    private OMFContext omfContext = new OMFContext((PersistenceConfiguration)this);
    private CommandLine cmd = new CommandLine();
    private String[] defaultArgs;
    private String propsFileName = null;
    public static final int SCHEMATOOL_CREATE_MODE = 1;
    public static final int SCHEMATOOL_DELETE_MODE = 2;
    public static final int SCHEMATOOL_VALIDATE_MODE = 3;
    public static final int SCHEMATOOL_DATABASE_INFO_MODE = 4;
    public static final int SCHEMATOOL_SCHEMA_INFO_MODE = 5;
    public static final String SCHEMATOOL_OPTION_MODE = "datanucleus.schemaTool.mode";
    public static final String SCHEMATOOL_OPTION_VERBOSE = "datanucleus.schemaTool.verbose";
    public static final String SCHEMATOOL_OPTION_PROPERTIES_FILE = "datanucleus.schemaTool.propertiesFile";
    public static final String SCHEMATOOL_OPTION_DDLFILE = "datanucleus.schemaTool.ddlFile";
    public static final String SCHEMATOOL_OPTION_DUMPDDL = "datanucleus.schemaTool.dumpDdl";
    public static final String SCHEMATOOL_OPTION_COMPLETEDDL = "datanucleus.schemaTool.completeDdl";
    public static final String SCHEMATOOL_OPTION_HELP = "datanucleus.schemaTool.help";
    static /* synthetic */ Class class$org$datanucleus$store$rdbms$RDBMSManager;
    static /* synthetic */ Class class$org$datanucleus$jdo$JDOPersistenceManagerFactory;

    public static void main(String[] args) throws Exception {
        String ddlFilename;
        SchemaTool tool = new SchemaTool();
        tool.setCommandLineArgs(args);
        if (tool.isHelp()) {
            System.out.println(LOCALISER.msg(false, "014023"));
            System.out.println(LOCALISER.msg(false, "014024"));
            System.out.println(LOCALISER.msg(false, "014025"));
            System.out.println(tool.cmd.toString());
            System.out.println(LOCALISER.msg(false, "014034"));
            System.out.println(LOCALISER.msg(false, "014035"));
            System.exit(0);
        }
        int mode = 1;
        String msg = null;
        if (tool.getModeName() != null) {
            if (tool.getModeName().equals("create")) {
                mode = 1;
                msg = LOCALISER.msg(false, "014000", (Object)ObjectManagerFactoryImpl.getVersionNumber());
            } else if (tool.getModeName().equals("delete")) {
                mode = 2;
                msg = LOCALISER.msg(false, "014001", (Object)ObjectManagerFactoryImpl.getVersionNumber());
            } else if (tool.getModeName().equals("validate")) {
                mode = 3;
                msg = LOCALISER.msg(false, "014002", (Object)ObjectManagerFactoryImpl.getVersionNumber());
            } else if (tool.getModeName().equals("dbinfo")) {
                mode = 4;
                msg = LOCALISER.msg(false, "014003", (Object)ObjectManagerFactoryImpl.getVersionNumber());
            } else if (tool.getModeName().equals("schemainfo")) {
                mode = 5;
                msg = LOCALISER.msg(false, "014004", (Object)ObjectManagerFactoryImpl.getVersionNumber());
            }
        } else {
            msg = LOCALISER.msg(false, "014000", (Object)ObjectManagerFactoryImpl.getVersionNumber());
        }
        NucleusLogger.SCHEMATOOL.info((Object)msg);
        System.out.println(msg);
        msg = LOCALISER.msg(false, "014005");
        NucleusLogger.SCHEMATOOL.info((Object)msg);
        if (tool.isVerbose()) {
            System.out.println(msg);
        }
        StringTokenizer tokeniser = new StringTokenizer(System.getProperty("java.class.path"), File.pathSeparator);
        while (tokeniser.hasMoreTokens()) {
            msg = LOCALISER.msg(false, "014006", (Object)tokeniser.nextToken());
            NucleusLogger.SCHEMATOOL.info((Object)msg);
            if (!tool.isVerbose()) continue;
            System.out.println(msg);
        }
        if (tool.isVerbose()) {
            System.out.println();
        }
        if ((ddlFilename = tool.getDdlFile()) != null) {
            msg = LOCALISER.msg(false, tool.getCompleteDdl() ? "014018" : "014019", (Object)ddlFilename);
            NucleusLogger.SCHEMATOOL.info((Object)msg);
            if (tool.isVerbose()) {
                System.out.println(msg);
                System.out.println();
            }
        }
        PersistenceManagerFactory pmf = null;
        try {
            pmf = tool.getPropsFileName() != null ? SchemaTool.getPMFForMode(mode, tool.getApi(), tool.getOptions(), tool.getStringProperty("datanucleus.PersistenceUnitName"), ddlFilename, tool.isVerbose()) : SchemaTool.getPMFForMode(mode, tool.getApi(), null, tool.getStringProperty("datanucleus.PersistenceUnitName"), ddlFilename, tool.isVerbose());
        }
        catch (Exception e) {
            NucleusLogger.SCHEMATOOL.error((Object)"Error creating PMF", (Throwable)e);
            System.out.println(LOCALISER.msg(false, "014008", (Object)e.getMessage()));
            System.exit(1);
            return;
        }
        ArrayList<String> classNames = null;
        if (mode != 5 && mode != 4) {
            try {
                MetaDataManager metaDataMgr = ((ObjectManagerFactoryImpl)pmf).getOMFContext().getMetaDataManager();
                ClassLoaderResolver clr = ((ObjectManagerFactoryImpl)pmf).getOMFContext().getClassLoaderResolver(null);
                FileMetaData[] filemds = SchemaTool.getFileMetaDataForInput(metaDataMgr, clr, tool.isVerbose(), tool.getStringProperty("datanucleus.PersistenceUnitName"), tool.getDefaultArgs());
                classNames = new ArrayList<String>();
                if (filemds == null) {
                    msg = LOCALISER.msg(false, "014021");
                    NucleusLogger.SCHEMATOOL.error((Object)msg);
                    System.out.println(msg);
                    System.exit(2);
                    return;
                }
                for (int i = 0; i < filemds.length; ++i) {
                    for (int j = 0; j < filemds[i].getNoOfPackages(); ++j) {
                        for (int k = 0; k < filemds[i].getPackage(j).getNoOfClasses(); ++k) {
                            classNames.add(filemds[i].getPackage(j).getClass(k).getFullClassName());
                        }
                    }
                }
            }
            catch (Exception e) {
                System.exit(2);
                return;
            }
        }
        try {
            StoreManager srm;
            if (mode == 1) {
                SchemaTool.createSchema(pmf, classNames, ddlFilename, tool.getCompleteDdl());
            } else if (mode == 2) {
                SchemaTool.deleteSchema(pmf, classNames);
            } else if (mode == 3) {
                SchemaTool.validateSchema(pmf, classNames);
            } else if (mode == 4) {
                srm = ((JDOPersistenceManager)pmf.getPersistenceManager()).getObjectManager().getStoreManager();
                srm.printInformation("DATASTORE", System.out);
            } else if (mode == 5) {
                srm = ((JDOPersistenceManager)pmf.getPersistenceManager()).getObjectManager().getStoreManager();
                srm.printInformation("SCHEMA", System.out);
            }
            msg = LOCALISER.msg(false, "014043");
            NucleusLogger.SCHEMATOOL.info((Object)msg);
            System.out.println(msg);
        }
        catch (Exception e) {
            msg = LOCALISER.msg(false, "014037", (Object)e.getMessage());
            System.out.println(msg);
            NucleusLogger.SCHEMATOOL.error((Object)msg, (Throwable)e);
            System.exit(2);
            return;
        }
    }

    public SchemaTool() {
        this.cmd.addOption("create", "create", null, LOCALISER.msg(false, "014026"));
        this.cmd.addOption("delete", "delete", null, LOCALISER.msg(false, "014027"));
        this.cmd.addOption("validate", "validate", null, LOCALISER.msg(false, "014028"));
        this.cmd.addOption("dbinfo", "dbinfo", null, LOCALISER.msg(false, "014029"));
        this.cmd.addOption("schemainfo", "schemainfo", null, LOCALISER.msg(false, "014030"));
        this.cmd.addOption("ddlFile", "ddlFile", "ddlFile", LOCALISER.msg(false, "014031"));
        this.cmd.addOption("dumpDdl", "dumpDdl", "dumpDdl", LOCALISER.msg(false, "014031"));
        this.cmd.addOption("completeDdl", "completeDdl", null, LOCALISER.msg(false, "014032"));
        this.cmd.addOption("api", "api", "<adapter-name>", "API Adapter (JDO, JPA, etc)");
        this.cmd.addOption("help", "help", null, LOCALISER.msg(false, "014033"));
        this.cmd.addOption("v", "verbose", null, "verbose output");
        this.cmd.addOption("persistenceUnit", "persistenceUnit", "<persistence-unit>", "name of the persistence unit to handle the schema for");
        this.cmd.addOption("props", "properties", "props", "path to a properties file");
    }

    protected static PersistenceManagerFactory getPMFForMode(int mode, String api, Map userProps, String persistenceUnitName, String ddlFile, boolean verbose) {
        HashMap<Object, Object> props = new HashMap<Object, Object>();
        if (persistenceUnitName != null) {
            props.put("javax.jdo.option.PersistenceUnitName", persistenceUnitName);
        }
        if (userProps != null) {
            props.putAll(userProps);
        } else {
            String[] propNames = new String[]{"datanucleus.ConnectionURL", "datanucleus.ConnectionDriverName", "datanucleus.ConnectionUserName", "datanucleus.ConnectionPassword", "datanucleus.Mapping", "javax.jdo.option.ConnectionURL", "javax.jdo.option.ConnectionDriverName", "javax.jdo.option.ConnectionUserName", "javax.jdo.option.ConnectionPassword", "javax.jdo.option.Mapping"};
            for (int i = 0; i < propNames.length; ++i) {
                if (System.getProperty(propNames[i]) == null) continue;
                props.put(propNames[i], System.getProperty(propNames[i]));
            }
            if (persistenceUnitName == null && props.get("javax.jdo.option.ConnectionURL") == null && props.get("datanucleus.ConnectionURL") == null) {
                File file = new File(System.getProperty("user.home") + "/.jdo/PMFProperties.properties");
                if (file.exists()) {
                    try {
                        FileInputStream is = new FileInputStream(file);
                        Properties fileProps = new Properties();
                        fileProps.load(is);
                        props.putAll(fileProps);
                        ((InputStream)is).close();
                    }
                    catch (IOException ioe) {}
                } else {
                    throw new NucleusException(LOCALISER.msg("014041"));
                }
            }
        }
        props.put("javax.jdo.PersistenceManagerFactoryClass", (class$org$datanucleus$jdo$JDOPersistenceManagerFactory == null ? (class$org$datanucleus$jdo$JDOPersistenceManagerFactory = SchemaTool.class$("org.datanucleus.jdo.JDOPersistenceManagerFactory")) : class$org$datanucleus$jdo$JDOPersistenceManagerFactory).getName());
        props.put("datanucleus.persistenceApiName", api);
        props.put("datanucleus.autoStartMechanism", "None");
        if (mode == 1) {
            if (ddlFile != null) {
                props.put("datanucleus.validateConstraints", "false");
                props.put("datanucleus.validateColumns", "false");
                props.put("datanucleus.validateTables", "false");
            }
            props.put("datanucleus.autoCreateSchema", "true");
            props.put("datanucleus.autoCreateTables", "true");
            props.put("datanucleus.autoCreateConstraints", "true");
            props.put("datanucleus.fixedDatastore", "false");
            props.put("datanucleus.readOnlyDatastore", "false");
            props.put("datanucleus.rdbms.checkExistTablesOrViews", "true");
        } else if (mode == 2) {
            props.put("datanucleus.fixedDatastore", "false");
            props.put("datanucleus.readOnlyDatastore", "false");
        } else if (mode == 3) {
            props.put("datanucleus.autoCreateSchema", "false");
            props.put("datanucleus.autoCreateTables", "false");
            props.put("datanucleus.autoCreateConstraints", "false");
            props.put("datanucleus.autoCreateColumns", "false");
            props.put("datanucleus.validateTables", "true");
            props.put("datanucleus.validateColumns", "true");
            props.put("datanucleus.validateConstraints", "true");
        }
        if (verbose) {
            String msg = LOCALISER.msg(false, "014020");
            NucleusLogger.SCHEMATOOL.info((Object)msg);
            System.out.println(msg);
            Set keys = props.keySet();
            ArrayList keyNames = new ArrayList(keys);
            Collections.sort(keyNames);
            Iterator keyNamesIter = keyNames.iterator();
            while (keyNamesIter.hasNext()) {
                String key = (String)keyNamesIter.next();
                if (!key.startsWith("datanucleus") || key.equals("datanucleus.ConnectionPassword")) continue;
                msg = LOCALISER.msg(false, "014022", (Object)key, props.get(key));
                NucleusLogger.SCHEMATOOL.info((Object)msg);
                System.out.println(msg);
            }
            System.out.println();
        }
        return JDOHelper.getPersistenceManagerFactory(props);
    }

    protected static FileMetaData[] getFileMetaDataForInput(MetaDataManager metaDataMgr, ClassLoaderResolver clr, boolean verbose, String persistenceUnitName, String[] inputFiles) {
        FileMetaData[] filemds = null;
        String msg = null;
        if (inputFiles == null && persistenceUnitName == null) {
            msg = LOCALISER.msg(false, "014007");
            NucleusLogger.SCHEMATOOL.error((Object)msg);
            System.out.println(msg);
            throw new NucleusUserException(msg);
        }
        if (persistenceUnitName != null) {
            msg = LOCALISER.msg(false, "014015", (Object)persistenceUnitName);
            NucleusLogger.SCHEMATOOL.info((Object)msg);
            if (verbose) {
                System.out.println(msg);
                System.out.println();
            }
            filemds = metaDataMgr.getFileMetaData();
        } else {
            msg = LOCALISER.msg(false, "014009");
            NucleusLogger.SCHEMATOOL.info((Object)msg);
            if (verbose) {
                System.out.println(msg);
            }
            for (int i = 0; i < inputFiles.length; ++i) {
                String entry = LOCALISER.msg(false, "014010", (Object)inputFiles[i]);
                NucleusLogger.SCHEMATOOL.info((Object)entry);
                if (!verbose) continue;
                System.out.println(entry);
            }
            if (verbose) {
                System.out.println();
            }
            try {
                NucleusLogger.SCHEMATOOL.debug((Object)LOCALISER.msg(false, "014011", (Object)("" + inputFiles.length)));
                HashSet<String> metadataFiles = new HashSet<String>();
                HashSet<String> classNames = new HashSet<String>();
                for (int i = 0; i < inputFiles.length; ++i) {
                    if (inputFiles[i].endsWith(".class")) {
                        URL classFileURL = null;
                        try {
                            classFileURL = new URL("file:" + inputFiles[i]);
                        }
                        catch (Exception e) {
                            msg = LOCALISER.msg(false, "014013", (Object)inputFiles[i]);
                            NucleusLogger.SCHEMATOOL.error((Object)msg);
                            throw new NucleusUserException(msg);
                        }
                        String className = ClassUtils.getClassNameForFileURL((URL)classFileURL);
                        classNames.add(className);
                        continue;
                    }
                    metadataFiles.add(inputFiles[i]);
                }
                filemds = metaDataMgr.initialise(((AbstractCollection)metadataFiles).toArray(new String[metadataFiles.size()]), ((AbstractCollection)classNames).toArray(new String[classNames.size()]), clr);
                NucleusLogger.SCHEMATOOL.debug((Object)LOCALISER.msg(false, "014012", (Object)("" + inputFiles.length)));
            }
            catch (Exception e) {
                msg = LOCALISER.msg(false, "014014", (Object)e.getMessage());
                NucleusLogger.SCHEMATOOL.error((Object)msg, (Throwable)e);
                System.out.println(msg);
                if (e instanceof NucleusException) {
                    throw (NucleusException)((Object)e);
                }
                throw new NucleusUserException(msg, (Throwable)e);
            }
        }
        return filemds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createSchema(PersistenceManagerFactory pmf, List classNames, String ddlFilename, boolean completeDdl) throws Exception {
        if (classNames != null && classNames.size() > 0) {
            ObjectManager om = ((JDOPersistenceManager)pmf.getPersistenceManager()).getObjectManager();
            RDBMSManager storeMgr = (RDBMSManager)om.getStoreManager();
            OutputStreamWriter ddlFileWriter = null;
            if (ddlFilename != null) {
                File ddlFile = StringUtils.getFileForFilename((String)ddlFilename);
                if (ddlFile.exists()) {
                    ddlFile.delete();
                }
                if (ddlFile.getParentFile() != null && !ddlFile.getParentFile().exists()) {
                    ddlFile.getParentFile().mkdirs();
                }
                ddlFile.createNewFile();
                ddlFileWriter = new FileWriter(ddlFile);
                SimpleDateFormat fmt = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
                ddlFileWriter.write("------------------------------------------------------------------\n");
                ddlFileWriter.write("-- DataNucleus SchemaTool (version " + ObjectManagerFactoryImpl.getVersionNumber() + ")" + " ran at " + fmt.format(new Date()) + "\n");
                ddlFileWriter.write("------------------------------------------------------------------\n");
                if (completeDdl) {
                    ddlFileWriter.write("-- Complete schema required for the following classes:-\n");
                } else {
                    ddlFileWriter.write("-- Schema diff for " + pmf.getConnectionURL() + " and the following classes:-\n");
                }
                Iterator classNameIter = classNames.iterator();
                while (classNameIter.hasNext()) {
                    ddlFileWriter.write("--     " + classNameIter.next() + "\n");
                }
                ddlFileWriter.write("--\n");
            }
            try {
                String[] classNameArray = classNames.toArray(new String[classNames.size()]);
                storeMgr.addClasses(classNameArray, om.getClassLoaderResolver(), ddlFileWriter, completeDdl);
            }
            finally {
                if (ddlFileWriter != null) {
                    ddlFileWriter.close();
                }
            }
        } else {
            String msg = LOCALISER.msg(false, "014039");
            NucleusLogger.SCHEMATOOL.error((Object)msg);
            System.out.println(msg);
            throw new Exception(msg);
        }
    }

    public static void deleteSchema(PersistenceManagerFactory pmf, List classNames) throws Exception {
        if (classNames == null || classNames.size() <= 0) {
            String msg = LOCALISER.msg(false, "014039");
            NucleusLogger.SCHEMATOOL.info((Object)msg);
            System.out.println(msg);
            throw new Exception(msg);
        }
        ObjectManager om = ((JDOPersistenceManager)pmf.getPersistenceManager()).getObjectManager();
        StoreManager storeMgr = om.getStoreManager();
        String[] classNameArray = classNames.toArray(new String[classNames.size()]);
        storeMgr.addClasses(classNameArray, om.getClassLoaderResolver());
        storeMgr.removeAllClasses(om.getClassLoaderResolver());
    }

    public static void validateSchema(PersistenceManagerFactory pmf, List classNames) throws Exception {
        if (classNames == null || classNames.size() <= 0) {
            String msg = LOCALISER.msg(false, "014039");
            NucleusLogger.SCHEMATOOL.error((Object)msg);
            System.out.println(msg);
            throw new Exception(msg);
        }
        ObjectManager om = ((JDOPersistenceManager)pmf.getPersistenceManager()).getObjectManager();
        StoreManager storeMgr = om.getStoreManager();
        String[] classNameArray = classNames.toArray(new String[classNames.size()]);
        storeMgr.addClasses(classNameArray, om.getClassLoaderResolver());
    }

    public void setCommandLineArgs(String[] args) {
        this.cmd.parse(args);
        this.defaultArgs = this.cmd.getDefaultArgs();
        if (this.cmd.hasOption("api")) {
            this.omfContext.setApi(this.cmd.getOptionArg("api"));
            this.setApi(this.cmd.getOptionArg("api"));
        }
        this.setOptions(this.omfContext.getApiAdapter().getDefaultFactoryProperties());
        if (this.cmd.hasOption("create")) {
            this.setProperty(SCHEMATOOL_OPTION_MODE, "create");
        } else if (this.cmd.hasOption("delete")) {
            this.setProperty(SCHEMATOOL_OPTION_MODE, "delete");
        } else if (this.cmd.hasOption("validate")) {
            this.setProperty(SCHEMATOOL_OPTION_MODE, "validate");
        } else if (this.cmd.hasOption("dbinfo")) {
            this.setProperty(SCHEMATOOL_OPTION_MODE, "dbinfo");
        } else if (this.cmd.hasOption("schemainfo")) {
            this.setProperty(SCHEMATOOL_OPTION_MODE, "schemainfo");
        }
        if (this.cmd.hasOption("help")) {
            this.setProperty(SCHEMATOOL_OPTION_HELP, "true");
        }
        if (this.cmd.hasOption("ddlFile")) {
            this.setProperty(SCHEMATOOL_OPTION_DDLFILE, this.cmd.getOptionArg("ddlFile"));
        }
        if (this.cmd.hasOption("dumpDdl")) {
            this.setProperty(SCHEMATOOL_OPTION_DDLFILE, this.cmd.getOptionArg("dumpDdl"));
        }
        if (this.cmd.hasOption("completeDdl")) {
            this.setProperty(SCHEMATOOL_OPTION_COMPLETEDDL, "true");
        }
        if (this.cmd.hasOption("persistenceUnit")) {
            this.setProperty("datanucleus.PersistenceUnitName", this.cmd.getOptionArg("persistenceUnit"));
        }
        if (this.cmd.hasOption("props")) {
            this.propsFileName = this.cmd.getOptionArg("props");
            this.setProperty("datanucleus.propertiesFile", this.propsFileName);
        }
        if (this.cmd.hasOption("v")) {
            this.setProperty(SCHEMATOOL_OPTION_VERBOSE, "true");
        }
    }

    public boolean isHelp() {
        return this.getBooleanProperty(SCHEMATOOL_OPTION_HELP);
    }

    public void setHelp(boolean help) {
        this.setProperty(SCHEMATOOL_OPTION_HELP, new Boolean(help));
    }

    public void setCompleteDdl(boolean completeDdl) {
        this.setProperty(SCHEMATOOL_OPTION_COMPLETEDDL, new Boolean(completeDdl));
    }

    public boolean getCompleteDdl() {
        return this.getBooleanProperty(SCHEMATOOL_OPTION_COMPLETEDDL);
    }

    public String getModeName() {
        return this.getStringProperty(SCHEMATOOL_OPTION_MODE);
    }

    public void setModeName(String mode) {
        this.setProperty(SCHEMATOOL_OPTION_MODE, mode);
    }

    public String getApi() {
        return this.getStringProperty("datanucleus.persistenceApiName");
    }

    public void setApi(String api) {
        this.setProperty("datanucleus.persistenceApiName", api);
    }

    public String getPersistenceUnitName() {
        return this.getStringProperty("datanucleus.PersistenceUnitName");
    }

    public void setPersistenceUnitName(String unit) {
        this.setProperty("datanucleus.PersistenceUnitName", unit);
    }

    public boolean isVerbose() {
        return this.getBooleanProperty(SCHEMATOOL_OPTION_VERBOSE);
    }

    public void setVerbose(boolean verbose) {
        this.setProperty(SCHEMATOOL_OPTION_VERBOSE, new Boolean(verbose));
    }

    public String[] getDefaultArgs() {
        return this.defaultArgs;
    }

    public String getDdlFile() {
        return this.getStringProperty(SCHEMATOOL_OPTION_DDLFILE);
    }

    public void setDdlFile(String file) {
        this.setProperty(SCHEMATOOL_OPTION_DDLFILE, file);
    }

    public String getPropsFileName() {
        return this.propsFileName;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

