/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.mapping;

import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreElementContainer;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.DatastoreObject;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.StatementExpressionIndex;
import org.datanucleus.store.mapped.expression.LogicSetExpression;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.ReferenceMapping;

public class Mappings {
    public static void selectMapping(QueryExpression qs, StatementExpressionIndex[] statementExpressionIndex) {
        Mappings.selectMapping(qs, null, statementExpressionIndex);
    }

    public static void selectMapping(QueryExpression qs, DatastoreIdentifier tableIdentifier, StatementExpressionIndex[] statementExpressionIndex) {
        if (statementExpressionIndex == null) {
            return;
        }
        for (int i = 0; i < statementExpressionIndex.length; ++i) {
            JavaTypeMapping m;
            if (statementExpressionIndex[i] == null || (m = statementExpressionIndex[i].getMapping()) == null) continue;
            if (m.getNumberOfDatastoreFields() > 0) {
                int[] columnNumbersByField = tableIdentifier != null ? qs.select(tableIdentifier, m, true) : qs.select(m, true);
                statementExpressionIndex[i].setExpressionIndex(columnNumbersByField);
                continue;
            }
            Mappings.setStatementExpressionForFieldWithNoDatastoreColumns(qs, tableIdentifier, m, statementExpressionIndex[i]);
        }
    }

    private static void setStatementExpressionForFieldWithNoDatastoreColumns(QueryExpression qs, DatastoreIdentifier tableIdentifier, JavaTypeMapping m, StatementExpressionIndex statementExpressionIndex) {
        ClassLoaderResolver clr;
        AbstractMemberMetaData fmd = m.getFieldMetaData();
        int relationType = fmd.getRelationType(clr = qs.getClassLoaderResolver());
        if (relationType == 2) {
            if (fmd.getMappedBy() != null) {
                int[] colNums = null;
                MappedStoreManager storeMgr = qs.getStoreManager();
                JavaTypeMapping[] sourceMappings = null;
                DatastoreClass[] sourceTables = null;
                if (m instanceof ReferenceMapping) {
                    JavaTypeMapping[] refMappings = ((ReferenceMapping)m).getJavaTypeMapping();
                    sourceTables = new DatastoreClass[refMappings.length];
                    sourceMappings = new JavaTypeMapping[refMappings.length];
                    for (int i = 0; i < refMappings.length; ++i) {
                        sourceTables[i] = storeMgr.getDatastoreClass(refMappings[i].type, qs.getClassLoaderResolver());
                        sourceMappings[i] = sourceTables[i].getFieldMapping(fmd.getMappedBy());
                    }
                } else {
                    sourceTables = new DatastoreClass[1];
                    sourceMappings = new JavaTypeMapping[1];
                    sourceTables[0] = storeMgr.getDatastoreClass(fmd.getTypeName(), qs.getClassLoaderResolver());
                    sourceMappings[0] = sourceTables[0].getFieldMapping(fmd.getMappedBy());
                }
                for (int i = 0; i < sourceMappings.length; ++i) {
                    ScalarExpression targetExpr;
                    DatastoreIdentifier sourceTableIdentifier = storeMgr.getIdentifierFactory().newIdentifier(0, "SOURCECLASS" + fmd.getAbsoluteFieldNumber() + "_" + i);
                    LogicSetExpression sourceTableExpr = qs.newTableExpression(sourceTables[i], sourceTableIdentifier, true)[0];
                    ScalarExpression sourceExpr = sourceMappings[i].newScalarExpression(qs, sourceTableExpr);
                    if (tableIdentifier != null) {
                        LogicSetExpression targetTableExpr = qs.getTableExpression(tableIdentifier) == null ? qs.newTableExpression(m.getDatastoreContainer(), tableIdentifier) : qs.getTableExpression(tableIdentifier);
                        targetExpr = m.getDatastoreContainer().getIDMapping().newScalarExpression(qs, targetTableExpr);
                    } else {
                        targetExpr = m.getDatastoreContainer().getIDMapping().newScalarExpression(qs, qs.getMainTableExpression());
                    }
                    qs.leftOuterJoin(sourceExpr, targetExpr, sourceTableExpr, true, true);
                    int[] columnNumbersByField = qs.select(sourceTableIdentifier, sourceTables[i].getIDMapping(), true);
                    if (sourceMappings.length == 1) {
                        colNums = columnNumbersByField;
                        continue;
                    }
                    if (colNums != null) {
                        int j;
                        int[] tmpColNums = colNums;
                        colNums = new int[tmpColNums.length + columnNumbersByField.length];
                        for (j = 0; j < tmpColNums.length; ++j) {
                            colNums[j] = tmpColNums[j];
                        }
                        for (j = 0; j < columnNumbersByField.length; ++j) {
                            colNums[tmpColNums.length + j] = columnNumbersByField[j];
                        }
                        tmpColNums = null;
                        continue;
                    }
                    colNums = new int[columnNumbersByField.length];
                    for (int j = 0; j < columnNumbersByField.length; ++j) {
                        colNums[j] = columnNumbersByField[j];
                    }
                }
                statementExpressionIndex.setExpressionIndex(colNums);
            }
        } else if (relationType == 6) {
            AbstractMemberMetaData[] relatedMmds = fmd.getRelatedMemberMetaData(clr);
            if (fmd.getJoinMetaData() != null || relatedMmds[0].getJoinMetaData() != null) {
                MappedStoreManager storeMgr = qs.getStoreManager();
                DatastoreContainerObject joinTable = storeMgr.getDatastoreContainerObject(relatedMmds[0]);
                JavaTypeMapping referenceMapping = null;
                JavaTypeMapping selectMapping = null;
                DatastoreElementContainer collTable = (DatastoreElementContainer)joinTable;
                referenceMapping = collTable.getElementMapping();
                selectMapping = collTable.getOwnerMapping();
                DatastoreObject mainTable = qs.getMainTableExpression().getMainTable();
                if (!mainTable.equals(joinTable)) {
                    DatastoreIdentifier joinTableIdentifier = storeMgr.getIdentifierFactory().newIdentifier(0, "JOINTABLE" + fmd.getAbsoluteFieldNumber());
                    LogicSetExpression table_expr_sub = qs.newTableExpression(joinTable, joinTableIdentifier, true)[0];
                    ScalarExpression subExpr = referenceMapping.newScalarExpression(qs, table_expr_sub);
                    ScalarExpression schExpr = null;
                    if (tableIdentifier != null) {
                        LogicSetExpression targetTableExpr = qs.getTableExpression(tableIdentifier) == null ? qs.newTableExpression(m.getDatastoreContainer(), tableIdentifier) : qs.getTableExpression(tableIdentifier);
                        schExpr = m.getDatastoreContainer().getIDMapping().newScalarExpression(qs, targetTableExpr);
                    } else {
                        schExpr = m.getDatastoreContainer().getIDMapping().newScalarExpression(qs, qs.getMainTableExpression());
                    }
                    qs.leftOuterJoin(subExpr, schExpr, table_expr_sub, true, true);
                    int[] columnNumbersByField = qs.select(joinTableIdentifier, selectMapping, true);
                    statementExpressionIndex.setExpressionIndex(columnNumbersByField);
                } else {
                    int[] columnNumbersByField = qs.select(selectMapping, true);
                    statementExpressionIndex.setExpressionIndex(columnNumbersByField);
                }
            }
        }
    }

    public static int[] getParametersIndex(int initialPosition, JavaTypeMapping mapping) {
        if (mapping.getNumberOfDatastoreFields() < 1) {
            return new int[]{initialPosition};
        }
        int[] parameter = new int[mapping.getNumberOfDatastoreFields()];
        for (int i = 0; i < parameter.length; ++i) {
            parameter[i] = initialPosition + i;
        }
        return parameter;
    }
}

