/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.expression;

import java.util.List;
import org.datanucleus.store.mapped.expression.BooleanExpression;
import org.datanucleus.store.mapped.expression.LogicSetExpression;
import org.datanucleus.store.mapped.expression.NullLiteral;
import org.datanucleus.store.mapped.expression.NumericExpression;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;

public class SqlTemporalExpression
extends ScalarExpression {
    protected SqlTemporalExpression(QueryExpression qs) {
        super(qs);
    }

    public SqlTemporalExpression(QueryExpression qs, JavaTypeMapping mapping, LogicSetExpression te) {
        super(qs, mapping, te);
    }

    public SqlTemporalExpression(String functionName, QueryExpression qs) {
        super(qs);
        this.st.append(functionName);
    }

    public SqlTemporalExpression(String functionName, List args) {
        super(functionName, args);
    }

    public SqlTemporalExpression(ScalarExpression operand1, ScalarExpression.DyadicOperator op, ScalarExpression operand2) {
        super(operand1, op, operand2);
    }

    public BooleanExpression eq(ScalarExpression expr) {
        if (expr instanceof NullLiteral) {
            return expr.eq(this);
        }
        if (expr instanceof SqlTemporalExpression) {
            return new BooleanExpression(this, ScalarExpression.OP_EQ, expr);
        }
        return super.eq(expr);
    }

    public BooleanExpression noteq(ScalarExpression expr) {
        if (expr instanceof NullLiteral) {
            return expr.noteq(this);
        }
        if (expr instanceof SqlTemporalExpression) {
            return new BooleanExpression(this, ScalarExpression.OP_NOTEQ, expr);
        }
        return super.noteq(expr);
    }

    public BooleanExpression lt(ScalarExpression expr) {
        if (expr instanceof SqlTemporalExpression) {
            return new BooleanExpression(this, ScalarExpression.OP_LT, expr);
        }
        return super.lt(expr);
    }

    public BooleanExpression lteq(ScalarExpression expr) {
        if (expr instanceof SqlTemporalExpression) {
            return new BooleanExpression(this, ScalarExpression.OP_LTEQ, expr);
        }
        return super.lteq(expr);
    }

    public BooleanExpression gt(ScalarExpression expr) {
        if (expr instanceof SqlTemporalExpression) {
            return new BooleanExpression(this, ScalarExpression.OP_GT, expr);
        }
        return super.gt(expr);
    }

    public BooleanExpression gteq(ScalarExpression expr) {
        if (expr instanceof SqlTemporalExpression) {
            return new BooleanExpression(this, ScalarExpression.OP_GTEQ, expr);
        }
        return super.gteq(expr);
    }

    public BooleanExpression in(ScalarExpression expr) {
        return new BooleanExpression(this, ScalarExpression.OP_IN, expr);
    }

    public NumericExpression getDayMethod() {
        return this.qs.getStoreManager().getDatastoreAdapter().getNumericExpressionForMethod("day", this);
    }

    public NumericExpression getMonthMethod() {
        return this.qs.getStoreManager().getDatastoreAdapter().getNumericExpressionForMethod("month", this);
    }

    public NumericExpression getYearMethod() {
        return this.qs.getStoreManager().getDatastoreAdapter().getNumericExpressionForMethod("year", this);
    }

    public NumericExpression getHourMethod() {
        return this.qs.getStoreManager().getDatastoreAdapter().getNumericExpressionForMethod("hour", this);
    }

    public NumericExpression getMinuteMethod() {
        return this.qs.getStoreManager().getDatastoreAdapter().getNumericExpressionForMethod("minute", this);
    }

    public NumericExpression getSecondMethod() {
        return this.qs.getStoreManager().getDatastoreAdapter().getNumericExpressionForMethod("second", this);
    }
}

