/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.expression;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.mapped.DatastoreField;
import org.datanucleus.store.mapped.expression.ArrayExpression;
import org.datanucleus.store.mapped.expression.BooleanExpression;
import org.datanucleus.store.mapped.expression.BooleanLiteral;
import org.datanucleus.store.mapped.expression.FloatingPointLiteral;
import org.datanucleus.store.mapped.expression.Literal;
import org.datanucleus.store.mapped.expression.LogicSetExpression;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.UnknownLiteral;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.query.StatementText;
import org.datanucleus.store.query.QueryInvalidParametersException;
import org.datanucleus.util.Localiser;

public abstract class ScalarExpression {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.Localisation", (ClassLoader)(class$org$datanucleus$ObjectManagerFactoryImpl == null ? (class$org$datanucleus$ObjectManagerFactoryImpl = ScalarExpression.class$("org.datanucleus.ObjectManagerFactoryImpl")) : class$org$datanucleus$ObjectManagerFactoryImpl).getClassLoader());
    public static int PROJECTION = 0;
    public static int FILTER = 1;
    public static final DyadicOperator OP_OR = new DyadicOperator("OR", 0, true);
    public static final DyadicOperator OP_AND = new DyadicOperator("AND", 1, true);
    public static final MonadicOperator OP_NOT = new MonadicOperator("NOT ", 2);
    public static final DyadicOperator OP_EQ = new DyadicOperator("=", 3, false);
    public static final DyadicOperator OP_NOTEQ = new DyadicOperator("<>", 3, false);
    public static final DyadicOperator OP_LT = new DyadicOperator("<", 3, false);
    public static final DyadicOperator OP_LTEQ = new DyadicOperator("<=", 3, false);
    public static final DyadicOperator OP_GT = new DyadicOperator(">", 3, false);
    public static final DyadicOperator OP_GTEQ = new DyadicOperator(">=", 3, false);
    public static final DyadicOperator OP_LIKE = new DyadicOperator("LIKE", 3, false);
    public static final DyadicOperator OP_NOTLIKE = new DyadicOperator("NOT LIKE", 3, false);
    public static final DyadicOperator OP_BETWEEN = new DyadicOperator("BETWEEN", 3, false);
    public static final DyadicOperator OP_IS = new DyadicOperator("IS", 3, false);
    public static final DyadicOperator OP_ISNOT = new DyadicOperator("IS NOT", 3, false);
    public static final DyadicOperator OP_IN = new DyadicOperator("IN", 3, false);
    public static final DyadicOperator OP_NOTIN = new DyadicOperator("NOT IN", 3, false);
    public static final DyadicOperator OP_ADD = new DyadicOperator("+", 4, true);
    public static final DyadicOperator OP_SUB = new DyadicOperator("-", 4, false);
    public static final DyadicOperator OP_CONCAT = new DyadicOperator("||", 4, true);
    public static final DyadicOperator OP_MUL = new DyadicOperator("*", 5, true);
    public static final DyadicOperator OP_DIV = new DyadicOperator("/", 5, false);
    public static final DyadicOperator OP_MOD = new DyadicOperator("%", 5, false);
    public static final MonadicOperator OP_NEG = new MonadicOperator("-", 6);
    public static final MonadicOperator OP_COM = new MonadicOperator("~", 6);
    protected final QueryExpression qs;
    protected LogicSetExpression te;
    protected final StatementText st = new StatementText();
    protected Operator lowestOperator = null;
    protected String aliasIdentifier;
    private String nonAliasExpression;
    protected JavaTypeMapping mapping;
    protected ExpressionList expressionList = new ExpressionList();
    protected String parameterName = null;
    protected boolean checkForTypeAssignability = false;
    private static final Class[][] PARAM_TYPE_SIGNATURES = new Class[][]{null, {class$org$datanucleus$store$mapped$expression$ScalarExpression == null ? (class$org$datanucleus$store$mapped$expression$ScalarExpression = ScalarExpression.class$("org.datanucleus.store.mapped.expression.ScalarExpression")) : class$org$datanucleus$store$mapped$expression$ScalarExpression}, {class$org$datanucleus$store$mapped$expression$ScalarExpression == null ? (class$org$datanucleus$store$mapped$expression$ScalarExpression = ScalarExpression.class$("org.datanucleus.store.mapped.expression.ScalarExpression")) : class$org$datanucleus$store$mapped$expression$ScalarExpression, class$org$datanucleus$store$mapped$expression$ScalarExpression == null ? (class$org$datanucleus$store$mapped$expression$ScalarExpression = ScalarExpression.class$("org.datanucleus.store.mapped.expression.ScalarExpression")) : class$org$datanucleus$store$mapped$expression$ScalarExpression}, {class$org$datanucleus$store$mapped$expression$ScalarExpression == null ? (class$org$datanucleus$store$mapped$expression$ScalarExpression = ScalarExpression.class$("org.datanucleus.store.mapped.expression.ScalarExpression")) : class$org$datanucleus$store$mapped$expression$ScalarExpression, class$org$datanucleus$store$mapped$expression$ScalarExpression == null ? (class$org$datanucleus$store$mapped$expression$ScalarExpression = ScalarExpression.class$("org.datanucleus.store.mapped.expression.ScalarExpression")) : class$org$datanucleus$store$mapped$expression$ScalarExpression, class$org$datanucleus$store$mapped$expression$ScalarExpression == null ? (class$org$datanucleus$store$mapped$expression$ScalarExpression = ScalarExpression.class$("org.datanucleus.store.mapped.expression.ScalarExpression")) : class$org$datanucleus$store$mapped$expression$ScalarExpression}, {class$org$datanucleus$store$mapped$expression$ScalarExpression == null ? (class$org$datanucleus$store$mapped$expression$ScalarExpression = ScalarExpression.class$("org.datanucleus.store.mapped.expression.ScalarExpression")) : class$org$datanucleus$store$mapped$expression$ScalarExpression, class$org$datanucleus$store$mapped$expression$ScalarExpression == null ? (class$org$datanucleus$store$mapped$expression$ScalarExpression = ScalarExpression.class$("org.datanucleus.store.mapped.expression.ScalarExpression")) : class$org$datanucleus$store$mapped$expression$ScalarExpression, class$org$datanucleus$store$mapped$expression$ScalarExpression == null ? (class$org$datanucleus$store$mapped$expression$ScalarExpression = ScalarExpression.class$("org.datanucleus.store.mapped.expression.ScalarExpression")) : class$org$datanucleus$store$mapped$expression$ScalarExpression, class$org$datanucleus$store$mapped$expression$ScalarExpression == null ? (class$org$datanucleus$store$mapped$expression$ScalarExpression = ScalarExpression.class$("org.datanucleus.store.mapped.expression.ScalarExpression")) : class$org$datanucleus$store$mapped$expression$ScalarExpression}, {class$org$datanucleus$store$mapped$expression$ScalarExpression == null ? (class$org$datanucleus$store$mapped$expression$ScalarExpression = ScalarExpression.class$("org.datanucleus.store.mapped.expression.ScalarExpression")) : class$org$datanucleus$store$mapped$expression$ScalarExpression, class$org$datanucleus$store$mapped$expression$ScalarExpression == null ? (class$org$datanucleus$store$mapped$expression$ScalarExpression = ScalarExpression.class$("org.datanucleus.store.mapped.expression.ScalarExpression")) : class$org$datanucleus$store$mapped$expression$ScalarExpression, class$org$datanucleus$store$mapped$expression$ScalarExpression == null ? (class$org$datanucleus$store$mapped$expression$ScalarExpression = ScalarExpression.class$("org.datanucleus.store.mapped.expression.ScalarExpression")) : class$org$datanucleus$store$mapped$expression$ScalarExpression, class$org$datanucleus$store$mapped$expression$ScalarExpression == null ? (class$org$datanucleus$store$mapped$expression$ScalarExpression = ScalarExpression.class$("org.datanucleus.store.mapped.expression.ScalarExpression")) : class$org$datanucleus$store$mapped$expression$ScalarExpression, class$org$datanucleus$store$mapped$expression$ScalarExpression == null ? (class$org$datanucleus$store$mapped$expression$ScalarExpression = ScalarExpression.class$("org.datanucleus.store.mapped.expression.ScalarExpression")) : class$org$datanucleus$store$mapped$expression$ScalarExpression}, {class$org$datanucleus$store$mapped$expression$ScalarExpression == null ? (class$org$datanucleus$store$mapped$expression$ScalarExpression = ScalarExpression.class$("org.datanucleus.store.mapped.expression.ScalarExpression")) : class$org$datanucleus$store$mapped$expression$ScalarExpression, class$org$datanucleus$store$mapped$expression$ScalarExpression == null ? (class$org$datanucleus$store$mapped$expression$ScalarExpression = ScalarExpression.class$("org.datanucleus.store.mapped.expression.ScalarExpression")) : class$org$datanucleus$store$mapped$expression$ScalarExpression, class$org$datanucleus$store$mapped$expression$ScalarExpression == null ? (class$org$datanucleus$store$mapped$expression$ScalarExpression = ScalarExpression.class$("org.datanucleus.store.mapped.expression.ScalarExpression")) : class$org$datanucleus$store$mapped$expression$ScalarExpression, class$org$datanucleus$store$mapped$expression$ScalarExpression == null ? (class$org$datanucleus$store$mapped$expression$ScalarExpression = ScalarExpression.class$("org.datanucleus.store.mapped.expression.ScalarExpression")) : class$org$datanucleus$store$mapped$expression$ScalarExpression, class$org$datanucleus$store$mapped$expression$ScalarExpression == null ? (class$org$datanucleus$store$mapped$expression$ScalarExpression = ScalarExpression.class$("org.datanucleus.store.mapped.expression.ScalarExpression")) : class$org$datanucleus$store$mapped$expression$ScalarExpression, class$org$datanucleus$store$mapped$expression$ScalarExpression == null ? (class$org$datanucleus$store$mapped$expression$ScalarExpression = ScalarExpression.class$("org.datanucleus.store.mapped.expression.ScalarExpression")) : class$org$datanucleus$store$mapped$expression$ScalarExpression}, {class$org$datanucleus$store$mapped$expression$ScalarExpression == null ? (class$org$datanucleus$store$mapped$expression$ScalarExpression = ScalarExpression.class$("org.datanucleus.store.mapped.expression.ScalarExpression")) : class$org$datanucleus$store$mapped$expression$ScalarExpression, class$org$datanucleus$store$mapped$expression$ScalarExpression == null ? (class$org$datanucleus$store$mapped$expression$ScalarExpression = ScalarExpression.class$("org.datanucleus.store.mapped.expression.ScalarExpression")) : class$org$datanucleus$store$mapped$expression$ScalarExpression, class$org$datanucleus$store$mapped$expression$ScalarExpression == null ? (class$org$datanucleus$store$mapped$expression$ScalarExpression = ScalarExpression.class$("org.datanucleus.store.mapped.expression.ScalarExpression")) : class$org$datanucleus$store$mapped$expression$ScalarExpression, class$org$datanucleus$store$mapped$expression$ScalarExpression == null ? (class$org$datanucleus$store$mapped$expression$ScalarExpression = ScalarExpression.class$("org.datanucleus.store.mapped.expression.ScalarExpression")) : class$org$datanucleus$store$mapped$expression$ScalarExpression, class$org$datanucleus$store$mapped$expression$ScalarExpression == null ? (class$org$datanucleus$store$mapped$expression$ScalarExpression = ScalarExpression.class$("org.datanucleus.store.mapped.expression.ScalarExpression")) : class$org$datanucleus$store$mapped$expression$ScalarExpression, class$org$datanucleus$store$mapped$expression$ScalarExpression == null ? (class$org$datanucleus$store$mapped$expression$ScalarExpression = ScalarExpression.class$("org.datanucleus.store.mapped.expression.ScalarExpression")) : class$org$datanucleus$store$mapped$expression$ScalarExpression, class$org$datanucleus$store$mapped$expression$ScalarExpression == null ? (class$org$datanucleus$store$mapped$expression$ScalarExpression = ScalarExpression.class$("org.datanucleus.store.mapped.expression.ScalarExpression")) : class$org$datanucleus$store$mapped$expression$ScalarExpression}};
    static /* synthetic */ Class class$org$datanucleus$ObjectManagerFactoryImpl;
    static /* synthetic */ Class class$org$datanucleus$store$mapped$expression$ScalarExpression;

    protected ScalarExpression(QueryExpression qs) {
        this.qs = qs;
    }

    protected ScalarExpression(QueryExpression qs, JavaTypeMapping mapping, LogicSetExpression te) {
        this(qs);
        this.mapping = mapping;
        this.te = te;
        for (int i = 0; i < mapping.getNumberOfDatastoreFields(); ++i) {
            DatastoreFieldExpression fieldExpr = new DatastoreFieldExpression(qs, mapping.getDataStoreMapping(i).getDatastoreField(), te);
            this.expressionList.addExpression(fieldExpr);
        }
        this.st.append(this.expressionList.toString());
    }

    protected ScalarExpression(String functionName, List args) {
        this.st.append(functionName).append('(');
        ScalarExpression arg = null;
        ListIterator i = args.listIterator();
        Object expr = i.next();
        if (expr instanceof String) {
            this.st.append(expr.toString());
        } else {
            arg = (ScalarExpression)expr;
            this.st.append(arg);
        }
        while (i.hasNext()) {
            expr = i.next();
            if (expr instanceof String) {
                this.st.append(',').append(expr.toString());
                continue;
            }
            arg = (ScalarExpression)expr;
            this.st.append(',').append(arg);
        }
        this.qs = arg.qs;
        this.st.append(')');
    }

    protected ScalarExpression(String functionName, List args, List types) {
        this.st.append(functionName).append('(');
        ListIterator i = args.listIterator();
        ListIterator iTypes = types.listIterator();
        ScalarExpression arg = (ScalarExpression)i.next();
        this.st.append(arg);
        this.st.append(" AS ");
        Object type = iTypes.next();
        if (type instanceof ScalarExpression) {
            this.st.append((ScalarExpression)type);
        } else {
            this.st.append(type.toString());
        }
        this.qs = arg.qs;
        while (i.hasNext()) {
            arg = (ScalarExpression)i.next();
            this.st.append(',').append(arg);
            this.st.append(" AS ");
            type = iTypes.next();
            if (type instanceof ScalarExpression) {
                this.st.append((ScalarExpression)type);
                continue;
            }
            this.st.append(type.toString());
        }
        this.st.append(')');
    }

    protected ScalarExpression(MonadicOperator op, ScalarExpression operand) {
        this.st.append(op.toString());
        if (op.isHigherThan(operand.lowestOperator)) {
            this.st.append('(').append(operand).append(')');
        } else {
            this.st.append(operand);
        }
        this.qs = operand.qs;
        this.lowestOperator = op;
        this.mapping = operand.mapping;
    }

    protected ScalarExpression(ScalarExpression operand1, DyadicOperator op, ScalarExpression operand2) {
        this.qs = operand1.qs;
        this.lowestOperator = op;
        if (op == OP_CONCAT) {
            this.st.append(this.qs.getStoreManager().getDatastoreAdapter().concatOperator(operand1, operand2).encloseWithInParentheses());
        } else {
            if (op.isHigherThanLeftSide(operand1.lowestOperator)) {
                this.st.append('(').append(operand1).append(')');
            } else {
                this.st.append(operand1);
            }
            this.st.append(op.toString());
            if (op.isHigherThanRightSide(operand2.lowestOperator)) {
                this.st.append('(').append(operand2).append(')');
            } else {
                this.st.append(operand2);
            }
            if (op == OP_LIKE && operand1.qs.getStoreManager().getDatastoreAdapter().supportsOption("EscapeExpressionInLikePredicate") && operand2 instanceof Literal) {
                this.st.append(' ');
                this.st.append(operand1.qs.getStoreManager().getDatastoreAdapter().getEscapePatternExpression());
                this.st.append(' ');
            }
        }
    }

    public void setParameterName(String paramName) {
        this.parameterName = paramName;
    }

    public String getParameterName() {
        return this.parameterName;
    }

    public boolean isParameter() {
        return this.parameterName != null;
    }

    public void checkForTypeAssignability() {
        this.checkForTypeAssignability = true;
    }

    public QueryExpression getQueryExpression() {
        return this.qs;
    }

    public LogicSetExpression getLogicSetExpression() {
        return this.te;
    }

    public BooleanExpression and(ScalarExpression expr) {
        throw new IllegalOperationException(this, "&&", expr);
    }

    public BooleanExpression eor(ScalarExpression expr) {
        throw new IllegalOperationException(this, "^", expr);
    }

    public BooleanExpression ior(ScalarExpression expr) {
        throw new IllegalOperationException(this, "||", expr);
    }

    public BooleanExpression not() {
        throw new IllegalOperationException("!", this);
    }

    public BooleanExpression eq(ScalarExpression expr) {
        if (this instanceof UnknownLiteral || expr instanceof UnknownLiteral) {
            return new BooleanLiteral(this.qs, this.mapping, true);
        }
        throw new IllegalOperationException(this, "==", expr);
    }

    public BooleanExpression noteq(ScalarExpression expr) {
        if (this instanceof UnknownLiteral || expr instanceof UnknownLiteral) {
            return new BooleanLiteral(this.qs, this.mapping, true);
        }
        throw new IllegalOperationException(this, "!=", expr);
    }

    public BooleanExpression lt(ScalarExpression expr) {
        if (this instanceof UnknownLiteral || expr instanceof UnknownLiteral) {
            return new BooleanLiteral(this.qs, this.mapping, true);
        }
        throw new IllegalOperationException(this, "<", expr);
    }

    public BooleanExpression lteq(ScalarExpression expr) {
        if (this instanceof UnknownLiteral || expr instanceof UnknownLiteral) {
            return new BooleanLiteral(this.qs, this.mapping, true);
        }
        throw new IllegalOperationException(this, "<=", expr);
    }

    public BooleanExpression gt(ScalarExpression expr) {
        if (this instanceof UnknownLiteral || expr instanceof UnknownLiteral) {
            return new BooleanLiteral(this.qs, this.mapping, true);
        }
        throw new IllegalOperationException(this, ">", expr);
    }

    public BooleanExpression gteq(ScalarExpression expr) {
        if (this instanceof UnknownLiteral || expr instanceof UnknownLiteral) {
            return new BooleanLiteral(this.qs, this.mapping, true);
        }
        throw new IllegalOperationException(this, ">=", expr);
    }

    public BooleanExpression instanceOf(ScalarExpression expr) {
        if (this instanceof UnknownLiteral || expr instanceof UnknownLiteral) {
            return new BooleanLiteral(this.qs, this.mapping, true);
        }
        throw new IllegalOperationException(this, "instanceof", expr);
    }

    public BooleanExpression in(ScalarExpression expr) {
        if (this instanceof UnknownLiteral || expr instanceof UnknownLiteral) {
            return new BooleanLiteral(this.qs, this.mapping, true);
        }
        throw new IllegalOperationException(this, "in", expr);
    }

    public ScalarExpression add(ScalarExpression expr) {
        if (this instanceof UnknownLiteral || expr instanceof UnknownLiteral) {
            return new FloatingPointLiteral(this.qs, this.mapping, new Double(0.0));
        }
        throw new IllegalOperationException(this, "+", expr);
    }

    public ScalarExpression sub(ScalarExpression expr) {
        if (this instanceof UnknownLiteral || expr instanceof UnknownLiteral) {
            return new FloatingPointLiteral(this.qs, this.mapping, new Double(0.0));
        }
        throw new IllegalOperationException(this, "-", expr);
    }

    public ScalarExpression mul(ScalarExpression expr) {
        if (this instanceof UnknownLiteral || expr instanceof UnknownLiteral) {
            return new FloatingPointLiteral(this.qs, this.mapping, new Double(0.0));
        }
        throw new IllegalOperationException(this, "*", expr);
    }

    public ScalarExpression div(ScalarExpression expr) {
        if (this instanceof UnknownLiteral || expr instanceof UnknownLiteral) {
            return new FloatingPointLiteral(this.qs, this.mapping, new Double(0.0));
        }
        throw new IllegalOperationException(this, "/", expr);
    }

    public ScalarExpression mod(ScalarExpression expr) {
        if (this instanceof UnknownLiteral || expr instanceof UnknownLiteral) {
            return new FloatingPointLiteral(this.qs, this.mapping, new Double(0.0));
        }
        throw new IllegalOperationException(this, "%", expr);
    }

    public ScalarExpression neg() {
        throw new IllegalOperationException("-", this);
    }

    public ScalarExpression com() {
        throw new IllegalOperationException("~", this);
    }

    public ScalarExpression cast(Class type) {
        throw new IllegalOperationException("cast to " + type.getName(), this);
    }

    public ScalarExpression accessField(String fieldName, boolean innerJoin) {
        throw new IllegalOperationException("access field " + fieldName, this);
    }

    public ScalarExpression as(String aliasIdentifier) {
        if (this.aliasIdentifier == null) {
            this.aliasIdentifier = aliasIdentifier;
            this.nonAliasExpression = this.st.toString();
            this.st.postpend(" AS " + aliasIdentifier);
            this.expressionList.updateExpressionAlias();
        }
        return this;
    }

    public String getAlias() {
        return this.aliasIdentifier;
    }

    public String getNonAliasExpression() {
        return this.nonAliasExpression;
    }

    public ScalarExpression callMethod(String methodName, List arguments) {
        ScalarExpression expr;
        try {
            int numArgs = arguments.size();
            if (numArgs >= PARAM_TYPE_SIGNATURES.length) {
                throw new NoSuchMethodException(methodName + ScalarExpression.typeList(arguments));
            }
            boolean hasArrayArgument = false;
            for (int i = 0; i < arguments.size(); ++i) {
                if (!(arguments.get(i) instanceof ArrayExpression)) continue;
                hasArrayArgument = true;
                break;
            }
            if (!hasArrayArgument) {
                Method m = this.getClass().getMethod(methodName + "Method", PARAM_TYPE_SIGNATURES[numArgs]);
                expr = (ScalarExpression)m.invoke((Object)this, arguments.toArray());
            } else {
                Class[] argTypes = new Class[arguments.size()];
                Object[] args = new Object[arguments.size()];
                for (int i = 0; i < arguments.size(); ++i) {
                    if (arguments.get(i) instanceof ArrayExpression) {
                        argTypes[i] = new ScalarExpression[0].getClass();
                        args[i] = ((ArrayExpression)arguments.get((int)i)).exprs;
                        continue;
                    }
                    argTypes[i] = class$org$datanucleus$store$mapped$expression$ScalarExpression == null ? ScalarExpression.class$("org.datanucleus.store.mapped.expression.ScalarExpression") : class$org$datanucleus$store$mapped$expression$ScalarExpression;
                    args[i] = arguments.get(i);
                }
                Method m = this.getClass().getMethod(methodName + "Method", argTypes);
                expr = (ScalarExpression)m.invoke((Object)this, args);
            }
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof NucleusException) {
                throw (NucleusException)t;
            }
            throw new MethodInvocationException(methodName, arguments, t);
        }
        catch (Exception e) {
            throw new MethodInvocationException(methodName, arguments, e);
        }
        return expr;
    }

    public ScalarExpression encloseWithInParentheses() {
        this.st.encloseWithInParentheses();
        return this;
    }

    public StatementText toStatementText(int mode) {
        return this.st;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScalarExpression)) {
            return false;
        }
        String thisString = this.toStatementText(FILTER).toString();
        String otherString = ((ScalarExpression)o).toStatementText(FILTER).toString();
        if (thisString.indexOf(" AS ") > 0) {
            thisString = thisString.substring(0, thisString.indexOf(" AS "));
        }
        if (otherString.indexOf(" AS ") > 0) {
            otherString = otherString.substring(0, otherString.indexOf(" AS "));
        }
        return thisString.equals(otherString);
    }

    public String toString() {
        String value;
        try {
            value = " \"" + this.toStatementText(FILTER).toString() + '\"';
        }
        catch (NucleusException e) {
            value = "";
        }
        String className = this.getClass().getName();
        return className.substring(className.lastIndexOf(46) + 1) + value;
    }

    private static String typeList(List exprs) {
        StringBuffer s = new StringBuffer("(");
        Iterator i = exprs.iterator();
        while (i.hasNext()) {
            s.append(i.next()).append(i.hasNext() ? (char)',' : ')');
        }
        return s.toString();
    }

    protected void assertValidTypeForParameterComparison(ScalarExpression expr, Class type) {
        if ((this.checkForTypeAssignability || expr.checkForTypeAssignability) && expr.isParameter() && !type.isAssignableFrom(expr.getClass())) {
            throw new QueryInvalidParametersException(LOCALISER.msg("021114", (Object)expr.getParameterName(), (Object)this.getClass().getName(), (Object)expr.getClass().getName()));
        }
    }

    protected ScalarExpression getConsistentTypeForParameterComparison(ScalarExpression expr) {
        if (expr.isParameter() && !this.isParameter() && this.mapping != null && expr.getMapping() != null && this.mapping.getDataStoreMapping(0).getClass() != expr.getMapping().getDataStoreMapping(0).getClass() && ((Literal)((Object)expr)).getRawValue() != null) {
            expr = this.mapping.newLiteral(this.qs, ((Literal)((Object)expr)).getRawValue());
        }
        return expr;
    }

    public JavaTypeMapping getMapping() {
        return this.mapping;
    }

    public ExpressionList getExpressionList() {
        return this.expressionList;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class IllegalOperationException
    extends NucleusUserException {
        public IllegalOperationException(String operation, ScalarExpression operand) {
            super("Cannot perform operation \"" + operation + "\" on " + operand);
        }

        public IllegalOperationException(ScalarExpression operand1, String operation, ScalarExpression operand2) {
            super("Cannot perform operation \"" + operation + "\" on " + operand1 + " and " + operand2);
        }
    }

    public static class MethodInvocationException
    extends NucleusUserException {
        public MethodInvocationException(String methodName, List arguments, Throwable t) {
            super("Exception occurred invoking method " + methodName + ScalarExpression.typeList(arguments), t);
        }
    }

    public static class IllegalArgumentTypeException
    extends IllegalArgumentException {
        public IllegalArgumentTypeException(ScalarExpression arg) {
            super("Illegal argument type: " + arg);
        }
    }

    public static class DatastoreFieldExpression
    extends ScalarExpression {
        DatastoreField field;

        public DatastoreFieldExpression(QueryExpression qs, DatastoreField field, LogicSetExpression te) {
            super(qs);
            this.field = field;
            this.te = te;
            this.st.append(te.referenceColumn(field));
        }

        public BooleanExpression eq(ScalarExpression expr) {
            return new BooleanExpression(expr, OP_EQ, this);
        }

        public BooleanExpression noteq(ScalarExpression expr) {
            return new BooleanExpression(expr, OP_NOTEQ, this);
        }

        public int hashCode() {
            return this.te.hashCode() ^ this.field.hashCode();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DatastoreFieldExpression)) {
                return false;
            }
            DatastoreFieldExpression qsc = (DatastoreFieldExpression)o;
            return this.te.equals(qsc.te) && this.field.equals(qsc.field);
        }

        public String toString() {
            if (this.aliasIdentifier != null) {
                return this.te.referenceColumn(this.field) + " AS " + this.aliasIdentifier;
            }
            return this.te.referenceColumn(this.field);
        }
    }

    public class ExpressionList {
        private List expressions = new ArrayList();

        public void addExpression(ScalarExpression expression) {
            this.expressions.add(expression);
        }

        public void updateExpressionAlias() {
            if (this.expressions.size() == 1) {
                ((ScalarExpression)this.expressions.get(0)).as(ScalarExpression.this.aliasIdentifier);
            }
        }

        public ScalarExpression getExpression(int index) {
            return (ScalarExpression)this.expressions.get(index);
        }

        public int size() {
            return this.expressions.size();
        }

        public String toString() {
            StringBuffer expr = new StringBuffer();
            for (int i = 0; i < this.expressions.size(); ++i) {
                expr.append(this.getExpression(i).toString());
                if (i >= this.expressions.size() - 1) continue;
                expr.append(',');
            }
            return expr.toString();
        }

        public ScalarExpression[] toArray() {
            return this.expressions.toArray(new ScalarExpression[this.expressions.size()]);
        }
    }

    protected static class DyadicOperator
    extends Operator {
        private final boolean isAssociative;

        public DyadicOperator(String symbol, int precedence, boolean isAssociative) {
            super(" " + symbol + " ", precedence);
            this.isAssociative = isAssociative;
        }

        public boolean isHigherThanLeftSide(Operator op) {
            if (op == null) {
                return false;
            }
            return this.precedence > op.precedence;
        }

        public boolean isHigherThanRightSide(Operator op) {
            if (op == null) {
                return false;
            }
            if (this.precedence == op.precedence) {
                return !this.isAssociative;
            }
            return this.precedence > op.precedence;
        }
    }

    protected static class MonadicOperator
    extends Operator {
        public MonadicOperator(String symbol, int precedence) {
            super(symbol, precedence);
        }

        public boolean isHigherThan(Operator op) {
            if (op == null) {
                return false;
            }
            return this.precedence > op.precedence;
        }
    }

    protected static class Operator {
        protected final String symbol;
        protected final int precedence;

        public Operator(String symbol, int precedence) {
            this.symbol = symbol;
            this.precedence = precedence;
        }

        public String toString() {
            return this.symbol;
        }
    }
}

