/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.neo4j;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.PersistenceNucleusContext;
import org.datanucleus.identity.SCOID;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.ClassPersistenceModifier;
import org.datanucleus.store.AbstractStoreManager;
import org.datanucleus.store.StoreData;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.neo4j.Neo4jPersistenceHandler;
import org.datanucleus.store.neo4j.Neo4jUtils;
import org.datanucleus.store.schema.table.CompleteClassTable;
import org.datanucleus.store.schema.table.Table;
import org.datanucleus.util.Localiser;
import org.neo4j.graphdb.GraphDatabaseService;

public class Neo4jStoreManager
extends AbstractStoreManager {
    public static String OBJECT_PROVIDER_PROPCONTAINER;
    public static String PROPCONTAINER_TYPE_INDEX;
    public static String PROPCONTAINER_TYPE_INDEX_KEY;
    public static String RELATIONSHIP_FIELD_NAME;
    public static String RELATIONSHIP_FIELD_NAME_NONOWNER;
    public static String RELATIONSHIP_INDEX_NAME;
    public static String RELATIONSHIP_MAP_KEY_VALUE;
    public static String RELATIONSHIP_MAP_VAL_VALUE;
    public static String METADATA_ATTRIBUTED_RELATION;

    public Neo4jStoreManager(ClassLoaderResolver clr, PersistenceNucleusContext nucleusContext, Map<String, Object> props) {
        super("neo4j", clr, nucleusContext, props);
        this.persistenceHandler = new Neo4jPersistenceHandler((StoreManager)this);
        this.logConfiguration();
    }

    public Collection getSupportedOptions() {
        HashSet<String> set = new HashSet<String>();
        set.add("ApplicationId");
        set.add("ApplicationCompositeId");
        set.add("DatastoreId");
        set.add("NonDurableId");
        set.add("ORM");
        set.add("ORM.EmbeddedPC");
        set.add("TransactionIsolationLevel.read-committed");
        set.add("Query.JDOQL.BulkDelete");
        set.add("Query.JPQL.BulkDelete");
        return set;
    }

    public String getClassNameForObjectID(Object id, ClassLoaderResolver clr, ExecutionContext ec) {
        if (id == null) {
            return null;
        }
        if (id instanceof SCOID) {
            return ((SCOID)id).getSCOClass();
        }
        String rootClassName = super.getClassNameForObjectID(id, clr, ec);
        String[] subclasses = this.getMetaDataManager().getSubclassesForClass(rootClassName, true);
        if (subclasses == null || subclasses.length == 0) {
            return rootClassName;
        }
        AbstractClassMetaData rootCmd = this.getMetaDataManager().getMetaDataForClass(rootClassName, clr);
        return Neo4jUtils.getClassNameForIdentity(id, rootCmd, ec, clr);
    }

    public boolean supportsValueStrategy(String strategy) {
        if (super.supportsValueStrategy(strategy)) {
            return true;
        }
        return strategy.equalsIgnoreCase("IDENTITY");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void manageClasses(ClassLoaderResolver clr, String ... classNames) {
        if (classNames == null) {
            return;
        }
        ManagedConnection mconn = this.connectionMgr.getConnection(-1);
        try {
            GraphDatabaseService db = (GraphDatabaseService)mconn.getConnection();
            this.manageClasses(classNames, clr, db);
        }
        finally {
            mconn.release();
        }
    }

    public void manageClasses(String[] classNames, ClassLoaderResolver clr, GraphDatabaseService db) {
        if (classNames == null) {
            return;
        }
        String[] filteredClassNames = this.getNucleusContext().getTypeManager().filterOutSupportedSecondClassNames(classNames);
        HashSet<String> clsNameSet = new HashSet<String>();
        for (ClassMetaData cmd : this.getMetaDataManager().getReferencedClasses(filteredClassNames, clr)) {
            if (cmd.getPersistenceModifier() != ClassPersistenceModifier.PERSISTENCE_CAPABLE || cmd.isAbstract() || cmd.isEmbeddedOnly() || this.storeDataMgr.managesClass(cmd.getFullClassName())) continue;
            StoreData sd = this.storeDataMgr.get(cmd.getFullClassName());
            if (sd == null) {
                CompleteClassTable table = new CompleteClassTable((StoreManager)this, (AbstractClassMetaData)cmd, null);
                sd = this.newStoreData(cmd, clr);
                sd.setTable((Table)table);
                this.registerStoreData(sd);
            }
            clsNameSet.add(cmd.getFullClassName());
        }
    }

    static {
        Localiser.registerBundle((String)"org.datanucleus.store.neo4j.Localisation", (ClassLoader)Neo4jStoreManager.class.getClassLoader());
        OBJECT_PROVIDER_PROPCONTAINER = "DN_OP_PROPCONTAINER";
        PROPCONTAINER_TYPE_INDEX = "DN_TYPES";
        PROPCONTAINER_TYPE_INDEX_KEY = "class";
        RELATIONSHIP_FIELD_NAME = "DN_FIELD_NAME";
        RELATIONSHIP_FIELD_NAME_NONOWNER = "DN_FIELD_NAME_NONOWNER";
        RELATIONSHIP_INDEX_NAME = "DN_CONTAINER_INDEX";
        RELATIONSHIP_MAP_KEY_VALUE = "DN_MAP_KEY";
        RELATIONSHIP_MAP_VAL_VALUE = "DN_MAP_VAL";
        METADATA_ATTRIBUTED_RELATION = "attributed-relation";
    }
}

