/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.neo4j.query;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.datanucleus.ExecutionContext;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.neo4j.Neo4jUtils;
import org.datanucleus.store.query.AbstractJavaQuery;
import org.datanucleus.store.query.Query;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.neo4j.graphdb.GraphDatabaseService;

public class CypherQuery
extends AbstractJavaQuery {
    private static final long serialVersionUID = 2808968696540162104L;
    String cypher;

    public CypherQuery(StoreManager storeMgr, ExecutionContext ec) {
        this(storeMgr, ec, (CypherQuery)null);
    }

    public CypherQuery(StoreManager storeMgr, ExecutionContext ec, CypherQuery q) {
        super(storeMgr, ec);
        this.cypher = q.cypher;
    }

    public CypherQuery(StoreManager storeMgr, ExecutionContext ec, String query) {
        super(storeMgr, ec);
        this.cypher = query;
    }

    public String getSingleStringQuery() {
        return this.cypher;
    }

    public void compileGeneric(Map parameterValues) {
    }

    protected void compileInternal(Map parameterValues) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object performExecute(Map parameters) {
        ManagedConnection mconn = this.getStoreManager().getConnection(this.ec);
        List results = new ArrayList();
        try {
            GraphDatabaseService db = (GraphDatabaseService)mconn.getConnection();
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.QUERY.isDebugEnabled()) {
                NucleusLogger.QUERY.debug((Object)Localiser.msg((String)"021046", (Object[])new Object[]{"Cypher", this.getSingleStringQuery(), null}));
            }
            results = Neo4jUtils.executeCypherQuery((Query)this, db, this.cypher, null);
            if (NucleusLogger.QUERY.isDebugEnabled()) {
                NucleusLogger.QUERY.debug((Object)Localiser.msg((String)"021074", (Object[])new Object[]{"Cypher", "" + (System.currentTimeMillis() - startTime)}));
            }
            List list = results;
            return list;
        }
        finally {
            mconn.release();
        }
    }
}

