/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.neo4j;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.NucleusContext;
import org.datanucleus.identity.SCOID;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.store.AbstractStoreManager;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.neo4j.Neo4jPersistenceHandler;
import org.datanucleus.store.neo4j.Neo4jUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Neo4jStoreManager
extends AbstractStoreManager {
    public static String OBJECT_PROVIDER_PROPCONTAINER = "DN_OP_PROPCONTAINER";
    public static String PROPCONTAINER_TYPE_INDEX = "DN_TYPES";
    public static String PROPCONTAINER_TYPE_INDEX_KEY = "class";
    public static String RELATIONSHIP_FIELD_NAME = "DN_FIELD_NAME";
    public static String RELATIONSHIP_FIELD_NAME_NONOWNER = "DN_FIELD_NAME_NONOWNER";
    public static String RELATIONSHIP_INDEX_NAME = "DN_CONTAINER_INDEX";
    public static String METADATA_ATTRIBUTED_RELATION = "attributed-relation";

    public Neo4jStoreManager(ClassLoaderResolver clr, NucleusContext nucleusContext, Map<String, Object> props) {
        super("neo4j", clr, nucleusContext, props);
        this.persistenceHandler = new Neo4jPersistenceHandler((StoreManager)this);
        this.logConfiguration();
    }

    public Collection getSupportedOptions() {
        HashSet<String> set = new HashSet<String>();
        set.add("ApplicationIdentity");
        set.add("DatastoreIdentity");
        set.add("NonDurableIdentity");
        set.add("ORM");
        set.add("TransactionIsolationLevel.read-committed");
        return set;
    }

    public String getClassNameForObjectID(Object id, ClassLoaderResolver clr, ExecutionContext ec) {
        if (id == null) {
            return null;
        }
        if (id instanceof SCOID) {
            return ((SCOID)id).getSCOClass();
        }
        String rootClassName = super.getClassNameForObjectID(id, clr, ec);
        String[] subclasses = this.getMetaDataManager().getSubclassesForClass(rootClassName, true);
        if (subclasses == null || subclasses.length == 0) {
            return rootClassName;
        }
        AbstractClassMetaData rootCmd = this.getMetaDataManager().getMetaDataForClass(rootClassName, clr);
        return Neo4jUtils.getClassNameForIdentity(id, rootCmd, ec, clr);
    }

    public boolean supportsValueStrategy(String strategy) {
        if (super.supportsValueStrategy(strategy)) {
            return true;
        }
        return strategy.equalsIgnoreCase("IDENTITY");
    }
}

