/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.neo4j.query;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.EmbeddedMetaData;
import org.datanucleus.metadata.Relation;
import org.datanucleus.query.compiler.CompilationComponent;
import org.datanucleus.query.compiler.QueryCompilation;
import org.datanucleus.query.evaluator.AbstractExpressionEvaluator;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.query.expression.ExpressionEvaluator;
import org.datanucleus.query.expression.Literal;
import org.datanucleus.query.expression.OrderExpression;
import org.datanucleus.query.expression.ParameterExpression;
import org.datanucleus.query.expression.PrimaryExpression;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.neo4j.Neo4jUtils;
import org.datanucleus.store.neo4j.query.expression.Neo4jBooleanExpression;
import org.datanucleus.store.neo4j.query.expression.Neo4jExpression;
import org.datanucleus.store.neo4j.query.expression.Neo4jFieldExpression;
import org.datanucleus.store.neo4j.query.expression.Neo4jLiteral;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.schema.naming.ColumnType;
import org.datanucleus.store.types.converters.TypeConverter;
import org.datanucleus.store.types.sco.SCO;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class QueryToCypherMapper
extends AbstractExpressionEvaluator {
    final ExecutionContext ec;
    final String candidateAlias;
    final AbstractClassMetaData candidateCmd;
    final Query query;
    final QueryCompilation compilation;
    final Map parameters;
    int positionalParamNumber = -1;
    CompilationComponent compileComponent;
    String filterText = null;
    boolean filterComplete = true;
    String orderText = null;
    boolean orderComplete = true;
    boolean precompilable = true;
    Stack<Neo4jExpression> stack = new Stack();

    public QueryToCypherMapper(QueryCompilation compilation, Map parameters, AbstractClassMetaData cmd, ExecutionContext ec, Query q) {
        this.ec = ec;
        this.query = q;
        this.compilation = compilation;
        this.parameters = parameters;
        this.candidateCmd = cmd;
        this.candidateAlias = compilation.getCandidateAlias();
    }

    public boolean isPrecompilable() {
        return this.precompilable;
    }

    public boolean isFilterComplete() {
        return this.filterComplete;
    }

    public String getFilterText() {
        return this.filterText;
    }

    public boolean isOrderComplete() {
        return this.orderComplete;
    }

    public String getOrderText() {
        return this.orderText;
    }

    public void compile() {
        this.compileFilter();
        this.compileOrder();
    }

    protected void compileFilter() {
        if (this.compilation.getExprFilter() != null) {
            this.compileComponent = CompilationComponent.FILTER;
            try {
                this.compilation.getExprFilter().evaluate((ExpressionEvaluator)this);
                Neo4jExpression neoExpr = this.stack.pop();
                if (!(neoExpr instanceof Neo4jBooleanExpression)) {
                    NucleusLogger.QUERY.error((Object)("Invalid compilation : filter compiled to " + neoExpr));
                    this.filterComplete = false;
                } else {
                    this.filterText = ((Neo4jBooleanExpression)neoExpr).getCypherText();
                }
            }
            catch (Exception e) {
                if (NucleusLogger.QUERY.isDebugEnabled()) {
                    NucleusLogger.QUERY.debug((Object)("Compilation of filter to be evaluated completely in-datastore was impossible : " + e.getMessage()));
                }
                this.filterComplete = false;
            }
            this.compileComponent = null;
        }
    }

    protected void compileOrder() {
        if (this.compilation.getExprOrdering() != null) {
            this.compileComponent = CompilationComponent.ORDERING;
            try {
                StringBuffer orderStr = new StringBuffer();
                Expression[] orderingExpr = this.compilation.getExprOrdering();
                for (int i = 0; i < orderingExpr.length; ++i) {
                    OrderExpression orderExpr = (OrderExpression)orderingExpr[i];
                    orderExpr.evaluate((ExpressionEvaluator)this);
                    Neo4jExpression neoExpr = this.stack.pop();
                    orderStr.append(neoExpr.getCypherText());
                    String orderDir = orderExpr.getSortOrder();
                    if (orderDir.equalsIgnoreCase("descending")) {
                        orderStr.append(" DESC");
                    }
                    if (i >= orderingExpr.length - 1) continue;
                    orderStr.append(",");
                }
                this.orderText = orderStr.toString();
            }
            catch (Exception e) {
                if (NucleusLogger.QUERY.isDebugEnabled()) {
                    NucleusLogger.QUERY.debug((Object)("Compilation of ordering to be evaluated completely in-datastore was impossible : " + e.getMessage()));
                }
                this.orderComplete = false;
            }
            this.compileComponent = null;
        }
    }

    protected Object processAndExpression(Expression expr) {
        Neo4jBooleanExpression right = (Neo4jBooleanExpression)this.stack.pop();
        Neo4jBooleanExpression left = (Neo4jBooleanExpression)this.stack.pop();
        Neo4jBooleanExpression andExpr = new Neo4jBooleanExpression(left, right, Expression.OP_AND);
        this.stack.push(andExpr);
        return andExpr;
    }

    protected Object processOrExpression(Expression expr) {
        Neo4jBooleanExpression right = (Neo4jBooleanExpression)this.stack.pop();
        Neo4jBooleanExpression left = (Neo4jBooleanExpression)this.stack.pop();
        Neo4jBooleanExpression andExpr = new Neo4jBooleanExpression(left, right, Expression.OP_OR);
        this.stack.push(andExpr);
        return andExpr;
    }

    protected Object processEqExpression(Expression expr) {
        Neo4jExpression right = this.stack.pop();
        Neo4jExpression left = this.stack.pop();
        if (left instanceof Neo4jLiteral && right instanceof Neo4jFieldExpression) {
            String field = ((Neo4jFieldExpression)right).getFieldName();
            Object value = ((Neo4jLiteral)left).getValue();
            Neo4jBooleanExpression neo4jExpr = new Neo4jBooleanExpression(field, value, (Expression.Operator)Expression.OP_EQ);
            this.stack.push(neo4jExpr);
            return neo4jExpr;
        }
        if (left instanceof Neo4jFieldExpression && right instanceof Neo4jLiteral) {
            String field = ((Neo4jFieldExpression)left).getFieldName();
            Object value = ((Neo4jLiteral)right).getValue();
            Neo4jBooleanExpression neo4jExpr = new Neo4jBooleanExpression(field, value, (Expression.Operator)Expression.OP_EQ);
            this.stack.push(neo4jExpr);
            return neo4jExpr;
        }
        return super.processEqExpression(expr);
    }

    protected Object processNoteqExpression(Expression expr) {
        Neo4jExpression right = this.stack.pop();
        Neo4jExpression left = this.stack.pop();
        if (left instanceof Neo4jLiteral && right instanceof Neo4jFieldExpression) {
            String field = ((Neo4jFieldExpression)right).getFieldName();
            Object value = ((Neo4jLiteral)left).getValue();
            Neo4jBooleanExpression neo4jExpr = new Neo4jBooleanExpression(field, value, (Expression.Operator)Expression.OP_NOTEQ);
            this.stack.push(neo4jExpr);
            return neo4jExpr;
        }
        if (left instanceof Neo4jFieldExpression && right instanceof Neo4jLiteral) {
            String field = ((Neo4jFieldExpression)left).getFieldName();
            Object value = ((Neo4jLiteral)right).getValue();
            Neo4jBooleanExpression neo4jExpr = new Neo4jBooleanExpression(field, value, (Expression.Operator)Expression.OP_NOTEQ);
            this.stack.push(neo4jExpr);
            return neo4jExpr;
        }
        return super.processEqExpression(expr);
    }

    protected Object processGtExpression(Expression expr) {
        Neo4jExpression right = this.stack.pop();
        Neo4jExpression left = this.stack.pop();
        if (left instanceof Neo4jLiteral && right instanceof Neo4jFieldExpression) {
            String field = ((Neo4jFieldExpression)right).getFieldName();
            Object value = ((Neo4jLiteral)left).getValue();
            Neo4jBooleanExpression neo4jExpr = new Neo4jBooleanExpression(field, value, (Expression.Operator)Expression.OP_LTEQ);
            this.stack.push(neo4jExpr);
            return neo4jExpr;
        }
        if (left instanceof Neo4jFieldExpression && right instanceof Neo4jLiteral) {
            String field = ((Neo4jFieldExpression)left).getFieldName();
            Object value = ((Neo4jLiteral)right).getValue();
            Neo4jBooleanExpression neo4jExpr = new Neo4jBooleanExpression(field, value, (Expression.Operator)Expression.OP_GT);
            this.stack.push(neo4jExpr);
            return neo4jExpr;
        }
        return super.processEqExpression(expr);
    }

    protected Object processLtExpression(Expression expr) {
        Neo4jExpression right = this.stack.pop();
        Neo4jExpression left = this.stack.pop();
        if (left instanceof Neo4jLiteral && right instanceof Neo4jFieldExpression) {
            String field = ((Neo4jFieldExpression)right).getFieldName();
            Object value = ((Neo4jLiteral)left).getValue();
            Neo4jBooleanExpression neo4jExpr = new Neo4jBooleanExpression(field, value, (Expression.Operator)Expression.OP_GTEQ);
            this.stack.push(neo4jExpr);
            return neo4jExpr;
        }
        if (left instanceof Neo4jFieldExpression && right instanceof Neo4jLiteral) {
            String field = ((Neo4jFieldExpression)left).getFieldName();
            Object value = ((Neo4jLiteral)right).getValue();
            Neo4jBooleanExpression neo4jExpr = new Neo4jBooleanExpression(field, value, (Expression.Operator)Expression.OP_LT);
            this.stack.push(neo4jExpr);
            return neo4jExpr;
        }
        return super.processEqExpression(expr);
    }

    protected Object processGteqExpression(Expression expr) {
        Neo4jExpression right = this.stack.pop();
        Neo4jExpression left = this.stack.pop();
        if (left instanceof Neo4jLiteral && right instanceof Neo4jFieldExpression) {
            String field = ((Neo4jFieldExpression)right).getFieldName();
            Object value = ((Neo4jLiteral)left).getValue();
            Neo4jBooleanExpression neo4jExpr = new Neo4jBooleanExpression(field, value, (Expression.Operator)Expression.OP_LT);
            this.stack.push(neo4jExpr);
            return neo4jExpr;
        }
        if (left instanceof Neo4jFieldExpression && right instanceof Neo4jLiteral) {
            String field = ((Neo4jFieldExpression)left).getFieldName();
            Object value = ((Neo4jLiteral)right).getValue();
            Neo4jBooleanExpression neo4jExpr = new Neo4jBooleanExpression(field, value, (Expression.Operator)Expression.OP_GTEQ);
            this.stack.push(neo4jExpr);
            return neo4jExpr;
        }
        return super.processEqExpression(expr);
    }

    protected Object processLteqExpression(Expression expr) {
        Neo4jExpression right = this.stack.pop();
        Neo4jExpression left = this.stack.pop();
        if (left instanceof Neo4jLiteral && right instanceof Neo4jFieldExpression) {
            String field = ((Neo4jFieldExpression)right).getFieldName();
            Object value = ((Neo4jLiteral)left).getValue();
            Neo4jBooleanExpression neo4jExpr = new Neo4jBooleanExpression(field, value, (Expression.Operator)Expression.OP_GT);
            this.stack.push(neo4jExpr);
            return neo4jExpr;
        }
        if (left instanceof Neo4jFieldExpression && right instanceof Neo4jLiteral) {
            String field = ((Neo4jFieldExpression)left).getFieldName();
            Object value = ((Neo4jLiteral)right).getValue();
            Neo4jBooleanExpression neo4jExpr = new Neo4jBooleanExpression(field, value, (Expression.Operator)Expression.OP_LTEQ);
            this.stack.push(neo4jExpr);
            return neo4jExpr;
        }
        return super.processEqExpression(expr);
    }

    protected Object processNotExpression(Expression expr) {
        Neo4jExpression theExpr = this.stack.pop();
        if (theExpr instanceof Neo4jBooleanExpression) {
            Neo4jBooleanExpression neo4jExpr = new Neo4jBooleanExpression((Neo4jBooleanExpression)theExpr, Expression.OP_NOT);
            this.stack.push(neo4jExpr);
            return neo4jExpr;
        }
        return super.processNotExpression(expr);
    }

    protected Object processParameterExpression(ParameterExpression expr) {
        Object paramValue = null;
        boolean paramValueSet = false;
        if (this.parameters != null && !this.parameters.isEmpty()) {
            if (this.parameters.containsKey(expr.getId())) {
                paramValue = this.parameters.get(expr.getId());
                paramValueSet = true;
            } else if (this.parameters != null && this.parameters.containsKey(expr.getId())) {
                paramValue = this.parameters.get(expr.getId());
                paramValueSet = true;
            } else {
                int position = this.positionalParamNumber;
                if (this.positionalParamNumber < 0) {
                    position = 0;
                }
                if (this.parameters.containsKey(position)) {
                    paramValue = this.parameters.get(position);
                    paramValueSet = true;
                    this.positionalParamNumber = position + 1;
                }
            }
        }
        if (paramValueSet) {
            if (paramValue instanceof Number) {
                Neo4jLiteral lit = new Neo4jLiteral(paramValue);
                this.stack.push(lit);
                this.precompilable = false;
                return lit;
            }
            if (paramValue instanceof String) {
                Neo4jLiteral lit = new Neo4jLiteral(paramValue);
                this.stack.push(lit);
                this.precompilable = false;
                return lit;
            }
            if (paramValue instanceof Character) {
                Neo4jLiteral lit = new Neo4jLiteral("" + paramValue);
                this.stack.push(lit);
                this.precompilable = false;
                return lit;
            }
            if (paramValue instanceof Boolean) {
                Neo4jLiteral lit = new Neo4jLiteral(paramValue);
                this.stack.push(lit);
                this.precompilable = false;
                return lit;
            }
            if (paramValue instanceof Date) {
                Object storedVal = paramValue;
                Class<?> paramType = paramValue.getClass();
                if (paramValue instanceof SCO) {
                    paramType = ((SCO)paramValue).getValue().getClass();
                }
                TypeConverter strConv = this.ec.getTypeManager().getTypeConverterForType(paramType, String.class);
                TypeConverter longConv = this.ec.getTypeManager().getTypeConverterForType(paramType, Long.class);
                if (strConv != null) {
                    storedVal = strConv.toDatastoreType(paramValue);
                } else if (longConv != null) {
                    storedVal = longConv.toDatastoreType(paramValue);
                }
                Neo4jLiteral lit = new Neo4jLiteral(storedVal);
                this.stack.push(lit);
                this.precompilable = false;
                return lit;
            }
            if (paramValue == null) {
                Neo4jLiteral lit = new Neo4jLiteral(paramValue);
                this.stack.push(lit);
                this.precompilable = false;
                return lit;
            }
        } else {
            this.precompilable = false;
            throw new NucleusException("Parameter " + expr + " is not currently set, so cannot complete the compilation");
        }
        NucleusLogger.QUERY.info((Object)("Dont currently support parameter values of type " + paramValue.getClass().getName()));
        return super.processParameterExpression(expr);
    }

    protected Object processPrimaryExpression(PrimaryExpression expr) {
        Expression left = expr.getLeft();
        if (left == null) {
            String fieldName = this.getFieldNameForPrimary(expr);
            if (fieldName == null) {
                if (this.compileComponent == CompilationComponent.FILTER) {
                    this.filterComplete = false;
                }
                NucleusLogger.QUERY.debug((Object)(">> Primary " + expr + " is not stored in this document, so unexecutable in datastore"));
            } else {
                Neo4jFieldExpression fieldExpr = new Neo4jFieldExpression(this.candidateAlias + "." + fieldName);
                this.stack.push(fieldExpr);
                return fieldExpr;
            }
        }
        return super.processPrimaryExpression(expr);
    }

    protected Object processLiteral(Literal expr) {
        Object litValue = expr.getLiteral();
        if (litValue instanceof BigDecimal) {
            Neo4jLiteral lit = new Neo4jLiteral(((BigDecimal)litValue).doubleValue());
            this.stack.push(lit);
            return lit;
        }
        if (litValue instanceof Number) {
            Neo4jLiteral lit = new Neo4jLiteral(litValue);
            this.stack.push(lit);
            return lit;
        }
        if (litValue instanceof String) {
            Neo4jLiteral lit = new Neo4jLiteral(litValue);
            this.stack.push(lit);
            return lit;
        }
        if (litValue instanceof Boolean) {
            Neo4jLiteral lit = new Neo4jLiteral(litValue);
            this.stack.push(lit);
            return lit;
        }
        if (litValue == null) {
            Neo4jLiteral lit = new Neo4jLiteral(litValue);
            this.stack.push(lit);
            return lit;
        }
        return super.processLiteral(expr);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String getFieldNameForPrimary(PrimaryExpression expr) {
        List tuples = expr.getTuples();
        if (tuples == null || tuples.isEmpty()) {
            return null;
        }
        AbstractClassMetaData cmd = this.candidateCmd;
        AbstractMemberMetaData embMmd = null;
        boolean firstTuple = true;
        Iterator iter = tuples.iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            if (firstTuple && name.equals(this.candidateAlias)) {
                cmd = this.candidateCmd;
                continue;
            }
            AbstractMemberMetaData mmd = cmd.getMetaDataForMember(name);
            int relationType = mmd.getRelationType(this.ec.getClassLoaderResolver());
            if (relationType == 0) {
                if (iter.hasNext()) {
                    throw new NucleusUserException("Query has reference to " + StringUtils.collectionToString((Collection)tuples) + " yet " + name + " is a non-relation field!");
                }
                if (embMmd == null) return this.ec.getStoreManager().getNamingFactory().getColumnName(mmd, ColumnType.COLUMN);
                return Neo4jUtils.getPropertyNameForEmbeddedField(embMmd, mmd.getAbsoluteFieldNumber());
            }
            boolean embedded = mmd.isEmbedded();
            if (!embedded) {
                AbstractMemberMetaData[] embmmds;
                EmbeddedMetaData embmd = mmd.getEmbeddedMetaData();
                if (embmd == null && embMmd != null) {
                    embmd = embMmd.getEmbeddedMetaData();
                }
                if (embmd != null && (embmmds = embmd.getMemberMetaData()) != null) {
                    for (int i = 0; i < embmmds.length; ++i) {
                        if (!embmmds[i].getName().equals(mmd.getName())) continue;
                        embedded = true;
                        break;
                    }
                }
            }
            if (embedded) {
                if (!Relation.isRelationSingleValued((int)relationType)) throw new NucleusUserException("Do not support the querying of embedded collection/map/array fields : " + mmd.getFullFieldName());
                cmd = this.ec.getMetaDataManager().getMetaDataForClass(mmd.getType(), this.ec.getClassLoaderResolver());
                embMmd = embMmd != null ? embMmd.getEmbeddedMetaData().getMemberMetaData()[mmd.getAbsoluteFieldNumber()] : mmd;
            } else {
                switch (relationType) {
                    case 1: 
                    case 3: 
                    case 6: 
                    case 7: {
                        if (iter.hasNext()) throw new NucleusUserException("Do not support query joining to related object at " + mmd.getFullFieldName() + " in " + StringUtils.collectionToString((Collection)tuples));
                        return name;
                    }
                }
                if (this.compileComponent == CompilationComponent.FILTER) {
                    this.filterComplete = false;
                }
                NucleusLogger.QUERY.debug((Object)("Query has reference to " + StringUtils.collectionToString((Collection)tuples) + " and " + mmd.getFullFieldName() + " is not persisted into this object, so unexecutable in the datastore"));
                return null;
            }
            firstTuple = false;
        }
        return null;
    }
}

