/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.neo4j.fieldmanager;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.Relation;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.fieldmanager.AbstractStoreFieldManager;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.neo4j.Neo4jStoreManager;
import org.datanucleus.store.neo4j.Neo4jUtils;
import org.datanucleus.store.neo4j.fieldmanager.DNRelationshipType;
import org.datanucleus.store.neo4j.fieldmanager.StoreEmbeddedFieldManager;
import org.datanucleus.store.schema.naming.ColumnType;
import org.datanucleus.store.types.TypeManager;
import org.datanucleus.store.types.converters.TypeConverter;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;

public class StoreFieldManager
extends AbstractStoreFieldManager {
    protected Node node;
    protected AbstractMemberMetaData ownerMmd = null;

    public StoreFieldManager(ObjectProvider op, Node node, boolean insert) {
        super(op, insert);
        this.node = node;
    }

    protected String getPropName(int fieldNumber) {
        return this.op.getExecutionContext().getStoreManager().getNamingFactory().getColumnName(this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber), ColumnType.COLUMN);
    }

    public void storeBooleanField(int fieldNumber, boolean value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        this.node.setProperty(this.getPropName(fieldNumber), (Object)value);
    }

    public void storeByteField(int fieldNumber, byte value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        this.node.setProperty(this.getPropName(fieldNumber), (Object)value);
    }

    public void storeCharField(int fieldNumber, char value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        this.node.setProperty(this.getPropName(fieldNumber), (Object)Character.valueOf(value));
    }

    public void storeDoubleField(int fieldNumber, double value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        this.node.setProperty(this.getPropName(fieldNumber), (Object)value);
    }

    public void storeFloatField(int fieldNumber, float value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        this.node.setProperty(this.getPropName(fieldNumber), (Object)Float.valueOf(value));
    }

    public void storeIntField(int fieldNumber, int value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        this.node.setProperty(this.getPropName(fieldNumber), (Object)value);
    }

    public void storeLongField(int fieldNumber, long value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        this.node.setProperty(this.getPropName(fieldNumber), (Object)value);
    }

    public void storeShortField(int fieldNumber, short value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        this.node.setProperty(this.getPropName(fieldNumber), (Object)value);
    }

    public void storeStringField(int fieldNumber, String value) {
        if (!this.isStorable(fieldNumber)) {
            return;
        }
        if (value == null) {
            if (!this.insert) {
                this.node.removeProperty(this.getPropName(fieldNumber));
            }
            return;
        }
        this.node.setProperty(this.getPropName(fieldNumber), (Object)value);
    }

    public void storeObjectField(int fieldNumber, Object value) {
        AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (!this.isStorable(mmd)) {
            return;
        }
        ExecutionContext ec = this.op.getExecutionContext();
        String propName = ec.getStoreManager().getNamingFactory().getColumnName(mmd, ColumnType.COLUMN);
        if (!this.insert && this.node.hasProperty(propName) && value == null) {
            this.node.removeProperty(propName);
            return;
        }
        ClassLoaderResolver clr = ec.getClassLoaderResolver();
        int relationType = mmd.getRelationType(clr);
        boolean embedded = false;
        if (relationType != 0) {
            AbstractMemberMetaData[] embMmds;
            if (Relation.isRelationSingleValued((int)relationType) && this.ownerMmd != null && this.ownerMmd.getEmbeddedMetaData() != null && (embMmds = this.ownerMmd.getEmbeddedMetaData().getMemberMetaData()) != null) {
                for (int i = 0; i < embMmds.length; ++i) {
                    if (!embMmds[i].getName().equals(mmd.getName())) continue;
                    embedded = true;
                }
            }
            if (mmd.isEmbedded()) {
                embedded = true;
            } else if (mmd.getEmbeddedMetaData() != null) {
                embedded = true;
            } else if (Relation.isRelationMultiValued((int)relationType)) {
                if (mmd.hasCollection() && mmd.getElementMetaData() != null && mmd.getElementMetaData().getEmbeddedMetaData() != null) {
                    embedded = true;
                } else if (mmd.hasArray() && mmd.getElementMetaData() != null && mmd.getElementMetaData().getEmbeddedMetaData() != null) {
                    embedded = true;
                } else if (mmd.hasMap() && (mmd.getKeyMetaData() != null && mmd.getKeyMetaData().getEmbeddedMetaData() != null || mmd.getValueMetaData() != null && mmd.getValueMetaData().getEmbeddedMetaData() != null)) {
                    embedded = true;
                }
            }
        }
        if (embedded) {
            if (Relation.isRelationSingleValued((int)relationType) && value != null) {
                if (this.ownerMmd != null && (Relation.isBidirectional((int)relationType) ? this.ownerMmd.getMappedBy() != null && mmd.getName().equals(this.ownerMmd.getMappedBy()) || mmd.getMappedBy() != null && this.ownerMmd.getName().equals(mmd.getMappedBy()) : this.ownerMmd.getEmbeddedMetaData() != null && this.ownerMmd.getEmbeddedMetaData().getOwnerMember() != null && this.ownerMmd.getEmbeddedMetaData().getOwnerMember().equals(mmd.getName()))) {
                    return;
                }
                AbstractClassMetaData embcmd = ec.getMetaDataManager().getMetaDataForClass(value.getClass(), clr);
                if (embcmd == null) {
                    throw new NucleusUserException("Field " + mmd.getFullFieldName() + " specified as embedded but metadata not found for the class of type " + mmd.getTypeName());
                }
                AbstractMemberMetaData embMmd = mmd;
                if (this.ownerMmd != null) {
                    embMmd = this.ownerMmd.getEmbeddedMetaData().getMemberMetaData()[fieldNumber];
                }
                ObjectProvider embOP = ec.findObjectProviderForEmbedded(value, this.op, mmd);
                StoreEmbeddedFieldManager ffm = new StoreEmbeddedFieldManager(embOP, this.node, this.insert, embMmd);
                embOP.provideFields(embcmd.getAllMemberPositions(), (FieldManager)ffm);
                return;
            }
            throw new NucleusUserException("Don't currently support embedded field : " + mmd.getFullFieldName());
        }
        if (mmd.isSerialized()) {
            throw new NucleusUserException("Field " + mmd.getFullFieldName() + " is marked as serialised, but serialised is not yet supported");
        }
        if (Relation.isRelationSingleValued((int)relationType)) {
            ObjectProvider relatedOP;
            Object valuePC = value != null ? ec.persistObjectInternal(value, null, -1, -1) : null;
            ObjectProvider objectProvider = relatedOP = value != null ? ec.findObjectProvider(valuePC) : null;
            if (relationType != 6 && mmd.getMappedBy() == null) {
                Node relatedNode = value != null ? Neo4jUtils.getNodeForObjectProvider(this.node.getGraphDatabase(), relatedOP) : null;
                boolean hasRelation = false;
                if (!this.insert) {
                    Iterable rels = this.node.getRelationships(new RelationshipType[]{DNRelationshipType.SINGLE_VALUED});
                    for (Relationship rel : rels) {
                        if (!rel.getProperty(Neo4jStoreManager.RELATIONSHIP_FIELD_NAME).equals(mmd.getName())) continue;
                        Node currentNode = rel.getOtherNode(this.node);
                        if (currentNode.equals(relatedNode)) {
                            hasRelation = true;
                            break;
                        }
                        rel.delete();
                    }
                }
                if (!hasRelation && relatedNode != null) {
                    Relationship rel = this.node.createRelationshipTo(relatedNode, (RelationshipType)DNRelationshipType.SINGLE_VALUED);
                    rel.setProperty(Neo4jStoreManager.RELATIONSHIP_FIELD_NAME, (Object)mmd.getName());
                    if (Relation.isBidirectional((int)relationType)) {
                        AbstractMemberMetaData[] relMmds = mmd.getRelatedMemberMetaData(clr);
                        rel.setProperty(Neo4jStoreManager.RELATIONSHIP_FIELD_NAME_NONOWNER, (Object)relMmds[0].getName());
                    }
                }
            }
            return;
        }
        if (Relation.isRelationMultiValued((int)relationType)) {
            if (mmd.hasCollection()) {
                Collection coll = (Collection)value;
                ArrayList<Node> collNodes = null;
                if (relationType == 4 || relationType == 3 || relationType == 5 && mmd.getMappedBy() == null) {
                    collNodes = new ArrayList<Node>();
                }
                if (value != null) {
                    Iterator collIter = coll.iterator();
                    while (collIter.hasNext()) {
                        if (mmd.getCollection().isSerializedElement()) {
                            throw new NucleusUserException("Don't currently support serialised collection elements at " + mmd.getFullFieldName());
                        }
                        Object element = collIter.next();
                        if (element != null) {
                            Object elementPC = ec.persistObjectInternal(element, null, -1, -1);
                            ObjectProvider relatedOP = ec.findObjectProvider(elementPC);
                            if (relationType != 4 && relationType != 3 && (relationType != 5 || mmd.getMappedBy() != null)) continue;
                            Node relatedNode = Neo4jUtils.getNodeForObjectProvider(this.node.getGraphDatabase(), relatedOP);
                            collNodes.add(relatedNode);
                            continue;
                        }
                        throw new NucleusUserException("Dont currently support having null elements in collections : " + mmd.getFullFieldName());
                    }
                }
                if (relationType == 4 || relationType == 3 || relationType == 5 && mmd.getMappedBy() == null) {
                    if (this.insert) {
                        int index = 0;
                        for (Node newNode : collNodes) {
                            Relationship rel = this.node.createRelationshipTo(newNode, (RelationshipType)DNRelationshipType.MULTI_VALUED);
                            rel.setProperty(Neo4jStoreManager.RELATIONSHIP_FIELD_NAME, (Object)mmd.getName());
                            if (coll instanceof List) {
                                rel.setProperty(Neo4jStoreManager.RELATIONSHIP_INDEX_NAME, (Object)index);
                                ++index;
                            }
                            if (!Relation.isBidirectional((int)relationType)) continue;
                            AbstractMemberMetaData[] relMmds = mmd.getRelatedMemberMetaData(clr);
                            rel.setProperty(Neo4jStoreManager.RELATIONSHIP_FIELD_NAME_NONOWNER, (Object)relMmds[0].getName());
                        }
                    } else {
                        Iterable rels = this.node.getRelationships(new RelationshipType[]{DNRelationshipType.MULTI_VALUED});
                        for (Relationship rel : rels) {
                            if (!rel.getProperty(Neo4jStoreManager.RELATIONSHIP_FIELD_NAME).equals(mmd.getName())) continue;
                            rel.delete();
                        }
                        int index = 0;
                        for (Node newNode : collNodes) {
                            Relationship rel = this.node.createRelationshipTo(newNode, (RelationshipType)DNRelationshipType.MULTI_VALUED);
                            rel.setProperty(Neo4jStoreManager.RELATIONSHIP_FIELD_NAME, (Object)mmd.getName());
                            if (coll instanceof List) {
                                rel.setProperty(Neo4jStoreManager.RELATIONSHIP_INDEX_NAME, (Object)index);
                                ++index;
                            }
                            if (!Relation.isBidirectional((int)relationType)) continue;
                            AbstractMemberMetaData[] relMmds = mmd.getRelatedMemberMetaData(clr);
                            rel.setProperty(Neo4jStoreManager.RELATIONSHIP_FIELD_NAME_NONOWNER, (Object)relMmds[0].getName());
                        }
                    }
                }
            } else if (mmd.hasArray()) {
                for (int i = 0; i < Array.getLength(value); ++i) {
                    if (mmd.getArray().isSerializedElement()) {
                        throw new NucleusUserException("Don't currently support serialised collection elements at " + mmd.getFullFieldName());
                    }
                    Object element = Array.get(value, i);
                    if (element != null) {
                        Object elementPC = ec.persistObjectInternal(element, null, -1, -1);
                        ObjectProvider relatedOP = ec.findObjectProvider(elementPC);
                        if (relationType != 4 && relationType != 3 && (relationType != 5 || mmd.getMappedBy() != null)) continue;
                        Node relatedNode = Neo4jUtils.getNodeForObjectProvider(this.node.getGraphDatabase(), relatedOP);
                        Relationship rel = this.node.createRelationshipTo(relatedNode, (RelationshipType)DNRelationshipType.MULTI_VALUED);
                        rel.setProperty(Neo4jStoreManager.RELATIONSHIP_FIELD_NAME, (Object)mmd.getName());
                        rel.setProperty(Neo4jStoreManager.RELATIONSHIP_INDEX_NAME, (Object)i);
                        if (!Relation.isBidirectional((int)relationType)) continue;
                        AbstractMemberMetaData[] relMmds = mmd.getRelatedMemberMetaData(clr);
                        rel.setProperty(Neo4jStoreManager.RELATIONSHIP_FIELD_NAME_NONOWNER, (Object)relMmds[0].getName());
                        continue;
                    }
                    throw new NucleusUserException("Dont currently support having null elements in array : " + mmd.getFullFieldName());
                }
            } else if (mmd.hasMap()) {
                throw new NucleusUserException("Don't currently support 1-N/M-N maps : " + mmd.getFullFieldName());
            }
            return;
        }
        if (value == null) {
            return;
        }
        if (mmd.getTypeConverterName() != null) {
            TypeManager typeMgr = this.op.getExecutionContext().getNucleusContext().getTypeManager();
            TypeConverter conv = typeMgr.getTypeConverterForName(mmd.getTypeConverterName());
            this.node.setProperty(propName, conv.toDatastoreType(value));
        } else {
            Object storedValue = Neo4jUtils.getStoredValueForField(ec, mmd, value, 2);
            this.node.setProperty(propName, storedValue);
        }
        this.op.wrapSCOField(fieldNumber, value, false, false, true);
    }
}

