/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mongodb.valuegenerator;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.Properties;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.valuegenerator.AbstractConnectedGenerator;
import org.datanucleus.store.valuegenerator.ValueGenerationBlock;
import org.datanucleus.util.Localiser;

public class IncrementGenerator
extends AbstractConnectedGenerator<Long> {
    static final String INCREMENT_COL_NAME = "increment";
    private String key;
    private String collectionName = null;

    public IncrementGenerator(StoreManager storeMgr, String name, Properties props) {
        super(storeMgr, name, props);
        this.key = this.properties.getProperty("field-name", name);
        this.collectionName = this.properties.getProperty("sequence-table-name");
        if (this.collectionName == null) {
            this.collectionName = "IncrementTable";
        }
        this.allocationSize = this.properties.containsKey("key-cache-size") ? Integer.valueOf(this.properties.getProperty("key-cache-size")) : 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ValueGenerationBlock<Long> reserveBlock(long size) {
        if (size < 1L) {
            return null;
        }
        ArrayList<Long> oids = new ArrayList<Long>();
        ManagedConnection mconn = this.connectionProvider.retrieveConnection();
        try {
            DB db = (DB)mconn.getConnection();
            if (!this.storeMgr.getSchemaHandler().isAutoCreateTables() && !db.collectionExists(this.collectionName)) {
                throw new NucleusUserException(Localiser.msg((String)"040011", (Object[])new Object[]{this.collectionName}));
            }
            DBCollection dbCollection = db.getCollection(this.collectionName);
            BasicDBObject query = new BasicDBObject();
            query.put((Object)"field-name", (Object)this.key);
            DBCursor curs = dbCollection.find((DBObject)query);
            if (curs == null || !curs.hasNext()) {
                long initialValue = 0L;
                if (this.properties.containsKey("key-initial-value")) {
                    initialValue = Long.valueOf(this.properties.getProperty("key-initial-value")) - 1L;
                }
                BasicDBObject dbObject = new BasicDBObject();
                dbObject.put((Object)"field-name", (Object)this.key);
                dbObject.put((Object)INCREMENT_COL_NAME, (Object)initialValue);
                dbCollection.insert(new DBObject[]{dbObject});
            }
            query = new BasicDBObject();
            query.put((Object)"field-name", (Object)this.key);
            curs = dbCollection.find((DBObject)query);
            DBObject dbObject = curs.next();
            Long currentValue = (Long)dbObject.get(INCREMENT_COL_NAME);
            long number = currentValue;
            int i = 0;
            while ((long)i < size) {
                oids.add(number + (long)i + 1L);
                ++i;
            }
            dbObject.put(INCREMENT_COL_NAME, (Object)(number + size));
            dbCollection.save(dbObject);
        }
        finally {
            this.connectionProvider.releaseConnection();
        }
        return new ValueGenerationBlock(oids);
    }
}

