/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mongodb.fieldmanager;

import com.mongodb.DBObject;
import com.mongodb.DBRef;
import java.lang.reflect.Array;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.PersistableObjectType;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.EmbeddedMetaData;
import org.datanucleus.metadata.FieldPersistenceModifier;
import org.datanucleus.metadata.FieldRole;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.metadata.ValueGenerationStrategy;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.store.StoreData;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.fieldmanager.AbstractFetchFieldManager;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.mongodb.MongoDBUtils;
import org.datanucleus.store.mongodb.fieldmanager.FetchEmbeddedFieldManager;
import org.datanucleus.store.query.QueryUtils;
import org.datanucleus.store.schema.naming.ColumnType;
import org.datanucleus.store.schema.table.MemberColumnMapping;
import org.datanucleus.store.schema.table.Table;
import org.datanucleus.store.types.SCOUtils;
import org.datanucleus.store.types.converters.MultiColumnConverter;
import org.datanucleus.store.types.converters.TypeConversionHelper;
import org.datanucleus.store.types.converters.TypeConverter;
import org.datanucleus.util.NucleusLogger;

public class FetchFieldManager
extends AbstractFetchFieldManager {
    protected Table table;
    protected DBObject dbObject;
    protected AbstractMemberMetaData ownerMmd = null;

    public FetchFieldManager(DNStateManager sm, DBObject dbObject, Table table) {
        super(sm);
        this.table = table;
        this.dbObject = dbObject;
    }

    public FetchFieldManager(ExecutionContext ec, DBObject dbObject, AbstractClassMetaData cmd, Table table) {
        super(ec, cmd);
        this.table = table;
        this.dbObject = dbObject;
    }

    protected MemberColumnMapping getColumnMapping(int fieldNumber) {
        return this.table.getMemberColumnMappingForMember(this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber));
    }

    public boolean fetchBooleanField(int fieldNumber) {
        String fieldName = this.getColumnMapping(fieldNumber).getColumn(0).getName();
        if (!this.dbObject.containsField(fieldName)) {
            AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
            String dflt = MongoDBUtils.getDefaultValueForMember(mmd);
            if (dflt != null) {
                return Boolean.valueOf(dflt);
            }
            return false;
        }
        Object value = this.dbObject.get(fieldName);
        return (Boolean)value;
    }

    public byte fetchByteField(int fieldNumber) {
        String fieldName = this.getColumnMapping(fieldNumber).getColumn(0).getName();
        if (!this.dbObject.containsField(fieldName)) {
            AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
            String dflt = MongoDBUtils.getDefaultValueForMember(mmd);
            if (dflt != null) {
                return Byte.valueOf(dflt);
            }
            return 0;
        }
        Object value = this.dbObject.get(fieldName);
        return ((Number)value).byteValue();
    }

    public char fetchCharField(int fieldNumber) {
        String fieldName = this.getColumnMapping(fieldNumber).getColumn(0).getName();
        if (!this.dbObject.containsField(fieldName)) {
            AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
            String dflt = MongoDBUtils.getDefaultValueForMember(mmd);
            if (dflt != null && dflt.length() > 0) {
                return dflt.charAt(0);
            }
            return '\u0000';
        }
        Object value = this.dbObject.get(fieldName);
        return ((String)value).charAt(0);
    }

    public double fetchDoubleField(int fieldNumber) {
        String fieldName = this.getColumnMapping(fieldNumber).getColumn(0).getName();
        if (!this.dbObject.containsField(fieldName)) {
            AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
            String dflt = MongoDBUtils.getDefaultValueForMember(mmd);
            if (dflt != null) {
                return Double.valueOf(dflt);
            }
            return 0.0;
        }
        Object value = this.dbObject.get(fieldName);
        return ((Number)value).doubleValue();
    }

    public float fetchFloatField(int fieldNumber) {
        String fieldName = this.getColumnMapping(fieldNumber).getColumn(0).getName();
        if (!this.dbObject.containsField(fieldName)) {
            AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
            String dflt = MongoDBUtils.getDefaultValueForMember(mmd);
            if (dflt != null) {
                return Float.valueOf(dflt).floatValue();
            }
            return 0.0f;
        }
        Object value = this.dbObject.get(fieldName);
        return ((Number)value).floatValue();
    }

    public int fetchIntField(int fieldNumber) {
        String fieldName = this.getColumnMapping(fieldNumber).getColumn(0).getName();
        if (!this.dbObject.containsField(fieldName)) {
            AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
            String dflt = MongoDBUtils.getDefaultValueForMember(mmd);
            if (dflt != null) {
                return Integer.valueOf(dflt);
            }
            return 0;
        }
        Object value = this.dbObject.get(fieldName);
        return ((Number)value).intValue();
    }

    public long fetchLongField(int fieldNumber) {
        String fieldName = this.getColumnMapping(fieldNumber).getColumn(0).getName();
        if (!this.dbObject.containsField(fieldName)) {
            AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
            String dflt = MongoDBUtils.getDefaultValueForMember(mmd);
            if (dflt != null) {
                return Long.valueOf(dflt);
            }
            return 0L;
        }
        Object value = this.dbObject.get(fieldName);
        return ((Number)value).longValue();
    }

    public short fetchShortField(int fieldNumber) {
        String fieldName = this.getColumnMapping(fieldNumber).getColumn(0).getName();
        if (!this.dbObject.containsField(fieldName)) {
            AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
            String dflt = MongoDBUtils.getDefaultValueForMember(mmd);
            if (dflt != null) {
                return Short.valueOf(dflt);
            }
            return 0;
        }
        Object value = this.dbObject.get(fieldName);
        return ((Number)value).shortValue();
    }

    public String fetchStringField(int fieldNumber) {
        AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (mmd.getValueStrategy() == ValueGenerationStrategy.IDENTITY) {
            Object id = this.dbObject.get("_id");
            return id.toString();
        }
        MemberColumnMapping mapping = this.getColumnMapping(fieldNumber);
        if (mapping.getTypeConverter() != null) {
            String colName = mapping.getColumn(0).getName();
            if (!this.dbObject.containsField(colName)) {
                return null;
            }
            return (String)mapping.getTypeConverter().toMemberType(this.dbObject.get(colName));
        }
        String fieldName = this.getColumnMapping(fieldNumber).getColumn(0).getName();
        if (this.dbObject.containsField(fieldName)) {
            return (String)this.dbObject.get(fieldName);
        }
        return null;
    }

    public Object fetchObjectField(int fieldNumber) {
        AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (mmd.getPersistenceModifier() != FieldPersistenceModifier.PERSISTENT) {
            return this.sm != null ? this.sm.provideField(fieldNumber) : null;
        }
        StoreManager storeMgr = this.ec.getStoreManager();
        ClassLoaderResolver clr = this.ec.getClassLoaderResolver();
        RelationType relationType = mmd.getRelationType(clr);
        if (relationType != RelationType.NONE && MetaDataUtils.getInstance().isMemberEmbedded(this.ec.getMetaDataManager(), clr, mmd, relationType, this.ownerMmd)) {
            if (RelationType.isRelationSingleValued((RelationType)relationType)) {
                AbstractClassMetaData embcmd = this.ec.getMetaDataManager().getMetaDataForClass(mmd.getType(), clr);
                if (embcmd == null) {
                    throw new NucleusUserException("Field " + mmd.getFullFieldName() + " marked as embedded but no such metadata");
                }
                if (MongoDBUtils.isMemberNested(mmd)) {
                    MemberColumnMapping mapping;
                    String fieldName;
                    if (this.ownerMmd != null) {
                        if (RelationType.isBidirectional((RelationType)relationType)) {
                            if (this.ownerMmd.getMappedBy() != null && mmd.getName().equals(this.ownerMmd.getMappedBy()) || mmd.getMappedBy() != null && this.ownerMmd.getName().equals(mmd.getMappedBy())) {
                                DNStateManager ownerSM = this.ec.getOwnerForEmbeddedStateManager(this.sm);
                                return ownerSM != null ? ownerSM.getObject() : null;
                            }
                        } else if (this.ownerMmd.hasCollection()) {
                            if (this.ownerMmd.getElementMetaData().getEmbeddedMetaData() != null && this.ownerMmd.getElementMetaData().getEmbeddedMetaData().getOwnerMember() != null && this.ownerMmd.getElementMetaData().getEmbeddedMetaData().getOwnerMember().equals(mmd.getName())) {
                                DNStateManager ownerSM = this.ec.getOwnerForEmbeddedStateManager(this.sm);
                                return ownerSM != null ? ownerSM.getObject() : null;
                            }
                        } else if (this.ownerMmd.getEmbeddedMetaData() != null && this.ownerMmd.getEmbeddedMetaData().getOwnerMember() != null && this.ownerMmd.getEmbeddedMetaData().getOwnerMember().equals(mmd.getName())) {
                            DNStateManager ownerSM = this.ec.getOwnerForEmbeddedStateManager(this.sm);
                            return ownerSM != null ? ownerSM.getObject() : null;
                        }
                    }
                    if (!this.dbObject.containsField(fieldName = (mapping = this.getColumnMapping(fieldNumber)).getColumn(0).getName())) {
                        return null;
                    }
                    DBObject embeddedValue = (DBObject)this.dbObject.get(fieldName);
                    if (embcmd.hasDiscriminatorStrategy()) {
                        String discPropName = null;
                        discPropName = mmd.getEmbeddedMetaData() != null && mmd.getEmbeddedMetaData().getDiscriminatorMetaData() != null ? mmd.getEmbeddedMetaData().getDiscriminatorMetaData().getColumnName() : storeMgr.getNamingFactory().getColumnName(embcmd, ColumnType.DISCRIMINATOR_COLUMN);
                        String discVal = (String)embeddedValue.get(discPropName);
                        String elemClassName = this.ec.getMetaDataManager().getClassNameFromDiscriminatorValue(discVal, embcmd.getDiscriminatorMetaData());
                        if (!elemClassName.equals(embcmd.getFullClassName())) {
                            embcmd = this.ec.getMetaDataManager().getMetaDataForClass(elemClassName, clr);
                        }
                    }
                    ArrayList<AbstractMemberMetaData> embMmds = new ArrayList<AbstractMemberMetaData>();
                    embMmds.add(mmd);
                    DNStateManager embSM = this.ec.getNucleusContext().getStateManagerFactory().newForEmbedded(this.ec, embcmd, this.sm, fieldNumber, PersistableObjectType.EMBEDDED_PC);
                    FetchEmbeddedFieldManager ffm = new FetchEmbeddedFieldManager(embSM, embeddedValue, embMmds, this.table);
                    embSM.replaceFields(embcmd.getAllMemberPositions(), (FieldManager)ffm);
                    return embSM.getObject();
                }
                if (embcmd.hasDiscriminatorStrategy()) {
                    String discPropName = null;
                    discPropName = mmd.getEmbeddedMetaData() != null && mmd.getEmbeddedMetaData().getDiscriminatorMetaData() != null ? mmd.getEmbeddedMetaData().getDiscriminatorMetaData().getColumnName() : storeMgr.getNamingFactory().getColumnName(embcmd, ColumnType.DISCRIMINATOR_COLUMN);
                    String discVal = (String)this.dbObject.get(discPropName);
                    String elemClassName = this.ec.getMetaDataManager().getClassNameFromDiscriminatorValue(discVal, embcmd.getDiscriminatorMetaData());
                    if (!elemClassName.equals(embcmd.getFullClassName())) {
                        embcmd = this.ec.getMetaDataManager().getMetaDataForClass(elemClassName, clr);
                    }
                }
                EmbeddedMetaData embmd = mmd.getEmbeddedMetaData();
                boolean isNull = true;
                int i = 0;
                List embmmds = embmd.getMemberMetaData();
                Iterator embMmdsIter = embmmds.iterator();
                while (embMmdsIter.hasNext()) {
                    embMmdsIter.next();
                    String embFieldName = MongoDBUtils.getFieldName(mmd, i);
                    if (this.dbObject.containsField(embFieldName)) {
                        isNull = false;
                        break;
                    }
                    ++i;
                }
                if (isNull) {
                    return null;
                }
                ArrayList<AbstractMemberMetaData> embMmds = new ArrayList<AbstractMemberMetaData>();
                embMmds.add(mmd);
                DNStateManager embSM = this.ec.getNucleusContext().getStateManagerFactory().newForEmbedded(this.ec, embcmd, this.sm, fieldNumber, PersistableObjectType.EMBEDDED_PC);
                FetchEmbeddedFieldManager ffm = new FetchEmbeddedFieldManager(embSM, this.dbObject, embMmds, this.table);
                embSM.replaceFields(embcmd.getAllMemberPositions(), (FieldManager)ffm);
                return embSM.getObject();
            }
            if (RelationType.isRelationMultiValued((RelationType)relationType)) {
                if (mmd.hasCollection()) {
                    Collection coll;
                    MemberColumnMapping mapping = this.getColumnMapping(fieldNumber);
                    String fieldName = mapping.getColumn(0).getName();
                    if (!this.dbObject.containsField(fieldName)) {
                        return null;
                    }
                    Object value = this.dbObject.get(fieldName);
                    AbstractClassMetaData elemCmd = mmd.getCollection().getElementClassMetaData(clr);
                    try {
                        Class instanceType = SCOUtils.getContainerInstanceType((Class)mmd.getType(), (Boolean)(mmd.getOrderMetaData() != null ? 1 : 0));
                        coll = (Collection)instanceType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (Exception e) {
                        throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
                    }
                    Collection collValue = (Collection)value;
                    for (DBObject elementObj : collValue) {
                        DNStateManager embSM;
                        String embClassName;
                        StoreData sd;
                        AbstractClassMetaData elementCmd = elemCmd;
                        if (elementCmd.hasDiscriminatorStrategy()) {
                            String discPropName = null;
                            discPropName = mmd.getEmbeddedMetaData() != null && mmd.getEmbeddedMetaData().getDiscriminatorMetaData() != null ? mmd.getEmbeddedMetaData().getDiscriminatorMetaData().getColumnName() : storeMgr.getNamingFactory().getColumnName(elementCmd, ColumnType.DISCRIMINATOR_COLUMN);
                            String discVal = (String)elementObj.get(discPropName);
                            String elemClassName = this.ec.getMetaDataManager().getClassNameFromDiscriminatorValue(discVal, elementCmd.getDiscriminatorMetaData());
                            if (!elemClassName.equals(elementCmd.getFullClassName())) {
                                elementCmd = this.ec.getMetaDataManager().getMetaDataForClass(elemClassName, clr);
                            }
                        }
                        if ((sd = storeMgr.getStoreDataForClass(embClassName = (embSM = this.ec.getNucleusContext().getStateManagerFactory().newForEmbedded(this.ec, elementCmd, this.sm, fieldNumber, PersistableObjectType.EMBEDDED_COLLECTION_ELEMENT_PC)).getClassMetaData().getFullClassName())) == null) {
                            storeMgr.manageClasses(clr, new String[]{embClassName});
                            sd = storeMgr.getStoreDataForClass(embClassName);
                        }
                        Table elemTable = sd.getTable();
                        FetchFieldManager ffm = new FetchFieldManager(embSM, elementObj, elemTable);
                        ffm.ownerMmd = mmd;
                        embSM.replaceFields(elementCmd.getAllMemberPositions(), (FieldManager)ffm);
                        coll.add(embSM.getObject());
                    }
                    if (this.sm != null) {
                        return SCOUtils.wrapSCOField((DNStateManager)this.sm, (int)fieldNumber, (Object)coll, (boolean)true);
                    }
                    return coll;
                }
                if (mmd.hasArray()) {
                    MemberColumnMapping mapping = this.getColumnMapping(fieldNumber);
                    String fieldName = mapping.getColumn(0).getName();
                    if (!this.dbObject.containsField(fieldName)) {
                        return null;
                    }
                    AbstractClassMetaData elemCmd = mmd.getArray().getElementClassMetaData(clr);
                    Object value = this.dbObject.get(fieldName);
                    Object[] array = new Object[Array.getLength(value)];
                    for (int i = 0; i < array.length; ++i) {
                        DNStateManager embSM;
                        String embClassName;
                        StoreData sd;
                        DBObject elementObj = (DBObject)Array.get(value, i);
                        AbstractClassMetaData elementCmd = elemCmd;
                        if (elementCmd.hasDiscriminatorStrategy()) {
                            String discPropName = null;
                            discPropName = mmd.getEmbeddedMetaData() != null && mmd.getEmbeddedMetaData().getDiscriminatorMetaData() != null ? mmd.getEmbeddedMetaData().getDiscriminatorMetaData().getColumnName() : storeMgr.getNamingFactory().getColumnName(elementCmd, ColumnType.DISCRIMINATOR_COLUMN);
                            String discVal = (String)elementObj.get(discPropName);
                            String elemClassName = this.ec.getMetaDataManager().getClassNameFromDiscriminatorValue(discVal, elementCmd.getDiscriminatorMetaData());
                            if (!elemClassName.equals(elementCmd.getFullClassName())) {
                                elementCmd = this.ec.getMetaDataManager().getMetaDataForClass(elemClassName, clr);
                            }
                        }
                        if ((sd = storeMgr.getStoreDataForClass(embClassName = (embSM = this.ec.getNucleusContext().getStateManagerFactory().newForEmbedded(this.ec, elementCmd, this.sm, fieldNumber, PersistableObjectType.EMBEDDED_ARRAY_ELEMENT_PC)).getClassMetaData().getFullClassName())) == null) {
                            storeMgr.manageClasses(clr, new String[]{embClassName});
                            sd = storeMgr.getStoreDataForClass(embClassName);
                        }
                        Table elemTable = sd.getTable();
                        FetchFieldManager ffm = new FetchFieldManager(embSM, elementObj, elemTable);
                        ffm.ownerMmd = mmd;
                        embSM.replaceFields(elementCmd.getAllMemberPositions(), (FieldManager)ffm);
                        array[i] = embSM.getObject();
                    }
                    return array;
                }
                MemberColumnMapping mapping = this.getColumnMapping(fieldNumber);
                String fieldName = mapping.getColumn(0).getName();
                if (!this.dbObject.containsField(fieldName)) {
                    return null;
                }
                Object value = this.dbObject.get(fieldName);
                Map map = null;
                try {
                    Class instanceType = SCOUtils.getContainerInstanceType((Class)mmd.getType(), null);
                    map = (Map)instanceType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
                }
                AbstractClassMetaData keyCmd = mmd.getMap().getKeyClassMetaData(clr);
                AbstractClassMetaData valCmd = mmd.getMap().getValueClassMetaData(clr);
                Collection entryColl = (Collection)value;
                for (DBObject entryObj : entryColl) {
                    Object keyObj = entryObj.get("key");
                    Object valObj = entryObj.get("value");
                    Object mapKey = null;
                    if (keyCmd != null) {
                        DNStateManager embSM;
                        String embClassName;
                        StoreData sd;
                        DBObject keyDbObj = (DBObject)keyObj;
                        AbstractClassMetaData theKeyCmd = keyCmd;
                        if (theKeyCmd.hasDiscriminatorStrategy()) {
                            String discPropName = null;
                            discPropName = mmd.getEmbeddedMetaData() != null && mmd.getEmbeddedMetaData().getDiscriminatorMetaData() != null ? mmd.getEmbeddedMetaData().getDiscriminatorMetaData().getColumnName() : storeMgr.getNamingFactory().getColumnName(theKeyCmd, ColumnType.DISCRIMINATOR_COLUMN);
                            String discVal = (String)keyDbObj.get(discPropName);
                            String elemClassName = this.ec.getMetaDataManager().getClassNameFromDiscriminatorValue(discVal, theKeyCmd.getDiscriminatorMetaData());
                            if (!elemClassName.equals(theKeyCmd.getFullClassName())) {
                                theKeyCmd = this.ec.getMetaDataManager().getMetaDataForClass(elemClassName, clr);
                            }
                        }
                        if ((sd = storeMgr.getStoreDataForClass(embClassName = (embSM = this.ec.getNucleusContext().getStateManagerFactory().newForEmbedded(this.ec, theKeyCmd, this.sm, fieldNumber, PersistableObjectType.EMBEDDED_MAP_KEY_PC)).getClassMetaData().getFullClassName())) == null) {
                            storeMgr.manageClasses(clr, new String[]{embClassName});
                            sd = storeMgr.getStoreDataForClass(embClassName);
                        }
                        Table keyTable = sd.getTable();
                        FetchFieldManager ffm = new FetchFieldManager(embSM, keyDbObj, keyTable);
                        ffm.ownerMmd = mmd;
                        embSM.replaceFields(theKeyCmd.getAllMemberPositions(), (FieldManager)ffm);
                        mapKey = embSM.getObject();
                    } else {
                        mapKey = this.getMapKeyForReturnValue(mmd, keyObj);
                    }
                    Object mapVal = null;
                    if (valCmd != null) {
                        DNStateManager embSM;
                        String embClassName;
                        StoreData sd;
                        DBObject valDbObj = (DBObject)valObj;
                        AbstractClassMetaData theValCmd = valCmd;
                        if (theValCmd.hasDiscriminatorStrategy()) {
                            String discPropName = null;
                            discPropName = mmd.getEmbeddedMetaData() != null && mmd.getEmbeddedMetaData().getDiscriminatorMetaData() != null ? mmd.getEmbeddedMetaData().getDiscriminatorMetaData().getColumnName() : storeMgr.getNamingFactory().getColumnName(theValCmd, ColumnType.DISCRIMINATOR_COLUMN);
                            String discVal = (String)valDbObj.get(discPropName);
                            String elemClassName = this.ec.getMetaDataManager().getClassNameFromDiscriminatorValue(discVal, theValCmd.getDiscriminatorMetaData());
                            if (!elemClassName.equals(theValCmd.getFullClassName())) {
                                theValCmd = this.ec.getMetaDataManager().getMetaDataForClass(elemClassName, clr);
                            }
                        }
                        if ((sd = storeMgr.getStoreDataForClass(embClassName = (embSM = this.ec.getNucleusContext().getStateManagerFactory().newForEmbedded(this.ec, theValCmd, this.sm, fieldNumber, PersistableObjectType.EMBEDDED_MAP_VALUE_PC)).getClassMetaData().getFullClassName())) == null) {
                            storeMgr.manageClasses(clr, new String[]{embClassName});
                            sd = storeMgr.getStoreDataForClass(embClassName);
                        }
                        Table valTable = sd.getTable();
                        FetchFieldManager ffm = new FetchFieldManager(embSM, valDbObj, valTable);
                        ffm.ownerMmd = mmd;
                        embSM.replaceFields(theValCmd.getAllMemberPositions(), (FieldManager)ffm);
                        mapVal = embSM.getObject();
                    } else {
                        mapVal = this.getMapValueForReturnValue(mmd, valObj);
                    }
                    map.put(mapKey, mapVal);
                }
                if (this.sm != null) {
                    return SCOUtils.wrapSCOField((DNStateManager)this.sm, (int)fieldNumber, (Object)map, (boolean)true);
                }
                return map;
            }
        }
        return this.fetchNonEmbeddedObjectField(mmd, relationType, clr);
    }

    protected Object fetchNonEmbeddedObjectField(AbstractMemberMetaData mmd, RelationType relationType, ClassLoaderResolver clr) {
        int fieldNumber = mmd.getAbsoluteFieldNumber();
        MemberColumnMapping mapping = this.getColumnMapping(fieldNumber);
        boolean optional = false;
        if (Optional.class.isAssignableFrom(mmd.getType())) {
            if (relationType != RelationType.NONE) {
                relationType = RelationType.ONE_TO_ONE_UNI;
            }
            optional = true;
        }
        if (mapping.getNumberOfColumns() == 1 && !this.dbObject.containsField(mapping.getColumn(0).getName())) {
            return optional ? Optional.empty() : null;
        }
        Object value = this.dbObject.get(mapping.getColumn(0).getName());
        if (mmd.isSerialized()) {
            DNStateManager embSM;
            Object obj = MongoDBUtils.getFieldValueForJavaSerialisedField(mmd, value);
            if (this.sm != null) {
                obj = SCOUtils.wrapSCOField((DNStateManager)this.sm, (int)mmd.getAbsoluteFieldNumber(), (Object)obj, (boolean)true);
            }
            if (RelationType.isRelationSingleValued((RelationType)relationType) && ((embSM = this.ec.findStateManager(obj)) == null || this.ec.getApiAdapter().getExecutionContext(obj) == null)) {
                this.ec.getNucleusContext().getStateManagerFactory().newForEmbedded(this.ec, obj, false, this.sm, fieldNumber, PersistableObjectType.EMBEDDED_PC);
            }
            return obj;
        }
        if (RelationType.isRelationSingleValued((RelationType)relationType)) {
            Optional<Object> memberValue = this.getValueForSingleRelationField(mmd, value, clr);
            return optional ? Optional.of(memberValue) : memberValue;
        }
        if (RelationType.isRelationMultiValued((RelationType)relationType)) {
            return this.getValueForContainerRelationField(mmd, value, clr);
        }
        Object val = null;
        if (mapping.getTypeConverter() != null) {
            TypeConverter conv = mapping.getTypeConverter();
            if (mapping.getNumberOfColumns() > 1) {
                boolean isNull = true;
                Object[] valuesArr = null;
                Class[] colTypes = ((MultiColumnConverter)conv).getDatastoreColumnTypes();
                valuesArr = colTypes[0] == Integer.TYPE ? new int[mapping.getNumberOfColumns()] : (colTypes[0] == Long.TYPE ? (Object[])new long[mapping.getNumberOfColumns()] : (colTypes[0] == Double.TYPE ? (Object[])new double[mapping.getNumberOfColumns()] : (colTypes[0] == Float.TYPE ? (Object[])new double[mapping.getNumberOfColumns()] : (colTypes[0] == String.class ? (Object[])new String[mapping.getNumberOfColumns()] : (Object[])new Object[mapping.getNumberOfColumns()]))));
                for (int i = 0; i < mapping.getNumberOfColumns(); ++i) {
                    String colName = mapping.getColumn(i).getName();
                    if (this.dbObject.containsField(colName)) {
                        isNull = false;
                        Array.set(valuesArr, i, this.dbObject.get(colName));
                        continue;
                    }
                    Array.set(valuesArr, i, null);
                }
                if (isNull) {
                    return null;
                }
                val = conv.toMemberType((Object)valuesArr);
            } else {
                String colName = mapping.getColumn(0).getName();
                if (!this.dbObject.containsField(colName)) {
                    return null;
                }
                Object propVal = this.dbObject.get(colName);
                Class datastoreType = this.ec.getTypeManager().getDatastoreTypeForTypeConverter(conv, mmd.getType());
                if (!datastoreType.isAssignableFrom(propVal.getClass())) {
                    if (datastoreType == Timestamp.class || datastoreType == Date.class || datastoreType == Time.class) {
                        propVal = TypeConversionHelper.convertTo((Object)propVal, (Class)datastoreType);
                    } else {
                        NucleusLogger.PERSISTENCE.warn((Object)("Retrieved value for member " + mmd.getFullFieldName() + " needs to be converted to member type " + mmd.getTypeName() + " yet the converter needs type=" + datastoreType.getName() + " and datastore returned " + propVal.getClass().getName()));
                    }
                }
                val = conv.toMemberType(propVal);
            }
        } else {
            val = MongoDBUtils.getFieldValueFromStored(this.ec, mmd, mapping, value, FieldRole.ROLE_FIELD);
        }
        val = optional ? Optional.of(val) : val;
        return this.sm != null ? SCOUtils.wrapSCOField((DNStateManager)this.sm, (int)mmd.getAbsoluteFieldNumber(), val, (boolean)true) : val;
    }

    protected Object getValueForSingleRelationField(AbstractMemberMetaData mmd, Object value, ClassLoaderResolver clr) {
        if (value instanceof DBRef) {
            throw new NucleusUserException("Field " + mmd.getFullFieldName() + " has a DBRef stored in it. We do not currently support DBRef links. See the DataNucleus documentation");
        }
        String idStr = (String)value;
        if (value == null) {
            return null;
        }
        Class memberType = mmd.getType();
        if (Optional.class.isAssignableFrom(mmd.getType())) {
            memberType = clr.classForName(mmd.getCollection().getElementType());
        }
        try {
            AbstractClassMetaData memberCmd = this.ec.getMetaDataManager().getMetaDataForClass(memberType, clr);
            if (memberCmd != null) {
                if (memberCmd.usesSingleFieldIdentityClass() && idStr.indexOf(58) > 0) {
                    return IdentityUtils.getObjectFromPersistableIdentity((String)idStr, (AbstractClassMetaData)memberCmd, (ExecutionContext)this.ec);
                }
                return IdentityUtils.getObjectFromIdString((String)idStr, (AbstractClassMetaData)memberCmd, (ExecutionContext)this.ec, (boolean)true);
            }
            String[] implNames = MetaDataUtils.getInstance().getImplementationNamesForReferenceField(mmd, FieldRole.ROLE_FIELD, clr, this.ec.getMetaDataManager());
            if (implNames != null && implNames.length == 1) {
                memberCmd = this.ec.getMetaDataManager().getMetaDataForClass(implNames[0], clr);
                return IdentityUtils.getObjectFromPersistableIdentity((String)idStr, (AbstractClassMetaData)memberCmd, (ExecutionContext)this.ec);
            }
            if (implNames != null && implNames.length > 1) {
                for (String implName : implNames) {
                    try {
                        memberCmd = this.ec.getMetaDataManager().getMetaDataForClass(implName, clr);
                        return IdentityUtils.getObjectFromPersistableIdentity((String)idStr, (AbstractClassMetaData)memberCmd, (ExecutionContext)this.ec);
                    }
                    catch (NucleusObjectNotFoundException nonfe) {
                        throw nonfe;
                    }
                    catch (Exception exception) {
                    }
                }
            }
            throw new NucleusUserException("We do not currently support the field type of " + mmd.getFullFieldName() + " which has an interdeterminate type (e.g interface or Object element types)");
        }
        catch (NucleusObjectNotFoundException onfe) {
            NucleusLogger.GENERAL.warn((Object)("Object=" + this.sm + " field=" + mmd.getFullFieldName() + " has id=" + idStr + " but could not instantiate object with that identity"));
            return null;
        }
    }

    protected Object getValueForContainerRelationField(AbstractMemberMetaData mmd, Object value, ClassLoaderResolver clr) {
        if (mmd.hasCollection()) {
            List newColl;
            Collection coll;
            try {
                Class instanceType = SCOUtils.getContainerInstanceType((Class)mmd.getType(), (Boolean)(mmd.getOrderMetaData() != null ? 1 : 0));
                coll = (Collection)instanceType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
            AbstractClassMetaData elemCmd = mmd.getCollection().getElementClassMetaData(clr);
            if (elemCmd == null) {
                String[] implNames = MetaDataUtils.getInstance().getImplementationNamesForReferenceField(mmd, FieldRole.ROLE_COLLECTION_ELEMENT, clr, this.ec.getMetaDataManager());
                if (implNames != null && implNames.length > 0) {
                    elemCmd = this.ec.getMetaDataManager().getMetaDataForClass(implNames[0], clr);
                }
                if (elemCmd == null) {
                    throw new NucleusUserException("We do not currently support the field type of " + mmd.getFullFieldName() + " which has a collection of interdeterminate element type (e.g interface or Object element types)");
                }
            }
            Collection collIds = (Collection)value;
            Iterator idIter = collIds.iterator();
            boolean changeDetected = false;
            AbstractClassMetaData elementCmd = mmd.getCollection().getElementClassMetaData(this.ec.getClassLoaderResolver());
            while (idIter.hasNext()) {
                Object idValue = idIter.next();
                if (idValue instanceof DBRef) {
                    throw new NucleusUserException("Field " + mmd.getFullFieldName() + " has a DBRef stored in it. We do not currently support DBRef links. See the DataNucleus documentation");
                }
                String elementIdStr = (String)idValue;
                if (elementIdStr.equals("NULL")) {
                    coll.add(null);
                    continue;
                }
                try {
                    Object element = null;
                    element = elementCmd.usesSingleFieldIdentityClass() && elementIdStr.indexOf(58) > 0 ? IdentityUtils.getObjectFromPersistableIdentity((String)elementIdStr, (AbstractClassMetaData)elementCmd, (ExecutionContext)this.ec) : IdentityUtils.getObjectFromIdString((String)elementIdStr, (AbstractClassMetaData)elementCmd, (ExecutionContext)this.ec, (boolean)true);
                    coll.add(element);
                }
                catch (NucleusObjectNotFoundException onfe) {
                    changeDetected = true;
                }
            }
            if (coll instanceof List && mmd.getOrderMetaData() != null && mmd.getOrderMetaData().getOrdering() != null && !mmd.getOrderMetaData().getOrdering().equals("#PK") && (newColl = QueryUtils.orderCandidates((List)((List)coll), (Class)clr.classForName(mmd.getCollection().getElementType()), (String)mmd.getOrderMetaData().getOrdering(), (ExecutionContext)this.ec, (ClassLoaderResolver)clr)).getClass() != coll.getClass()) {
                coll.clear();
                coll.addAll(newColl);
            }
            if (this.sm != null) {
                coll = (Collection)SCOUtils.wrapSCOField((DNStateManager)this.sm, (int)mmd.getAbsoluteFieldNumber(), (Object)coll, (boolean)true);
                if (changeDetected) {
                    this.sm.makeDirty(mmd.getAbsoluteFieldNumber());
                }
            }
            return coll;
        }
        if (mmd.hasMap()) {
            Map map = null;
            try {
                Class instanceType = SCOUtils.getContainerInstanceType((Class)mmd.getType(), null);
                map = (Map)instanceType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
            AbstractClassMetaData keyCmd = mmd.getMap().getKeyClassMetaData(clr);
            AbstractClassMetaData valueCmd = mmd.getMap().getValueClassMetaData(clr);
            Collection collEntries = (Collection)value;
            boolean changeDetected = false;
            for (DBObject entryObj : collEntries) {
                Object keyObj = entryObj.get("key");
                Object valueObj = entryObj.get("value");
                if (keyObj instanceof DBRef) {
                    throw new NucleusUserException("Field " + mmd.getFullFieldName() + " has a key with DBRef stored in it. We do not currently support DBRef links. See the DataNucleus documentation");
                }
                try {
                    Object mapKey = null;
                    if (keyCmd != null) {
                        String keyStr = (String)keyObj;
                        mapKey = keyCmd.usesSingleFieldIdentityClass() && keyStr.indexOf(58) > 0 ? IdentityUtils.getObjectFromPersistableIdentity((String)keyStr, (AbstractClassMetaData)keyCmd, (ExecutionContext)this.ec) : IdentityUtils.getObjectFromIdString((String)keyStr, (AbstractClassMetaData)keyCmd, (ExecutionContext)this.ec, (boolean)true);
                    } else {
                        mapKey = this.getMapKeyForReturnValue(mmd, keyObj);
                    }
                    if (valueObj instanceof DBRef) {
                        throw new NucleusUserException("Field " + mmd.getFullFieldName() + " has a value with DBRef stored in it. We do not currently support DBRef links. See the DataNucleus documentation");
                    }
                    Object mapVal = null;
                    if (valueCmd != null) {
                        String valStr = (String)valueObj;
                        mapVal = valueCmd.usesSingleFieldIdentityClass() && valStr.indexOf(58) > 0 ? IdentityUtils.getObjectFromPersistableIdentity((String)valStr, (AbstractClassMetaData)valueCmd, (ExecutionContext)this.ec) : IdentityUtils.getObjectFromIdString((String)valStr, (AbstractClassMetaData)valueCmd, (ExecutionContext)this.ec, (boolean)true);
                    } else {
                        mapVal = this.getMapValueForReturnValue(mmd, valueObj);
                    }
                    map.put(mapKey, mapVal);
                }
                catch (NucleusObjectNotFoundException onfe) {
                    changeDetected = true;
                }
            }
            if (this.sm != null) {
                map = (Map)SCOUtils.wrapSCOField((DNStateManager)this.sm, (int)mmd.getAbsoluteFieldNumber(), (Object)map, (boolean)true);
                if (changeDetected) {
                    this.sm.makeDirty(mmd.getAbsoluteFieldNumber());
                }
            }
            return map;
        }
        if (mmd.hasArray()) {
            AbstractClassMetaData elemCmd = mmd.getArray().getElementClassMetaData(clr);
            if (elemCmd == null) {
                String[] implNames = MetaDataUtils.getInstance().getImplementationNamesForReferenceField(mmd, FieldRole.ROLE_ARRAY_ELEMENT, clr, this.ec.getMetaDataManager());
                if (implNames != null && implNames.length == 1) {
                    elemCmd = this.ec.getMetaDataManager().getMetaDataForClass(implNames[0], clr);
                }
                if (elemCmd == null) {
                    throw new NucleusUserException("We do not currently support the field type of " + mmd.getFullFieldName() + " which has an array of interdeterminate element type (e.g interface or Object element types)");
                }
            }
            Collection collIds = (Collection)value;
            Iterator idIter = collIds.iterator();
            int i = 0;
            Object array = Array.newInstance(mmd.getType().getComponentType(), collIds.size());
            boolean changeDetected = false;
            while (idIter.hasNext()) {
                Object idValue = idIter.next();
                if (idValue instanceof DBRef) {
                    throw new NucleusUserException("Field " + mmd.getFullFieldName() + " has an array with DBRef stored in it. We do not currently support DBRef links. See the DataNucleus documentation");
                }
                String elementIdStr = (String)idValue;
                if (elementIdStr.equals("NULL")) {
                    Array.set(array, i++, null);
                    continue;
                }
                try {
                    Object element = null;
                    element = elemCmd.usesSingleFieldIdentityClass() && elementIdStr.indexOf(58) > 0 ? IdentityUtils.getObjectFromPersistableIdentity((String)elementIdStr, (AbstractClassMetaData)elemCmd, (ExecutionContext)this.ec) : IdentityUtils.getObjectFromIdString((String)elementIdStr, (AbstractClassMetaData)elemCmd, (ExecutionContext)this.ec, (boolean)true);
                    Array.set(array, i++, element);
                }
                catch (NucleusObjectNotFoundException onfe) {
                    changeDetected = true;
                }
            }
            if (changeDetected) {
                if (i < collIds.size()) {
                    Object arrayOld = array;
                    array = Array.newInstance(mmd.getType().getComponentType(), i);
                    for (int j = 0; j < i; ++j) {
                        Array.set(array, j, Array.get(arrayOld, j));
                    }
                }
                if (this.sm != null) {
                    this.sm.makeDirty(mmd.getAbsoluteFieldNumber());
                }
            }
            return array;
        }
        return value;
    }

    private Object getMapKeyForReturnValue(AbstractMemberMetaData mmd, Object value) {
        String keyType = mmd.getMap().getKeyType();
        Class keyCls = this.ec.getClassLoaderResolver().classForName(keyType);
        if (keyCls == Long.class || keyCls == Double.class || keyCls == Float.class || keyCls == Integer.class || keyCls == Short.class || keyCls == String.class) {
            return value;
        }
        if (Enum.class.isAssignableFrom(keyCls)) {
            return Enum.valueOf(keyCls, (String)value);
        }
        throw new NucleusException("Dont currently support persistence/retrieval of maps with keys of type " + keyType);
    }

    private Object getMapValueForReturnValue(AbstractMemberMetaData mmd, Object value) {
        String valueType = mmd.getMap().getValueType();
        Class valueCls = this.ec.getClassLoaderResolver().classForName(valueType);
        if (valueCls == Long.class || valueCls == Double.class || valueCls == Float.class || valueCls == Integer.class || valueCls == Short.class || valueCls == String.class) {
            return value;
        }
        if (Enum.class.isAssignableFrom(valueCls)) {
            return Enum.valueOf(valueCls, (String)value);
        }
        throw new NucleusException("Dont currently support persistence/retrieval of maps with values of type " + valueType);
    }
}

