/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.ClassPersistenceModifier;
import org.datanucleus.metadata.ConstraintMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.IndexMetaData;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.metadata.UniqueMetaData;
import org.datanucleus.store.StoreData;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.schema.AbstractStoreSchemaHandler;
import org.datanucleus.store.schema.naming.NamingFactory;
import org.datanucleus.store.schema.table.Column;
import org.datanucleus.store.schema.table.CompleteClassTable;
import org.datanucleus.store.schema.table.MemberColumnMapping;
import org.datanucleus.store.schema.table.SurrogateColumnType;
import org.datanucleus.store.schema.table.Table;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class MongoDBSchemaHandler
extends AbstractStoreSchemaHandler {
    public MongoDBSchemaHandler(StoreManager storeMgr) {
        super(storeMgr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSchemaForClasses(Set<String> classNames, Properties props, Object connection) {
        DB db = (DB)connection;
        ManagedConnection mconn = null;
        try {
            if (db == null) {
                mconn = this.storeMgr.getConnectionManager().getConnection(-1);
                db = (DB)mconn.getConnection();
            }
            ClassLoaderResolver clr = this.storeMgr.getNucleusContext().getClassLoaderResolver(null);
            for (String className : classNames) {
                AbstractClassMetaData cmd = this.storeMgr.getMetaDataManager().getMetaDataForClass(className, clr);
                if (cmd == null) continue;
                this.createSchemaForClass(cmd, db);
            }
        }
        finally {
            if (mconn != null) {
                mconn.release();
            }
        }
    }

    protected void createSchemaForClass(AbstractClassMetaData cmd, DB db) {
        if (cmd.isEmbeddedOnly() || cmd.getPersistenceModifier() != ClassPersistenceModifier.PERSISTENCE_CAPABLE) {
            return;
        }
        if (cmd instanceof ClassMetaData && ((ClassMetaData)cmd).isAbstract()) {
            return;
        }
        StoreData storeData = this.storeMgr.getStoreDataForClass(cmd.getFullClassName());
        Object table = null;
        table = storeData != null ? storeData.getTable() : new CompleteClassTable(this.storeMgr, cmd, null);
        String collectionName = table.getName();
        DBCollection collection = null;
        if (this.isAutoCreateTables() && !db.collectionExists(collectionName)) {
            if (cmd.hasExtension("mongodb.capped.size")) {
                BasicDBObject options;
                Set collNames = db.getCollectionNames();
                if (!collNames.contains(collectionName)) {
                    options = new BasicDBObject();
                    options.put("capped", (Object)"true");
                    Long size = Long.valueOf(cmd.getValueForExtension("mongodb.capped.size"));
                    options.put("size", (Object)size);
                    if (NucleusLogger.DATASTORE_SCHEMA.isDebugEnabled()) {
                        NucleusLogger.DATASTORE_SCHEMA.debug((Object)Localiser.msg((String)"MongoDB.Schema.CreateClass", (Object[])new Object[]{cmd.getFullClassName(), collectionName}));
                    }
                    db.createCollection(collectionName, (DBObject)options);
                } else {
                    options = new BasicDBObject();
                    if (NucleusLogger.DATASTORE_SCHEMA.isDebugEnabled()) {
                        NucleusLogger.DATASTORE_SCHEMA.debug((Object)Localiser.msg((String)"MongoDB.Schema.CreateClass", (Object[])new Object[]{cmd.getFullClassName(), collectionName}));
                    }
                    collection = db.createCollection(collectionName, (DBObject)options);
                }
            } else {
                BasicDBObject options = new BasicDBObject();
                if (NucleusLogger.DATASTORE_SCHEMA.isDebugEnabled()) {
                    NucleusLogger.DATASTORE_SCHEMA.debug((Object)Localiser.msg((String)"MongoDB.Schema.CreateClass", (Object[])new Object[]{cmd.getFullClassName(), collectionName}));
                }
                collection = db.createCollection(collectionName, (DBObject)options);
            }
        }
        ClassLoaderResolver clr = this.storeMgr.getNucleusContext().getClassLoaderResolver(null);
        if (this.autoCreateConstraints) {
            BasicDBObject query;
            if (collection == null && !db.getCollectionNames().contains(collectionName)) {
                NucleusLogger.DATASTORE_SCHEMA.warn((Object)("Cannot create constraints for " + cmd.getFullClassName() + " since collection of name " + collectionName + " doesn't exist (enable autoCreateTables?)"));
                return;
            }
            if (collection == null) {
                collection = db.getCollection(collectionName);
            }
            NamingFactory namingFactory = this.storeMgr.getNamingFactory();
            for (AbstractClassMetaData theCmd = cmd; theCmd != null; theCmd = theCmd.getSuperAbstractClassMetaData()) {
                List clsUniMds;
                IndexMetaData idxmd2;
                List clsIdxMds = theCmd.getIndexMetaData();
                if (clsIdxMds != null) {
                    int i = 0;
                    for (IndexMetaData idxmd2 : clsIdxMds) {
                        DBObject idxObj = this.getDBObjectForIndex(cmd, idxmd2, (Table)table);
                        String idxName = namingFactory.getConstraintName(theCmd, (ConstraintMetaData)idxmd2, i++);
                        if (NucleusLogger.DATASTORE_SCHEMA.isDebugEnabled()) {
                            NucleusLogger.DATASTORE_SCHEMA.debug((Object)Localiser.msg((String)"MongoDB.Schema.CreateClassIndex", (Object[])new Object[]{idxName, collectionName, idxObj}));
                        }
                        collection.createIndex(idxObj, idxName, idxmd2.isUnique());
                    }
                }
                if ((clsUniMds = theCmd.getUniqueMetaData()) == null) continue;
                int i = 0;
                idxmd2 = clsUniMds.iterator();
                while (idxmd2.hasNext()) {
                    UniqueMetaData unimd = (UniqueMetaData)idxmd2.next();
                    DBObject uniObj = this.getDBObjectForUnique(cmd, unimd, (Table)table);
                    String uniName = namingFactory.getConstraintName(theCmd, (ConstraintMetaData)unimd, i++);
                    if (NucleusLogger.DATASTORE_SCHEMA.isDebugEnabled()) {
                        NucleusLogger.DATASTORE_SCHEMA.debug((Object)Localiser.msg((String)"MongoDB.Schema.CreateClassIndex", (Object[])new Object[]{uniName, collectionName, uniObj}));
                    }
                    collection.createIndex(uniObj, uniName, true);
                }
            }
            if (cmd.getIdentityType() == IdentityType.APPLICATION) {
                query = new BasicDBObject();
                int[] pkFieldNumbers = cmd.getPKMemberPositions();
                boolean applyIndex = true;
                for (int i = 0; i < pkFieldNumbers.length; ++i) {
                    AbstractMemberMetaData pkMmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(pkFieldNumbers[i]);
                    if (this.storeMgr.isValueGenerationStrategyDatastoreAttributed(cmd, pkFieldNumbers[i])) {
                        applyIndex = false;
                        break;
                    }
                    if (pkMmd.getUniqueMetaData() != null) {
                        applyIndex = false;
                        break;
                    }
                    MemberColumnMapping mapping = table.getMemberColumnMappingForMember(pkMmd);
                    Column[] cols = mapping.getColumns();
                    String colName = cols[0].getName();
                    query.append(colName, (Object)1);
                }
                if (applyIndex && !query.containsField("_id")) {
                    String pkName;
                    String string = pkName = cmd.getPrimaryKeyMetaData() != null ? cmd.getPrimaryKeyMetaData().getName() : cmd.getName() + "_PK";
                    if (NucleusLogger.DATASTORE_SCHEMA.isDebugEnabled()) {
                        NucleusLogger.DATASTORE_SCHEMA.debug((Object)Localiser.msg((String)"MongoDB.Schema.CreateClassIndex", (Object[])new Object[]{pkName, collectionName, query}));
                    }
                    collection.createIndex((DBObject)query, pkName, true);
                }
            } else if (cmd.getIdentityType() == IdentityType.DATASTORE && !this.storeMgr.isValueGenerationStrategyDatastoreAttributed(cmd, -1)) {
                String pkName;
                query = new BasicDBObject();
                query.append(table.getSurrogateColumn(SurrogateColumnType.DATASTORE_ID).getName(), (Object)1);
                String string = pkName = cmd.getPrimaryKeyMetaData() != null ? cmd.getPrimaryKeyMetaData().getName() : cmd.getName() + "_PK";
                if (NucleusLogger.DATASTORE_SCHEMA.isDebugEnabled()) {
                    NucleusLogger.DATASTORE_SCHEMA.debug((Object)Localiser.msg((String)"MongoDB.Schema.CreateClassIndex", (Object[])new Object[]{pkName, collectionName, query}));
                }
                collection.createIndex((DBObject)query, pkName, true);
            }
            Set mappings = table.getMemberColumnMappings();
            for (MemberColumnMapping mapping : mappings) {
                Column column = mapping.getColumn(0);
                RelationType relType = mapping.getMemberMetaData().getRelationType(clr);
                UniqueMetaData unimd = mapping.getMemberMetaData().getUniqueMetaData();
                if (relType == RelationType.NONE && unimd != null) {
                    String idxName;
                    BasicDBObject query2 = new BasicDBObject();
                    query2.append(column.getName(), (Object)1);
                    if (NucleusLogger.DATASTORE_SCHEMA.isDebugEnabled()) {
                        NucleusLogger.DATASTORE_SCHEMA.debug((Object)Localiser.msg((String)"MongoDB.Schema.CreateClassIndex", (Object[])new Object[]{unimd.getName(), collectionName, query2}));
                    }
                    if ((idxName = unimd.getName()) == null) {
                        idxName = namingFactory.getConstraintName(cmd.getName(), mapping.getMemberMetaData(), (ConstraintMetaData)unimd);
                    }
                    collection.createIndex((DBObject)query2, idxName, true);
                    continue;
                }
                IndexMetaData idxmd = mapping.getMemberMetaData().getIndexMetaData();
                if (idxmd == null) continue;
                BasicDBObject query3 = new BasicDBObject();
                query3.append(column.getName(), (Object)1);
                String idxName = namingFactory.getConstraintName(cmd.getName(), mapping.getMemberMetaData(), (ConstraintMetaData)idxmd);
                if (NucleusLogger.DATASTORE_SCHEMA.isDebugEnabled()) {
                    NucleusLogger.DATASTORE_SCHEMA.debug((Object)Localiser.msg((String)"MongoDB.Schema.CreateClassIndex", (Object[])new Object[]{idxName, collectionName, query3}));
                }
                collection.createIndex((DBObject)query3, idxName, idxmd.isUnique());
            }
        }
    }

    private DBObject getDBObjectForIndex(AbstractClassMetaData cmd, IndexMetaData idxmd, Table table) {
        BasicDBObject idxObj;
        block4: {
            String[] idxMemberNames;
            block3: {
                String[] idxcolNames;
                idxObj = new BasicDBObject();
                if (idxmd.getNumberOfColumns() <= 0) break block3;
                for (String idxcolName : idxcolNames = idxmd.getColumnNames()) {
                    idxObj.append(idxcolName, (Object)1);
                }
                break block4;
            }
            if (idxmd.getNumberOfMembers() <= 0) break block4;
            for (String idxMemberName : idxMemberNames = idxmd.getMemberNames()) {
                Column[] cols;
                AbstractMemberMetaData mmd = cmd.getMetaDataForMember(idxMemberName);
                for (Column col : cols = table.getMemberColumnMappingForMember(mmd).getColumns()) {
                    idxObj.append(col.getName(), (Object)1);
                }
            }
        }
        return idxObj;
    }

    private DBObject getDBObjectForUnique(AbstractClassMetaData cmd, UniqueMetaData unimd, Table table) {
        BasicDBObject uniObj;
        block4: {
            String[] uniMemberNames;
            block3: {
                String[] unicolNames;
                uniObj = new BasicDBObject();
                if (unimd.getNumberOfColumns() <= 0) break block3;
                for (String unicolName : unicolNames = unimd.getColumnNames()) {
                    uniObj.append(unicolName, (Object)1);
                }
                break block4;
            }
            if (unimd.getMemberNames() == null) break block4;
            for (String uniMemberName : uniMemberNames = unimd.getMemberNames()) {
                Column[] cols;
                AbstractMemberMetaData mmd = cmd.getMetaDataForMember(uniMemberName);
                for (Column col : cols = table.getMemberColumnMappingForMember(mmd).getColumns()) {
                    uniObj.append(col.getName(), (Object)1);
                }
            }
        }
        return uniObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSchemaForClasses(Set<String> classNames, Properties props, Object connection) {
        DB db = (DB)connection;
        ManagedConnection mconn = null;
        try {
            if (db == null) {
                mconn = this.storeMgr.getConnectionManager().getConnection(-1);
                db = (DB)mconn.getConnection();
            }
            ClassLoaderResolver clr = this.storeMgr.getNucleusContext().getClassLoaderResolver(null);
            for (String className : classNames) {
                AbstractClassMetaData cmd = this.storeMgr.getMetaDataManager().getMetaDataForClass(className, clr);
                if (cmd == null) continue;
                StoreData storeData = this.storeMgr.getStoreDataForClass(cmd.getFullClassName());
                Object table = null;
                table = storeData != null ? storeData.getTable() : new CompleteClassTable(this.storeMgr, cmd, null);
                DBCollection collection = db.getCollection(table.getName());
                collection.dropIndexes();
                if (NucleusLogger.DATASTORE_SCHEMA.isDebugEnabled()) {
                    NucleusLogger.DATASTORE_SCHEMA.debug((Object)Localiser.msg((String)"MongoDB.SchemaDelete.Class", (Object[])new Object[]{cmd.getFullClassName(), table.getName()}));
                }
                collection.drop();
            }
        }
        finally {
            if (mconn != null) {
                mconn.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateSchema(Set<String> classNames, Properties props, Object connection) {
        boolean success = true;
        DB db = (DB)connection;
        ManagedConnection mconn = null;
        try {
            if (db == null) {
                mconn = this.storeMgr.getConnectionManager().getConnection(-1);
                db = (DB)mconn.getConnection();
            }
            ClassLoaderResolver clr = this.storeMgr.getNucleusContext().getClassLoaderResolver(null);
            for (String className : classNames) {
                AbstractMemberMetaData[] mmds;
                BasicDBObject query;
                DBObject indexObj;
                List unimds;
                DBObject indexObj2;
                String msg;
                AbstractClassMetaData cmd = this.storeMgr.getMetaDataManager().getMetaDataForClass(className, clr);
                if (cmd == null) continue;
                StoreData storeData = this.storeMgr.getStoreDataForClass(cmd.getFullClassName());
                Object table = null;
                table = storeData != null ? storeData.getTable() : new CompleteClassTable(this.storeMgr, cmd, null);
                String tableName = table.getName();
                if (!db.collectionExists(tableName)) {
                    success = false;
                    msg = Localiser.msg((String)"MongoDB.SchemaValidate.Class", (Object[])new Object[]{cmd.getFullClassName(), tableName});
                    System.out.println(msg);
                    NucleusLogger.DATASTORE_SCHEMA.error((Object)msg);
                    continue;
                }
                msg = "Table for class=" + cmd.getFullClassName() + " with name=" + tableName + " validated";
                NucleusLogger.DATASTORE_SCHEMA.info((Object)msg);
                DBCollection dbColl = db.getCollection(tableName);
                ArrayList<DBObject> indices = new ArrayList<DBObject>(dbColl.getIndexInfo());
                List idxmds = cmd.getIndexMetaData();
                if (idxmds != null) {
                    for (IndexMetaData idxmd : idxmds) {
                        DBObject idxObj = this.getDBObjectForIndex(cmd, idxmd, (Table)table);
                        indexObj2 = this.getIndexObjectForIndex(indices, idxmd.getName(), idxObj, true);
                        if (indexObj2 != null) {
                            indices.remove(indexObj2);
                            msg = "Index for class=" + cmd.getFullClassName() + " with name=" + idxmd.getName() + " validated";
                            NucleusLogger.DATASTORE_SCHEMA.info((Object)msg);
                            continue;
                        }
                        success = false;
                        msg = "Index missing for class=" + cmd.getFullClassName() + " name=" + idxmd.getName() + " key=" + idxObj;
                        System.out.println(msg);
                        NucleusLogger.DATASTORE_SCHEMA.error((Object)msg);
                    }
                }
                if ((unimds = cmd.getUniqueMetaData()) != null) {
                    IndexMetaData idxmd;
                    idxmd = unimds.iterator();
                    while (idxmd.hasNext()) {
                        UniqueMetaData unimd = (UniqueMetaData)idxmd.next();
                        DBObject uniObj = this.getDBObjectForUnique(cmd, unimd, (Table)table);
                        indexObj = this.getIndexObjectForIndex(indices, unimd.getName(), uniObj, true);
                        if (indexObj != null) {
                            indices.remove(indexObj);
                            msg = "Unique index for class=" + cmd.getFullClassName() + " with name=" + unimd.getName() + " validated";
                            NucleusLogger.DATASTORE_SCHEMA.info((Object)msg);
                            continue;
                        }
                        success = false;
                        msg = "Unique index missing for class=" + cmd.getFullClassName() + " name=" + unimd.getName() + " key=" + uniObj;
                        System.out.println(msg);
                        NucleusLogger.DATASTORE_SCHEMA.error((Object)msg);
                    }
                }
                if (cmd.getIdentityType() == IdentityType.APPLICATION) {
                    query = new BasicDBObject();
                    int[] pkFieldNumbers = cmd.getPKMemberPositions();
                    for (int i = 0; i < pkFieldNumbers.length; ++i) {
                        AbstractMemberMetaData pkMmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(pkFieldNumbers[i]);
                        Column[] cols = table.getMemberColumnMappingForMember(pkMmd).getColumns();
                        String colName = cols[0].getName();
                        query.append(colName, (Object)1);
                    }
                    String pkName = cmd.getPrimaryKeyMetaData() != null ? cmd.getPrimaryKeyMetaData().getName() : cmd.getName() + "_PK";
                    indexObj = this.getIndexObjectForIndex(indices, pkName, (DBObject)query, true);
                    if (indexObj != null) {
                        indices.remove(indexObj);
                        msg = "Index for application-identity with name=" + pkName + " validated";
                        NucleusLogger.DATASTORE_SCHEMA.info((Object)msg);
                    } else {
                        success = false;
                        msg = "Index missing for application id name=" + pkName + " key=" + query;
                        System.out.println(msg);
                        NucleusLogger.DATASTORE_SCHEMA.error((Object)msg);
                    }
                } else if (cmd.getIdentityType() == IdentityType.DATASTORE && !this.storeMgr.isValueGenerationStrategyDatastoreAttributed(cmd, -1)) {
                    query = new BasicDBObject();
                    query.append(table.getSurrogateColumn(SurrogateColumnType.DATASTORE_ID).getName(), (Object)1);
                    String pkName = cmd.getPrimaryKeyMetaData() != null ? cmd.getPrimaryKeyMetaData().getName() : cmd.getName() + "_PK";
                    indexObj2 = this.getIndexObjectForIndex(indices, pkName, (DBObject)query, true);
                    if (indexObj2 != null) {
                        indices.remove(indexObj2);
                        msg = "Index for datastore-identity with name=" + pkName + " validated";
                        NucleusLogger.DATASTORE_SCHEMA.info((Object)msg);
                    } else {
                        success = false;
                        msg = "Index missing for datastore id name=" + pkName + " key=" + query;
                        System.out.println(msg);
                        NucleusLogger.DATASTORE_SCHEMA.error((Object)msg);
                    }
                }
                if ((mmds = cmd.getManagedMembers()) == null || mmds.length <= 0) continue;
                for (AbstractMemberMetaData mmd : mmds) {
                    UniqueMetaData unimd;
                    IndexMetaData idxmd = mmd.getIndexMetaData();
                    if (idxmd != null) {
                        Column[] cols = table.getMemberColumnMappingForMember(mmd).getColumns();
                        BasicDBObject query2 = new BasicDBObject();
                        query2.append(cols[0].getName(), (Object)1);
                        DBObject indexObj3 = this.getIndexObjectForIndex(indices, idxmd.getName(), (DBObject)query2, true);
                        if (indexObj3 != null) {
                            msg = "Index for field=" + mmd.getFullFieldName() + " with name=" + idxmd.getName() + " validated";
                            NucleusLogger.DATASTORE_SCHEMA.info((Object)msg);
                            indices.remove(indexObj3);
                        } else {
                            success = false;
                            msg = "Index missing for field=" + mmd.getFullFieldName() + " name=" + idxmd.getName() + " key=" + query2;
                            System.out.println(msg);
                            NucleusLogger.DATASTORE_SCHEMA.error((Object)msg);
                        }
                    }
                    if ((unimd = mmd.getUniqueMetaData()) == null) continue;
                    Column[] cols = table.getMemberColumnMappingForMember(mmd).getColumns();
                    BasicDBObject query3 = new BasicDBObject();
                    query3.append(cols[0].getName(), (Object)1);
                    DBObject indexObj4 = this.getIndexObjectForIndex(indices, unimd.getName(), (DBObject)query3, true);
                    if (indexObj4 != null) {
                        msg = "Unique index for field=" + mmd.getFullFieldName() + " with name=" + unimd.getName() + " validated";
                        NucleusLogger.DATASTORE_SCHEMA.info((Object)msg);
                        indices.remove(indexObj4);
                        continue;
                    }
                    success = false;
                    msg = "Unique index missing for field=" + mmd.getFullFieldName() + " name=" + unimd.getName() + " key=" + query3;
                    System.out.println(msg);
                    NucleusLogger.DATASTORE_SCHEMA.error((Object)msg);
                }
            }
        }
        finally {
            if (mconn != null) {
                mconn.release();
            }
        }
        if (!success) {
            throw new NucleusException("Errors were encountered during validation of MongoDB schema");
        }
    }

    private DBObject getIndexObjectForIndex(List<DBObject> indices, String idxName, DBObject idxObj, boolean unique) {
        if (indices == null || indices.isEmpty()) {
            return null;
        }
        for (DBObject index : indices) {
            boolean flag;
            DBObject obj = null;
            String name = (String)index.get("name");
            if (!name.equals(idxName)) continue;
            obj = index;
            if (unique && !(flag = ((Boolean)index.get("unique")).booleanValue())) continue;
            boolean equal = true;
            DBObject key = (DBObject)index.get("key");
            if (key.toMap().size() != idxObj.toMap().size()) {
                equal = false;
            } else {
                for (String fieldKey : key.keySet()) {
                    Object fieldValue = key.get(fieldKey);
                    if (!idxObj.containsField(fieldKey)) {
                        equal = false;
                        continue;
                    }
                    Object idxObjValue = idxObj.get(fieldKey);
                    if (idxObjValue.equals(fieldValue)) continue;
                    equal = false;
                }
            }
            if (!equal) continue;
            return obj;
        }
        return null;
    }
}

