/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mongodb.query;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.query.inmemory.JDOQLInMemoryEvaluator;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.connection.ManagedConnectionResourceListener;
import org.datanucleus.store.mongodb.MongoDBUtils;
import org.datanucleus.store.mongodb.query.LazyLoadQueryResult;
import org.datanucleus.store.mongodb.query.MongoDBQueryCompilation;
import org.datanucleus.store.mongodb.query.MongoDBResult;
import org.datanucleus.store.mongodb.query.QueryToMongoDBMapper;
import org.datanucleus.store.mongodb.query.expression.MongoBooleanExpression;
import org.datanucleus.store.query.AbstractJDOQLQuery;
import org.datanucleus.store.query.AbstractQueryResult;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.query.QueryManager;
import org.datanucleus.store.query.QueryResult;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class JDOQLQuery
extends AbstractJDOQLQuery {
    private static final long serialVersionUID = -8591715136438523983L;
    protected transient MongoDBQueryCompilation datastoreCompilation = null;

    public JDOQLQuery(StoreManager storeMgr, ExecutionContext ec) {
        this(storeMgr, ec, (JDOQLQuery)null);
    }

    public JDOQLQuery(StoreManager storeMgr, ExecutionContext ec, JDOQLQuery q) {
        super(storeMgr, ec, (AbstractJDOQLQuery)q);
    }

    public JDOQLQuery(StoreManager storeMgr, ExecutionContext ec, String query) {
        super(storeMgr, ec, query);
    }

    protected void discardCompiled() {
        super.discardCompiled();
        this.datastoreCompilation = null;
    }

    protected boolean isCompiled() {
        if (this.evaluateInMemory()) {
            return this.compilation != null;
        }
        if (this.compilation == null || this.datastoreCompilation == null) {
            return false;
        }
        if (!this.datastoreCompilation.isPrecompilable()) {
            NucleusLogger.GENERAL.info((Object)"Query compiled but not precompilable so ditching datastore compilation");
            this.datastoreCompilation = null;
            return false;
        }
        return true;
    }

    protected boolean evaluateInMemory() {
        if (this.candidateCollection != null) {
            if (this.compilation != null && this.compilation.getSubqueryAliases() != null) {
                NucleusLogger.QUERY.warn((Object)"In-memory evaluator doesn't currently handle subqueries completely so evaluating in datastore");
                return false;
            }
            Object val = this.getExtension("datanucleus.query.evaluateInMemory");
            if (val == null) {
                return true;
            }
            return Boolean.valueOf((String)val);
        }
        return super.evaluateInMemory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void compileInternal(Map parameterValues) {
        if (this.isCompiled()) {
            return;
        }
        super.compileInternal(parameterValues);
        boolean inMemory = this.evaluateInMemory();
        if (this.candidateCollection != null && inMemory) {
            return;
        }
        if (this.candidateClass == null) {
            throw new NucleusUserException(Localiser.msg((String)"021009", (Object[])new Object[]{this.candidateClassName}));
        }
        this.ec.hasPersistenceInformationForClass(this.candidateClass);
        QueryManager qm = this.getQueryManager();
        String datastoreKey = this.getStoreManager().getQueryCacheKey();
        String cacheKey = this.getQueryCacheKey();
        if (this.useCaching()) {
            this.datastoreCompilation = (MongoDBQueryCompilation)qm.getDatastoreQueryCompilation(datastoreKey, this.getLanguage(), cacheKey);
            if (this.datastoreCompilation != null) {
                this.setResultDistinct(this.compilation.getResultDistinct());
                return;
            }
        }
        this.datastoreCompilation = new MongoDBQueryCompilation();
        AbstractClassMetaData cmd = this.getCandidateClassMetaData();
        this.storeMgr.manageClasses(this.clr, new String[]{cmd.getFullClassName()});
        MongoDBQueryCompilation mongoDBQueryCompilation = this.datastoreCompilation;
        synchronized (mongoDBQueryCompilation) {
            if (!inMemory) {
                this.compileQueryFull(parameterValues, cmd);
            }
        }
        if (cacheKey != null && this.datastoreCompilation.isPrecompilable()) {
            qm.addDatastoreQueryCompilation(datastoreKey, this.getLanguage(), cacheKey, (Object)this.datastoreCompilation);
        }
    }

    protected AbstractClassMetaData getCandidateClassMetaData() {
        String[] impls;
        AbstractClassMetaData cmd = this.ec.getMetaDataManager().getMetaDataForClass(this.candidateClass, this.clr);
        if (this.candidateClass.isInterface() && ((impls = this.ec.getMetaDataManager().getClassesImplementingInterface(this.candidateClass.getName(), this.clr)).length != 1 || !cmd.isImplementationOfPersistentDefinition()) && (cmd = this.ec.getMetaDataManager().getMetaDataForInterface(this.candidateClass, this.clr)) == null) {
            throw new NucleusUserException("Attempting to query an interface yet it is not declared 'persistent'. Define the interface in metadata as being persistent to perform this operation, and make sure any implementations use the same identity and identity member(s)");
        }
        return cmd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object performExecute(Map parameters) {
        ManagedConnection mconn = this.getStoreManager().getConnection(this.ec);
        try {
            Object resultMapper;
            DB db = (DB)mconn.getConnection();
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.QUERY.isDebugEnabled()) {
                NucleusLogger.QUERY.debug((Object)Localiser.msg((String)"021046", (Object[])new Object[]{"JDOQL", this.getSingleStringQuery(), null}));
            }
            boolean filterInMemory = this.filter != null && !this.datastoreCompilation.isFilterComplete();
            boolean resultInMemory = this.result != null && !this.datastoreCompilation.isResultComplete();
            Boolean orderInMemory = this.ordering != null;
            Boolean rangeInMemory = this.range != null;
            List candidates = null;
            if (this.candidateCollection != null) {
                candidates = new ArrayList(this.candidateCollection);
            } else if (this.evaluateInMemory()) {
                if (this.filter != null) {
                    filterInMemory = true;
                }
                if (this.ordering != null) {
                    orderInMemory = true;
                }
                if (this.result != null) {
                    resultInMemory = true;
                }
                candidates = MongoDBUtils.getObjectsOfCandidateType((Query)this, db, null, null);
            } else {
                MongoDBResult resultObject;
                BasicDBObject filterObject = null;
                MongoBooleanExpression filterExpr = this.datastoreCompilation.getFilterExpression();
                if (filterExpr != null) {
                    filterObject = filterExpr.getDBObject();
                }
                if ((resultObject = this.datastoreCompilation.getResult()) != null && resultObject.isCountOnly() && this.datastoreCompilation.isFilterComplete() && this.grouping == null) {
                    List<Long> list = MongoDBUtils.performMongoCount(db, filterObject, this.candidateClass, this.subclasses, this.ec);
                    return list;
                }
                HashMap<String, Object> options = new HashMap<String, Object>();
                if (this.getBooleanExtensionProperty("slave-ok", false)) {
                    options.put("slave-ok", true);
                }
                if (filterInMemory || resultInMemory || this.resultClass != null) {
                    candidates = MongoDBUtils.getObjectsOfCandidateType((Query)this, db, filterObject, options);
                } else {
                    BasicDBObject orderingObject = this.datastoreCompilation.getOrdering();
                    candidates = MongoDBUtils.getObjectsOfCandidateType((Query)this, db, filterObject, orderingObject, options, (int)this.fromInclNo, (int)(this.toExclNo - this.fromInclNo));
                    if (orderInMemory.booleanValue() && ((LazyLoadQueryResult)((Object)candidates)).getOrderProcessed()) {
                        orderInMemory = false;
                    }
                    if (rangeInMemory.booleanValue() && ((LazyLoadQueryResult)((Object)candidates)).getRangeProcessed()) {
                        rangeInMemory = false;
                    }
                }
            }
            Collection results = candidates;
            if (filterInMemory || resultInMemory || this.resultClass != null || rangeInMemory.booleanValue() || orderInMemory.booleanValue()) {
                if (candidates instanceof QueryResult) {
                    ((QueryResult)candidates).disconnect();
                }
                resultMapper = new JDOQLInMemoryEvaluator((Query)this, candidates, this.compilation, parameters, this.ec.getClassLoaderResolver());
                results = resultMapper.execute(filterInMemory, orderInMemory.booleanValue(), this.result != null, this.resultClass != null, rangeInMemory.booleanValue());
            }
            if (NucleusLogger.QUERY.isDebugEnabled()) {
                NucleusLogger.QUERY.debug((Object)Localiser.msg((String)"021074", (Object[])new Object[]{"JDOQL", "" + (System.currentTimeMillis() - startTime)}));
            }
            if (this.type == Query.QueryType.BULK_DELETE) {
                if (results instanceof QueryResult) {
                    ((QueryResult)results).disconnect();
                }
                this.ec.deleteObjects(results.toArray());
                resultMapper = Long.valueOf(results.size());
                return resultMapper;
            }
            if (this.type == Query.QueryType.BULK_UPDATE) {
                throw new NucleusException("Bulk Update is not yet supported");
            }
            if (results instanceof QueryResult) {
                final QueryResult qr1 = (QueryResult)results;
                final ManagedConnection mconn1 = mconn;
                ManagedConnectionResourceListener listener = new ManagedConnectionResourceListener(){

                    public void transactionFlushed() {
                    }

                    public void transactionPreClose() {
                        qr1.disconnect();
                    }

                    public void managedConnectionPreClose() {
                        if (!JDOQLQuery.this.ec.getTransaction().isActive()) {
                            qr1.disconnect();
                        }
                    }

                    public void managedConnectionPostClose() {
                    }

                    public void resourcePostClose() {
                        mconn1.removeListener((ManagedConnectionResourceListener)this);
                    }
                };
                mconn.addListener(listener);
                if (qr1 instanceof AbstractQueryResult) {
                    ((AbstractQueryResult)qr1).addConnectionListener(listener);
                }
            }
            ArrayList arrayList = results;
            return arrayList;
        }
        finally {
            mconn.release();
        }
    }

    private void compileQueryFull(Map parameters, AbstractClassMetaData candidateCmd) {
        long startTime = 0L;
        if (NucleusLogger.QUERY.isDebugEnabled()) {
            startTime = System.currentTimeMillis();
            NucleusLogger.QUERY.debug((Object)Localiser.msg((String)"021083", (Object[])new Object[]{this.getLanguage(), this.toString()}));
        }
        QueryToMongoDBMapper mapper = new QueryToMongoDBMapper(this.compilation, parameters, candidateCmd, this.ec, (Query)this);
        mapper.compile();
        this.datastoreCompilation.setFilterComplete(mapper.isFilterComplete());
        this.datastoreCompilation.setFilterExpression(mapper.getFilterExpression());
        this.datastoreCompilation.setOrdering(mapper.getOrderingObject());
        this.datastoreCompilation.setOrderComplete(mapper.isOrderComplete());
        this.datastoreCompilation.setResultComplete(mapper.isResultComplete());
        this.datastoreCompilation.setResult(mapper.getResultObject());
        this.datastoreCompilation.setPrecompilable(mapper.isPrecompilable());
        if (this.candidateCollection != null) {
            // empty if block
        }
        if (this.range != null) {
            // empty if block
        }
        if (NucleusLogger.QUERY.isDebugEnabled()) {
            NucleusLogger.QUERY.debug((Object)Localiser.msg((String)"021084", (Object[])new Object[]{this.getLanguage(), System.currentTimeMillis() - startTime}));
        }
    }
}

