/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mongodb.fieldmanager;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.List;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.EmbeddedMetaData;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.mongodb.MongoDBUtils;
import org.datanucleus.store.mongodb.fieldmanager.StoreFieldManager;
import org.datanucleus.store.schema.table.MemberColumnMapping;
import org.datanucleus.store.schema.table.Table;

public class StoreEmbeddedFieldManager
extends StoreFieldManager {
    protected List<AbstractMemberMetaData> mmds;

    public StoreEmbeddedFieldManager(ObjectProvider op, DBObject dbObject, boolean insert, List<AbstractMemberMetaData> mmds, Table table) {
        super(op, dbObject, insert, table);
        this.mmds = mmds;
    }

    @Override
    protected MemberColumnMapping getColumnMapping(int fieldNumber) {
        ArrayList<AbstractMemberMetaData> embMmds = new ArrayList<AbstractMemberMetaData>(this.mmds);
        embMmds.add(this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber));
        return this.table.getMemberColumnMappingForEmbeddedMember(embMmds);
    }

    @Override
    public void storeObjectField(int fieldNumber, Object value) {
        AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        AbstractMemberMetaData lastMmd = this.mmds.get(this.mmds.size() - 1);
        EmbeddedMetaData embmd = this.mmds.get(0).getEmbeddedMetaData();
        if (this.mmds.size() == 1 && embmd != null && embmd.getOwnerMember() != null && embmd.getOwnerMember().equals(mmd.getName())) {
            ObjectProvider[] ownerOPs;
            if (this.op != null && (ownerOPs = this.ec.getOwnersForEmbeddedObjectProvider(this.op)) != null && ownerOPs.length == 1 && value != ownerOPs[0].getObject()) {
                this.op.replaceField(fieldNumber, ownerOPs[0].getObject());
            }
            return;
        }
        ExecutionContext ec = this.op.getExecutionContext();
        ClassLoaderResolver clr = ec.getClassLoaderResolver();
        RelationType relationType = mmd.getRelationType(clr);
        if (relationType != RelationType.NONE && MetaDataUtils.getInstance().isMemberEmbedded(ec.getMetaDataManager(), clr, mmd, relationType, lastMmd) && RelationType.isRelationSingleValued((RelationType)relationType)) {
            AbstractClassMetaData embCmd = ec.getMetaDataManager().getMetaDataForClass(mmd.getType(), clr);
            if (embCmd == null) {
                throw new NucleusUserException("Field " + mmd.getFullFieldName() + " specified as embedded but metadata not found for the class of type " + mmd.getTypeName());
            }
            boolean nested = MongoDBUtils.isMemberNested(mmd);
            if (RelationType.isBidirectional((RelationType)relationType)) {
                // empty if block
            }
            if (value == null) {
                if (nested) {
                    MemberColumnMapping mapping = this.getColumnMapping(fieldNumber);
                    for (int i = 0; i < mapping.getNumberOfColumns(); ++i) {
                        this.dbObject.removeField(mapping.getColumn(i).getName());
                    }
                    return;
                }
                return;
            }
            ArrayList<AbstractMemberMetaData> embMmds = new ArrayList<AbstractMemberMetaData>(this.mmds);
            embMmds.add(mmd);
            if (nested) {
                BasicDBObject embeddedObject = new BasicDBObject();
                ObjectProvider embOP = ec.findObjectProviderForEmbedded(value, this.op, mmd);
                StoreEmbeddedFieldManager ffm = new StoreEmbeddedFieldManager(embOP, (DBObject)embeddedObject, this.insert, embMmds, this.table);
                embOP.provideFields(embCmd.getAllMemberPositions(), (FieldManager)ffm);
                MemberColumnMapping mapping = this.getColumnMapping(fieldNumber);
                this.dbObject.put(mapping.getColumn(0).getName(), (Object)embeddedObject);
                return;
            }
            ObjectProvider embOP = ec.findObjectProviderForEmbedded(value, this.op, mmd);
            StoreEmbeddedFieldManager ffm = new StoreEmbeddedFieldManager(embOP, this.dbObject, this.insert, embMmds, this.table);
            embOP.provideFields(embCmd.getAllMemberPositions(), (FieldManager)ffm);
            return;
        }
        this.storeNonEmbeddedObjectField(mmd, relationType, clr, value);
    }
}

