/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mongodb;

import com.mongodb.DB;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.PersistenceNucleusContext;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.identity.SCOID;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.ClassPersistenceModifier;
import org.datanucleus.metadata.IdentityMetaData;
import org.datanucleus.metadata.JdbcType;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.store.AbstractStoreManager;
import org.datanucleus.store.StoreData;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.mongodb.MongoDBPersistenceHandler;
import org.datanucleus.store.mongodb.MongoDBSchemaHandler;
import org.datanucleus.store.mongodb.MongoDBUtils;
import org.datanucleus.store.schema.SchemaAwareStoreManager;
import org.datanucleus.util.Localiser;

public class MongoDBStoreManager
extends AbstractStoreManager
implements SchemaAwareStoreManager {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.store.mongodb.Localisation", (ClassLoader)MongoDBStoreManager.class.getClassLoader());
    public static final String CAPPED_SIZE_EXTENSION_NAME = "mongodb.capped.size";

    public MongoDBStoreManager(ClassLoaderResolver clr, PersistenceNucleusContext nucleusCtx, Map<String, Object> props) {
        super("mongodb", clr, nucleusCtx, props);
        this.schemaHandler = new MongoDBSchemaHandler((StoreManager)this);
        this.persistenceHandler = new MongoDBPersistenceHandler((StoreManager)this);
        this.logConfiguration();
    }

    public Collection getSupportedOptions() {
        HashSet<String> set = new HashSet<String>();
        set.add("ApplicationId");
        set.add("ApplicationCompositeId");
        set.add("DatastoreId");
        set.add("NonDurableId");
        set.add("ORM");
        set.add("ORM.EmbeddedPC");
        set.add("ORM.EmbeddedCollection");
        set.add("ORM.EmbeddedMap");
        set.add("ORM.EmbeddedArray");
        set.add("TransactionIsolationLevel.read-committed");
        return set;
    }

    public String getClassNameForObjectID(Object id, ClassLoaderResolver clr, ExecutionContext ec) {
        if (id == null) {
            return null;
        }
        if (id instanceof SCOID) {
            return ((SCOID)id).getSCOClass();
        }
        String rootClassName = super.getClassNameForObjectID(id, clr, ec);
        String[] subclasses = this.getMetaDataManager().getSubclassesForClass(rootClassName, true);
        if (subclasses == null || subclasses.length == 0) {
            return rootClassName;
        }
        AbstractClassMetaData rootCmd = this.getMetaDataManager().getMetaDataForClass(rootClassName, clr);
        return MongoDBUtils.getClassNameForIdentity(id, rootCmd, ec, clr);
    }

    public boolean supportsValueStrategy(String strategy) {
        if (super.supportsValueStrategy(strategy)) {
            return true;
        }
        return strategy.equalsIgnoreCase("IDENTITY");
    }

    protected String getStrategyForNative(AbstractClassMetaData cmd, int absFieldNumber) {
        if (absFieldNumber >= 0) {
            AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(absFieldNumber);
            Class type = mmd.getType();
            if (String.class.isAssignableFrom(type)) {
                if (this.supportsValueStrategy("identity")) {
                    return "identity";
                }
                return "uuid-hex";
            }
            if (type == Long.class || type == Integer.class || type == Short.class || type == Long.TYPE || type == Integer.TYPE || type == Short.TYPE) {
                if (this.supportsValueStrategy("sequence") && mmd.getSequence() != null) {
                    return "sequence";
                }
                if (this.supportsValueStrategy("increment")) {
                    return "increment";
                }
                throw new NucleusUserException("This datastore provider doesn't support numeric native strategy for member " + mmd.getFullFieldName());
            }
            throw new NucleusUserException("This datastore provider doesn't support native strategy for field of type " + type.getName());
        }
        IdentityMetaData idmd = cmd.getBaseIdentityMetaData();
        if (idmd != null && idmd.getColumnMetaData() != null && MetaDataUtils.isJdbcTypeString((JdbcType)idmd.getColumnMetaData().getJdbcType())) {
            return "uuid-hex";
        }
        if (this.supportsValueStrategy("identity")) {
            return "identity";
        }
        if (this.supportsValueStrategy("sequence") && idmd.getSequence() != null) {
            return "sequence";
        }
        if (this.supportsValueStrategy("increment")) {
            return "increment";
        }
        throw new NucleusUserException("This datastore provider doesn't support numeric native strategy for class " + cmd.getFullClassName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void manageClasses(ClassLoaderResolver clr, String ... classNames) {
        if (classNames == null) {
            return;
        }
        ManagedConnection mconn = this.getConnection(-1);
        try {
            DB db = (DB)mconn.getConnection();
            this.manageClasses(classNames, clr, db);
        }
        finally {
            mconn.release();
        }
    }

    public void manageClasses(String[] classNames, ClassLoaderResolver clr, DB db) {
        if (classNames == null) {
            return;
        }
        String[] filteredClassNames = this.getNucleusContext().getTypeManager().filterOutSupportedSecondClassNames(classNames);
        for (ClassMetaData cmd : this.getMetaDataManager().getReferencedClasses(filteredClassNames, clr)) {
            if (cmd.getPersistenceModifier() != ClassPersistenceModifier.PERSISTENCE_CAPABLE || this.storeDataMgr.managesClass(cmd.getFullClassName())) continue;
            StoreData sd = this.storeDataMgr.get(cmd.getFullClassName());
            if (sd == null) {
                this.registerStoreData(this.newStoreData(cmd, clr));
            }
            HashSet<String> clsNames = new HashSet<String>();
            clsNames.add(cmd.getFullClassName());
            this.schemaHandler.createSchemaForClasses(clsNames, null, (Object)db);
        }
    }

    public void createSchema(String schemaName, Properties props) {
        this.schemaHandler.createSchema(schemaName, props, null);
    }

    public void deleteSchema(String schemaName, Properties props) {
        this.schemaHandler.deleteSchema(schemaName, props, null);
    }

    public void createSchemaForClasses(Set<String> classNames, Properties props) {
        this.schemaHandler.createSchemaForClasses(classNames, props, null);
    }

    public void deleteSchemaForClasses(Set<String> classNames, Properties props) {
        this.schemaHandler.deleteSchemaForClasses(classNames, props, null);
    }

    public void validateSchemaForClasses(Set<String> classNames, Properties props) {
        this.schemaHandler.validateSchema(classNames, props, null);
    }
}

