/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mongodb.fieldmanager;

import com.mongodb.DBObject;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.EmbeddedMetaData;
import org.datanucleus.metadata.FieldPersistenceModifier;
import org.datanucleus.metadata.IdentityStrategy;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.fieldmanager.AbstractFetchFieldManager;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.mongodb.MongoDBUtils;
import org.datanucleus.store.mongodb.fieldmanager.FetchEmbeddedFieldManager;
import org.datanucleus.store.schema.naming.ColumnType;
import org.datanucleus.store.types.SCOUtils;
import org.datanucleus.store.types.converters.TypeConverter;
import org.datanucleus.util.NucleusLogger;

public class FetchFieldManager
extends AbstractFetchFieldManager {
    protected DBObject dbObject;
    boolean embedded = false;
    protected AbstractMemberMetaData ownerMmd = null;

    public FetchFieldManager(ObjectProvider op, DBObject dbObject) {
        super(op);
        this.dbObject = dbObject;
        if (op.getEmbeddedOwners() != null) {
            this.embedded = true;
        }
    }

    public FetchFieldManager(ExecutionContext ec, DBObject dbObject, AbstractClassMetaData cmd) {
        super(ec, cmd);
        this.dbObject = dbObject;
    }

    public boolean fetchBooleanField(int fieldNumber) {
        String fieldName = this.getFieldName(fieldNumber);
        if (!this.dbObject.containsField(fieldName)) {
            AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
            String dflt = MongoDBUtils.getDefaultValueForMember(mmd);
            if (dflt != null) {
                return Boolean.valueOf(dflt);
            }
            return false;
        }
        Object value = this.dbObject.get(fieldName);
        return (Boolean)value;
    }

    public byte fetchByteField(int fieldNumber) {
        String fieldName = this.getFieldName(fieldNumber);
        if (!this.dbObject.containsField(fieldName)) {
            AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
            String dflt = MongoDBUtils.getDefaultValueForMember(mmd);
            if (dflt != null) {
                return Byte.valueOf(dflt);
            }
            return 0;
        }
        Object value = this.dbObject.get(fieldName);
        return ((Number)value).byteValue();
    }

    public char fetchCharField(int fieldNumber) {
        String fieldName = this.getFieldName(fieldNumber);
        if (!this.dbObject.containsField(fieldName)) {
            AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
            String dflt = MongoDBUtils.getDefaultValueForMember(mmd);
            if (dflt != null && dflt.length() > 0) {
                return dflt.charAt(0);
            }
            return '\u0000';
        }
        Object value = this.dbObject.get(fieldName);
        return ((String)value).charAt(0);
    }

    public double fetchDoubleField(int fieldNumber) {
        String fieldName = this.getFieldName(fieldNumber);
        if (!this.dbObject.containsField(fieldName)) {
            AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
            String dflt = MongoDBUtils.getDefaultValueForMember(mmd);
            if (dflt != null) {
                return Double.valueOf(dflt);
            }
            return 0.0;
        }
        Object value = this.dbObject.get(fieldName);
        return ((Number)value).doubleValue();
    }

    public float fetchFloatField(int fieldNumber) {
        String fieldName = this.getFieldName(fieldNumber);
        if (!this.dbObject.containsField(fieldName)) {
            AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
            String dflt = MongoDBUtils.getDefaultValueForMember(mmd);
            if (dflt != null) {
                return Float.valueOf(dflt).floatValue();
            }
            return 0.0f;
        }
        Object value = this.dbObject.get(fieldName);
        return ((Number)value).floatValue();
    }

    public int fetchIntField(int fieldNumber) {
        String fieldName = this.getFieldName(fieldNumber);
        if (!this.dbObject.containsField(fieldName)) {
            AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
            String dflt = MongoDBUtils.getDefaultValueForMember(mmd);
            if (dflt != null) {
                return Integer.valueOf(dflt);
            }
            return 0;
        }
        Object value = this.dbObject.get(fieldName);
        return ((Number)value).intValue();
    }

    public long fetchLongField(int fieldNumber) {
        String fieldName = this.getFieldName(fieldNumber);
        if (!this.dbObject.containsField(fieldName)) {
            AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
            String dflt = MongoDBUtils.getDefaultValueForMember(mmd);
            if (dflt != null) {
                return Long.valueOf(dflt);
            }
            return 0L;
        }
        Object value = this.dbObject.get(fieldName);
        return ((Number)value).longValue();
    }

    public short fetchShortField(int fieldNumber) {
        String fieldName = this.getFieldName(fieldNumber);
        if (!this.dbObject.containsField(fieldName)) {
            AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
            String dflt = MongoDBUtils.getDefaultValueForMember(mmd);
            if (dflt != null) {
                return Short.valueOf(dflt);
            }
            return 0;
        }
        Object value = this.dbObject.get(fieldName);
        return ((Number)value).shortValue();
    }

    public String fetchStringField(int fieldNumber) {
        AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (mmd.getValueStrategy() == IdentityStrategy.IDENTITY) {
            Object id = this.dbObject.get("_id");
            return id.toString();
        }
        String fieldName = this.getFieldName(fieldNumber);
        if (this.dbObject.containsField(fieldName)) {
            return (String)this.dbObject.get(fieldName);
        }
        return null;
    }

    protected String getFieldName(int fieldNumber) {
        return this.ec.getStoreManager().getNamingFactory().getColumnName(this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber), ColumnType.COLUMN);
    }

    public Object fetchObjectField(int fieldNumber) {
        String fieldName;
        AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (mmd.getPersistenceModifier() != FieldPersistenceModifier.PERSISTENT) {
            return this.op.provideField(fieldNumber);
        }
        ClassLoaderResolver clr = this.ec.getClassLoaderResolver();
        RelationType relationType = mmd.getRelationType(clr);
        if (relationType != RelationType.NONE && MetaDataUtils.getInstance().isMemberEmbedded(this.ec.getMetaDataManager(), clr, mmd, relationType, this.ownerMmd)) {
            if (RelationType.isRelationSingleValued((RelationType)relationType)) {
                AbstractClassMetaData embcmd = this.ec.getMetaDataManager().getMetaDataForClass(mmd.getType(), clr);
                if (embcmd == null) {
                    throw new NucleusUserException("Field " + mmd.getFullFieldName() + " marked as embedded but no such metadata");
                }
                boolean nested = true;
                String nestedStr = mmd.getValueForExtension("nested");
                if (nestedStr != null && nestedStr.equalsIgnoreCase("false")) {
                    nested = false;
                }
                if (nested) {
                    String fieldName2;
                    if (this.ownerMmd != null) {
                        if (RelationType.isBidirectional((RelationType)relationType)) {
                            if (this.ownerMmd.getMappedBy() != null && mmd.getName().equals(this.ownerMmd.getMappedBy()) || mmd.getMappedBy() != null && this.ownerMmd.getName().equals(mmd.getMappedBy())) {
                                ObjectProvider[] ownerOps = this.op.getEmbeddedOwners();
                                return ownerOps != null && ownerOps.length > 0 ? ownerOps[0].getObject() : null;
                            }
                        } else if (this.ownerMmd.hasCollection()) {
                            if (this.ownerMmd.getElementMetaData().getEmbeddedMetaData() != null && this.ownerMmd.getElementMetaData().getEmbeddedMetaData().getOwnerMember() != null && this.ownerMmd.getElementMetaData().getEmbeddedMetaData().getOwnerMember().equals(mmd.getName())) {
                                ObjectProvider[] ownerOps = this.op.getEmbeddedOwners();
                                return ownerOps != null && ownerOps.length > 0 ? ownerOps[0].getObject() : null;
                            }
                        } else if (this.ownerMmd.getEmbeddedMetaData() != null && this.ownerMmd.getEmbeddedMetaData().getOwnerMember() != null && this.ownerMmd.getEmbeddedMetaData().getOwnerMember().equals(mmd.getName())) {
                            ObjectProvider[] ownerOps = this.op.getEmbeddedOwners();
                            return ownerOps != null && ownerOps.length > 0 ? ownerOps[0].getObject() : null;
                        }
                    }
                    if (!this.dbObject.containsField(fieldName2 = this.ec.getStoreManager().getNamingFactory().getColumnName(mmd, ColumnType.COLUMN))) {
                        return null;
                    }
                    DBObject embeddedValue = (DBObject)this.dbObject.get(fieldName2);
                    if (embcmd.hasDiscriminatorStrategy()) {
                        String discPropName = null;
                        discPropName = mmd.getEmbeddedMetaData() != null && mmd.getEmbeddedMetaData().getDiscriminatorMetaData() != null ? mmd.getEmbeddedMetaData().getDiscriminatorMetaData().getColumnName() : this.ec.getStoreManager().getNamingFactory().getColumnName(embcmd, ColumnType.DISCRIMINATOR_COLUMN);
                        String discVal = (String)embeddedValue.get(discPropName);
                        String elemClassName = this.ec.getMetaDataManager().getClassNameFromDiscriminatorValue(discVal, embcmd.getDiscriminatorMetaData());
                        if (!elemClassName.equals(embcmd.getFullClassName())) {
                            embcmd = this.ec.getMetaDataManager().getMetaDataForClass(elemClassName, clr);
                        }
                    }
                    ObjectProvider embOP = this.ec.newObjectProviderForEmbedded(embcmd, this.op, fieldNumber);
                    FetchFieldManager ffm = new FetchFieldManager(embOP, embeddedValue);
                    ffm.ownerMmd = mmd;
                    ffm.embedded = true;
                    embOP.replaceFields(embcmd.getAllMemberPositions(), (FieldManager)ffm);
                    return embOP.getObject();
                }
                if (embcmd.hasDiscriminatorStrategy()) {
                    String discPropName = null;
                    discPropName = mmd.getEmbeddedMetaData() != null && mmd.getEmbeddedMetaData().getDiscriminatorMetaData() != null ? mmd.getEmbeddedMetaData().getDiscriminatorMetaData().getColumnName() : this.ec.getStoreManager().getNamingFactory().getColumnName(embcmd, ColumnType.DISCRIMINATOR_COLUMN);
                    String discVal = (String)this.dbObject.get(discPropName);
                    String elemClassName = this.ec.getMetaDataManager().getClassNameFromDiscriminatorValue(discVal, embcmd.getDiscriminatorMetaData());
                    if (!elemClassName.equals(embcmd.getFullClassName())) {
                        embcmd = this.ec.getMetaDataManager().getMetaDataForClass(elemClassName, clr);
                    }
                }
                EmbeddedMetaData embmd = mmd.getEmbeddedMetaData();
                AbstractMemberMetaData[] embmmds = embmd.getMemberMetaData();
                boolean isNull = true;
                for (int i = 0; i < embmmds.length; ++i) {
                    String embFieldName = MongoDBUtils.getFieldName(mmd, i);
                    if (!this.dbObject.containsField(embFieldName)) continue;
                    isNull = false;
                    break;
                }
                if (isNull) {
                    return null;
                }
                ObjectProvider embOP = this.ec.newObjectProviderForEmbedded(embcmd, this.op, fieldNumber);
                FetchEmbeddedFieldManager ffm = new FetchEmbeddedFieldManager(embOP, this.dbObject, mmd);
                embOP.replaceFields(embcmd.getAllMemberPositions(), (FieldManager)ffm);
                return embOP.getObject();
            }
            if (RelationType.isRelationMultiValued((RelationType)relationType)) {
                if (mmd.hasCollection()) {
                    Collection coll;
                    String fieldName3 = this.ec.getStoreManager().getNamingFactory().getColumnName(mmd, ColumnType.COLUMN);
                    if (!this.dbObject.containsField(fieldName3)) {
                        return null;
                    }
                    Object value = this.dbObject.get(fieldName3);
                    AbstractClassMetaData elemCmd = mmd.getCollection().getElementClassMetaData(clr, this.ec.getMetaDataManager());
                    try {
                        Class instanceType = SCOUtils.getContainerInstanceType((Class)mmd.getType(), (Boolean)(mmd.getOrderMetaData() != null ? 1 : 0));
                        coll = (Collection)instanceType.newInstance();
                    }
                    catch (Exception e) {
                        throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
                    }
                    Collection collValue = (Collection)value;
                    for (DBObject elementObj : collValue) {
                        AbstractClassMetaData elementCmd = elemCmd;
                        if (elementCmd.hasDiscriminatorStrategy()) {
                            String discPropName = null;
                            discPropName = mmd.getEmbeddedMetaData() != null && mmd.getEmbeddedMetaData().getDiscriminatorMetaData() != null ? mmd.getEmbeddedMetaData().getDiscriminatorMetaData().getColumnName() : this.ec.getStoreManager().getNamingFactory().getColumnName(elementCmd, ColumnType.DISCRIMINATOR_COLUMN);
                            String discVal = (String)elementObj.get(discPropName);
                            String elemClassName = this.ec.getMetaDataManager().getClassNameFromDiscriminatorValue(discVal, elementCmd.getDiscriminatorMetaData());
                            if (!elemClassName.equals(elementCmd.getFullClassName())) {
                                elementCmd = this.ec.getMetaDataManager().getMetaDataForClass(elemClassName, clr);
                            }
                        }
                        ObjectProvider embOP = this.ec.newObjectProviderForEmbedded(elementCmd, this.op, fieldNumber);
                        embOP.setPcObjectType((short)2);
                        FetchFieldManager ffm = new FetchFieldManager(embOP, elementObj);
                        ffm.ownerMmd = mmd;
                        ffm.embedded = true;
                        embOP.replaceFields(elementCmd.getAllMemberPositions(), (FieldManager)ffm);
                        coll.add(embOP.getObject());
                    }
                    if (this.op != null) {
                        return this.op.wrapSCOField(fieldNumber, (Object)coll, false, false, true);
                    }
                    return coll;
                }
                if (mmd.hasArray()) {
                    String fieldName4 = this.ec.getStoreManager().getNamingFactory().getColumnName(mmd, ColumnType.COLUMN);
                    if (!this.dbObject.containsField(fieldName4)) {
                        return null;
                    }
                    AbstractClassMetaData elemCmd = mmd.getArray().getElementClassMetaData(clr, this.ec.getMetaDataManager());
                    Object value = this.dbObject.get(fieldName4);
                    Object[] array = new Object[Array.getLength(value)];
                    for (int i = 0; i < array.length; ++i) {
                        DBObject elementObj = (DBObject)Array.get(value, i);
                        AbstractClassMetaData elementCmd = elemCmd;
                        if (elementCmd.hasDiscriminatorStrategy()) {
                            String discPropName = null;
                            discPropName = mmd.getEmbeddedMetaData() != null && mmd.getEmbeddedMetaData().getDiscriminatorMetaData() != null ? mmd.getEmbeddedMetaData().getDiscriminatorMetaData().getColumnName() : this.ec.getStoreManager().getNamingFactory().getColumnName(elementCmd, ColumnType.DISCRIMINATOR_COLUMN);
                            String discVal = (String)elementObj.get(discPropName);
                            String elemClassName = this.ec.getMetaDataManager().getClassNameFromDiscriminatorValue(discVal, elementCmd.getDiscriminatorMetaData());
                            if (!elemClassName.equals(elementCmd.getFullClassName())) {
                                elementCmd = this.ec.getMetaDataManager().getMetaDataForClass(elemClassName, clr);
                            }
                        }
                        ObjectProvider embOP = this.ec.newObjectProviderForEmbedded(elementCmd, this.op, fieldNumber);
                        embOP.setPcObjectType((short)2);
                        FetchFieldManager ffm = new FetchFieldManager(embOP, elementObj);
                        ffm.ownerMmd = mmd;
                        ffm.embedded = true;
                        embOP.replaceFields(elementCmd.getAllMemberPositions(), (FieldManager)ffm);
                        array[i] = embOP.getObject();
                    }
                    return array;
                }
                String fieldName5 = this.ec.getStoreManager().getNamingFactory().getColumnName(mmd, ColumnType.COLUMN);
                if (!this.dbObject.containsField(fieldName5)) {
                    return null;
                }
                Object value = this.dbObject.get(fieldName5);
                Map map = null;
                try {
                    Class instanceType = SCOUtils.getContainerInstanceType((Class)mmd.getType(), null);
                    map = (Map)instanceType.newInstance();
                }
                catch (Exception e) {
                    throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
                }
                AbstractClassMetaData keyCmd = mmd.getMap().getKeyClassMetaData(clr, this.ec.getMetaDataManager());
                AbstractClassMetaData valCmd = mmd.getMap().getValueClassMetaData(clr, this.ec.getMetaDataManager());
                Collection entryColl = (Collection)value;
                for (DBObject entryObj : entryColl) {
                    Object keyObj = entryObj.get("key");
                    Object valObj = entryObj.get("value");
                    Object mapKey = null;
                    if (keyCmd != null) {
                        DBObject keyDbObj = (DBObject)keyObj;
                        ObjectProvider embOP = this.ec.newObjectProviderForEmbedded(keyCmd, this.op, fieldNumber);
                        embOP.setPcObjectType((short)3);
                        FetchFieldManager ffm = new FetchFieldManager(embOP, keyDbObj);
                        ffm.ownerMmd = mmd;
                        ffm.embedded = true;
                        embOP.replaceFields(keyCmd.getAllMemberPositions(), (FieldManager)ffm);
                        mapKey = embOP.getObject();
                    } else {
                        mapKey = this.getMapKeyForReturnValue(mmd, keyObj);
                    }
                    Object mapVal = null;
                    if (valCmd != null) {
                        DBObject valDbObj = (DBObject)valObj;
                        ObjectProvider embOP = this.ec.newObjectProviderForEmbedded(valCmd, this.op, fieldNumber);
                        embOP.setPcObjectType((short)4);
                        FetchFieldManager ffm = new FetchFieldManager(embOP, valDbObj);
                        ffm.ownerMmd = mmd;
                        ffm.embedded = true;
                        embOP.replaceFields(valCmd.getAllMemberPositions(), (FieldManager)ffm);
                        mapVal = embOP.getObject();
                    } else {
                        mapVal = this.getMapValueForReturnValue(mmd, valObj);
                    }
                    map.put(mapKey, mapVal);
                }
                if (this.op != null) {
                    return this.op.wrapSCOField(fieldNumber, (Object)map, false, false, true);
                }
                return map;
            }
        }
        if (!this.dbObject.containsField(fieldName = this.ec.getStoreManager().getNamingFactory().getColumnName(mmd, ColumnType.COLUMN))) {
            return null;
        }
        Object value = this.dbObject.get(fieldName);
        if (mmd.isSerialized()) {
            ObjectProvider embSM;
            Object obj = MongoDBUtils.getFieldValueForJavaSerialisedField(mmd, value);
            if (this.op != null) {
                obj = this.op.wrapSCOField(mmd.getAbsoluteFieldNumber(), obj, false, false, true);
            }
            if (RelationType.isRelationSingleValued((RelationType)relationType) && ((embSM = this.ec.findObjectProvider(obj)) == null || this.ec.getApiAdapter().getExecutionContext(obj) == null)) {
                this.ec.newObjectProviderForEmbedded(obj, false, this.op, fieldNumber);
            }
            return obj;
        }
        if (RelationType.isRelationSingleValued((RelationType)relationType)) {
            return this.getValueForSingleRelationField(mmd, value, clr);
        }
        if (RelationType.isRelationMultiValued((RelationType)relationType)) {
            return this.getValueForContainerRelationField(mmd, value, clr);
        }
        ColumnMetaData colmd = null;
        if (mmd.getColumnMetaData() != null && mmd.getColumnMetaData().length > 0) {
            colmd = mmd.getColumnMetaData()[0];
        }
        Object val = this.getValueForContainerNonRelationField(mmd, value, colmd);
        if (this.op != null) {
            return this.op.wrapSCOField(mmd.getAbsoluteFieldNumber(), val, false, false, true);
        }
        return val;
    }

    protected Object getValueForSingleRelationField(AbstractMemberMetaData mmd, Object value, ClassLoaderResolver clr) {
        String idStr = (String)value;
        if (value == null) {
            return null;
        }
        try {
            Object obj = null;
            AbstractClassMetaData memberCmd = this.ec.getMetaDataManager().getMetaDataForClass(mmd.getType(), clr);
            obj = memberCmd.usesSingleFieldIdentityClass() && idStr.indexOf(58) > 0 ? IdentityUtils.getObjectFromPersistableIdentity((String)idStr, (AbstractClassMetaData)memberCmd, (ExecutionContext)this.ec) : IdentityUtils.getObjectFromIdString((String)idStr, (AbstractClassMetaData)memberCmd, (ExecutionContext)this.ec, (boolean)true);
            return obj;
        }
        catch (NucleusObjectNotFoundException onfe) {
            NucleusLogger.GENERAL.warn((Object)("Object=" + this.op + " field=" + mmd.getFullFieldName() + " has id=" + idStr + " but could not instantiate object with that identity"));
            return null;
        }
    }

    protected Object getValueForContainerRelationField(AbstractMemberMetaData mmd, Object value, ClassLoaderResolver clr) {
        if (mmd.hasCollection()) {
            Collection coll;
            try {
                Class instanceType = SCOUtils.getContainerInstanceType((Class)mmd.getType(), (Boolean)(mmd.getOrderMetaData() != null ? 1 : 0));
                coll = (Collection)instanceType.newInstance();
            }
            catch (Exception e) {
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
            AbstractClassMetaData elemCmd = mmd.getCollection().getElementClassMetaData(clr, this.ec.getMetaDataManager());
            if (elemCmd == null) {
                String[] implNames = MetaDataUtils.getInstance().getImplementationNamesForReferenceField(mmd, 3, clr, this.ec.getMetaDataManager());
                if (implNames != null && implNames.length == 1) {
                    elemCmd = this.ec.getMetaDataManager().getMetaDataForClass(implNames[0], clr);
                }
                if (elemCmd == null) {
                    throw new NucleusUserException("We do not currently support the field type of " + mmd.getFullFieldName() + " which has a collection of interdeterminate element type (e.g interface or Object element types)");
                }
            }
            Collection collIds = (Collection)value;
            Iterator idIter = collIds.iterator();
            boolean changeDetected = false;
            AbstractClassMetaData elementCmd = mmd.getCollection().getElementClassMetaData(this.ec.getClassLoaderResolver(), this.ec.getMetaDataManager());
            while (idIter.hasNext()) {
                String elementIdStr = (String)idIter.next();
                if (elementIdStr.equals("NULL")) {
                    coll.add(null);
                    continue;
                }
                try {
                    Object element = null;
                    element = elementCmd.usesSingleFieldIdentityClass() && elementIdStr.indexOf(58) > 0 ? IdentityUtils.getObjectFromPersistableIdentity((String)elementIdStr, (AbstractClassMetaData)elementCmd, (ExecutionContext)this.ec) : IdentityUtils.getObjectFromIdString((String)elementIdStr, (AbstractClassMetaData)elementCmd, (ExecutionContext)this.ec, (boolean)true);
                    coll.add(element);
                }
                catch (NucleusObjectNotFoundException onfe) {
                    changeDetected = true;
                }
            }
            if (this.op != null) {
                coll = (Collection)this.op.wrapSCOField(mmd.getAbsoluteFieldNumber(), (Object)coll, false, false, true);
                if (changeDetected) {
                    this.op.makeDirty(mmd.getAbsoluteFieldNumber());
                }
            }
            return coll;
        }
        if (mmd.hasMap()) {
            Map map = null;
            try {
                Class instanceType = SCOUtils.getContainerInstanceType((Class)mmd.getType(), null);
                map = (Map)instanceType.newInstance();
            }
            catch (Exception e) {
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
            AbstractClassMetaData keyCmd = mmd.getMap().getKeyClassMetaData(clr, this.ec.getMetaDataManager());
            AbstractClassMetaData valueCmd = mmd.getMap().getValueClassMetaData(clr, this.ec.getMetaDataManager());
            Collection collEntries = (Collection)value;
            Iterator entryIter = collEntries.iterator();
            boolean changeDetected = false;
            while (entryIter.hasNext()) {
                DBObject entryObj = (DBObject)entryIter.next();
                Object keyObj = entryObj.get("key");
                Object valueObj = entryObj.get("value");
                try {
                    Object mapKey = null;
                    if (keyCmd != null) {
                        String keyStr = (String)keyObj;
                        mapKey = keyCmd.usesSingleFieldIdentityClass() && keyStr.indexOf(58) > 0 ? IdentityUtils.getObjectFromPersistableIdentity((String)keyStr, (AbstractClassMetaData)keyCmd, (ExecutionContext)this.ec) : IdentityUtils.getObjectFromIdString((String)keyStr, (AbstractClassMetaData)keyCmd, (ExecutionContext)this.ec, (boolean)true);
                    } else {
                        mapKey = this.getMapKeyForReturnValue(mmd, keyObj);
                    }
                    Object mapVal = null;
                    if (valueCmd != null) {
                        String valStr = (String)valueObj;
                        mapVal = valueCmd.usesSingleFieldIdentityClass() && valStr.indexOf(58) > 0 ? IdentityUtils.getObjectFromPersistableIdentity((String)valStr, (AbstractClassMetaData)valueCmd, (ExecutionContext)this.ec) : IdentityUtils.getObjectFromIdString((String)valStr, (AbstractClassMetaData)valueCmd, (ExecutionContext)this.ec, (boolean)true);
                    } else {
                        mapVal = this.getMapValueForReturnValue(mmd, valueObj);
                    }
                    map.put(mapKey, mapVal);
                }
                catch (NucleusObjectNotFoundException onfe) {
                    changeDetected = true;
                }
            }
            if (this.op != null) {
                map = (Map)this.op.wrapSCOField(mmd.getAbsoluteFieldNumber(), (Object)map, false, false, true);
                if (changeDetected) {
                    this.op.makeDirty(mmd.getAbsoluteFieldNumber());
                }
            }
            return map;
        }
        if (mmd.hasArray()) {
            AbstractClassMetaData elemCmd = mmd.getArray().getElementClassMetaData(clr, this.ec.getMetaDataManager());
            if (elemCmd == null) {
                String[] implNames = MetaDataUtils.getInstance().getImplementationNamesForReferenceField(mmd, 4, clr, this.ec.getMetaDataManager());
                if (implNames != null && implNames.length == 1) {
                    elemCmd = this.ec.getMetaDataManager().getMetaDataForClass(implNames[0], clr);
                }
                if (elemCmd == null) {
                    throw new NucleusUserException("We do not currently support the field type of " + mmd.getFullFieldName() + " which has an array of interdeterminate element type (e.g interface or Object element types)");
                }
            }
            Collection collIds = (Collection)value;
            Iterator idIter = collIds.iterator();
            int i = 0;
            Object array = Array.newInstance(mmd.getType().getComponentType(), collIds.size());
            boolean changeDetected = false;
            while (idIter.hasNext()) {
                String elementIdStr = (String)idIter.next();
                if (elementIdStr.equals("NULL")) {
                    Array.set(array, i++, null);
                    continue;
                }
                try {
                    Object element = null;
                    element = elemCmd.usesSingleFieldIdentityClass() && elementIdStr.indexOf(58) > 0 ? IdentityUtils.getObjectFromPersistableIdentity((String)elementIdStr, (AbstractClassMetaData)elemCmd, (ExecutionContext)this.ec) : IdentityUtils.getObjectFromIdString((String)elementIdStr, (AbstractClassMetaData)elemCmd, (ExecutionContext)this.ec, (boolean)true);
                    Array.set(array, i++, element);
                }
                catch (NucleusObjectNotFoundException onfe) {
                    changeDetected = true;
                }
            }
            if (changeDetected) {
                if (i < collIds.size()) {
                    Object arrayOld = array;
                    array = Array.newInstance(mmd.getType().getComponentType(), i);
                    for (int j = 0; j < i; ++j) {
                        Array.set(array, j, Array.get(arrayOld, j));
                    }
                }
                if (this.op != null) {
                    this.op.makeDirty(mmd.getAbsoluteFieldNumber());
                }
            }
            return array;
        }
        return value;
    }

    protected Object getValueForContainerNonRelationField(AbstractMemberMetaData mmd, Object value, ColumnMetaData colmd) {
        if (mmd.getTypeConverterName() != null) {
            TypeConverter conv = this.ec.getNucleusContext().getTypeManager().getTypeConverterForName(mmd.getTypeConverterName());
            return conv.toMemberType(value);
        }
        Object fieldValue = MongoDBUtils.getFieldValueFromStored(this.ec, mmd, value, 2);
        if (this.op != null) {
            return this.op.wrapSCOField(mmd.getAbsoluteFieldNumber(), fieldValue, false, false, true);
        }
        return fieldValue;
    }

    private Object getMapKeyForReturnValue(AbstractMemberMetaData mmd, Object value) {
        String keyType = mmd.getMap().getKeyType();
        Class keyCls = this.ec.getClassLoaderResolver().classForName(keyType);
        if (keyCls == Long.class || keyCls == Double.class || keyCls == Float.class || keyCls == Integer.class || keyCls == Short.class || keyCls == String.class) {
            return value;
        }
        if (Enum.class.isAssignableFrom(keyCls)) {
            return Enum.valueOf(keyCls, (String)value);
        }
        throw new NucleusException("Dont currently support persistence/retrieval of maps with keys of type " + keyType);
    }

    private Object getMapValueForReturnValue(AbstractMemberMetaData mmd, Object value) {
        String valueType = mmd.getMap().getValueType();
        Class valueCls = this.ec.getClassLoaderResolver().classForName(valueType);
        if (valueCls == Long.class || valueCls == Double.class || valueCls == Float.class || valueCls == Integer.class || valueCls == Short.class || valueCls == String.class) {
            return value;
        }
        if (Enum.class.isAssignableFrom(valueCls)) {
            return Enum.valueOf(valueCls, (String)value);
        }
        throw new NucleusException("Dont currently support persistence/retrieval of maps with values of type " + valueType);
    }
}

