/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mongodb.query;

import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.datanucleus.FetchPlan;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.mongodb.MongoDBUtils;
import org.datanucleus.store.query.AbstractCandidateLazyLoadList;

public class MongoDBCandidateList
extends AbstractCandidateLazyLoadList {
    List<DBCursor> cursors = new ArrayList<DBCursor>();
    int size = -1;
    FetchPlan fp;
    boolean ignoreCache;

    public MongoDBCandidateList(Class cls, boolean subclasses, ExecutionContext ec, String cacheType, FetchPlan fp, boolean ignoreCache) {
        super(cls, subclasses, ec, cacheType);
        this.ignoreCache = ignoreCache;
        this.fp = fp;
        for (int i = 0; i < this.cmds.size(); ++i) {
            this.cursors.add(null);
        }
    }

    public void addCandidateCursor(AbstractClassMetaData cmd, DBCursor cursor) {
        int position = this.cmds.indexOf(cmd);
        this.cursors.set(position, cursor);
    }

    public void close() {
        for (DBCursor cursor : this.cursors) {
            cursor.close();
        }
    }

    protected Object retrieveObjectForIndex(int index) {
        Iterator<DBCursor> cursorIter = this.cursors.iterator();
        Iterator cmdIter = this.cmds.iterator();
        int first = 0;
        int last = -1;
        while (cursorIter.hasNext()) {
            DBCursor cursor = cursorIter.next();
            AbstractClassMetaData cmd = (AbstractClassMetaData)cmdIter.next();
            last = first + cursor.size();
            if (index >= first && index < last) {
                int i = first + cursor.numSeen();
                while (cursor.hasNext()) {
                    DBObject dbObject = cursor.next();
                    if (i == index) {
                        int[] fpMembers = this.fp.getFetchPlanForClass(cmd).getMemberNumbers();
                        if (cmd.getIdentityType() == IdentityType.APPLICATION) {
                            return MongoDBUtils.getObjectUsingApplicationIdForDBObject(dbObject, cmd, this.ec, this.ignoreCache, fpMembers);
                        }
                        if (cmd.getIdentityType() == IdentityType.DATASTORE) {
                            return MongoDBUtils.getObjectUsingDatastoreIdForDBObject(dbObject, cmd, this.ec, this.ignoreCache, fpMembers);
                        }
                        return MongoDBUtils.getObjectUsingNondurableIdForDBObject(dbObject, cmd, this.ec, this.ignoreCache, fpMembers);
                    }
                    ++i;
                }
                continue;
            }
            first = last;
        }
        return null;
    }

    protected int getSize() {
        if (this.size >= 0) {
            return this.size;
        }
        this.size = 0;
        for (DBCursor cursor : this.cursors) {
            this.size += cursor.size();
        }
        return this.size;
    }
}

