/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mongodb.query;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.metadata.DiscriminatorStrategy;
import org.datanucleus.query.evaluator.JPQLEvaluator;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.mongodb.MongoDBUtils;
import org.datanucleus.store.mongodb.query.MongoDBCandidateList;
import org.datanucleus.store.mongodb.query.MongoDBQueryCompilation;
import org.datanucleus.store.mongodb.query.QueryToMongoDBMapper;
import org.datanucleus.store.mongodb.query.expression.MongoBooleanExpression;
import org.datanucleus.store.mongodb.query.expression.MongoOperator;
import org.datanucleus.store.query.AbstractJPQLQuery;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.query.QueryManager;
import org.datanucleus.util.NucleusLogger;

public class JPQLQuery
extends AbstractJPQLQuery {
    protected transient MongoDBQueryCompilation datastoreCompilation = null;

    public JPQLQuery(StoreManager storeMgr, ExecutionContext ec) {
        this(storeMgr, ec, (JPQLQuery)null);
    }

    public JPQLQuery(StoreManager storeMgr, ExecutionContext ec, JPQLQuery q) {
        super(storeMgr, ec, (AbstractJPQLQuery)q);
    }

    public JPQLQuery(StoreManager storeMgr, ExecutionContext ec, String query) {
        super(storeMgr, ec, query);
    }

    protected void discardCompiled() {
        super.discardCompiled();
        this.datastoreCompilation = null;
    }

    protected boolean isCompiled() {
        if (this.evaluateInMemory()) {
            return this.compilation != null;
        }
        return this.compilation != null && this.datastoreCompilation != null;
    }

    protected boolean evaluateInMemory() {
        if (this.candidateCollection != null) {
            if (this.compilation != null && this.compilation.getSubqueryAliases() != null) {
                NucleusLogger.QUERY.warn((Object)"In-memory evaluator doesn't currently handle subqueries completely so evaluating in datastore");
                return false;
            }
            Object val = this.getExtension("datanucleus.query.evaluateInMemory");
            if (val == null) {
                return true;
            }
            return Boolean.valueOf((String)val);
        }
        return super.evaluateInMemory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void compileInternal(Map parameterValues) {
        if (this.isCompiled()) {
            return;
        }
        super.compileInternal(parameterValues);
        boolean inMemory = this.evaluateInMemory();
        if (this.candidateCollection != null && inMemory) {
            return;
        }
        if (this.candidateClass == null || this.candidateClassName == null) {
            this.candidateClass = this.compilation.getCandidateClass();
            this.candidateClassName = this.candidateClass.getName();
        }
        if (this.candidateClass == null) {
            throw new NucleusUserException(LOCALISER.msg("021009", (Object)this.candidateClassName));
        }
        this.ec.hasPersistenceInformationForClass(this.candidateClass);
        AbstractClassMetaData cmd = this.ec.getMetaDataManager().getMetaDataForClass(this.candidateClass, this.clr);
        QueryManager qm = this.getQueryManager();
        String datastoreKey = this.getStoreManager().getQueryCacheKey();
        String cacheKey = this.getQueryCacheKey();
        if (this.useCaching()) {
            this.datastoreCompilation = (MongoDBQueryCompilation)qm.getDatastoreQueryCompilation(datastoreKey, this.getLanguage(), cacheKey);
            if (this.datastoreCompilation != null) {
                this.setResultDistinct(this.compilation.getResultDistinct());
                return;
            }
        }
        MongoDBQueryCompilation mongoDBQueryCompilation = this.datastoreCompilation = new MongoDBQueryCompilation();
        synchronized (mongoDBQueryCompilation) {
            if (!inMemory) {
                this.compileQueryFull(parameterValues, cmd);
            }
        }
        if (cacheKey != null) {
            qm.addDatastoreQueryCompilation(datastoreKey, this.getLanguage(), cacheKey, (Object)this.datastoreCompilation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object performExecute(Map parameters) {
        ManagedConnection mconn = this.getStoreManager().getConnection(this.ec);
        try {
            Object object;
            DB db = (DB)mconn.getConnection();
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.QUERY.isDebugEnabled()) {
                NucleusLogger.QUERY.debug((Object)LOCALISER.msg("021046", (Object)"JPQL", (Object)this.getSingleStringQuery(), null));
            }
            boolean evaluateFilter = true;
            List candidates = null;
            if (this.candidateCollection != null) {
                candidates = new ArrayList(this.candidateCollection);
            } else {
                BasicDBObject filterObject = null;
                MongoBooleanExpression filterExpr = null;
                AbstractClassMetaData cmd = this.ec.getMetaDataManager().getMetaDataForClass(this.candidateClass, this.clr);
                if (cmd.hasDiscriminatorStrategy()) {
                    DiscriminatorMetaData discmd = cmd.getDiscriminatorMetaData();
                    String fieldName = MongoDBUtils.getFieldName(discmd);
                    String discVal = null;
                    discVal = cmd.getDiscriminatorStrategy() == DiscriminatorStrategy.CLASS_NAME ? cmd.getFullClassName() : discmd.getValue();
                    filterExpr = new MongoBooleanExpression(fieldName, discVal, MongoOperator.OP_EQ);
                }
                if (this.storeMgr.getStringProperty("datanucleus.TenantID") != null && !"true".equalsIgnoreCase(cmd.getValueForExtension("multitenancy-disable"))) {
                    String fieldName = MongoDBUtils.getFieldNameForMultitenancy(cmd);
                    String value = this.storeMgr.getStringProperty("datanucleus.TenantID");
                    MongoBooleanExpression tenancyExpr = new MongoBooleanExpression(fieldName, value, MongoOperator.OP_EQ);
                    filterExpr = filterExpr == null ? tenancyExpr : new MongoBooleanExpression(filterExpr, tenancyExpr, MongoOperator.OP_AND);
                }
                if (this.datastoreCompilation != null && this.datastoreCompilation.isFilterComplete()) {
                    MongoBooleanExpression userFilterExpr = this.datastoreCompilation.getFilterExpression();
                    if (filterExpr == null) {
                        filterExpr = userFilterExpr;
                    } else if (userFilterExpr != null) {
                        filterExpr = new MongoBooleanExpression(filterExpr, userFilterExpr, MongoOperator.OP_AND);
                    }
                }
                if (filterExpr != null) {
                    filterObject = filterExpr.getDBObject();
                }
                HashMap<String, Object> options = new HashMap<String, Object>();
                if (this.getBooleanExtensionProperty("slave-ok", false)) {
                    options.put("slave-ok", true);
                }
                candidates = MongoDBUtils.getObjectsOfCandidateType(this.ec, db, this.candidateClass, this.subclasses, this.ignoreCache, this.getFetchPlan(), filterObject, options);
                if (this.filter != null && this.datastoreCompilation.isFilterComplete()) {
                    evaluateFilter = false;
                }
            }
            JPQLEvaluator resultMapper = new JPQLEvaluator((Query)this, candidates, this.compilation, parameters, this.ec.getClassLoaderResolver());
            Collection results = resultMapper.execute(evaluateFilter, true, true, true, true);
            if (candidates instanceof MongoDBCandidateList) {
                ((MongoDBCandidateList)((Object)candidates)).close();
            }
            if (NucleusLogger.QUERY.isDebugEnabled()) {
                NucleusLogger.QUERY.debug((Object)LOCALISER.msg("021074", (Object)"JPQL", (Object)("" + (System.currentTimeMillis() - startTime))));
            }
            if (this.type == 2) {
                this.ec.deleteObjects(results.toArray());
                object = (long)results.size();
                return object;
            }
            if (this.type == 1) {
                throw new NucleusException("Bulk Update is not yet supported");
            }
            object = results;
            return object;
        }
        finally {
            mconn.release();
        }
    }

    private void compileQueryFull(Map parameters, AbstractClassMetaData candidateCmd) {
        if (this.type != 0) {
            return;
        }
        long startTime = 0L;
        if (NucleusLogger.QUERY.isDebugEnabled()) {
            startTime = System.currentTimeMillis();
            NucleusLogger.QUERY.debug((Object)LOCALISER.msg("021083", (Object)this.getLanguage(), (Object)this.toString()));
        }
        QueryToMongoDBMapper mapper = new QueryToMongoDBMapper(this.compilation, parameters, candidateCmd, this.ec, (Query)this);
        mapper.compile();
        this.datastoreCompilation.setFilterComplete(mapper.isFilterComplete());
        this.datastoreCompilation.setFilterExpression(mapper.getFilterExpression());
        this.datastoreCompilation.setResultComplete(mapper.isResultComplete());
        this.datastoreCompilation.setResult(mapper.getResultObject());
        if (this.candidateCollection != null) {
            // empty if block
        }
        if (this.range != null) {
            // empty if block
        }
        if (NucleusLogger.QUERY.isDebugEnabled()) {
            NucleusLogger.QUERY.debug((Object)LOCALISER.msg("021084", (Object)this.getLanguage(), (Object)(System.currentTimeMillis() - startTime)));
        }
    }
}

