/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import com.mongodb.WriteConcern;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.bson.types.ObjectId;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.exceptions.NucleusOptimisticException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.identity.OID;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.metadata.DiscriminatorStrategy;
import org.datanucleus.metadata.IdentityStrategy;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.metadata.VersionStrategy;
import org.datanucleus.store.AbstractPersistenceHandler;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.VersionHelper;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.fieldmanager.DeleteFieldManager;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.mongodb.MongoDBStoreManager;
import org.datanucleus.store.mongodb.MongoDBUtils;
import org.datanucleus.store.mongodb.fieldmanager.FetchFieldManager;
import org.datanucleus.store.mongodb.fieldmanager.StoreFieldManager;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class MongoDBPersistenceHandler
extends AbstractPersistenceHandler {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.store.mongodb.Localisation", (ClassLoader)MongoDBStoreManager.class.getClassLoader());
    protected final MongoDBStoreManager storeMgr;

    public MongoDBPersistenceHandler(StoreManager storeMgr) {
        this.storeMgr = (MongoDBStoreManager)storeMgr;
    }

    public void close() {
    }

    public void insertObjects(ObjectProvider ... ops) {
        if (ops.length == 1) {
            this.insertObject(ops[0]);
            return;
        }
        for (int i = 0; i < ops.length; ++i) {
            AbstractClassMetaData cmd = ops[i].getClassMetaData();
            if (!cmd.pkUsesIdentityValueGenerator()) continue;
            this.insertObject(ops[i]);
        }
        HashMap<String, HashSet<ObjectProvider>> opsByTable = new HashMap<String, HashSet<ObjectProvider>>();
        for (int i = 0; i < ops.length; ++i) {
            AbstractClassMetaData cmd = ops[i].getClassMetaData();
            if (cmd.pkUsesIdentityValueGenerator()) continue;
            String tableName = MongoDBUtils.getCollectionName(cmd);
            HashSet<ObjectProvider> opsForTable = (HashSet<ObjectProvider>)opsByTable.get(tableName);
            if (opsForTable == null) {
                opsForTable = new HashSet<ObjectProvider>();
                opsByTable.put(tableName, opsForTable);
            }
            opsForTable.add(ops[i]);
        }
        for (String tableName : opsByTable.keySet()) {
            Set opsForTable = (Set)opsByTable.get(tableName);
            ExecutionContext ec = ops[0].getExecutionContext();
            ManagedConnection mconn = this.storeMgr.getConnection(ec);
            try {
                DB db = (DB)mconn.getConnection();
                long startTime = System.currentTimeMillis();
                DBCollection collection = db.getCollection(tableName);
                Object[] dbObjects = new DBObject[opsForTable.size()];
                int i = 0;
                for (ObjectProvider op : opsForTable) {
                    this.storeMgr.assertReadOnlyForUpdateOfObject(op);
                    AbstractClassMetaData cmd = op.getClassMetaData();
                    if (!this.storeMgr.managesClass(cmd.getFullClassName())) {
                        this.storeMgr.addClass(cmd.getFullClassName(), op.getExecutionContext().getClassLoaderResolver());
                    }
                    if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                        NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("MongoDB.Insert.Start", (Object)op.toPrintableID(), op.getInternalObjectId()));
                    }
                    dbObjects[i] = MongoDBPersistenceHandler.getDBObjectForObjectProviderToInsert(op);
                    if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                        NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("MongoDB.Insert.ObjectPersisted", (Object)op.toPrintableID(), op.getInternalObjectId()));
                    }
                    ++i;
                }
                if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                    NucleusLogger.DATASTORE_PERSIST.debug((Object)("Persisting objects as " + StringUtils.objectArrayToString((Object[])dbObjects)));
                }
                collection.insert((DBObject[])dbObjects, new WriteConcern(1));
                if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                    NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("MongoDB.ExecutionTime", System.currentTimeMillis() - startTime));
                }
                if (this.storeMgr.getRuntimeManager() == null) continue;
                for (int j = 0; j < dbObjects.length; ++j) {
                    this.storeMgr.getRuntimeManager().incrementInsertCount();
                }
            }
            catch (MongoException me) {
                NucleusLogger.PERSISTENCE.error((Object)"Exception inserting objects", (Throwable)me);
                throw new NucleusDataStoreException("Exception inserting objects", (Throwable)me);
            }
            finally {
                mconn.release();
            }
        }
    }

    public void insertObject(ObjectProvider op) {
        this.storeMgr.assertReadOnlyForUpdateOfObject(op);
        AbstractClassMetaData cmd = op.getClassMetaData();
        if (!this.storeMgr.managesClass(cmd.getFullClassName())) {
            this.storeMgr.addClass(cmd.getFullClassName(), op.getExecutionContext().getClassLoaderResolver());
        }
        ExecutionContext ec = op.getExecutionContext();
        ManagedConnection mconn = this.storeMgr.getConnection(ec);
        try {
            DB db = (DB)mconn.getConnection();
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("MongoDB.Insert.Start", (Object)op.toPrintableID(), op.getInternalObjectId()));
            }
            DBCollection collection = db.getCollection(MongoDBUtils.getCollectionName(cmd));
            DBObject dbObject = MongoDBPersistenceHandler.getDBObjectForObjectProviderToInsert(op);
            NucleusLogger.DATASTORE_PERSIST.debug((Object)("Persisting object " + op + " as " + dbObject));
            collection.insert(dbObject, new WriteConcern(1));
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("MongoDB.Insert.ObjectPersisted", (Object)op.toPrintableID(), op.getInternalObjectId()));
            }
            if (cmd.getIdentityType() == IdentityType.DATASTORE && cmd.getIdentityMetaData().getValueStrategy() == IdentityStrategy.IDENTITY) {
                ObjectId idKey = (ObjectId)dbObject.get("_id");
                op.setPostStoreNewObjectId((Object)idKey.toString());
                if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                    NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("MongoDB.Insert.ObjectPersistedWithIdentity", (Object)op.toPrintableID(), (Object)idKey));
                }
            } else if (cmd.getIdentityType() == IdentityType.APPLICATION) {
                int[] pkFieldNumbers = cmd.getPKMemberPositions();
                for (int i = 0; i < pkFieldNumbers.length; ++i) {
                    AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(pkFieldNumbers[i]);
                    if (mmd.getValueStrategy() != IdentityStrategy.IDENTITY) continue;
                    if (mmd.getType() != String.class) {
                        throw new NucleusUserException("Any field using IDENTITY value generation with MongoDB should be of type String");
                    }
                    ObjectId idKey = (ObjectId)dbObject.get("_id");
                    op.replaceField(mmd.getAbsoluteFieldNumber(), (Object)idKey.toString());
                    op.setPostStoreNewObjectId((Object)idKey);
                    if (!NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) continue;
                    NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("MongoDB.Insert.ObjectPersistedWithIdentity", (Object)op.toPrintableID(), (Object)idKey));
                }
            }
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("MongoDB.ExecutionTime", System.currentTimeMillis() - startTime));
            }
            if (this.storeMgr.getRuntimeManager() != null) {
                this.storeMgr.getRuntimeManager().incrementInsertCount();
            }
        }
        catch (MongoException me) {
            NucleusLogger.PERSISTENCE.error((Object)("Exception inserting object " + op), (Throwable)me);
            throw new NucleusDataStoreException("Exception inserting object for " + op, (Throwable)me);
        }
        finally {
            mconn.release();
        }
    }

    private static DBObject getDBObjectForObjectProviderToInsert(ObjectProvider op) {
        BasicDBObject dbObject = new BasicDBObject();
        AbstractClassMetaData cmd = op.getClassMetaData();
        if (cmd.getIdentityType() == IdentityType.DATASTORE && cmd.getIdentityMetaData().getValueStrategy() != IdentityStrategy.IDENTITY) {
            String fieldName = MongoDBUtils.getFieldName(cmd.getIdentityMetaData());
            OID oid = (OID)op.getInternalObjectId();
            Object key = oid.getKeyValue();
            dbObject.put(fieldName, key);
        }
        if (cmd.hasDiscriminatorStrategy()) {
            DiscriminatorMetaData discmd = cmd.getDiscriminatorMetaData();
            String fieldName = MongoDBUtils.getFieldName(discmd);
            String discVal = null;
            discVal = cmd.getDiscriminatorStrategy() == DiscriminatorStrategy.CLASS_NAME ? cmd.getFullClassName() : discmd.getValue();
            dbObject.put(fieldName, (Object)discVal);
        }
        if (cmd.isVersioned()) {
            VersionMetaData vermd = cmd.getVersionMetaDataForClass();
            if (vermd.getVersionStrategy() == VersionStrategy.VERSION_NUMBER) {
                long versionNumber = 1L;
                op.setTransactionalVersion((Object)versionNumber);
                if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                    NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("MongoDB.Insert.ObjectPersistedWithVersion", (Object)op.toPrintableID(), op.getInternalObjectId(), (Object)("" + versionNumber)));
                }
                if (vermd.getFieldName() != null) {
                    AbstractMemberMetaData verMmd = cmd.getMetaDataForMember(vermd.getFieldName());
                    Number verFieldValue = versionNumber;
                    if (verMmd.getType() == Integer.TYPE || verMmd.getType() == Integer.class) {
                        verFieldValue = (int)versionNumber;
                    }
                    op.replaceField(verMmd.getAbsoluteFieldNumber(), (Object)verFieldValue);
                } else {
                    String fieldName = MongoDBUtils.getFieldName(vermd);
                    dbObject.put(fieldName, (Object)new Long(versionNumber));
                }
            } else if (vermd.getVersionStrategy() == VersionStrategy.DATE_TIME) {
                Date date = new Date();
                Timestamp ts = new Timestamp(date.getTime());
                op.setTransactionalVersion((Object)ts);
                if (vermd.getFieldName() != null) {
                    AbstractMemberMetaData verMmd = cmd.getMetaDataForMember(vermd.getFieldName());
                    op.replaceField(verMmd.getAbsoluteFieldNumber(), (Object)ts);
                } else {
                    String fieldName = MongoDBUtils.getFieldName(vermd);
                    dbObject.put(fieldName, (Object)ts);
                }
            }
        }
        StoreFieldManager fieldManager = new StoreFieldManager(op, (DBObject)dbObject, cmd, true);
        op.provideFields(cmd.getAllMemberPositions(), (FieldManager)fieldManager);
        return dbObject;
    }

    public void updateObject(ObjectProvider op, int[] fieldNumbers) {
        this.storeMgr.assertReadOnlyForUpdateOfObject(op);
        ExecutionContext ec = op.getExecutionContext();
        ManagedConnection mconn = this.storeMgr.getConnection(ec);
        try {
            DBCollection collection;
            DBObject dbObject;
            DB db = (DB)mconn.getConnection();
            long startTime = System.currentTimeMillis();
            AbstractClassMetaData cmd = op.getClassMetaData();
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                StringBuffer fieldStr = new StringBuffer();
                for (int i = 0; i < fieldNumbers.length; ++i) {
                    if (i > 0) {
                        fieldStr.append(",");
                    }
                    fieldStr.append(cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]).getName());
                }
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("MongoDB.Update.Start", (Object)op.toPrintableID(), op.getInternalObjectId(), (Object)fieldStr.toString()));
            }
            if ((dbObject = MongoDBUtils.getObjectForObjectProvider(collection = db.getCollection(MongoDBUtils.getCollectionName(cmd)), op, true)) == null) {
                if (cmd.isVersioned()) {
                    throw new NucleusOptimisticException("Object with id " + op.getObjectId() + " and version " + op.getTransactionalVersion() + " no longer present");
                }
                throw new NucleusDataStoreException("Could not find object with id " + op.getObjectId());
            }
            if (cmd.isVersioned()) {
                Object currentVersion = op.getTransactionalVersion();
                VersionMetaData vermd = cmd.getVersionMetaDataForClass();
                Object nextVersion = VersionHelper.getNextVersion((VersionStrategy)vermd.getVersionStrategy(), (Object)currentVersion);
                op.setTransactionalVersion(nextVersion);
                if (vermd.getFieldName() != null) {
                    AbstractMemberMetaData verMmd = cmd.getMetaDataForMember(vermd.getFieldName());
                    op.replaceField(verMmd.getAbsoluteFieldNumber(), nextVersion);
                } else {
                    String fieldName = MongoDBUtils.getFieldName(vermd);
                    dbObject.put(fieldName, nextVersion);
                }
            }
            StoreFieldManager fieldManager = new StoreFieldManager(op, dbObject, cmd, false);
            op.provideFields(cmd.getAllMemberPositions(), (FieldManager)fieldManager);
            collection.save(dbObject);
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("MongoDB.ExecutionTime", System.currentTimeMillis() - startTime));
            }
            if (this.storeMgr.getRuntimeManager() != null) {
                this.storeMgr.getRuntimeManager().incrementUpdateCount();
            }
        }
        catch (MongoException me) {
            NucleusLogger.PERSISTENCE.error((Object)("Exception updating object " + op), (Throwable)me);
            throw new NucleusDataStoreException("Exception updating object for " + op, (Throwable)me);
        }
        finally {
            mconn.release();
        }
    }

    public void deleteObjects(ObjectProvider ... ops) {
        super.deleteObjects(ops);
    }

    public void deleteObject(ObjectProvider op) {
        this.storeMgr.assertReadOnlyForUpdateOfObject(op);
        AbstractClassMetaData cmd = op.getClassMetaData();
        ExecutionContext ec = op.getExecutionContext();
        ManagedConnection mconn = this.storeMgr.getConnection(ec);
        try {
            DBCollection collection;
            DBObject dbObject;
            DB db = (DB)mconn.getConnection();
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("MongoDB.Delete.Start", (Object)op.toPrintableID(), op.getInternalObjectId()));
            }
            if ((dbObject = MongoDBUtils.getObjectForObjectProvider(collection = db.getCollection(MongoDBUtils.getCollectionName(cmd)), op, true)) == null) {
                if (cmd.isVersioned()) {
                    throw new NucleusOptimisticException("Object with id " + op.getObjectId() + " and version " + op.getTransactionalVersion() + " no longer present");
                }
                throw new NucleusDataStoreException("Could not find object with id " + op.getObjectId());
            }
            op.loadUnloadedFields();
            op.provideFields(cmd.getAllMemberPositions(), (FieldManager)new DeleteFieldManager(op));
            collection.remove(dbObject);
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("MongoDB.ExecutionTime", System.currentTimeMillis() - startTime));
            }
            if (this.storeMgr.getRuntimeManager() != null) {
                this.storeMgr.getRuntimeManager().incrementDeleteCount();
            }
        }
        catch (MongoException me) {
            NucleusLogger.PERSISTENCE.error((Object)("Exception deleting object " + op), (Throwable)me);
            throw new NucleusDataStoreException("Exception deleting object for " + op, (Throwable)me);
        }
        finally {
            mconn.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetchObject(ObjectProvider op, int[] fieldNumbers) {
        AbstractClassMetaData cmd = op.getClassMetaData();
        ExecutionContext ec = op.getExecutionContext();
        ManagedConnection mconn = this.storeMgr.getConnection(ec);
        try {
            DBCollection collection;
            DBObject dbObject;
            DB db = (DB)mconn.getConnection();
            if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
                StringBuffer str = new StringBuffer("Fetching object \"");
                str.append(op.toPrintableID()).append("\" (id=");
                str.append(op.getExecutionContext().getApiAdapter().getObjectId(op)).append(")").append(" fields [");
                for (int i = 0; i < fieldNumbers.length; ++i) {
                    if (i > 0) {
                        str.append(",");
                    }
                    str.append(cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]).getName());
                }
                str.append("]");
                NucleusLogger.DATASTORE_RETRIEVE.debug((Object)str);
            }
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
                NucleusLogger.DATASTORE_RETRIEVE.debug((Object)LOCALISER.msg("MongoDB.Fetch.Start", (Object)op.toPrintableID(), op.getInternalObjectId()));
            }
            if ((dbObject = MongoDBUtils.getObjectForObjectProvider(collection = db.getCollection(MongoDBUtils.getCollectionName(cmd)), op, false)) == null) {
                throw new NucleusObjectNotFoundException("Could not find object with id " + op.getInternalObjectId() + " op=" + op);
            }
            if (cmd.isVersioned() && op.getTransactionalVersion() == null) {
                VersionMetaData vermd = cmd.getVersionMetaDataForClass();
                if (vermd.getFieldName() != null) {
                    Object datastoreVersion = op.provideField(cmd.getAbsolutePositionOfMember(vermd.getFieldName()));
                    op.setVersion(datastoreVersion);
                } else {
                    String fieldName = MongoDBUtils.getFieldName(vermd);
                    Object datastoreVersion = dbObject.get(fieldName);
                    op.setVersion(datastoreVersion);
                }
            }
            FetchFieldManager fieldManager = new FetchFieldManager(op, dbObject, cmd);
            op.replaceFields(fieldNumbers, (FieldManager)fieldManager);
            if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
                NucleusLogger.DATASTORE_RETRIEVE.debug((Object)LOCALISER.msg("MongoDB.ExecutionTime", System.currentTimeMillis() - startTime));
            }
            if (this.storeMgr.getRuntimeManager() != null) {
                this.storeMgr.getRuntimeManager().incrementFetchCount();
            }
        }
        finally {
            mconn.release();
        }
    }

    public Object findObject(ExecutionContext om, Object id) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void locateObject(ObjectProvider op) {
        AbstractClassMetaData cmd = op.getClassMetaData();
        if (cmd.getIdentityType() == IdentityType.APPLICATION || cmd.getIdentityType() == IdentityType.DATASTORE) {
            ExecutionContext ec = op.getExecutionContext();
            ManagedConnection mconn = this.storeMgr.getConnection(ec);
            try {
                DB db = (DB)mconn.getConnection();
                DBCollection collection = db.getCollection(MongoDBUtils.getCollectionName(cmd));
                DBObject dbObject = MongoDBUtils.getObjectForObjectProvider(collection, op, false);
                if (dbObject == null) {
                    throw new NucleusObjectNotFoundException();
                }
            }
            finally {
                mconn.release();
            }
        }
    }
}

