/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.NucleusContext;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ClassMetaData;
import org.datanucleus.metadata.ClassPersistenceModifier;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.IdentityStrategy;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.IndexMetaData;
import org.datanucleus.metadata.UniqueMetaData;
import org.datanucleus.store.AbstractStoreManager;
import org.datanucleus.store.StoreData;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.mongodb.MongoDBPersistenceHandler;
import org.datanucleus.store.mongodb.MongoDBUtils;
import org.datanucleus.store.schema.SchemaAwareStoreManager;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MongoDBStoreManager
extends AbstractStoreManager
implements SchemaAwareStoreManager {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.store.mongodb.Localisation", (ClassLoader)MongoDBStoreManager.class.getClassLoader());

    public MongoDBStoreManager(ClassLoaderResolver clr, NucleusContext nucleusCtx, Map<String, Object> props) {
        super("mongodb", clr, nucleusCtx, props);
        this.persistenceHandler = new MongoDBPersistenceHandler((StoreManager)this);
        this.logConfiguration();
    }

    public Collection getSupportedOptions() {
        HashSet<String> set = new HashSet<String>();
        set.add("ApplicationIdentity");
        set.add("DatastoreIdentity");
        set.add("ORM");
        set.add("TransactionIsolationLevel.read-committed");
        return set;
    }

    public boolean supportsValueStrategy(String strategy) {
        if (super.supportsValueStrategy(strategy)) {
            return true;
        }
        return strategy.equalsIgnoreCase("IDENTITY");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClasses(String[] classNames, ClassLoaderResolver clr) {
        if (classNames == null) {
            return;
        }
        String[] filteredClassNames = this.getNucleusContext().getTypeManager().filterOutSupportedSecondClassNames(classNames);
        ManagedConnection mconn = this.getConnection(-1);
        try {
            DB db = (DB)mconn.getConnection();
            for (ClassMetaData cmd : this.getMetaDataManager().getReferencedClasses(filteredClassNames, clr)) {
                if (cmd.getPersistenceModifier() != ClassPersistenceModifier.PERSISTENCE_CAPABLE || this.storeDataMgr.managesClass(cmd.getFullClassName())) continue;
                StoreData sd = this.storeDataMgr.get(cmd.getFullClassName());
                if (sd == null) {
                    this.registerStoreData(this.newStoreData(cmd, clr));
                }
                this.createSchemaForClass((AbstractClassMetaData)cmd, db);
            }
        }
        finally {
            mconn.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSchema(Set<String> classNames, Properties props) {
        ManagedConnection mconn = this.getConnection(-1);
        try {
            DB db = (DB)mconn.getConnection();
            Iterator<String> classIter = classNames.iterator();
            ClassLoaderResolver clr = this.nucleusContext.getClassLoaderResolver(null);
            while (classIter.hasNext()) {
                String className = classIter.next();
                AbstractClassMetaData cmd = this.getMetaDataManager().getMetaDataForClass(className, clr);
                if (cmd == null) continue;
                this.createSchemaForClass(cmd, db);
            }
        }
        finally {
            mconn.close();
        }
    }

    protected void createSchemaForClass(AbstractClassMetaData cmd, DB db) {
        UniqueMetaData[] unimds;
        DBCollection collection = db.getCollection(MongoDBUtils.getCollectionName(cmd));
        IndexMetaData[] idxmds = cmd.getIndexMetaData();
        if (idxmds != null && idxmds.length > 0) {
            for (int i = 0; i < idxmds.length; ++i) {
                int j;
                BasicDBObject query = new BasicDBObject();
                if (idxmds[i].getColumnMetaData() != null) {
                    ColumnMetaData[] idxcolmds = idxmds[i].getColumnMetaData();
                    for (j = 0; j < idxcolmds.length; ++j) {
                        query.append(idxcolmds[j].getName(), (Object)1);
                    }
                } else if (idxmds[i].getMemberMetaData() != null) {
                    AbstractMemberMetaData[] idxmmds = idxmds[i].getMemberMetaData();
                    for (j = 0; j < idxmmds.length; ++j) {
                        String memberName = idxmmds[i].getName();
                        AbstractMemberMetaData mmd = cmd.getMetaDataForMember(memberName);
                        query.append(MongoDBUtils.getFieldName(mmd), (Object)1);
                    }
                }
                if (NucleusLogger.DATASTORE_SCHEMA.isDebugEnabled()) {
                    NucleusLogger.DATASTORE_SCHEMA.debug((Object)LOCALISER.msg("MongoDB.SchemaCreate.Class.Index", (Object)idxmds[i].getName(), (Object)MongoDBUtils.getCollectionName(cmd), (Object)query));
                }
                collection.ensureIndex((DBObject)query, idxmds[i].getName(), idxmds[i].isUnique());
            }
        }
        if ((unimds = cmd.getUniqueMetaData()) != null && unimds.length > 0) {
            for (int i = 0; i < unimds.length; ++i) {
                int j;
                BasicDBObject query = new BasicDBObject();
                if (unimds[i].getColumnMetaData() != null) {
                    ColumnMetaData[] unicolmds = unimds[i].getColumnMetaData();
                    for (j = 0; j < unicolmds.length; ++j) {
                        query.append(unicolmds[j].getName(), (Object)1);
                    }
                } else if (unimds[i].getMemberMetaData() != null) {
                    AbstractMemberMetaData[] unimmds = unimds[i].getMemberMetaData();
                    for (j = 0; j < unimmds.length; ++j) {
                        String memberName = unimmds[i].getName();
                        AbstractMemberMetaData mmd = cmd.getMetaDataForMember(memberName);
                        query.append(MongoDBUtils.getFieldName(mmd), (Object)1);
                    }
                }
                if (NucleusLogger.DATASTORE_SCHEMA.isDebugEnabled()) {
                    NucleusLogger.DATASTORE_SCHEMA.debug((Object)LOCALISER.msg("MongoDB.SchemaCreate.Class.Index", (Object)unimds[i].getName(), (Object)MongoDBUtils.getCollectionName(cmd), (Object)query));
                }
                collection.ensureIndex((DBObject)query, unimds[i].getName(), true);
            }
        }
        if (cmd.getIdentityType() == IdentityType.APPLICATION) {
            String pkName;
            BasicDBObject query = new BasicDBObject();
            int[] pkFieldNumbers = cmd.getPKMemberPositions();
            for (int i = 0; i < pkFieldNumbers.length; ++i) {
                AbstractMemberMetaData pkMmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(pkFieldNumbers[i]);
                query.append(MongoDBUtils.getFieldName(pkMmd), (Object)1);
            }
            String string = pkName = cmd.getPackageMetaData() != null ? cmd.getPackageMetaData().getName() : cmd.getName() + "_PK";
            if (NucleusLogger.DATASTORE_SCHEMA.isDebugEnabled()) {
                NucleusLogger.DATASTORE_SCHEMA.debug((Object)LOCALISER.msg("MongoDB.SchemaCreate.Class.Index", (Object)pkName, (Object)MongoDBUtils.getCollectionName(cmd), (Object)query));
            }
            collection.ensureIndex((DBObject)query, pkName, true);
        } else if (cmd.getIdentityType() == IdentityType.DATASTORE && cmd.getIdentityMetaData().getValueStrategy() != IdentityStrategy.IDENTITY) {
            String pkName;
            BasicDBObject query = new BasicDBObject();
            query.append(MongoDBUtils.getFieldName(cmd.getIdentityMetaData()), (Object)1);
            String string = pkName = cmd.getPrimaryKeyMetaData() != null ? cmd.getPrimaryKeyMetaData().getName() : cmd.getName() + "_PK";
            if (NucleusLogger.DATASTORE_SCHEMA.isDebugEnabled()) {
                NucleusLogger.DATASTORE_SCHEMA.debug((Object)LOCALISER.msg("MongoDB.SchemaCreate.Class.Index", (Object)pkName, (Object)MongoDBUtils.getCollectionName(cmd), (Object)query));
            }
            collection.ensureIndex((DBObject)query, pkName, true);
        }
        AbstractMemberMetaData[] mmds = cmd.getManagedMembers();
        if (mmds != null && mmds.length > 0) {
            for (int i = 0; i < mmds.length; ++i) {
                UniqueMetaData unimd;
                IndexMetaData idxmd = mmds[i].getIndexMetaData();
                if (idxmd != null) {
                    BasicDBObject query = new BasicDBObject();
                    query.append(MongoDBUtils.getFieldName(mmds[i]), (Object)1);
                    if (NucleusLogger.DATASTORE_SCHEMA.isDebugEnabled()) {
                        NucleusLogger.DATASTORE_SCHEMA.debug((Object)LOCALISER.msg("MongoDB.SchemaCreate.Class.Index", (Object)idxmd.getName(), (Object)MongoDBUtils.getCollectionName(cmd), (Object)query));
                    }
                    collection.ensureIndex((DBObject)query, idxmd.getName(), idxmd.isUnique());
                }
                if ((unimd = mmds[i].getUniqueMetaData()) == null) continue;
                BasicDBObject query = new BasicDBObject();
                query.append(MongoDBUtils.getFieldName(mmds[i]), (Object)1);
                if (NucleusLogger.DATASTORE_SCHEMA.isDebugEnabled()) {
                    NucleusLogger.DATASTORE_SCHEMA.debug((Object)LOCALISER.msg("MongoDB.SchemaCreate.Class.Index", (Object)unimd.getName(), (Object)MongoDBUtils.getCollectionName(cmd), (Object)query));
                }
                collection.ensureIndex((DBObject)query, unimd.getName(), true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSchema(Set<String> classNames, Properties props) {
        ManagedConnection mconn = this.getConnection(-1);
        try {
            DB db = (DB)mconn.getConnection();
            Iterator<String> classIter = classNames.iterator();
            ClassLoaderResolver clr = this.nucleusContext.getClassLoaderResolver(null);
            while (classIter.hasNext()) {
                String className = classIter.next();
                AbstractClassMetaData cmd = this.getMetaDataManager().getMetaDataForClass(className, clr);
                if (cmd == null) continue;
                DBCollection collection = db.getCollection(MongoDBUtils.getCollectionName(cmd));
                collection.dropIndexes();
                collection.drop();
            }
        }
        finally {
            mconn.close();
        }
    }

    public void validateSchema(Set<String> classNames, Properties props) {
        Iterator<String> classIter = classNames.iterator();
        ClassLoaderResolver clr = this.nucleusContext.getClassLoaderResolver(null);
        while (classIter.hasNext()) {
            String className = classIter.next();
            AbstractClassMetaData cmd = this.getMetaDataManager().getMetaDataForClass(className, clr);
            if (cmd == null) continue;
        }
    }
}

