/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mongodb.query;

import com.mongodb.BasicDBObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.Relation;
import org.datanucleus.query.compiler.CompilationComponent;
import org.datanucleus.query.compiler.QueryCompilation;
import org.datanucleus.query.evaluator.AbstractExpressionEvaluator;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.query.expression.ExpressionEvaluator;
import org.datanucleus.query.expression.Literal;
import org.datanucleus.query.expression.PrimaryExpression;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.mongodb.MongoDBUtils;
import org.datanucleus.store.mongodb.query.expression.MongoBooleanExpression;
import org.datanucleus.store.mongodb.query.expression.MongoExpression;
import org.datanucleus.store.mongodb.query.expression.MongoFieldExpression;
import org.datanucleus.store.mongodb.query.expression.MongoLiteral;
import org.datanucleus.store.mongodb.query.expression.MongoOperator;
import org.datanucleus.store.query.Query;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryToMongoDBMapper
extends AbstractExpressionEvaluator {
    final ExecutionContext ec;
    final String candidateAlias;
    final AbstractClassMetaData candidateCmd;
    final Query query;
    final QueryCompilation compilation;
    final Map parameters;
    CompilationComponent compileComponent;
    boolean filterComplete = true;
    BasicDBObject filterObject;
    boolean resultComplete = true;
    BasicDBObject resultObject;
    Stack<MongoExpression> stack = new Stack();

    public QueryToMongoDBMapper(QueryCompilation compilation, Map parameters, AbstractClassMetaData cmd, ExecutionContext ec, Query q) {
        this.ec = ec;
        this.query = q;
        this.compilation = compilation;
        this.parameters = parameters;
        this.candidateCmd = cmd;
        this.candidateAlias = compilation.getCandidateAlias();
    }

    public boolean isFilterComplete() {
        return this.filterComplete;
    }

    public boolean isResultComplete() {
        return this.resultComplete;
    }

    public BasicDBObject getFilterObject() {
        return this.filterObject;
    }

    public BasicDBObject getResultObject() {
        return this.resultObject;
    }

    public void compile() {
        this.compileFrom();
        this.compileFilter();
        this.compileResult();
        this.compileGrouping();
        this.compileHaving();
        this.compileOrdering();
    }

    protected void compileFrom() {
        if (this.compilation.getExprFrom() != null) {
            this.compileComponent = CompilationComponent.FROM;
            Expression[] fromExprs = this.compilation.getExprFrom();
            for (int i = 0; i < fromExprs.length; ++i) {
            }
        }
    }

    protected void compileFilter() {
        if (this.compilation.getExprFilter() != null) {
            this.compileComponent = CompilationComponent.FILTER;
            try {
                this.compilation.getExprFilter().evaluate((ExpressionEvaluator)this);
                MongoExpression mongoExpr = this.stack.pop();
                if (!(mongoExpr instanceof MongoBooleanExpression)) {
                    NucleusLogger.QUERY.error((Object)(">> invalid compilation : filter compiled to " + mongoExpr));
                    this.filterComplete = false;
                } else {
                    MongoBooleanExpression mbExpr = (MongoBooleanExpression)mongoExpr;
                    this.filterObject = mbExpr.getDBObject();
                }
                NucleusLogger.QUERY.debug((Object)(">> compileFilter filterObject=" + this.filterObject));
            }
            catch (Exception e) {
                this.filterComplete = false;
                NucleusLogger.QUERY.debug((Object)">> compileFilter caught exception ", (Throwable)e);
            }
            this.compileComponent = null;
        }
    }

    protected void compileResult() {
        if (this.compilation.getExprResult() != null) {
            this.compileComponent = CompilationComponent.RESULT;
            this.resultObject = new BasicDBObject();
            Expression[] resultExprs = this.compilation.getExprResult();
            for (int i = 0; i < resultExprs.length; ++i) {
            }
        }
        this.compileComponent = null;
    }

    protected void compileGrouping() {
        if (this.compilation.getExprGrouping() != null) {
            this.compileComponent = CompilationComponent.GROUPING;
            Expression[] groupExprs = this.compilation.getExprGrouping();
            for (int i = 0; i < groupExprs.length; ++i) {
            }
            this.compileComponent = null;
        }
    }

    protected void compileHaving() {
        if (this.compilation.getExprHaving() != null) {
            this.compileComponent = CompilationComponent.HAVING;
            this.compilation.getExprHaving();
            this.compileComponent = null;
        }
    }

    protected void compileOrdering() {
        if (this.compilation.getExprOrdering() != null) {
            this.compileComponent = CompilationComponent.ORDERING;
            Expression[] orderingExpr = this.compilation.getExprOrdering();
            for (int i = 0; i < orderingExpr.length; ++i) {
            }
            this.compileComponent = null;
        }
    }

    protected Object processAndExpression(Expression expr) {
        MongoBooleanExpression right = (MongoBooleanExpression)this.stack.pop();
        MongoBooleanExpression left = (MongoBooleanExpression)this.stack.pop();
        MongoBooleanExpression andExpr = new MongoBooleanExpression(left, right, MongoOperator.OP_AND);
        this.stack.push(andExpr);
        return andExpr;
    }

    protected Object processOrExpression(Expression expr) {
        MongoBooleanExpression right = (MongoBooleanExpression)this.stack.pop();
        MongoBooleanExpression left = (MongoBooleanExpression)this.stack.pop();
        MongoBooleanExpression andExpr = new MongoBooleanExpression(left, right, MongoOperator.OP_OR);
        this.stack.push(andExpr);
        return andExpr;
    }

    protected Object processEqExpression(Expression expr) {
        MongoExpression right = this.stack.pop();
        MongoExpression left = this.stack.pop();
        if (left instanceof MongoLiteral && right instanceof MongoFieldExpression) {
            String field = ((MongoFieldExpression)right).getFieldName();
            Object value = ((MongoLiteral)left).getValue();
            MongoBooleanExpression mongoExpr = new MongoBooleanExpression(field, value, MongoOperator.OP_EQ);
            this.stack.push(mongoExpr);
            return mongoExpr;
        }
        if (left instanceof MongoFieldExpression && right instanceof MongoLiteral) {
            String field = ((MongoFieldExpression)left).getFieldName();
            Object value = ((MongoLiteral)right).getValue();
            MongoBooleanExpression mongoExpr = new MongoBooleanExpression(field, value, MongoOperator.OP_EQ);
            this.stack.push(mongoExpr);
            return mongoExpr;
        }
        NucleusLogger.GENERAL.info((Object)(">> processEq : left=" + left + " right=" + right));
        return super.processEqExpression(expr);
    }

    protected Object processNoteqExpression(Expression expr) {
        MongoExpression right = this.stack.pop();
        MongoExpression left = this.stack.pop();
        if (left instanceof MongoLiteral && right instanceof MongoFieldExpression) {
            String field = ((MongoFieldExpression)right).getFieldName();
            Object value = ((MongoLiteral)left).getValue();
            MongoBooleanExpression mongoExpr = new MongoBooleanExpression(field, value, MongoOperator.OP_NOTEQ);
            this.stack.push(mongoExpr);
            return mongoExpr;
        }
        if (left instanceof MongoFieldExpression && right instanceof MongoLiteral) {
            String field = ((MongoFieldExpression)left).getFieldName();
            Object value = ((MongoLiteral)right).getValue();
            MongoBooleanExpression mongoExpr = new MongoBooleanExpression(field, value, MongoOperator.OP_NOTEQ);
            this.stack.push(mongoExpr);
            return mongoExpr;
        }
        NucleusLogger.GENERAL.info((Object)(">> processNoteq : left=" + left + " right=" + right));
        return super.processNoteqExpression(expr);
    }

    protected Object processGtExpression(Expression expr) {
        MongoExpression right = this.stack.pop();
        MongoExpression left = this.stack.pop();
        if (left instanceof MongoLiteral && right instanceof MongoFieldExpression) {
            String field = ((MongoFieldExpression)right).getFieldName();
            Object value = ((MongoLiteral)left).getValue();
            MongoBooleanExpression mongoExpr = new MongoBooleanExpression(field, value, MongoOperator.OP_LTEQ);
            this.stack.push(mongoExpr);
            return mongoExpr;
        }
        if (left instanceof MongoFieldExpression && right instanceof MongoLiteral) {
            String field = ((MongoFieldExpression)left).getFieldName();
            Object value = ((MongoLiteral)right).getValue();
            MongoBooleanExpression mongoExpr = new MongoBooleanExpression(field, value, MongoOperator.OP_GT);
            this.stack.push(mongoExpr);
            return mongoExpr;
        }
        NucleusLogger.GENERAL.info((Object)(">> processGt : left=" + left + " right=" + right));
        return super.processGtExpression(expr);
    }

    protected Object processLtExpression(Expression expr) {
        MongoExpression right = this.stack.pop();
        MongoExpression left = this.stack.pop();
        if (left instanceof MongoLiteral && right instanceof MongoFieldExpression) {
            String field = ((MongoFieldExpression)right).getFieldName();
            Object value = ((MongoLiteral)left).getValue();
            MongoBooleanExpression mongoExpr = new MongoBooleanExpression(field, value, MongoOperator.OP_GTEQ);
            this.stack.push(mongoExpr);
            return mongoExpr;
        }
        if (left instanceof MongoFieldExpression && right instanceof MongoLiteral) {
            String field = ((MongoFieldExpression)left).getFieldName();
            Object value = ((MongoLiteral)right).getValue();
            MongoBooleanExpression mongoExpr = new MongoBooleanExpression(field, value, MongoOperator.OP_LT);
            this.stack.push(mongoExpr);
            return mongoExpr;
        }
        NucleusLogger.GENERAL.info((Object)(">> processLt : left=" + left + " right=" + right));
        return super.processLtExpression(expr);
    }

    protected Object processGteqExpression(Expression expr) {
        MongoExpression right = this.stack.pop();
        MongoExpression left = this.stack.pop();
        if (left instanceof MongoLiteral && right instanceof MongoFieldExpression) {
            String field = ((MongoFieldExpression)right).getFieldName();
            Object value = ((MongoLiteral)left).getValue();
            MongoBooleanExpression mongoExpr = new MongoBooleanExpression(field, value, MongoOperator.OP_LT);
            this.stack.push(mongoExpr);
            return mongoExpr;
        }
        if (left instanceof MongoFieldExpression && right instanceof MongoLiteral) {
            String field = ((MongoFieldExpression)left).getFieldName();
            Object value = ((MongoLiteral)right).getValue();
            MongoBooleanExpression mongoExpr = new MongoBooleanExpression(field, value, MongoOperator.OP_GTEQ);
            this.stack.push(mongoExpr);
            return mongoExpr;
        }
        NucleusLogger.GENERAL.info((Object)(">> processGteq : left=" + left + " right=" + right));
        return super.processGteqExpression(expr);
    }

    protected Object processLteqExpression(Expression expr) {
        MongoExpression right = this.stack.pop();
        MongoExpression left = this.stack.pop();
        if (left instanceof MongoLiteral && right instanceof MongoFieldExpression) {
            String field = ((MongoFieldExpression)right).getFieldName();
            Object value = ((MongoLiteral)left).getValue();
            MongoBooleanExpression mongoExpr = new MongoBooleanExpression(field, value, MongoOperator.OP_GT);
            this.stack.push(mongoExpr);
            return mongoExpr;
        }
        if (left instanceof MongoFieldExpression && right instanceof MongoLiteral) {
            String field = ((MongoFieldExpression)left).getFieldName();
            Object value = ((MongoLiteral)right).getValue();
            MongoBooleanExpression mongoExpr = new MongoBooleanExpression(field, value, MongoOperator.OP_LTEQ);
            this.stack.push(mongoExpr);
            return mongoExpr;
        }
        NucleusLogger.GENERAL.info((Object)(">> processLteq : left=" + left + " right=" + right));
        return super.processLteqExpression(expr);
    }

    protected Object processPrimaryExpression(PrimaryExpression expr) {
        Expression left = expr.getLeft();
        if (left == null) {
            List tuples = expr.getTuples();
            String fieldName = this.getFieldNameForPrimary(tuples);
            if (fieldName == null) {
                if (this.compileComponent == CompilationComponent.FILTER) {
                    this.filterComplete = false;
                } else if (this.compileComponent == CompilationComponent.RESULT) {
                    this.resultComplete = false;
                }
                NucleusLogger.QUERY.debug((Object)(">> Primary " + expr + " is not stored in this document, so unexecutable in datastore"));
            } else {
                MongoFieldExpression fieldExpr = new MongoFieldExpression(fieldName);
                this.stack.push(fieldExpr);
                return fieldExpr;
            }
        }
        NucleusLogger.GENERAL.info((Object)(">> processPrimary " + expr));
        return super.processPrimaryExpression(expr);
    }

    protected Object processLiteral(Literal expr) {
        Object litValue = expr.getLiteral();
        if (litValue instanceof Number) {
            MongoLiteral lit = new MongoLiteral(litValue);
            this.stack.push(lit);
            return lit;
        }
        if (litValue instanceof String) {
            MongoLiteral lit = new MongoLiteral(litValue);
            this.stack.push(lit);
            return lit;
        }
        return super.processLiteral(expr);
    }

    protected String getFieldNameForPrimary(List<String> tuples) {
        if (tuples == null || tuples.size() == 0) {
            return null;
        }
        ClassLoaderResolver clr = this.ec.getClassLoaderResolver();
        AbstractClassMetaData cmd = this.candidateCmd;
        AbstractMemberMetaData embMmd = null;
        boolean embeddedFlat = false;
        String embeddedNestedField = null;
        Iterator<String> iter = tuples.iterator();
        while (iter.hasNext()) {
            String name = iter.next();
            if (name.equals(this.candidateAlias)) {
                cmd = this.candidateCmd;
                continue;
            }
            AbstractMemberMetaData mmd = cmd.getMetaDataForMember(name);
            int relationType = mmd.getRelationType(clr);
            if (relationType == 0) {
                if (iter.hasNext()) {
                    throw new NucleusUserException("Query has reference to " + StringUtils.collectionToString(tuples) + " yet " + name + " is a non-relation field!");
                }
                if (embMmd != null) {
                    if (embeddedFlat) {
                        return MongoDBUtils.getFieldName(embMmd, mmd.getAbsoluteFieldNumber());
                    }
                    return embeddedNestedField + "." + MongoDBUtils.getFieldName(mmd);
                }
                return MongoDBUtils.getFieldName(mmd);
            }
            if (mmd.isEmbedded()) {
                if (Relation.isRelationSingleValued((int)relationType)) {
                    boolean nested = true;
                    String nestedStr = mmd.getValueForExtension("nested");
                    if (nestedStr != null && nestedStr.equalsIgnoreCase("false")) {
                        nested = false;
                    }
                    cmd = this.ec.getMetaDataManager().getMetaDataForClass(mmd.getType(), clr);
                    embMmd = mmd;
                    if (nested) {
                        if (embeddedNestedField == null) {
                            embeddedNestedField = MongoDBUtils.getFieldName(mmd);
                            continue;
                        }
                        embeddedNestedField = embeddedNestedField + "." + MongoDBUtils.getFieldName(mmd);
                        continue;
                    }
                    if (embeddedFlat) continue;
                    embeddedFlat = true;
                    continue;
                }
                if (!Relation.isRelationMultiValued((int)relationType)) continue;
                throw new NucleusUserException("Dont currently support querying of embedded collection fields at " + mmd.getFullFieldName());
            }
            if (this.compileComponent == CompilationComponent.FILTER) {
                this.filterComplete = false;
            } else if (this.compileComponent == CompilationComponent.RESULT) {
                this.resultComplete = false;
            }
            NucleusLogger.QUERY.debug((Object)("Query has reference to " + StringUtils.collectionToString(tuples) + " and " + mmd.getFullFieldName() + " is not persisted into this document, so unexecutable in the datastore"));
            return null;
        }
        return null;
    }
}

