/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mongodb.fieldmanager;

import com.mongodb.DBObject;
import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.EmbeddedMetaData;
import org.datanucleus.metadata.Relation;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.fieldmanager.AbstractFieldManager;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.mongodb.MongoDBUtils;
import org.datanucleus.store.mongodb.fieldmanager.FetchEmbeddedFieldManager;
import org.datanucleus.store.types.ObjectLongConverter;
import org.datanucleus.store.types.ObjectStringConverter;
import org.datanucleus.store.types.sco.SCOUtils;

public class FetchFieldManager
extends AbstractFieldManager {
    protected ExecutionContext ec;
    protected ObjectProvider sm;
    protected DBObject dbObject;
    protected AbstractClassMetaData cmd;
    boolean embedded = false;
    protected AbstractMemberMetaData ownerMmd = null;

    public FetchFieldManager(ObjectProvider sm, DBObject dbObject, AbstractClassMetaData acmd) {
        this.sm = sm;
        this.ec = sm.getExecutionContext();
        this.dbObject = dbObject;
        this.cmd = acmd;
        if (sm.getEmbeddedOwners() != null) {
            this.embedded = true;
        }
    }

    public FetchFieldManager(ExecutionContext ec, DBObject dbObject, AbstractClassMetaData acmd) {
        this.ec = ec;
        this.dbObject = dbObject;
        this.cmd = acmd;
    }

    public boolean fetchBooleanField(int fieldNumber) {
        String fieldName = this.getFieldName(fieldNumber);
        return (Boolean)this.dbObject.get(fieldName);
    }

    public char fetchCharField(int fieldNumber) {
        String fieldName = this.getFieldName(fieldNumber);
        return ((Character)this.dbObject.get(fieldName)).charValue();
    }

    public byte fetchByteField(int fieldNumber) {
        String fieldName = this.getFieldName(fieldNumber);
        return (Byte)this.dbObject.get(fieldName);
    }

    public short fetchShortField(int fieldNumber) {
        String fieldName = this.getFieldName(fieldNumber);
        return (Short)this.dbObject.get(fieldName);
    }

    public int fetchIntField(int fieldNumber) {
        String fieldName = this.getFieldName(fieldNumber);
        return (Integer)this.dbObject.get(fieldName);
    }

    public long fetchLongField(int fieldNumber) {
        String fieldName = this.getFieldName(fieldNumber);
        return (Long)this.dbObject.get(fieldName);
    }

    public float fetchFloatField(int fieldNumber) {
        String fieldName = this.getFieldName(fieldNumber);
        return ((Float)this.dbObject.get(fieldName)).floatValue();
    }

    public double fetchDoubleField(int fieldNumber) {
        String fieldName = this.getFieldName(fieldNumber);
        return (Double)this.dbObject.get(fieldName);
    }

    public String fetchStringField(int fieldNumber) {
        String fieldName = this.getFieldName(fieldNumber);
        if (this.dbObject.containsField(fieldName)) {
            return (String)this.dbObject.get(fieldName);
        }
        return null;
    }

    protected String getFieldName(int fieldNumber) {
        return MongoDBUtils.getFieldName(this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber));
    }

    public Object fetchObjectField(int fieldNumber) {
        String fieldName;
        AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        ClassLoaderResolver clr = this.ec.getClassLoaderResolver();
        int relationType = mmd.getRelationType(clr);
        boolean embedded = false;
        if (this.embedded || this.ownerMmd != null) {
            embedded = true;
        } else if (relationType != 0) {
            if (mmd.isEmbedded()) {
                embedded = true;
            } else if (mmd.getEmbeddedMetaData() != null) {
                embedded = true;
            } else if (Relation.isRelationMultiValued((int)relationType)) {
                if (mmd.hasCollection() && mmd.getElementMetaData() != null && mmd.getElementMetaData().getEmbeddedMetaData() != null) {
                    embedded = true;
                } else if (mmd.hasArray() && mmd.getElementMetaData() != null && mmd.getElementMetaData().getEmbeddedMetaData() != null) {
                    embedded = true;
                } else if (mmd.hasMap() && (mmd.getKeyMetaData() != null && mmd.getKeyMetaData().getEmbeddedMetaData() != null || mmd.getValueMetaData() != null && mmd.getValueMetaData().getEmbeddedMetaData() != null)) {
                    embedded = true;
                }
            }
        }
        if (embedded) {
            if (Relation.isRelationSingleValued((int)relationType)) {
                AbstractClassMetaData embcmd = this.ec.getMetaDataManager().getMetaDataForClass(mmd.getType(), clr);
                if (embcmd == null) {
                    throw new NucleusUserException("Field " + mmd.getFullFieldName() + " marked as embedded but no such metadata");
                }
                boolean nested = true;
                String nestedStr = mmd.getValueForExtension("nested");
                if (nestedStr != null && nestedStr.equalsIgnoreCase("false")) {
                    nested = false;
                }
                if (nested) {
                    if (embedded && Relation.isBidirectional((int)relationType) && (this.ownerMmd.getMappedBy() != null && mmd.getName().equals(this.ownerMmd.getMappedBy()) || mmd.getMappedBy() != null && this.ownerMmd.getName().equals(mmd.getMappedBy()))) {
                        ObjectProvider[] ownerSms = this.sm.getEmbeddedOwners();
                        if (ownerSms == null) {
                            throw new NucleusException("Processing of " + mmd.getFullFieldName() + " cannot set value to owner since owner StateManager not set");
                        }
                        return ownerSms[0].getObject();
                    }
                    String fieldName2 = MongoDBUtils.getFieldName(mmd);
                    if (!this.dbObject.containsField(fieldName2)) {
                        return null;
                    }
                    DBObject embeddedValue = (DBObject)this.dbObject.get(fieldName2);
                    ObjectProvider embSM = this.ec.newObjectProviderForEmbedded(mmd, embcmd, this.sm, fieldNumber);
                    FetchFieldManager ffm = new FetchFieldManager(embSM, embeddedValue, embcmd);
                    ffm.ownerMmd = mmd;
                    ffm.embedded = true;
                    embSM.replaceFields(embcmd.getAllMemberPositions(), (FieldManager)ffm);
                    return embSM.getObject();
                }
                EmbeddedMetaData embmd = mmd.getEmbeddedMetaData();
                AbstractMemberMetaData[] embmmds = embmd.getMemberMetaData();
                boolean isNull = true;
                for (int i = 0; i < embmmds.length; ++i) {
                    String embFieldName = MongoDBUtils.getFieldName(mmd, i);
                    if (!this.dbObject.containsField(embFieldName)) continue;
                    isNull = false;
                    break;
                }
                if (isNull) {
                    return null;
                }
                ObjectProvider embSM = this.ec.newObjectProviderForEmbedded(mmd, embcmd, this.sm, fieldNumber);
                FetchEmbeddedFieldManager ffm = new FetchEmbeddedFieldManager(embSM, this.dbObject, mmd);
                embSM.replaceFields(embcmd.getAllMemberPositions(), (FieldManager)ffm);
                return embSM.getObject();
            }
            if (Relation.isRelationMultiValued((int)relationType)) {
                if (mmd.hasCollection()) {
                    Collection coll;
                    String fieldName3 = MongoDBUtils.getFieldName(mmd);
                    if (!this.dbObject.containsField(fieldName3)) {
                        return null;
                    }
                    Object value = this.dbObject.get(fieldName3);
                    AbstractClassMetaData elemCmd = mmd.getCollection().getElementClassMetaData(clr, this.ec.getMetaDataManager());
                    try {
                        Class instanceType = SCOUtils.getContainerInstanceType((Class)mmd.getType(), (Boolean)(mmd.getOrderMetaData() != null ? 1 : 0));
                        coll = (Collection)instanceType.newInstance();
                    }
                    catch (Exception e) {
                        throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
                    }
                    Collection collValue = (Collection)value;
                    for (DBObject elementObj : collValue) {
                        ObjectProvider embSM = this.ec.newObjectProviderForEmbedded(mmd, elemCmd, this.sm, fieldNumber);
                        embSM.setPcObjectType((short)2);
                        FetchFieldManager ffm = new FetchFieldManager(embSM, elementObj, elemCmd);
                        ffm.ownerMmd = mmd;
                        ffm.embedded = true;
                        embSM.replaceFields(elemCmd.getAllMemberPositions(), (FieldManager)ffm);
                        coll.add(embSM.getObject());
                    }
                    if (this.sm != null) {
                        return this.sm.wrapSCOField(fieldNumber, (Object)coll, false, false, true);
                    }
                    return coll;
                }
                if (mmd.hasArray()) {
                    String fieldName4 = MongoDBUtils.getFieldName(mmd);
                    if (!this.dbObject.containsField(fieldName4)) {
                        return null;
                    }
                    AbstractClassMetaData elemCmd = mmd.getArray().getElementClassMetaData(clr, this.ec.getMetaDataManager());
                    Object value = this.dbObject.get(fieldName4);
                    Object[] array = new Object[Array.getLength(value)];
                    for (int i = 0; i < array.length; ++i) {
                        DBObject elementObj = (DBObject)Array.get(value, i);
                        ObjectProvider embSM = this.ec.newObjectProviderForEmbedded(mmd, elemCmd, this.sm, fieldNumber);
                        embSM.setPcObjectType((short)2);
                        FetchFieldManager ffm = new FetchFieldManager(embSM, elementObj, elemCmd);
                        ffm.ownerMmd = mmd;
                        ffm.embedded = true;
                        embSM.replaceFields(elemCmd.getAllMemberPositions(), (FieldManager)ffm);
                        array[i] = embSM.getObject();
                    }
                    return array;
                }
                String fieldName5 = MongoDBUtils.getFieldName(mmd);
                if (!this.dbObject.containsField(fieldName5)) {
                    return null;
                }
                Object value = this.dbObject.get(fieldName5);
                Map map = null;
                try {
                    Class instanceType = SCOUtils.getContainerInstanceType((Class)mmd.getType(), null);
                    map = (Map)instanceType.newInstance();
                }
                catch (Exception e) {
                    throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
                }
                AbstractClassMetaData keyCmd = mmd.getMap().getKeyClassMetaData(clr, this.ec.getMetaDataManager());
                AbstractClassMetaData valCmd = mmd.getMap().getValueClassMetaData(clr, this.ec.getMetaDataManager());
                Collection entryColl = (Collection)value;
                for (DBObject entryObj : entryColl) {
                    Object keyObj = entryObj.get("key");
                    Object valObj = entryObj.get("value");
                    Object mapKey = null;
                    if (keyCmd != null) {
                        DBObject keyDbObj = (DBObject)keyObj;
                        ObjectProvider embSM = this.ec.newObjectProviderForEmbedded(mmd, keyCmd, this.sm, fieldNumber);
                        embSM.setPcObjectType((short)3);
                        FetchFieldManager ffm = new FetchFieldManager(embSM, keyDbObj, keyCmd);
                        ffm.ownerMmd = mmd;
                        ffm.embedded = true;
                        embSM.replaceFields(keyCmd.getAllMemberPositions(), (FieldManager)ffm);
                        mapKey = embSM.getObject();
                    } else {
                        mapKey = this.getMapKeyForReturnValue(mmd, keyObj);
                    }
                    Object mapVal = null;
                    if (valCmd != null) {
                        DBObject valDbObj = (DBObject)valObj;
                        ObjectProvider embSM = this.ec.newObjectProviderForEmbedded(mmd, valCmd, this.sm, fieldNumber);
                        embSM.setPcObjectType((short)4);
                        FetchFieldManager ffm = new FetchFieldManager(embSM, valDbObj, valCmd);
                        ffm.ownerMmd = mmd;
                        ffm.embedded = true;
                        embSM.replaceFields(valCmd.getAllMemberPositions(), (FieldManager)ffm);
                        mapVal = embSM.getObject();
                    } else {
                        mapVal = this.getMapValueForReturnValue(mmd, valObj);
                    }
                    map.put(mapKey, mapVal);
                }
                if (this.sm != null) {
                    return this.sm.wrapSCOField(fieldNumber, (Object)map, false, false, true);
                }
                return map;
            }
        }
        if (!this.dbObject.containsField(fieldName = MongoDBUtils.getFieldName(mmd))) {
            return null;
        }
        Object value = this.dbObject.get(fieldName);
        if (mmd.isSerialized()) {
            return this.getValueForSerialisedField(mmd, value);
        }
        if (Relation.isRelationSingleValued((int)relationType)) {
            return this.getValueForSingleRelationField(mmd, value, clr);
        }
        if (Relation.isRelationMultiValued((int)relationType)) {
            return this.getValueForContainerRelationField(mmd, value, clr);
        }
        return this.getValueForContainerNonRelationField(mmd, value);
    }

    protected Object getValueForSerialisedField(AbstractMemberMetaData mmd, Object value) {
        Object returnValue = null;
        try {
            if (value != null) {
                byte[] bytes = (byte[])value;
                ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
                ObjectInputStream ois = new ObjectInputStream(bis);
                returnValue = ois.readObject();
                ois.close();
                bis.close();
                if (this.sm != null) {
                    returnValue = this.sm.wrapSCOField(mmd.getAbsoluteFieldNumber(), returnValue, false, false, true);
                }
            }
        }
        catch (Exception e) {
            throw new NucleusUserException("Exception thrown deserialising field at " + mmd.getFullFieldName(), (Throwable)e);
        }
        return returnValue;
    }

    protected Object getValueForSingleRelationField(AbstractMemberMetaData mmd, Object value, ClassLoaderResolver clr) {
        String idStr = (String)value;
        if (value == null) {
            return null;
        }
        AbstractClassMetaData otherCmd = this.ec.getMetaDataManager().getMetaDataForClass(mmd.getType(), clr);
        return IdentityUtils.getObjectFromIdString((String)idStr, (AbstractClassMetaData)otherCmd, (ExecutionContext)this.ec, (boolean)true);
    }

    protected Object getValueForContainerRelationField(AbstractMemberMetaData mmd, Object value, ClassLoaderResolver clr) {
        if (mmd.hasCollection()) {
            Collection coll;
            try {
                Class instanceType = SCOUtils.getContainerInstanceType((Class)mmd.getType(), (Boolean)(mmd.getOrderMetaData() != null ? 1 : 0));
                coll = (Collection)instanceType.newInstance();
            }
            catch (Exception e) {
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
            AbstractClassMetaData elemCmd = mmd.getCollection().getElementClassMetaData(clr, this.ec.getMetaDataManager());
            Collection collIds = (Collection)value;
            for (String elementIdStr : collIds) {
                coll.add(IdentityUtils.getObjectFromIdString((String)elementIdStr, (AbstractClassMetaData)elemCmd, (ExecutionContext)this.ec, (boolean)true));
            }
            if (this.sm != null) {
                return this.sm.wrapSCOField(mmd.getAbsoluteFieldNumber(), (Object)coll, false, false, true);
            }
            return coll;
        }
        if (mmd.hasMap()) {
            Map map = null;
            try {
                Class instanceType = SCOUtils.getContainerInstanceType((Class)mmd.getType(), null);
                map = (Map)instanceType.newInstance();
            }
            catch (Exception e) {
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
            AbstractClassMetaData keyCmd = mmd.getMap().getKeyClassMetaData(clr, this.ec.getMetaDataManager());
            AbstractClassMetaData valueCmd = mmd.getMap().getValueClassMetaData(clr, this.ec.getMetaDataManager());
            Collection collEntries = (Collection)value;
            for (DBObject entryObj : collEntries) {
                Object keyObj = entryObj.get("key");
                Object valueObj = entryObj.get("value");
                Object mapKey = null;
                mapKey = keyCmd != null ? IdentityUtils.getObjectFromIdString((String)((String)keyObj), (AbstractClassMetaData)keyCmd, (ExecutionContext)this.ec, (boolean)true) : this.getMapKeyForReturnValue(mmd, keyObj);
                Object mapVal = null;
                mapVal = valueCmd != null ? IdentityUtils.getObjectFromIdString((String)((String)valueObj), (AbstractClassMetaData)valueCmd, (ExecutionContext)this.ec, (boolean)true) : this.getMapValueForReturnValue(mmd, valueObj);
                map.put(mapKey, mapVal);
            }
            if (this.sm != null) {
                return this.sm.wrapSCOField(mmd.getAbsoluteFieldNumber(), (Object)map, false, false, true);
            }
            return map;
        }
        if (mmd.hasArray()) {
            AbstractClassMetaData elemCmd = mmd.getArray().getElementClassMetaData(clr, this.ec.getMetaDataManager());
            Collection collIds = (Collection)value;
            Iterator idIter = collIds.iterator();
            int i = 0;
            Object array = Array.newInstance(mmd.getType().getComponentType(), collIds.size());
            while (idIter.hasNext()) {
                String elementIdStr = (String)idIter.next();
                Array.set(array, i, IdentityUtils.getObjectFromIdString((String)elementIdStr, (AbstractClassMetaData)elemCmd, (ExecutionContext)this.ec, (boolean)true));
                ++i;
            }
            return array;
        }
        return value;
    }

    protected Object getValueForContainerNonRelationField(AbstractMemberMetaData mmd, Object value) {
        ObjectStringConverter strConv = this.ec.getNucleusContext().getTypeManager().getStringConverter(value.getClass());
        ObjectLongConverter longConv = this.ec.getNucleusContext().getTypeManager().getLongConverter(value.getClass());
        Object returnValue = value;
        if (strConv != null) {
            String strValue = (String)value;
            returnValue = strConv.toObject(strValue);
        } else if (longConv != null) {
            Long longValue = (Long)value;
            returnValue = longConv.toObject(longValue);
        }
        if (this.sm != null) {
            return this.sm.wrapSCOField(mmd.getAbsoluteFieldNumber(), returnValue, false, false, true);
        }
        return returnValue;
    }

    private Object getMapKeyForReturnValue(AbstractMemberMetaData mmd, Object value) {
        String keyType = mmd.getMap().getKeyType();
        Class keyCls = this.ec.getClassLoaderResolver().classForName(keyType);
        if (keyCls == Long.class || keyCls == Double.class || keyCls == Float.class || keyCls == Integer.class || keyCls == Short.class || keyCls == String.class) {
            return value;
        }
        throw new NucleusException("Dont currently support persistence/retrieval of maps with keys of type " + keyType);
    }

    private Object getMapValueForReturnValue(AbstractMemberMetaData mmd, Object value) {
        String valueType = mmd.getMap().getValueType();
        Class valueCls = this.ec.getClassLoaderResolver().classForName(valueType);
        if (valueCls == Long.class || valueCls == Double.class || valueCls == Float.class || valueCls == Integer.class || valueCls == Short.class || valueCls == String.class) {
            return value;
        }
        throw new NucleusException("Dont currently support persistence/retrieval of maps with values of type " + valueType);
    }
}

