/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import java.sql.Timestamp;
import java.util.Date;
import org.bson.types.ObjectId;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.exceptions.NucleusOptimisticException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.identity.OID;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.DiscriminatorMetaData;
import org.datanucleus.metadata.DiscriminatorStrategy;
import org.datanucleus.metadata.IdentityStrategy;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.VersionMetaData;
import org.datanucleus.metadata.VersionStrategy;
import org.datanucleus.store.AbstractPersistenceHandler;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.fieldmanager.DeleteFieldManager;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.mongodb.MongoDBStoreManager;
import org.datanucleus.store.mongodb.MongoDBUtils;
import org.datanucleus.store.mongodb.fieldmanager.FetchFieldManager;
import org.datanucleus.store.mongodb.fieldmanager.StoreFieldManager;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class MongoDBPersistenceHandler
extends AbstractPersistenceHandler {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.store.mongodb.Localisation", (ClassLoader)MongoDBStoreManager.class.getClassLoader());
    protected final MongoDBStoreManager storeMgr;

    public MongoDBPersistenceHandler(StoreManager storeMgr) {
        this.storeMgr = (MongoDBStoreManager)storeMgr;
    }

    public void close() {
    }

    public void batchStart(ExecutionContext ec) {
    }

    public void batchEnd(ExecutionContext ec) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertObject(ObjectProvider sm) {
        this.storeMgr.assertReadOnlyForUpdateOfObject(sm);
        AbstractClassMetaData cmd = sm.getClassMetaData();
        if (!this.storeMgr.managesClass(cmd.getFullClassName())) {
            this.storeMgr.addClass(cmd.getFullClassName(), sm.getExecutionContext().getClassLoaderResolver());
        }
        if (cmd.getIdentityType() != IdentityType.NONDURABLE) {
            try {
                this.locateObject(sm);
                throw new NucleusUserException(LOCALISER.msg("MongoDB.Insert.ObjectWithIdAlreadyExists", (Object)sm.toPrintableID(), sm.getInternalObjectId()));
            }
            catch (NucleusObjectNotFoundException onfe) {
                // empty catch block
            }
        }
        ExecutionContext ec = sm.getExecutionContext();
        ManagedConnection mconn = this.storeMgr.getConnection(ec);
        try {
            DB db = (DB)mconn.getConnection();
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("MongoDB.Insert.Start", (Object)sm.toPrintableID(), sm.getInternalObjectId()));
            }
            DBCollection collection = db.getCollection(MongoDBUtils.getCollectionName(cmd));
            BasicDBObject dbObject = new BasicDBObject();
            if (cmd.getIdentityType() == IdentityType.DATASTORE && cmd.getIdentityMetaData().getValueStrategy() != IdentityStrategy.IDENTITY) {
                String fieldName = MongoDBUtils.getFieldName(cmd.getIdentityMetaData());
                OID oid = (OID)sm.getInternalObjectId();
                Object key = oid.getKeyValue();
                dbObject.put(fieldName, key);
            }
            if (cmd.hasDiscriminatorStrategy()) {
                DiscriminatorMetaData discmd = cmd.getDiscriminatorMetaData();
                String fieldName = MongoDBUtils.getFieldName(discmd);
                String discVal = null;
                discVal = cmd.getDiscriminatorStrategy() == DiscriminatorStrategy.CLASS_NAME ? cmd.getFullClassName() : discmd.getValue();
                dbObject.put(fieldName, (Object)discVal);
            }
            String versionStr = null;
            if (cmd.hasVersionStrategy()) {
                String fieldName;
                AbstractMemberMetaData verMmd;
                if (cmd.getVersionMetaData().getVersionStrategy() == VersionStrategy.VERSION_NUMBER) {
                    long versionNumber = 1L;
                    sm.setTransactionalVersion((Object)versionNumber);
                    versionStr = "" + versionNumber;
                    if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                        NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("MongoDB.Insert.ObjectPersistedWithVersion", (Object)sm.toPrintableID(), sm.getInternalObjectId(), (Object)("" + versionNumber)));
                    }
                    if (cmd.getVersionMetaData().getFieldName() != null) {
                        verMmd = cmd.getMetaDataForMember(cmd.getVersionMetaData().getFieldName());
                        Number verFieldValue = versionNumber;
                        if (verMmd.getType() == Integer.TYPE || verMmd.getType() == Integer.class) {
                            verFieldValue = (int)versionNumber;
                        }
                        sm.replaceField(verMmd.getAbsoluteFieldNumber(), (Object)verFieldValue);
                    } else {
                        fieldName = MongoDBUtils.getFieldName(cmd.getVersionMetaData());
                        dbObject.put(fieldName, (Object)new Long(versionNumber));
                    }
                } else if (cmd.getVersionMetaData().getVersionStrategy() == VersionStrategy.DATE_TIME) {
                    Date date = new Date();
                    Timestamp ts = new Timestamp(date.getTime());
                    sm.setTransactionalVersion((Object)ts);
                    versionStr = "" + ts;
                    if (cmd.getVersionMetaData().getFieldName() != null) {
                        verMmd = cmd.getMetaDataForMember(cmd.getVersionMetaData().getFieldName());
                        sm.replaceField(verMmd.getAbsoluteFieldNumber(), (Object)ts);
                    } else {
                        fieldName = MongoDBUtils.getFieldName(cmd.getVersionMetaData());
                        dbObject.put(fieldName, (Object)ts);
                    }
                }
            }
            StoreFieldManager fieldManager = new StoreFieldManager(sm, (DBObject)dbObject, cmd);
            sm.provideFields(cmd.getAllMemberPositions(), (FieldManager)fieldManager);
            collection.insert(new DBObject[]{dbObject});
            NucleusLogger.DATASTORE_PERSIST.debug((Object)("Persisting object as " + dbObject));
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                if (versionStr != null) {
                    NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("MongoDB.Insert.ObjectPersistedWithVersion", (Object)sm.toPrintableID(), sm.getInternalObjectId(), (Object)versionStr));
                } else {
                    NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("MongoDB.Insert.ObjectPersisted", (Object)sm.toPrintableID(), sm.getInternalObjectId()));
                }
            }
            if (cmd.getIdentityType() == IdentityType.DATASTORE && cmd.getIdentityMetaData().getValueStrategy() == IdentityStrategy.IDENTITY) {
                ObjectId idKey = (ObjectId)dbObject.get("_id");
                sm.setPostStoreNewObjectId((Object)idKey.toString());
                if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                    NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("MongoDB.Insert.ObjectPersistedWithIdentity", (Object)sm.toPrintableID(), (Object)idKey));
                }
            } else if (cmd.getIdentityType() == IdentityType.APPLICATION) {
                int[] pkFieldNumbers = cmd.getPKMemberPositions();
                for (int i = 0; i < pkFieldNumbers.length; ++i) {
                    AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(pkFieldNumbers[i]);
                    if (mmd.getValueStrategy() != IdentityStrategy.IDENTITY) continue;
                    if (mmd.getType() != String.class) {
                        throw new NucleusUserException("Any field using IDENTITY value generation with MongoDB should be of type String");
                    }
                    ObjectId idKey = (ObjectId)dbObject.get("_id");
                    sm.replaceField(mmd.getAbsoluteFieldNumber(), (Object)idKey.toString());
                    sm.setPostStoreNewObjectId((Object)idKey);
                    if (!NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) continue;
                    NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("MongoDB.Insert.ObjectPersistedWithIdentity", (Object)sm.toPrintableID(), (Object)idKey));
                }
            }
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("MongoDB.ExecutionTime", System.currentTimeMillis() - startTime));
            }
            if (this.storeMgr.getRuntimeManager() != null) {
                this.storeMgr.getRuntimeManager().incrementInsertCount();
            }
        }
        finally {
            mconn.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateObject(ObjectProvider sm, int[] fieldNumbers) {
        this.storeMgr.assertReadOnlyForUpdateOfObject(sm);
        ExecutionContext ec = sm.getExecutionContext();
        ManagedConnection mconn = this.storeMgr.getConnection(ec);
        try {
            DBCollection collection;
            DBObject dbObject;
            DB db = (DB)mconn.getConnection();
            long startTime = System.currentTimeMillis();
            AbstractClassMetaData cmd = sm.getClassMetaData();
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                StringBuffer fieldStr = new StringBuffer();
                for (int i = 0; i < fieldNumbers.length; ++i) {
                    if (i > 0) {
                        fieldStr.append(",");
                    }
                    fieldStr.append(cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]).getName());
                }
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("MongoDB.Update.Start", (Object)sm.toPrintableID(), sm.getInternalObjectId(), (Object)fieldStr.toString()));
            }
            if ((dbObject = MongoDBUtils.getObjectForObjectProvider(collection = db.getCollection(MongoDBUtils.getCollectionName(cmd)), sm, true)) == null) {
                if (cmd.hasVersionStrategy()) {
                    throw new NucleusOptimisticException("Object with id " + sm.getObjectId() + " and version " + sm.getTransactionalVersion() + " no longer present");
                }
                throw new NucleusDataStoreException("Could not find object with id " + sm.getObjectId());
            }
            if (cmd.hasVersionStrategy()) {
                Object currentVersion = sm.getTransactionalVersion();
                VersionMetaData vermd = cmd.getVersionMetaData();
                Object nextVersion = vermd.getNextVersion(currentVersion);
                sm.setTransactionalVersion(nextVersion);
                if (cmd.getVersionMetaData().getFieldName() != null) {
                    AbstractMemberMetaData verMmd = cmd.getMetaDataForMember(cmd.getVersionMetaData().getFieldName());
                    sm.replaceField(verMmd.getAbsoluteFieldNumber(), nextVersion);
                } else {
                    String fieldName = MongoDBUtils.getFieldName(cmd.getVersionMetaData());
                    dbObject.put(fieldName, nextVersion);
                }
            }
            StoreFieldManager fieldManager = new StoreFieldManager(sm, dbObject, cmd);
            sm.provideFields(cmd.getAllMemberPositions(), (FieldManager)fieldManager);
            collection.save(dbObject);
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("MongoDB.ExecutionTime", System.currentTimeMillis() - startTime));
            }
            if (this.storeMgr.getRuntimeManager() != null) {
                this.storeMgr.getRuntimeManager().incrementUpdateCount();
            }
        }
        finally {
            mconn.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteObject(ObjectProvider sm) {
        this.storeMgr.assertReadOnlyForUpdateOfObject(sm);
        AbstractClassMetaData cmd = sm.getClassMetaData();
        ExecutionContext ec = sm.getExecutionContext();
        ManagedConnection mconn = this.storeMgr.getConnection(ec);
        try {
            DBCollection collection;
            DBObject dbObject;
            DB db = (DB)mconn.getConnection();
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("MongoDB.Delete.Start", (Object)sm.toPrintableID(), sm.getInternalObjectId()));
            }
            if ((dbObject = MongoDBUtils.getObjectForObjectProvider(collection = db.getCollection(MongoDBUtils.getCollectionName(cmd)), sm, true)) == null) {
                if (cmd.hasVersionStrategy()) {
                    throw new NucleusOptimisticException("Object with id " + sm.getObjectId() + " and version " + sm.getTransactionalVersion() + " no longer present");
                }
                throw new NucleusDataStoreException("Could not find object with id " + sm.getObjectId());
            }
            sm.loadUnloadedFields();
            sm.provideFields(cmd.getAllMemberPositions(), (FieldManager)new DeleteFieldManager(sm));
            collection.remove(dbObject);
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("MongoDB.ExecutionTime", System.currentTimeMillis() - startTime));
            }
            if (this.storeMgr.getRuntimeManager() != null) {
                this.storeMgr.getRuntimeManager().incrementDeleteCount();
            }
        }
        finally {
            mconn.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetchObject(ObjectProvider sm, int[] fieldNumbers) {
        AbstractClassMetaData cmd = sm.getClassMetaData();
        ExecutionContext ec = sm.getExecutionContext();
        ManagedConnection mconn = this.storeMgr.getConnection(ec);
        try {
            DBCollection collection;
            DBObject dbObject;
            DB db = (DB)mconn.getConnection();
            if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
                StringBuffer str = new StringBuffer("Fetching object \"");
                str.append(sm.toPrintableID()).append("\" (id=");
                str.append(sm.getExecutionContext().getApiAdapter().getObjectId(sm)).append(")").append(" fields [");
                for (int i = 0; i < fieldNumbers.length; ++i) {
                    if (i > 0) {
                        str.append(",");
                    }
                    str.append(cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]).getName());
                }
                str.append("]");
                NucleusLogger.DATASTORE_RETRIEVE.debug((Object)str);
            }
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
                NucleusLogger.DATASTORE_RETRIEVE.debug((Object)LOCALISER.msg("MongoDB.Fetch.Start", (Object)sm.toPrintableID(), sm.getInternalObjectId()));
            }
            if ((dbObject = MongoDBUtils.getObjectForObjectProvider(collection = db.getCollection(MongoDBUtils.getCollectionName(cmd)), sm, false)) == null) {
                throw new NucleusDataStoreException("Could not find object with id " + sm.getObjectId());
            }
            if (cmd.hasVersionStrategy() && sm.getTransactionalVersion() == null) {
                if (cmd.getVersionMetaData().getFieldName() != null) {
                    Object datastoreVersion = sm.provideField(cmd.getAbsolutePositionOfMember(cmd.getVersionMetaData().getFieldName()));
                    sm.setVersion(datastoreVersion);
                } else {
                    String fieldName = MongoDBUtils.getFieldName(cmd.getVersionMetaData());
                    Object datastoreVersion = dbObject.get(fieldName);
                    sm.setVersion(datastoreVersion);
                }
            }
            FetchFieldManager fieldManager = new FetchFieldManager(sm, dbObject, cmd);
            sm.replaceFields(fieldNumbers, (FieldManager)fieldManager);
            if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
                NucleusLogger.DATASTORE_RETRIEVE.debug((Object)LOCALISER.msg("MongoDB.ExecutionTime", System.currentTimeMillis() - startTime));
            }
            if (this.storeMgr.getRuntimeManager() != null) {
                this.storeMgr.getRuntimeManager().incrementFetchCount();
            }
        }
        finally {
            mconn.release();
        }
    }

    public Object findObject(ExecutionContext om, Object id) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void locateObject(ObjectProvider sm) {
        AbstractClassMetaData cmd = sm.getClassMetaData();
        if (cmd.getIdentityType() == IdentityType.APPLICATION || cmd.getIdentityType() == IdentityType.DATASTORE) {
            ExecutionContext ec = sm.getExecutionContext();
            ManagedConnection mconn = this.storeMgr.getConnection(ec);
            try {
                DB db = (DB)mconn.getConnection();
                DBCollection collection = db.getCollection(MongoDBUtils.getCollectionName(cmd));
                DBObject dbObject = MongoDBUtils.getObjectForObjectProvider(collection, sm, false);
                if (dbObject == null) {
                    throw new NucleusObjectNotFoundException();
                }
            }
            finally {
                mconn.release();
            }
        }
    }
}

