/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.ldap.fieldmanager;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.fieldmanager.AbstractFieldManager;
import org.datanucleus.store.ldap.LDAPUtils;
import org.datanucleus.store.ldap.fieldmanager.AbstractMappingStrategy;
import org.datanucleus.store.ldap.fieldmanager.CalendarToGeneralizedTimeStringConverter;
import org.datanucleus.store.ldap.fieldmanager.DateToGeneralizedTimeStringConverter;
import org.datanucleus.store.ldap.fieldmanager.MappingStrategyHelper;
import org.datanucleus.store.ldap.fieldmanager.SimpleContainerHelper;

public class StoreFieldManager
extends AbstractFieldManager {
    DNStateManager sm;
    StoreManager storeMgr;
    Attributes attributes;
    boolean insert;

    public StoreFieldManager(StoreManager storeMgr, DNStateManager sm, Attributes attrs, boolean insert) {
        this.sm = sm;
        this.storeMgr = storeMgr;
        this.attributes = attrs;
        this.insert = insert;
    }

    public void storeObjectField(int fieldNumber, Object value) {
        AbstractMemberMetaData mmd = this.sm.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        String name = LDAPUtils.getAttributeNameForField(mmd);
        ClassLoaderResolver clr = this.sm.getExecutionContext().getClassLoaderResolver();
        RelationType relType = mmd.getRelationType(clr);
        if (relType == RelationType.NONE) {
            if (mmd.hasCollection()) {
                Collection valueCollection = (Collection)value;
                if (value == null) {
                    return;
                }
                if (valueCollection.isEmpty() && this.insert) {
                    return;
                }
                Attribute attr = SimpleContainerHelper.storeCollection(mmd, value, this.sm.getExecutionContext().getTypeManager(), clr);
                this.attributes.put(attr);
                return;
            }
            if (mmd.hasArray()) {
                if (value == null) {
                    if (this.insert) {
                        return;
                    }
                    this.attributes.put(new BasicAttribute(name));
                } else {
                    Attribute attr = SimpleContainerHelper.storeArray(mmd, value, this.sm.getExecutionContext().getTypeManager());
                    this.attributes.put(attr);
                }
                return;
            }
            if (!mmd.hasMap()) {
                if (value == null) {
                    if (this.insert) {
                        return;
                    }
                    this.attributes.put(new BasicAttribute(name));
                    return;
                }
                if (Boolean.class.isAssignableFrom(mmd.getType())) {
                    this.storeBooleanField(fieldNumber, (Boolean)value);
                    return;
                }
                if (Byte.class.isAssignableFrom(mmd.getType())) {
                    this.storeByteField(fieldNumber, (Byte)value);
                    return;
                }
                if (Character.class.isAssignableFrom(mmd.getType())) {
                    this.storeCharField(fieldNumber, ((Character)value).charValue());
                    return;
                }
                if (Double.class.isAssignableFrom(mmd.getType())) {
                    this.storeDoubleField(fieldNumber, (Double)value);
                    return;
                }
                if (Float.class.isAssignableFrom(mmd.getType())) {
                    this.storeFloatField(fieldNumber, ((Float)value).floatValue());
                    return;
                }
                if (Integer.class.isAssignableFrom(mmd.getType())) {
                    this.storeIntField(fieldNumber, (Integer)value);
                    return;
                }
                if (Long.class.isAssignableFrom(mmd.getType())) {
                    this.storeLongField(fieldNumber, (Long)value);
                    return;
                }
                if (Short.class.isAssignableFrom(mmd.getType())) {
                    this.storeShortField(fieldNumber, (Short)value);
                    return;
                }
                if (mmd.getType().isEnum()) {
                    boolean useNumeric;
                    ColumnMetaData colmd = null;
                    if (mmd != null && mmd.getColumnMetaData() != null && mmd.getColumnMetaData().length > 0) {
                        colmd = mmd.getColumnMetaData()[0];
                    }
                    this.storeStringValue(fieldNumber, "" + (Serializable)((useNumeric = MetaDataUtils.persistColumnAsNumeric(colmd)) ? Integer.valueOf(((Enum)value).ordinal()) : value.toString()));
                    return;
                }
                Object converter = null;
                converter = Date.class.isAssignableFrom(mmd.getType()) ? new DateToGeneralizedTimeStringConverter() : (Calendar.class.isAssignableFrom(mmd.getType()) ? new CalendarToGeneralizedTimeStringConverter() : this.sm.getExecutionContext().getTypeManager().getTypeConverterForType(mmd.getType(), String.class));
                if (converter != null) {
                    this.attributes.put(new BasicAttribute(name, converter.toDatastoreType(value)));
                    return;
                }
                throw new NucleusException("Field " + mmd.getFullFieldName() + " cannot be persisted because type=" + mmd.getTypeName() + " is not supported for this datastore");
            }
        } else {
            AbstractMappingStrategy ms = MappingStrategyHelper.findMappingStrategy(this.storeMgr, this.sm, mmd, this.attributes);
            if (ms != null) {
                if (this.insert) {
                    ms.insert(value);
                } else {
                    ms.update(value);
                }
                return;
            }
        }
        throw new NucleusException("Field " + mmd.getFullFieldName() + " cannot be persisted because type=" + mmd.getTypeName() + " is not supported for this datastore");
    }

    public void storeBooleanField(int fieldNumber, boolean value) {
        AbstractMemberMetaData mmd = this.sm.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        String name = LDAPUtils.getAttributeNameForField(mmd);
        this.attributes.put(new BasicAttribute(name, ("" + value).toUpperCase()));
    }

    public void storeByteField(int fieldNumber, byte value) {
        this.storeStringValue(fieldNumber, "" + value);
    }

    public void storeCharField(int fieldNumber, char value) {
        this.storeStringValue(fieldNumber, "" + value);
    }

    public void storeDoubleField(int fieldNumber, double value) {
        this.storeStringValue(fieldNumber, "" + value);
    }

    public void storeFloatField(int fieldNumber, float value) {
        this.storeStringValue(fieldNumber, "" + value);
    }

    public void storeIntField(int fieldNumber, int value) {
        this.storeStringValue(fieldNumber, "" + value);
    }

    public void storeLongField(int fieldNumber, long value) {
        this.storeStringValue(fieldNumber, "" + value);
    }

    public void storeShortField(int fieldNumber, short value) {
        this.storeStringValue(fieldNumber, "" + value);
    }

    public void storeStringField(int fieldNumber, String value) {
        this.storeStringValue(fieldNumber, value);
    }

    protected void storeStringValue(int fieldNumber, String stringValue) {
        if (stringValue != null && stringValue.length() == 0) {
            stringValue = null;
        }
        AbstractMemberMetaData mmd = this.sm.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        String name = LDAPUtils.getAttributeNameForField(mmd);
        if (stringValue == null) {
            if (this.insert) {
                return;
            }
            this.attributes.put(new BasicAttribute(name));
            return;
        }
        this.attributes.put(new BasicAttribute(name, stringValue));
    }
}

