/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.ldap.query;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.ldap.LDAPUtils;
import org.datanucleus.store.ldap.query.filter.AndFilter;
import org.datanucleus.store.ldap.query.filter.EqualityFilter;
import org.datanucleus.store.ldap.query.filter.Filter;
import org.datanucleus.store.ldap.query.filter.GreaterEqFilter;
import org.datanucleus.store.ldap.query.filter.LessEqFilter;
import org.datanucleus.store.ldap.query.filter.NotFilter;
import org.datanucleus.store.ldap.query.filter.OrFilter;
import org.datanucleus.store.ldap.query.filter.PresenceFilter;
import org.datanucleus.store.ldap.query.filter.SubstringFilter;
import org.datanucleus.store.query.QueryUtils;
import org.datanucleus.store.query.compiler.QueryCompilation;
import org.datanucleus.store.query.compiler.SymbolTable;
import org.datanucleus.store.query.expression.AbstractExpressionEvaluator;
import org.datanucleus.store.query.expression.Expression;
import org.datanucleus.store.query.expression.ExpressionEvaluator;
import org.datanucleus.store.query.expression.InvokeExpression;
import org.datanucleus.store.query.expression.Literal;
import org.datanucleus.store.query.expression.ParameterExpression;
import org.datanucleus.store.query.expression.PrimaryExpression;

public class QueryToLDAPFilterMapper
extends AbstractExpressionEvaluator {
    QueryCompilation compilation;
    Map parameters;
    Expression filterExpr;
    AbstractClassMetaData acmd;
    SymbolTable symtbl;
    Deque stack = new ArrayDeque();
    Map ldapAttributeTypeMap;

    public QueryToLDAPFilterMapper(QueryCompilation compilation, Map parameters, AbstractClassMetaData acmd) {
        this.filterExpr = compilation.getExprFilter();
        this.symtbl = compilation.getSymbolTable();
        this.compilation = compilation;
        this.parameters = parameters;
        this.acmd = acmd;
    }

    public String compile() {
        if (this.filterExpr != null) {
            this.filterExpr.evaluate((ExpressionEvaluator)this);
            if (!this.stack.isEmpty()) {
                Object object = this.stack.pop();
                if (object instanceof Filter) {
                    Filter additionalFilter = (Filter)object;
                    return additionalFilter.toString();
                }
                throw new NucleusException("Unexpected element on stack: object=" + object);
            }
            throw new NucleusException("Unexpected empty stack");
        }
        return null;
    }

    protected Object processOrExpression(Expression expr) {
        Object right = this.stack.pop();
        Object left = this.stack.pop();
        if (!(left instanceof Filter) || !(right instanceof Filter)) {
            throw new NucleusException("Case not handled yet: left=" + left + ", right=" + right);
        }
        OrFilter filter = new OrFilter((Filter)left, (Filter)right);
        this.stack.push(filter);
        return filter;
    }

    protected Object processAndExpression(Expression expr) {
        Object right = this.stack.pop();
        Object left = this.stack.pop();
        if (!(left instanceof Filter) || !(right instanceof Filter)) {
            throw new NucleusException("Case not handled yet: left=" + left + ", right=" + right);
        }
        AndFilter filter = new AndFilter((Filter)left, (Filter)right);
        this.stack.push(filter);
        return filter;
    }

    protected Object processEqExpression(Expression expr) {
        return this.processExpressionWithOperator(expr, (Expression.Operator)Expression.OP_EQ);
    }

    protected Object processNoteqExpression(Expression expr) {
        return this.processExpressionWithOperator(expr, (Expression.Operator)Expression.OP_NOTEQ);
    }

    protected Object processLtExpression(Expression expr) {
        return this.processExpressionWithOperator(expr, (Expression.Operator)Expression.OP_LT);
    }

    protected Object processLteqExpression(Expression expr) {
        return this.processExpressionWithOperator(expr, (Expression.Operator)Expression.OP_LTEQ);
    }

    protected Object processGtExpression(Expression expr) {
        return this.processExpressionWithOperator(expr, (Expression.Operator)Expression.OP_GT);
    }

    protected Object processGteqExpression(Expression expr) {
        return this.processExpressionWithOperator(expr, (Expression.Operator)Expression.OP_GTEQ);
    }

    private Object processExpressionWithOperator(Expression expr, Expression.Operator operator) {
        Filter filter;
        Object right = this.stack.pop();
        Object left = this.stack.pop();
        if (left instanceof PrimaryExpression && right instanceof Literal) {
            String param = QueryUtils.getStringValueForExpression((Expression)((Literal)right), (Map)this.parameters);
            filter = this.getFilterForPrimaryLiteralValue(operator, (PrimaryExpression)left, param);
            this.stack.push(filter);
        } else if (left instanceof PrimaryExpression && right instanceof String) {
            String param = (String)right;
            filter = this.getFilterForPrimaryLiteralValue(operator, (PrimaryExpression)left, param);
            this.stack.push(filter);
        } else if (left instanceof PrimaryExpression && right instanceof Character) {
            String param = ((Character)right).toString();
            filter = this.getFilterForPrimaryLiteralValue(operator, (PrimaryExpression)left, param);
            this.stack.push(filter);
        } else if (left instanceof PrimaryExpression && right instanceof Number) {
            String param = ((Number)right).toString();
            filter = this.getFilterForPrimaryLiteralValue(operator, (PrimaryExpression)left, param);
            this.stack.push(filter);
        } else {
            throw new NucleusException("Case not handled yet: left=" + left + ", right=" + right);
        }
        return filter;
    }

    protected Object processPrimaryExpression(PrimaryExpression expr) {
        this.stack.push(expr);
        return expr;
    }

    protected Object processLiteral(Literal expr) {
        this.stack.push(expr);
        return expr;
    }

    protected Object processParameterExpression(ParameterExpression expr) {
        Object value = QueryUtils.getValueForParameterExpression((Map)this.parameters, (ParameterExpression)expr);
        this.stack.push(value);
        return value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object processInvokeExpression(InvokeExpression expr) {
        SubstringFilter filter;
        Expression invokedExpr = expr.getLeft();
        String method = expr.getOperation();
        if (!(invokedExpr instanceof PrimaryExpression)) throw new NucleusException("Case not handled yet: expr=" + expr);
        PrimaryExpression primaryExpression = (PrimaryExpression)invokedExpr;
        String attribute = this.getLdapAttributeType(primaryExpression);
        if (method.equals("startsWith")) {
            Expression param = (Expression)expr.getArguments().get(0);
            String value = QueryUtils.getStringValueForExpression((Expression)param, (Map)this.parameters);
            filter = new SubstringFilter(attribute);
            filter.setInitialPattern(this.getEscapedValue(value));
            this.stack.push(filter);
            return filter;
        } else {
            if (!method.equals("endsWith")) throw new NucleusException("Case not handled yet: expr=" + expr);
            Expression param = (Expression)expr.getArguments().get(0);
            String value = QueryUtils.getStringValueForExpression((Expression)param, (Map)this.parameters);
            filter = new SubstringFilter(attribute);
            filter.setFinalPattern(this.getEscapedValue(value));
            this.stack.push(filter);
        }
        return filter;
    }

    private String getEscapedValue(String value) {
        if (value != null) {
            value = value.replace("\\", "\\5c");
            value = value.replace("\u0000", "\\00");
            value = value.replace("*", "\\2a");
            value = value.replace("(", "\\28");
            value = value.replace(")", "\\29");
        }
        return value;
    }

    private Filter getFilterForPrimaryLiteralValue(Expression.Operator operator, PrimaryExpression expr, String param) {
        String attribute = this.getLdapAttributeType(expr);
        String value = this.getEscapedValue(param);
        Filter filter = null;
        if (operator == Expression.OP_EQ) {
            filter = value != null ? new EqualityFilter(attribute, value) : new NotFilter((Filter)new PresenceFilter(attribute));
        } else if (operator == Expression.OP_NOTEQ) {
            filter = value != null ? new NotFilter((Filter)new EqualityFilter(attribute, value)) : new PresenceFilter(attribute);
        } else if (operator == Expression.OP_LT) {
            LessEqFilter lessEqualFilter = new LessEqFilter(attribute, value);
            NotFilter notEqualFilter = new NotFilter((Filter)new EqualityFilter(attribute, value));
            filter = new AndFilter(lessEqualFilter, notEqualFilter);
        } else if (operator == Expression.OP_LTEQ) {
            filter = new LessEqFilter(attribute, value);
        } else if (operator == Expression.OP_GT) {
            GreaterEqFilter greaterEqualFilter = new GreaterEqFilter(attribute, value);
            NotFilter notEqualFilter = new NotFilter((Filter)new EqualityFilter(attribute, value));
            filter = new AndFilter(greaterEqualFilter, notEqualFilter);
        } else if (operator == Expression.OP_GTEQ) {
            filter = new GreaterEqFilter(attribute, value);
        } else {
            throw new NucleusException("Case not handled yet: operator=" + operator);
        }
        return filter;
    }

    private String getLdapAttributeType(PrimaryExpression expr) {
        String id = null;
        List tuples = expr.getTuples();
        for (String component : tuples) {
            if (component.equals(this.compilation.getCandidateAlias())) continue;
            id = component;
            break;
        }
        if (this.ldapAttributeTypeMap == null) {
            this.ldapAttributeTypeMap = new HashMap();
            List<AbstractMemberMetaData> mmds = LDAPUtils.getAllMemberMetaData(this.acmd);
            for (AbstractMemberMetaData mmd : mmds) {
                String ldapAttributeType = LDAPUtils.getAttributeNameForField(mmd);
                this.ldapAttributeTypeMap.put(mmd.getName(), ldapAttributeType);
            }
        }
        String ldapAttributeType = id;
        if (this.ldapAttributeTypeMap.containsKey(id)) {
            ldapAttributeType = (String)this.ldapAttributeTypeMap.get(id);
        }
        return ldapAttributeType;
    }
}

