/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.ldap.fieldmanager;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.naming.directory.Attributes;
import javax.naming.ldap.LdapName;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.ldap.LDAPUtils;
import org.datanucleus.store.ldap.fieldmanager.AbstractMappingStrategy;
import org.datanucleus.store.types.SCOUtils;
import org.datanucleus.util.ClassUtils;

public class RelationByHierarchyStrategy
extends AbstractMappingStrategy {
    protected int fieldNumber;
    protected StoreManager storeMgr;
    protected ClassLoaderResolver clr;
    protected AbstractClassMetaData effectiveClassMetaData;
    protected boolean isFieldHierarchicalMapped;
    protected boolean isFieldParentOfHierarchicalMapping;

    protected RelationByHierarchyStrategy(StoreManager storeMgr, ObjectProvider op, AbstractMemberMetaData mmd, Attributes attributes) {
        super(op, mmd, attributes);
        this.fieldNumber = mmd.getAbsoluteFieldNumber();
        this.storeMgr = storeMgr;
        this.clr = this.ec.getClassLoaderResolver();
        this.effectiveClassMetaData = LDAPUtils.getEffectiveClassMetaData(mmd, this.ec.getMetaDataManager());
        this.isFieldHierarchicalMapped = RelationByHierarchyStrategy.isChildOfHierarchicalMapping(mmd, this.ec.getMetaDataManager());
        this.isFieldParentOfHierarchicalMapping = RelationByHierarchyStrategy.isParentOfHierarchicalMapping(mmd, this.ec.getMetaDataManager());
    }

    @Override
    public Object fetch() {
        if (this.isFieldHierarchicalMapped) {
            RelationType relType = this.mmd.getRelationType(this.clr);
            if (RelationType.isRelationSingleValued((RelationType)relType)) {
                this.mmd.setDependent(true);
                return this.getHierarchicalMappedChild(this.mmd, this.op);
            }
            if ((relType == RelationType.ONE_TO_MANY_UNI || relType == RelationType.ONE_TO_MANY_BI) && this.mmd.hasCollection()) {
                Collection<Object> coll = this.getHierarchicalMappedChildren(this.mmd.getCollection().getElementType(), this.mmd.getMappedBy(), this.mmd, this.op);
                return SCOUtils.wrapSCOField((ObjectProvider)this.op, (int)this.fieldNumber, coll, (boolean)true);
            }
        }
        if (this.isFieldParentOfHierarchicalMapping) {
            LdapName dn = LDAPUtils.getDistinguishedNameForObject(this.storeMgr, this.op, true);
            LDAPUtils.LocationInfo locationInfo = LDAPUtils.getLocationInfo(this.op.getClassMetaData());
            LdapName parentDn = LDAPUtils.getParentDistingueshedName(dn, locationInfo.suffix);
            Object value = null;
            if (locationInfo.dn == null || !locationInfo.dn.equals(parentDn)) {
                value = LDAPUtils.getObjectByDN(this.storeMgr, this.ec, this.type, parentDn.toString());
            }
            return value;
        }
        throw new NucleusException("Cant obtain value for field " + this.mmd.getFullFieldName() + " since type=" + this.mmd.getTypeName() + " is not supported for this datastore");
    }

    private Object getHierarchicalMappedChild(AbstractMemberMetaData mmd, ObjectProvider sm) {
        Collection<Object> coll = this.getHierarchicalMappedChildren(mmd.getTypeName(), mmd.getMappedBy(), null, sm);
        if (coll.iterator().hasNext()) {
            return coll.iterator().next();
        }
        return null;
    }

    private Collection<Object> getHierarchicalMappedChildren(String type, String mappedBy, AbstractMemberMetaData mmd, ObjectProvider sm) {
        Collection coll;
        Class collectionClass = mmd == null ? ArrayList.class : SCOUtils.getContainerInstanceType((Class)mmd.getType(), (Boolean)(mmd.getOrderMetaData() != null ? 1 : 0));
        try {
            coll = (Collection)collectionClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            ClassLoaderResolver clr = this.ec.getClassLoaderResolver();
            MetaDataManager metaDataMgr = sm.getExecutionContext().getMetaDataManager();
            AbstractClassMetaData childCmd = metaDataMgr.getMetaDataForClass(type, clr);
            LdapName base = LDAPUtils.getDistinguishedNameForObject(this.storeMgr, sm, true);
            List<Object> objects = LDAPUtils.getObjectsOfCandidateType(this.storeMgr, this.ec, childCmd, base, null, true, false);
            coll.addAll(objects);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new NucleusException("Error in trying to create object of type " + collectionClass.getName(), (Throwable)e);
        }
        return coll;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void insert(Object value) {
        if (value == null || this.isFieldParentOfHierarchicalMapping) return;
        if (!this.isFieldHierarchicalMapped) throw new NucleusException("Field " + this.mmd.getFullFieldName() + " cannot be persisted because type=" + this.mmd.getTypeName() + " is not supported for this datastore");
        RelationType relType = this.mmd.getRelationType(this.clr);
        if (RelationType.isRelationSingleValued((RelationType)relType)) {
            LDAPUtils.markForPersisting(value, this.ec);
            return;
        } else {
            if (relType != RelationType.ONE_TO_MANY_UNI && relType != RelationType.ONE_TO_MANY_BI) throw new NucleusException("Field " + this.mmd.getFullFieldName() + " cannot be persisted because type=" + this.mmd.getTypeName() + " with relation type " + this.mmd.getRelationType(this.clr) + " is not supported for this datastore");
            if (!this.mmd.hasCollection()) return;
            Collection c = (Collection)value;
            for (Object pc : c) {
                LDAPUtils.markForPersisting(pc, this.ec);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void update(Object value) {
        if (this.isFieldParentOfHierarchicalMapping) {
            if (value != null) return;
            LDAPUtils.markForDeletion(this.op.getObject(), this.ec);
            return;
        } else {
            if (!this.isFieldHierarchicalMapped) throw new NucleusException("Field " + this.mmd.getFullFieldName() + " cannot be persisted because type=" + this.mmd.getTypeName() + " is not supported for this datastore");
            if (value == null) return;
            String mappedBy = this.mmd.getMappedBy();
            RelationType relType = this.mmd.getRelationType(this.clr);
            if (relType == RelationType.ONE_TO_ONE_UNI || relType == RelationType.MANY_TO_ONE_UNI) {
                ObjectProvider valueSM;
                ObjectProvider oldValueSM;
                Object oldValue = this.getHierarchicalMappedChild(this.mmd, this.op);
                if (oldValue != null && this.mustDelete(oldValueSM = this.ec.findObjectProvider(oldValue, false))) {
                    LDAPUtils.markForDeletion(oldValue, this.ec);
                }
                if ((valueSM = this.ec.findObjectProvider(value, false)) != null) {
                    LdapName oldDn = LDAPUtils.getDistinguishedNameForObject(this.storeMgr, valueSM, true);
                    LdapName newDn = LDAPUtils.getDistinguishedNameForObject(this.storeMgr, valueSM);
                    LDAPUtils.markForRename(this.storeMgr, value, this.ec, oldDn, newDn);
                    LDAPUtils.unmarkForDeletion(value, this.ec);
                }
                LDAPUtils.markForPersisting(value, this.ec);
                LDAPUtils.unmarkForDeletion(value, this.ec);
                return;
            } else if (relType == RelationType.ONE_TO_ONE_BI) {
                LDAPUtils.markForPersisting(value, this.ec);
                LDAPUtils.unmarkForDeletion(value, this.ec);
                return;
            } else {
                if (relType != RelationType.ONE_TO_MANY_UNI && relType != RelationType.ONE_TO_MANY_BI) throw new NucleusException("Field " + this.mmd.getFullFieldName() + " cannot be persisted because type=" + this.mmd.getTypeName() + " with relation type " + this.mmd.getRelationType(this.clr) + " is not supported for this datastore");
                if (!this.mmd.hasCollection()) return;
                Collection coll = (Collection)value;
                Collection<Object> oldColl = this.getHierarchicalMappedChildren(this.mmd.getCollection().getElementType(), this.mmd.getMappedBy(), this.mmd, this.op);
                AbstractCollection toAdd = null;
                AbstractCollection toRemove = null;
                Class instanceType = this.mmd.getType();
                if (List.class.isAssignableFrom(instanceType)) {
                    toAdd = new ArrayList(coll);
                    toRemove = new ArrayList<Object>(oldColl);
                } else {
                    toAdd = new HashSet(coll);
                    toRemove = new HashSet<Object>(oldColl);
                }
                toAdd.removeAll(oldColl);
                for (Object pc : toAdd) {
                    LDAPUtils.markForPersisting(pc, this.ec);
                    LDAPUtils.unmarkForDeletion(pc, this.ec);
                }
                if (this.mmd.getRelationType(this.clr) == RelationType.ONE_TO_MANY_UNI) {
                    toRemove.removeAll(coll);
                    for (Object pc : toRemove) {
                        ObjectProvider pcSM = this.ec.findObjectProvider(pc, false);
                        if (!this.mustDelete(pcSM)) continue;
                        LDAPUtils.markForDeletion(pc, this.ec);
                    }
                    return;
                } else {
                    if (mappedBy == null) return;
                    toRemove.removeAll(coll);
                    for (Object pc : toRemove) {
                        ObjectProvider pcSM = this.ec.findObjectProvider(pc, false);
                        if (!this.mustDelete(pcSM, mappedBy)) continue;
                        LDAPUtils.markForDeletion(pc, this.ec);
                    }
                }
            }
        }
    }

    private boolean mustDelete(ObjectProvider pcSM) {
        LdapName dn = LDAPUtils.getDistinguishedNameForObject(this.storeMgr, this.op, true);
        LdapName pcDn = LDAPUtils.getDistinguishedNameForObject(this.storeMgr, pcSM, true);
        return pcDn.startsWith(dn);
    }

    private boolean mustDelete(ObjectProvider pcSM, String mappedBy) {
        try {
            Object pc = pcSM.getObject();
            Class<?> clazz = pc.getClass();
            String methodName = ClassUtils.getJavaBeanGetterName((String)mappedBy, (boolean)false);
            Method method = ClassUtils.getMethodForClass(clazz, (String)methodName, null);
            Object fieldPC = method.invoke(pc, new Object[0]);
            Object myPC = this.op.getObject();
            if (fieldPC == null || fieldPC == myPC) {
                return true;
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static boolean isChildOfHierarchicalMapping(AbstractMemberMetaData mmd, MetaDataManager mmgr) {
        AbstractClassMetaData targetCmd;
        AbstractMemberMetaData mappedByMmd;
        String mappedBy = mmd.getMappedBy();
        if (mappedBy != null && (mappedByMmd = (targetCmd = LDAPUtils.getEffectiveClassMetaData(mmd, mmgr)).getMetaDataForMember(mappedBy)) != null) {
            return RelationByHierarchyStrategy.isParentOfHierarchicalMapping(mappedByMmd, mmgr);
        }
        return false;
    }

    public static boolean isParentOfHierarchicalMapping(AbstractMemberMetaData mmd, MetaDataManager mmgr) {
        AbstractClassMetaData cmd = mmd.getAbstractClassMetaData();
        LDAPUtils.LocationInfo locationInfo = LDAPUtils.getLocationInfo(cmd);
        if (locationInfo.parentFieldName != null) {
            return mmd.getName().equals(locationInfo.parentFieldName);
        }
        return false;
    }

    @Override
    public List<String> getAttributeNames() {
        return Collections.EMPTY_LIST;
    }
}

