/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.ldap;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.PersistenceNucleusContext;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.flush.FlushOrdered;
import org.datanucleus.metadata.MetaDataListener;
import org.datanucleus.store.AbstractStoreManager;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.ldap.LDAPMetaDataListener;
import org.datanucleus.store.ldap.LDAPPersistenceHandler;
import org.datanucleus.store.ldap.query.JDOQLQuery;
import org.datanucleus.store.ldap.query.JPQLQuery;
import org.datanucleus.store.query.Query;
import org.datanucleus.util.Localiser;

public class LDAPStoreManager
extends AbstractStoreManager {
    public static final String MAPPING_STRATEGY_EXTENSON = "mapping-strategy";
    MetaDataListener metadataListener = new LDAPMetaDataListener();

    public LDAPStoreManager(ClassLoaderResolver clr, PersistenceNucleusContext ctx, Map<String, Object> props) {
        super("ldap", clr, ctx, props);
        ctx.getMetaDataManager().registerListener(this.metadataListener);
        this.persistenceHandler = new LDAPPersistenceHandler((StoreManager)this);
        this.flushProcess = new FlushOrdered();
        this.logConfiguration();
    }

    public synchronized void close() {
        this.nucleusContext.getMetaDataManager().deregisterListener(this.metadataListener);
        super.close();
    }

    public Collection getSupportedOptions() {
        HashSet<String> set = new HashSet<String>();
        set.add("ApplicationId");
        set.add("TransactionIsolationLevel.read-committed");
        set.add("ORM");
        set.add("ORM.EmbeddedPC");
        set.add("Query.JDOQL.BulkDelete");
        set.add("Query.JPQL.BulkDelete");
        return set;
    }

    public Query newQuery(String language, ExecutionContext ec) {
        if (language.equalsIgnoreCase("JDOQL")) {
            return new JDOQLQuery((StoreManager)this, ec);
        }
        if (language.equalsIgnoreCase("JPQL")) {
            return new JPQLQuery((StoreManager)this, ec);
        }
        throw new NucleusException("Error creating query for language " + language);
    }

    public Query newQuery(String language, ExecutionContext ec, String queryString) {
        if (language.equalsIgnoreCase("JDOQL")) {
            return new JDOQLQuery((StoreManager)this, ec, queryString);
        }
        if (language.equalsIgnoreCase("JPQL")) {
            return new JPQLQuery((StoreManager)this, ec, queryString);
        }
        throw new NucleusException("Error creating query for language " + language);
    }

    public Query newQuery(String language, ExecutionContext ec, Query q) {
        if (language.equalsIgnoreCase("JDOQL")) {
            return new JDOQLQuery((StoreManager)this, ec, (JDOQLQuery)q);
        }
        if (language.equalsIgnoreCase("JPQL")) {
            return new JPQLQuery((StoreManager)this, ec, (JPQLQuery)q);
        }
        throw new NucleusException("Error creating query for language " + language);
    }

    static {
        Localiser.registerBundle((String)"org.datanucleus.store.ldap.Localisation", (ClassLoader)LDAPStoreManager.class.getClassLoader());
    }
}

