/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.ldap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.transaction.xa.XAResource;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.AbstractConnectionFactory;
import org.datanucleus.store.connection.AbstractManagedConnection;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.connection.ManagedConnectionResourceListener;
import org.datanucleus.store.ldap.LDAPUtils;

public class ConnectionFactoryImpl
extends AbstractConnectionFactory {
    Hashtable ldapEnv = new Hashtable();

    public ConnectionFactoryImpl(StoreManager storeMgr, String resourceType) {
        super(storeMgr, resourceType);
        this.ldapEnv.put("java.naming.factory.initial", storeMgr.getConnectionDriverName());
        this.ldapEnv.put("java.naming.provider.url", storeMgr.getConnectionURL());
        this.ldapEnv.put("java.naming.security.principal", storeMgr.getConnectionUserName());
        this.ldapEnv.put("java.naming.security.credentials", storeMgr.getConnectionPassword());
        if ("JNDI".equalsIgnoreCase(storeMgr.getStringProperty("datanucleus.connectionPoolingType"))) {
            int size;
            this.ldapEnv.put("com.sun.jndi.ldap.connect.pool", "true");
            if (storeMgr.hasProperty("datanucleus.connectionPool.maxPoolSize") && (size = storeMgr.getIntProperty("datanucleus.connectionPool.maxPoolSize")) >= 0) {
                System.setProperty("com.sun.jndi.ldap.connect.pool.maxsize", "" + size);
            }
            if (storeMgr.hasProperty("datanucleus.connectionPool.initialPoolSize") && (size = storeMgr.getIntProperty("datanucleus.connectionPool.initialPoolSize")) >= 0) {
                System.setProperty("com.sun.jndi.ldap.connect.pool.initsize", "" + size);
            }
        }
        MetaDataManager mdm = storeMgr.getNucleusContext().getMetaDataManager();
        Collection classesWithMetaData = mdm.getClassesWithMetaData();
        StringBuilder sb = new StringBuilder();
        for (String className : classesWithMetaData) {
            AbstractClassMetaData cmd = mdm.getMetaDataForClass(className, storeMgr.getNucleusContext().getClassLoaderResolver(null));
            List<AbstractMemberMetaData> mmds = LDAPUtils.getAllMemberMetaData(cmd);
            for (AbstractMemberMetaData mmd : mmds) {
                if (mmd.getJoinMetaData() != null || !mmd.getType().isArray()) continue;
                String attributeNameForField = LDAPUtils.getAttributeNameForField(mmd);
                sb.append(attributeNameForField).append(' ');
            }
        }
        if (sb.length() > 0) {
            this.ldapEnv.put("java.naming.ldap.attributes.binary", sb.toString());
        }
    }

    public ManagedConnection createManagedConnection(ExecutionContext ec, Map txnOptionsIgnored) {
        return new ManagedConnectionImpl();
    }

    public class ManagedConnectionImpl
    extends AbstractManagedConnection {
        LdapContext mainContext;
        List<LdapContext> subContexts;

        public Object getConnection() {
            if (this.conn == null) {
                try {
                    this.mainContext = new InitialLdapContext(ConnectionFactoryImpl.this.ldapEnv, null);
                    this.subContexts = new ArrayList<LdapContext>();
                    this.conn = this.mainContext;
                }
                catch (NamingException e) {
                    throw new NucleusException(e.getMessage(), (Throwable)e);
                }
            }
            try {
                LdapContext subContext = this.mainContext.newInstance(null);
                this.subContexts.add(subContext);
                return subContext;
            }
            catch (NamingException e) {
                throw new NucleusException(e.getMessage(), (Throwable)e);
            }
        }

        public void release() {
            if (this.commitOnRelease) {
                try {
                    for (LdapContext subContext : this.subContexts) {
                        subContext.close();
                    }
                    this.mainContext.close();
                    this.subContexts = null;
                    this.mainContext = null;
                    this.conn = null;
                }
                catch (Exception e) {
                    throw new NucleusException(e.getMessage(), (Throwable)e);
                }
            }
            super.release();
        }

        public void close() {
            if (this.mainContext == null) {
                return;
            }
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((ManagedConnectionResourceListener)this.listeners.get(i)).managedConnectionPreClose();
            }
            try {
                try {
                    for (LdapContext subContext : this.subContexts) {
                        subContext.close();
                    }
                    this.mainContext.close();
                }
                catch (Exception e) {
                    throw new NucleusException(e.getMessage(), (Throwable)e);
                }
            }
            finally {
                this.subContexts = null;
                this.mainContext = null;
                this.conn = null;
                for (int i = 0; i < this.listeners.size(); ++i) {
                    ((ManagedConnectionResourceListener)this.listeners.get(i)).managedConnectionPostClose();
                }
            }
        }

        public XAResource getXAResource() {
            return null;
        }
    }
}

