/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.ldap.fieldmanager;

import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.fieldmanager.AbstractFieldManager;
import org.datanucleus.store.ldap.LDAPUtils;
import org.datanucleus.store.ldap.fieldmanager.AbstractMappingStrategy;
import org.datanucleus.store.ldap.fieldmanager.CalendarToGeneralizedTimeStringConverter;
import org.datanucleus.store.ldap.fieldmanager.DateToGeneralizedTimeStringConverter;
import org.datanucleus.store.ldap.fieldmanager.MappingStrategyHelper;
import org.datanucleus.store.ldap.fieldmanager.SimpleContainerHelper;

public class FetchFieldManager
extends AbstractFieldManager {
    ExecutionContext ec;
    ObjectProvider op;
    StoreManager storeMgr;
    Attributes result;

    public FetchFieldManager(StoreManager storeMgr, ObjectProvider op, Attributes result) {
        this.ec = op.getExecutionContext();
        this.op = op;
        this.storeMgr = storeMgr;
        this.result = result;
    }

    public Object fetchObjectField(int fieldNumber) {
        AbstractMappingStrategy ms;
        AbstractMemberMetaData mmd = this.op.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        ClassLoaderResolver clr = this.op.getExecutionContext().getClassLoaderResolver();
        Attribute attr = this.getAttributeForField(fieldNumber);
        RelationType relType = mmd.getRelationType(clr);
        if (relType == RelationType.NONE) {
            if (mmd.hasCollection()) {
                Collection coll = SimpleContainerHelper.fetchCollection(mmd, attr, this.ec.getTypeManager(), clr);
                return this.op.wrapSCOField(fieldNumber, (Object)coll, false, false, true);
            }
            if (mmd.hasArray()) {
                if (attr == null) {
                    return null;
                }
                return SimpleContainerHelper.fetchArray(mmd, attr, this.ec.getTypeManager());
            }
            if (!mmd.hasMap()) {
                if (attr == null) {
                    return null;
                }
                if (Boolean.class.isAssignableFrom(mmd.getType())) {
                    return this.fetchBooleanField(attr);
                }
                if (Byte.class.isAssignableFrom(mmd.getType())) {
                    return this.fetchByteField(attr);
                }
                if (Character.class.isAssignableFrom(mmd.getType())) {
                    return Character.valueOf(this.fetchCharField(attr));
                }
                if (Double.class.isAssignableFrom(mmd.getType())) {
                    return this.fetchDoubleField(attr);
                }
                if (Float.class.isAssignableFrom(mmd.getType())) {
                    return Float.valueOf(this.fetchFloatField(attr));
                }
                if (Integer.class.isAssignableFrom(mmd.getType())) {
                    return this.fetchIntField(attr);
                }
                if (Long.class.isAssignableFrom(mmd.getType())) {
                    return this.fetchLongField(attr);
                }
                if (Short.class.isAssignableFrom(mmd.getType())) {
                    return this.fetchShortField(attr);
                }
                if (mmd.getType().isEnum()) {
                    boolean useNumeric;
                    ColumnMetaData colmd = null;
                    if (mmd != null && mmd.getColumnMetaData() != null && mmd.getColumnMetaData().length > 0) {
                        colmd = mmd.getColumnMetaData()[0];
                    }
                    if (useNumeric = MetaDataUtils.persistColumnAsNumeric(colmd)) {
                        return mmd.getType().getEnumConstants()[this.fetchIntField(attr)];
                    }
                    return Enum.valueOf(mmd.getType(), this.fetchStringField(attr));
                }
                Object converter = null;
                converter = Date.class.isAssignableFrom(mmd.getType()) ? new DateToGeneralizedTimeStringConverter() : (Calendar.class.isAssignableFrom(mmd.getType()) ? new CalendarToGeneralizedTimeStringConverter() : this.ec.getTypeManager().getTypeConverterForType(mmd.getType(), String.class));
                if (converter != null) {
                    return converter.toMemberType(this.fetchStringField(attr));
                }
                throw new NucleusException("Cant obtain value for field " + mmd.getFullFieldName() + " since type=" + mmd.getTypeName() + " is not supported for this datastore");
            }
        }
        if ((ms = MappingStrategyHelper.findMappingStrategy(this.storeMgr, this.op, mmd, this.result)) != null) {
            return ms.fetch();
        }
        throw new NucleusException("Cant obtain value for field " + mmd.getFullFieldName() + " since type=" + mmd.getTypeName() + " is not supported for this datastore");
    }

    protected Attribute getAttributeForField(int fieldNumber) {
        AbstractMemberMetaData mmd = this.op.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        String name = LDAPUtils.getAttributeNameForField(mmd);
        return this.result.get(name);
    }

    public boolean fetchBooleanField(int fieldNumber) {
        Attribute attr = this.getAttributeForField(fieldNumber);
        return this.fetchBooleanField(attr);
    }

    public byte fetchByteField(int fieldNumber) {
        Attribute attr = this.getAttributeForField(fieldNumber);
        return this.fetchByteField(attr);
    }

    public char fetchCharField(int fieldNumber) {
        Attribute attr = this.getAttributeForField(fieldNumber);
        return this.fetchCharField(attr);
    }

    public double fetchDoubleField(int fieldNumber) {
        Attribute attr = this.getAttributeForField(fieldNumber);
        return this.fetchDoubleField(attr);
    }

    public float fetchFloatField(int fieldNumber) {
        Attribute attr = this.getAttributeForField(fieldNumber);
        return this.fetchFloatField(attr);
    }

    public int fetchIntField(int fieldNumber) {
        Attribute attr = this.getAttributeForField(fieldNumber);
        return this.fetchIntField(attr);
    }

    public long fetchLongField(int fieldNumber) {
        Attribute attr = this.getAttributeForField(fieldNumber);
        return this.fetchLongField(attr);
    }

    public short fetchShortField(int fieldNumber) {
        Attribute attr = this.getAttributeForField(fieldNumber);
        return this.fetchShortField(attr);
    }

    public String fetchStringField(int fieldNumber) {
        Attribute attr = this.getAttributeForField(fieldNumber);
        return this.fetchStringField(attr);
    }

    protected boolean fetchBooleanField(Attribute attr) {
        if (attr == null) {
            return false;
        }
        try {
            return Boolean.valueOf(attr.get(0).toString());
        }
        catch (NamingException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
    }

    protected byte fetchByteField(Attribute attr) {
        if (attr == null) {
            return 0;
        }
        try {
            return Byte.valueOf(attr.get(0).toString());
        }
        catch (NamingException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
    }

    protected char fetchCharField(Attribute attr) {
        if (attr == null) {
            return ' ';
        }
        try {
            return attr.get(0).toString().charAt(0);
        }
        catch (NamingException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
    }

    protected double fetchDoubleField(Attribute attr) {
        if (attr == null) {
            return 0.0;
        }
        try {
            return Double.valueOf(attr.get(0).toString());
        }
        catch (NamingException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
    }

    protected float fetchFloatField(Attribute attr) {
        if (attr == null) {
            return 0.0f;
        }
        try {
            return Float.valueOf(attr.get(0).toString()).floatValue();
        }
        catch (NamingException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
    }

    protected int fetchIntField(Attribute attr) {
        if (attr == null) {
            return 0;
        }
        try {
            return Integer.valueOf(attr.get(0).toString());
        }
        catch (NamingException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
    }

    protected long fetchLongField(Attribute attr) {
        if (attr == null) {
            return 0L;
        }
        try {
            return Long.valueOf(attr.get(0).toString());
        }
        catch (NamingException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
    }

    protected short fetchShortField(Attribute attr) {
        if (attr == null) {
            return 0;
        }
        try {
            return Short.valueOf(attr.get(0).toString());
        }
        catch (NamingException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
    }

    protected String fetchStringField(Attribute attr) {
        if (attr == null) {
            return null;
        }
        try {
            if (attr.get(0) instanceof byte[]) {
                return new String((byte[])attr.get(0), "UTF-8");
            }
            return (String)attr.get(0);
        }
        catch (NamingException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
    }
}

