/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.ldap.fieldmanager;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.ldap.fieldmanager.GeneralizedTime;
import org.datanucleus.store.types.converters.TypeConverter;

public class DateToGeneralizedTimeStringConverter
implements TypeConverter<Date, String> {
    private static final long serialVersionUID = 8064287866213991924L;

    public Date toMemberType(String str) {
        if (str == null) {
            return null;
        }
        Calendar cal = null;
        try {
            GeneralizedTime gt = new GeneralizedTime(str);
            cal = gt.getCalendar();
            cal.set(14, 0);
        }
        catch (ParseException e) {
            throw new NucleusException("Error parsing string to calendar.", (Throwable)e);
        }
        cal.setTimeZone(TimeZone.getTimeZone("GMT"));
        Date date = cal.getTime();
        return date;
    }

    public String toDatastoreType(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
        calendar.setTime(date);
        calendar.set(14, 0);
        GeneralizedTime gt = new GeneralizedTime(calendar);
        return gt.toGeneralizedTime();
    }
}

