/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.ldap.fieldmanager;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import javax.naming.directory.Attributes;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.JoinMetaData;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.store.ldap.fieldmanager.CalendarToGeneralizedTimeStringConverter;
import org.datanucleus.store.ldap.fieldmanager.DateToGeneralizedTimeStringConverter;
import org.datanucleus.store.ldap.fieldmanager.SimpleArrayMappingStrategy;
import org.datanucleus.store.types.sco.SCOUtils;

public class SimpleCollectionMappingStrategy
extends SimpleArrayMappingStrategy {
    public SimpleCollectionMappingStrategy(ObjectProvider sm, AbstractMemberMetaData mmd, Attributes attributes) {
        super(sm, mmd, attributes);
        this.type = sm.getExecutionContext().getClassLoaderResolver().classForName(mmd.getCollection().getElementType());
        if (mmd.getJoinMetaData() == null) {
            mmd.setJoinMetaData(new JoinMetaData());
        }
    }

    public Object fetch() {
        Collection collection;
        Class instanceType = this.mmd.getType();
        instanceType = SCOUtils.getContainerInstanceType((Class)instanceType, (Boolean)(this.mmd.getOrderMetaData() != null ? 1 : 0));
        try {
            collection = (Collection)instanceType.newInstance();
        }
        catch (InstantiationException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
        Object[] values = null;
        if (this.attr == null) {
            values = new Object[]{};
        } else if (String.class.isAssignableFrom(this.type)) {
            values = this.fetchStringArrayField();
        } else if (Boolean.class.isAssignableFrom(this.type)) {
            values = this.fetchBooleanObjectArrayField();
        } else if (Byte.class.isAssignableFrom(this.type)) {
            values = this.fetchByteObjectArrayField();
        } else if (Character.class.isAssignableFrom(this.type)) {
            values = this.fetchCharacterObjectArrayField();
        } else if (Double.class.isAssignableFrom(this.type)) {
            values = this.fetchDoubleObjectArrayField();
        } else if (Float.class.isAssignableFrom(this.type)) {
            values = this.fetchFloatObjectArrayField();
        } else if (Integer.class.isAssignableFrom(this.type)) {
            values = this.fetchIntegerObjectArrayField();
        } else if (Long.class.isAssignableFrom(this.type)) {
            values = this.fetchLongObjectArrayField();
        } else if (Short.class.isAssignableFrom(this.type)) {
            values = this.fetchShortObjectArrayField();
        } else {
            Object converter = null;
            converter = Date.class.isAssignableFrom(this.type) ? new DateToGeneralizedTimeStringConverter() : (Calendar.class.isAssignableFrom(this.type) ? new CalendarToGeneralizedTimeStringConverter() : this.sm.getExecutionContext().getTypeManager().getTypeConverterForType(this.type, String.class));
            if (converter != null) {
                String[] stringValues = this.fetchStringArrayField();
                values = (Object[])Array.newInstance(this.type, stringValues.length);
                for (int i = 0; i < stringValues.length; ++i) {
                    values[i] = converter.toMemberType(stringValues[i]);
                }
            } else if (this.type.isEnum()) {
                values = this.fetchEnumArrayField(this.type);
            }
        }
        if (values != null) {
            collection.addAll(Arrays.asList(values));
            int fieldNumber = this.sm.isEmbedded() ? this.sm.getClassMetaData().getAbsolutePositionOfMember(this.mmd.getName()) : this.mmd.getAbsoluteFieldNumber();
            this.sm.setAssociatedValue((Object)("COLL" + fieldNumber), (Object)collection);
            return this.sm.wrapSCOField(fieldNumber, (Object)collection, false, false, true);
        }
        throw new NucleusException("Cant obtain value for field " + this.mmd.getFullFieldName() + " since type=" + this.mmd.getTypeName() + " is not supported for this datastore");
    }

    public void insert(Object value) {
        if (value == null) {
            return;
        }
        Collection valueCollection = (Collection)value;
        if (valueCollection.isEmpty()) {
            return;
        }
        this.store(value);
    }

    public void update(Object value) {
        if (value == null) {
            return;
        }
        this.store(value);
    }

    protected void store(Object value) {
        Collection valueCollection = (Collection)value;
        Object[] values = valueCollection.toArray();
        if (String.class.isAssignableFrom(this.type)) {
            this.storeObjectArrayField(values);
        } else if (Boolean.class.isAssignableFrom(this.type)) {
            this.storeBooleanObjectArrayField(valueCollection.toArray(new Boolean[0]));
        } else if (Byte.class.isAssignableFrom(this.type)) {
            this.storeByteObjectArrayField(valueCollection.toArray(new Byte[0]));
        } else if (Character.class.isAssignableFrom(this.type)) {
            this.storeCharacterObjectArrayField(valueCollection.toArray(new Character[0]));
        } else if (Double.class.isAssignableFrom(this.type)) {
            this.storeDoubleObjectArrayField(valueCollection.toArray(new Double[0]));
        } else if (Float.class.isAssignableFrom(this.type)) {
            this.storeFloatObjectArrayField(valueCollection.toArray(new Float[0]));
        } else if (Integer.class.isAssignableFrom(this.type)) {
            this.storeIntegerObjectArrayField(valueCollection.toArray(new Integer[0]));
        } else if (Long.class.isAssignableFrom(this.type)) {
            this.storeLongObjectArrayField(valueCollection.toArray(new Long[0]));
        } else if (Short.class.isAssignableFrom(this.type)) {
            this.storeShortObjectArrayField(valueCollection.toArray(new Short[0]));
        } else {
            Object converter = null;
            converter = Date.class.isAssignableFrom(this.type) ? new DateToGeneralizedTimeStringConverter() : (Calendar.class.isAssignableFrom(this.type) ? new CalendarToGeneralizedTimeStringConverter() : this.sm.getExecutionContext().getTypeManager().getTypeConverterForType(this.type, String.class));
            if (converter != null) {
                Object[] stringValues = new String[values.length];
                for (int i = 0; i < values.length; ++i) {
                    stringValues[i] = (String)converter.toDatastoreType(values[i]);
                }
                this.storeObjectArrayField(stringValues);
            } else if (this.type.isEnum()) {
                this.storeObjectArrayField(values);
            } else {
                throw new NucleusException("Field " + this.mmd.getFullFieldName() + " cannot be persisted because type=" + this.mmd.getTypeName() + " is not supported for this datastore");
            }
        }
    }
}

