/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.ldap.fieldmanager;

import java.text.ParseException;
import java.util.Calendar;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.ldap.fieldmanager.GeneralizedTime;
import org.datanucleus.store.types.ObjectStringConverter;

public class CalendarToGeneralizedTimeStringConverter
implements ObjectStringConverter {
    public Object toObject(String str) {
        if (str == null) {
            return null;
        }
        try {
            GeneralizedTime gt = new GeneralizedTime(str);
            Calendar calendar = gt.getCalendar();
            calendar.set(14, 0);
            return calendar;
        }
        catch (ParseException e) {
            throw new NucleusException("Error parsing string to calendar.", (Throwable)e);
        }
    }

    public String toString(Object obj) {
        String str;
        if (obj instanceof Calendar) {
            Calendar calendar = (Calendar)obj;
            calendar.set(14, 0);
            GeneralizedTime gt = new GeneralizedTime(calendar);
            str = gt.toGeneralizedTime();
        } else {
            str = (String)obj;
        }
        return str;
    }
}

