/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.ldap.fieldmanager;

import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.JoinMetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.store.ldap.LDAPUtils;

public class RelationByAttributeMetaData {
    private AbstractMemberMetaData mmd;
    private AbstractMemberMetaData otherMmd;
    private JoinMetaData joinMetaData;
    private String emptyValue;
    private boolean hasColumn;

    public RelationByAttributeMetaData(AbstractMemberMetaData mmd, MetaDataManager mmgr) {
        this.mmd = mmd;
        AbstractClassMetaData otherClassMetaData = LDAPUtils.getEffectiveClassMetaData(mmd, mmgr);
        boolean bl = this.hasColumn = mmd.getColumnMetaData() != null && mmd.getColumnMetaData().length > 0;
        if (mmd.getMappedBy() != null) {
            this.otherMmd = otherClassMetaData.getMetaDataForMember(mmd.getMappedBy());
        } else if (mmd.getElementMetaData() != null && !this.hasColumn) {
            this.otherMmd = null;
        } else if (mmd.getJoinMetaData() != null) {
            String otherAttributeName = mmd.getJoinMetaData().getColumnName();
            this.otherMmd = LDAPUtils.getMemberMetadataForAttributeName(otherClassMetaData, otherAttributeName);
        }
        this.joinMetaData = mmd.getMappedBy() != null ? this.otherMmd.getJoinMetaData() : mmd.getJoinMetaData();
        this.emptyValue = mmd.getMappedBy() != null ? LDAPUtils.getEmptyValue(this.otherMmd) : LDAPUtils.getEmptyValue(mmd);
    }

    public AbstractMemberMetaData getOwnerMMD() {
        if (this.mmd.getMappedBy() != null) {
            return this.otherMmd;
        }
        if (this.mmd.getElementMetaData() != null && !this.hasColumn) {
            return null;
        }
        return this.mmd;
    }

    public String getJoinAttributeName() {
        return this.joinMetaData.getColumnName();
    }

    public String getEmptyValue() {
        return this.emptyValue;
    }

    public String getOwnerAttributeName() {
        if (this.mmd.getMappedBy() != null) {
            return LDAPUtils.getAttributeNameForField(this.otherMmd);
        }
        if (this.mmd.getElementMetaData() != null && !this.hasColumn) {
            return this.mmd.getElementMetaData().getColumnName();
        }
        return LDAPUtils.getAttributeNameForField(this.mmd);
    }

    public AbstractMemberMetaData getNonOwnerMMD() {
        if (this.mmd.getMappedBy() != null) {
            return this.mmd;
        }
        if (this.mmd.getElementMetaData() != null && !this.hasColumn) {
            return this.mmd;
        }
        return this.otherMmd;
    }

    public static boolean isRelationByAttribute(AbstractMemberMetaData mmd, MetaDataManager mmgr) {
        return new RelationByAttributeMetaData((AbstractMemberMetaData)mmd, (MetaDataManager)mmgr).joinMetaData != null;
    }
}

