/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.ldap;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.naming.ContextNotEmptyException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapName;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ElementMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.state.AbstractStateManager;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.StorePersistenceHandler;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.fieldmanager.DeleteFieldManager;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.ldap.LDAPStoreManager;
import org.datanucleus.store.ldap.LDAPUtils;
import org.datanucleus.store.ldap.fieldmanager.AbstractMappingStrategy;
import org.datanucleus.store.ldap.fieldmanager.FetchFieldManager;
import org.datanucleus.store.ldap.fieldmanager.InsertFieldManager;
import org.datanucleus.store.ldap.fieldmanager.RelationByAttributeMetaData;
import org.datanucleus.store.ldap.fieldmanager.RelationByDnMetaData;
import org.datanucleus.store.ldap.fieldmanager.UpdateFieldManager;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class LDAPPersistenceHandler
implements StorePersistenceHandler {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.store.ldap.Localisation", (ClassLoader)LDAPStoreManager.class.getClassLoader());
    protected final LDAPStoreManager storeMgr;

    public LDAPPersistenceHandler(StoreManager storeMgr) {
        this.storeMgr = (LDAPStoreManager)storeMgr;
    }

    public void close() {
    }

    public void insertObject(StateManager sm) {
        this.storeMgr.assertReadOnlyForUpdateOfObject(sm);
        AbstractClassMetaData cmd = sm.getClassMetaData();
        if (LDAPUtils.isHierarchicalMappedAtChild(sm)) {
            LDAPUtils.LocationInfo locationInfo = LDAPUtils.getLocationInfo(cmd);
            AbstractMemberMetaData parentFieldMmd = cmd.getMetaDataForMember(locationInfo.parentFieldName);
            Object parentFieldValue = sm.provideField(parentFieldMmd.getAbsoluteFieldNumber());
            if (parentFieldValue != null) {
                LDAPUtils.getStateManagerForObject(parentFieldValue, sm.getObjectManager(), true);
            } else if (locationInfo.dn == null) {
                throw new NucleusUserException(LOCALISER.msg("LDAP.Insert.MissingParentReference", (Object)StringUtils.toJVMIDString((Object)sm.getObject()), sm.getInternalObjectId()));
            }
        }
        if (cmd.getIdentityType() != IdentityType.APPLICATION && cmd.getIdentityType() == IdentityType.DATASTORE) {
            throw new NucleusUserException(LOCALISER.msg("LDAP.DatastoreID"));
        }
        Set<String> objectClasses = LDAPUtils.getObjectClassesForClass(sm.getClassMetaData());
        if (objectClasses == null) {
            throw new NucleusDataStoreException("Missing 'objectClass' extension or 'schema' attribute for class " + cmd.getName());
        }
        ManagedConnection mconn = this.storeMgr.getConnection(sm.getObjectManager());
        try {
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("LDAP.Insert.Start", (Object)StringUtils.toJVMIDString((Object)sm.getObject()), sm.getInternalObjectId()));
            }
            DirContext ctx = (DirContext)mconn.getConnection();
            BasicAttributes attrs = new BasicAttributes();
            List<AbstractMemberMetaData> nonEmbeddedMmds = LDAPUtils.getAllMemberMetaData(cmd);
            ArrayList<AbstractMemberMetaData> embeddedMmds = new ArrayList<AbstractMemberMetaData>();
            Iterator<AbstractMemberMetaData> it = nonEmbeddedMmds.iterator();
            while (it.hasNext()) {
                AbstractMemberMetaData mmd = it.next();
                if (!LDAPUtils.isEmbeddedField(mmd)) continue;
                embeddedMmds.add(mmd);
                it.remove();
            }
            int[] nonEmbeddedFieldNumbers = new int[nonEmbeddedMmds.size()];
            for (int i = 0; i < nonEmbeddedFieldNumbers.length; ++i) {
                nonEmbeddedFieldNumbers[i] = nonEmbeddedMmds.get(i).getAbsoluteFieldNumber();
            }
            int[] embeddedFieldNumbers = new int[embeddedMmds.size()];
            for (int i = 0; i < embeddedFieldNumbers.length; ++i) {
                embeddedFieldNumbers[i] = ((AbstractMemberMetaData)embeddedMmds.get(i)).getAbsoluteFieldNumber();
            }
            sm.provideFields(nonEmbeddedFieldNumbers, (FieldManager)new InsertFieldManager(sm, attrs));
            LdapName dn = LDAPUtils.getDistinguishedNameForObject(sm, false);
            BasicAttribute objectClass = new BasicAttribute("objectClass");
            for (String oc : objectClasses) {
                objectClass.add(oc);
            }
            attrs.put(objectClass);
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("LDAP.JNDI.createSubcontext", (Object)dn, (Object)attrs));
            }
            ctx.bind(dn, null, (Attributes)attrs);
            attrs = new BasicAttributes();
            sm.provideFields(embeddedFieldNumbers, (FieldManager)new InsertFieldManager(sm, attrs));
            if (attrs.size() > 0) {
                if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                    NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("LDAP.JNDI.modifyAttributes", (Object)dn, (Object)"REPLACE", (Object)attrs));
                }
                ctx.modifyAttributes(dn, 2, (Attributes)attrs);
            }
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("LDAP.ExecutionTime", System.currentTimeMillis() - startTime));
            }
            if (this.storeMgr.getRuntimeManager() != null) {
                this.storeMgr.getRuntimeManager().incrementInsertCount();
            }
            if (NucleusLogger.DATASTORE.isDebugEnabled()) {
                NucleusLogger.DATASTORE.debug((Object)LOCALISER.msg("LDAP.Insert.ObjectPersisted", (Object)StringUtils.toJVMIDString((Object)sm.getObject()), sm.getInternalObjectId()));
            }
        }
        catch (NameAlreadyBoundException e) {
            throw new NucleusUserException(LOCALISER.msg("LDAP.Insert.ObjectWithIdAlreadyExists", (Object)StringUtils.toJVMIDString((Object)sm.getObject()), sm.getInternalObjectId()), (Throwable)e);
        }
        catch (NamingException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
        finally {
            mconn.release();
        }
    }

    public void updateObject(StateManager sm, int[] fieldNumbers) {
        this.storeMgr.assertReadOnlyForUpdateOfObject(sm);
        ManagedConnection mconn = this.storeMgr.getConnection(sm.getObjectManager());
        try {
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                AbstractClassMetaData cmd = sm.getClassMetaData();
                StringBuffer fieldStr = new StringBuffer();
                for (int i = 0; i < fieldNumbers.length; ++i) {
                    if (i > 0) {
                        fieldStr.append(",");
                    }
                    fieldStr.append(cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]).getName());
                }
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("LDAP.Update.Start", (Object)StringUtils.toJVMIDString((Object)sm.getObject()), sm.getInternalObjectId(), (Object)fieldStr.toString()));
            }
            DirContext ctx = (DirContext)mconn.getConnection();
            AbstractClassMetaData cmd = sm.getClassMetaData();
            if (LDAPUtils.isHierarchicalMappedAtChild(sm)) {
                LDAPUtils.LocationInfo locationInfo = LDAPUtils.getLocationInfo(cmd);
                AbstractMemberMetaData parentFieldMmd = cmd.getMetaDataForMember(locationInfo.parentFieldName);
                int absoluteFieldNumber = parentFieldMmd.getAbsoluteFieldNumber();
                for (int i : fieldNumbers) {
                    if (i != absoluteFieldNumber) continue;
                    LdapName oldDn = LDAPUtils.getDistinguishedNameForObject(sm, true);
                    sm.setAssociatedValue((Object)"dn", null);
                    LdapName newDn = null;
                    Object parentFieldValue = sm.provideField(absoluteFieldNumber);
                    if (parentFieldValue != null) {
                        newDn = LDAPUtils.getDistinguishedNameForObject(sm, false);
                    } else if (locationInfo.dn != null) {
                        newDn = LDAPUtils.getDistinguishedNameForObject(sm, false);
                    }
                    if (newDn == null || oldDn.equals(newDn)) break;
                    LDAPUtils.markForRename(sm.getObject(), sm.getObjectManager(), oldDn, newDn);
                    LDAPUtils.unmarkForDeletion(sm.getObject(), sm.getObjectManager());
                    break;
                }
            }
            BasicAttributes attrs = new BasicAttributes();
            sm.provideFields(fieldNumbers, (FieldManager)new UpdateFieldManager(sm, attrs));
            LdapName dn = LDAPUtils.getDistinguishedNameForObject(sm, true);
            if (attrs.size() > 0) {
                if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                    NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("LDAP.JNDI.modifyAttributes", (Object)dn, (Object)"REPLACE", (Object)attrs));
                }
                ctx.modifyAttributes(dn, 2, (Attributes)attrs);
            }
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("LDAP.ExecutionTime", System.currentTimeMillis() - startTime));
            }
            if (this.storeMgr.getRuntimeManager() != null) {
                this.storeMgr.getRuntimeManager().incrementUpdateCount();
            }
        }
        catch (NamingException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
        finally {
            mconn.release();
        }
    }

    public void deleteObject(StateManager sm) {
        this.storeMgr.assertReadOnlyForUpdateOfObject(sm);
        sm.loadUnloadedFields();
        sm.provideFields(sm.getClassMetaData().getAllMemberPositions(), (FieldManager)new DeleteFieldManager(sm));
        this.deleteDnReferences(sm);
        this.deleteAttributeReferences(sm);
        ManagedConnection mconn = this.storeMgr.getConnection(sm.getObjectManager());
        DirContext ctx = (DirContext)mconn.getConnection();
        long startTime = System.currentTimeMillis();
        try {
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("LDAP.Delete.Start", (Object)StringUtils.toJVMIDString((Object)sm.getObject()), sm.getInternalObjectId()));
            }
            LdapName dn = LDAPUtils.getDistinguishedNameForObject(sm, true);
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("LDAP.JNDI.destroySubcontext", (Object)dn));
            }
            ctx.unbind(dn);
            if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("LDAP.ExecutionTime", System.currentTimeMillis() - startTime));
            }
            if (this.storeMgr.getRuntimeManager() != null) {
                this.storeMgr.getRuntimeManager().incrementDeleteCount();
            }
        }
        catch (ContextNotEmptyException cnee) {
            try {
                if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                    NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("LDAP.DeleteRecursive.Start", (Object)StringUtils.toJVMIDString((Object)sm.getObject()), sm.getInternalObjectId()));
                }
                LDAPUtils.deleteRecursive(LDAPUtils.getDistinguishedNameForObject(sm, true), ctx);
                if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                    NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("LDAP.ExecutionTime", System.currentTimeMillis() - startTime));
                }
            }
            catch (NamingException e) {
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
        }
        catch (NamingException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
        finally {
            mconn.release();
        }
    }

    private void deleteDnReferences(StateManager sm) {
        int[] fieldNumbers;
        for (int fieldNumber : fieldNumbers = sm.getClassMetaData().getAllMemberPositions()) {
            ElementMetaData elementMetaData;
            AbstractMemberMetaData mmd = sm.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
            if (!RelationByDnMetaData.isRelationByDn(mmd, sm.getMetaDataManager()) || (elementMetaData = mmd.getElementMetaData()) == null) continue;
            AbstractClassMetaData otherCmd = LDAPUtils.getEffectiveClassMetaData(mmd, sm.getMetaDataManager());
            Class c = sm.getObjectManager().getClassLoaderResolver().classForName(otherCmd.getFullClassName());
            if (c.isInterface() || Modifier.isAbstract(c.getModifiers())) continue;
            String name = elementMetaData.getColumnName() != null ? elementMetaData.getColumnName() : elementMetaData.getColumnMetaData()[0].getName();
            String emptyValue = LDAPUtils.getEmptyValue(mmd);
            this.deleteDnReference(otherCmd, name, sm, emptyValue);
        }
        ClassLoaderResolver clr = sm.getObjectManager().getClassLoaderResolver();
        MetaDataManager mdm = sm.getMetaDataManager();
        Collection classesWithMetaData = mdm.getClassesWithMetaData();
        for (String className : classesWithMetaData) {
            Class c;
            AbstractClassMetaData otherCmd = mdm.getMetaDataForClass(className, clr);
            if (otherCmd.isEmbeddedOnly() || (c = sm.getObjectManager().getClassLoaderResolver().classForName(className)).isInterface() || Modifier.isAbstract(c.getModifiers())) continue;
            for (int fieldNumber : fieldNumbers = otherCmd.getAllMemberPositions()) {
                String[] subclassNames;
                AbstractMemberMetaData mmd = otherCmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
                if (!RelationByDnMetaData.isRelationByDn(mmd, sm.getMetaDataManager())) continue;
                AbstractClassMetaData effectiveCmd = LDAPUtils.getEffectiveClassMetaData(mmd, sm.getMetaDataManager());
                String[] stringArray = subclassNames = effectiveCmd != null ? sm.getMetaDataManager().getSubclassesForClass(effectiveCmd.getFullClassName(), true) : null;
                if (effectiveCmd != sm.getClassMetaData() && (subclassNames == null || !Arrays.asList(subclassNames).contains(sm.getClassMetaData().getFullClassName()))) continue;
                String name = LDAPUtils.getAttributeNameForField(mmd);
                String emptyValue = LDAPUtils.getEmptyValue(mmd);
                this.deleteDnReference(otherCmd, name, sm, emptyValue);
            }
        }
    }

    private void deleteDnReference(AbstractClassMetaData cmd, String name, StateManager sm, Object emptyValue) {
        LdapName dn = LDAPUtils.getDistinguishedNameForObject(sm, true);
        ObjectManager om = sm.getObjectManager();
        ManagedConnection mconn = om.getStoreManager().getConnection(om);
        try {
            LdapName base = LDAPUtils.getSearchBase(cmd, sm.getMetaDataManager());
            String ocFilter = LDAPUtils.getSearchFilter(cmd);
            String dnFilter = "(" + name + "=" + dn.toString() + ")";
            String filter = ocFilter != null ? "(&" + ocFilter + dnFilter + ")" : dnFilter;
            SearchControls searchControls = LDAPUtils.getSearchControls(cmd);
            searchControls.setReturningAttributes(new String[]{name});
            DirContext ctx = (DirContext)mconn.getConnection();
            NamingEnumeration<SearchResult> enumeration = ctx.search((Name)base, filter, searchControls);
            while (enumeration.hasMoreElements()) {
                boolean removed;
                SearchResult sr = (SearchResult)enumeration.nextElement();
                String srName = sr.getNameInNamespace();
                Attributes attrs = sr.getAttributes();
                Attribute attr = sr.getAttributes().get(name);
                if (attr == null || !(removed = attr.remove(dn.toString()))) continue;
                if (attr.size() == 0 && emptyValue != null) {
                    attr.add(emptyValue);
                }
                if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                    NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("LDAP.JNDI.DeleteDnReference", (Object)srName, (Object)dn));
                    NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("LDAP.JNDI.modifyAttributes", (Object)srName, (Object)"REPLACE", (Object)attrs));
                }
                ctx.modifyAttributes(srName, 2, attrs);
            }
        }
        catch (NamingException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
        finally {
            mconn.release();
        }
    }

    private void deleteAttributeReferences(StateManager sm) {
        int[] fieldNumbers;
        for (int fieldNumber : fieldNumbers = sm.getClassMetaData().getAllMemberPositions()) {
            RelationByAttributeMetaData mappingMetaData;
            ElementMetaData elementMetaData;
            AbstractMemberMetaData mmd = sm.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
            if (!RelationByAttributeMetaData.isRelationByAttribute(mmd, sm.getMetaDataManager()) || (elementMetaData = mmd.getElementMetaData()) == null || (mappingMetaData = new RelationByAttributeMetaData(mmd, sm.getMetaDataManager())).getNonOwnerMMD() != mmd) continue;
            String ownerAttributeName = mappingMetaData.getOwnerAttributeName();
            String joinAttributeName = mappingMetaData.getJoinAttributeName();
            Object joinAttributeValue = LDAPUtils.getAttributeValue(sm, joinAttributeName);
            String emptyValue = LDAPUtils.getEmptyValue(mmd);
            AbstractClassMetaData otherCmd = LDAPUtils.getEffectiveClassMetaData(mmd, sm.getMetaDataManager());
            this.deleteAttributeReference(otherCmd, ownerAttributeName, joinAttributeValue, sm, emptyValue);
        }
        ClassLoaderResolver clr = sm.getObjectManager().getClassLoaderResolver();
        MetaDataManager mdm = sm.getMetaDataManager();
        Collection classesWithMetaData = mdm.getClassesWithMetaData();
        for (String className : classesWithMetaData) {
            Class c;
            AbstractClassMetaData otherCmd = mdm.getMetaDataForClass(className, clr);
            if (otherCmd.isEmbeddedOnly() || (c = sm.getObjectManager().getClassLoaderResolver().classForName(className)).isInterface() || Modifier.isAbstract(c.getModifiers())) continue;
            for (int fieldNumber : fieldNumbers = otherCmd.getAllMemberPositions()) {
                RelationByAttributeMetaData mappingMetaData;
                String[] subclassNames;
                AbstractMemberMetaData mmd = otherCmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
                if (!RelationByAttributeMetaData.isRelationByAttribute(mmd, sm.getMetaDataManager())) continue;
                AbstractClassMetaData effectiveCmd = LDAPUtils.getEffectiveClassMetaData(mmd, sm.getMetaDataManager());
                String[] stringArray = subclassNames = effectiveCmd != null ? sm.getMetaDataManager().getSubclassesForClass(effectiveCmd.getFullClassName(), true) : null;
                if (effectiveCmd != sm.getClassMetaData() && (subclassNames == null || !Arrays.asList(subclassNames).contains(sm.getClassMetaData().getFullClassName())) || (mappingMetaData = new RelationByAttributeMetaData(mmd, sm.getMetaDataManager())).getOwnerMMD() != mmd) continue;
                String ownerAttributeName = mappingMetaData.getOwnerAttributeName();
                String joinAttributeName = mappingMetaData.getJoinAttributeName();
                Object joinAttributeValue = LDAPUtils.getAttributeValue(sm, joinAttributeName);
                String emptyValue = LDAPUtils.getEmptyValue(mmd);
                this.deleteAttributeReference(otherCmd, ownerAttributeName, joinAttributeValue, sm, emptyValue);
            }
        }
    }

    private void deleteAttributeReference(AbstractClassMetaData cmd, String attributeName, Object attributeValue, StateManager sm, Object emptyValue) {
        ObjectManager om = sm.getObjectManager();
        ManagedConnection mconn = om.getStoreManager().getConnection(om);
        try {
            LdapName base = LDAPUtils.getSearchBase(cmd, sm.getMetaDataManager());
            String ocFilter = LDAPUtils.getSearchFilter(cmd);
            String dnFilter = "(" + attributeName + "=" + attributeValue + ")";
            String filter = ocFilter != null ? "(&" + ocFilter + dnFilter + ")" : dnFilter;
            SearchControls searchControls = LDAPUtils.getSearchControls(cmd);
            searchControls.setReturningAttributes(new String[]{attributeName});
            DirContext ctx = (DirContext)mconn.getConnection();
            NamingEnumeration<SearchResult> enumeration = ctx.search((Name)base, filter, searchControls);
            while (enumeration.hasMoreElements()) {
                boolean removed;
                SearchResult sr = (SearchResult)enumeration.nextElement();
                String srName = sr.getNameInNamespace();
                Attributes attrs = sr.getAttributes();
                Attribute attr = sr.getAttributes().get(attributeName);
                if (attr == null || !(removed = attr.remove(attributeValue))) continue;
                if (attr.size() == 0 && emptyValue != null) {
                    attr.add(emptyValue);
                }
                if (NucleusLogger.DATASTORE_PERSIST.isDebugEnabled()) {
                    NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("LDAP.JNDI.DeleteAttributeReference", (Object)attributeName, attributeValue, (Object)srName));
                    NucleusLogger.DATASTORE_PERSIST.debug((Object)LOCALISER.msg("LDAP.JNDI.modifyAttributes", (Object)srName, (Object)"REPLACE", (Object)attrs));
                }
                ctx.modifyAttributes(srName, 2, attrs);
            }
        }
        catch (NamingException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
        finally {
            mconn.release();
        }
    }

    public void fetchObject(StateManager sm, int[] fieldNumbers) {
        int i;
        if (((AbstractStateManager)sm).getLifecycleState().isDeleted()) {
            return;
        }
        AbstractClassMetaData cmd = sm.getClassMetaData();
        if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
            StringBuffer str = new StringBuffer("Fetching object \"");
            str.append(StringUtils.toJVMIDString((Object)sm.getObject())).append("\" (id=");
            str.append(sm.getObjectManager().getApiAdapter().getObjectId(sm)).append(")").append(" fields [");
            for (i = 0; i < fieldNumbers.length; ++i) {
                if (i > 0) {
                    str.append(",");
                }
                str.append(cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]).getName());
            }
            str.append("]");
            NucleusLogger.DATASTORE_RETRIEVE.debug((Object)str);
        }
        ArrayList<String> attributeNameList = new ArrayList<String>();
        for (i = 0; i < fieldNumbers.length; ++i) {
            AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]);
            AbstractMappingStrategy ms = AbstractMappingStrategy.findMappingStrategy(sm, mmd, new BasicAttributes());
            List<String> attributeNames = ms.getAttributeNames();
            attributeNameList.addAll(attributeNames);
        }
        String[] attributeNames = attributeNameList.toArray(new String[0]);
        ManagedConnection mconn = this.storeMgr.getConnection(sm.getObjectManager());
        try {
            long startTime = System.currentTimeMillis();
            if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
                NucleusLogger.DATASTORE_RETRIEVE.debug((Object)LOCALISER.msg("LDAP.Fetch.Start", (Object)StringUtils.toJVMIDString((Object)sm.getObject()), sm.getInternalObjectId()));
            }
            DirContext ctx = (DirContext)mconn.getConnection();
            LdapName dn = LDAPUtils.getDistinguishedNameForObject(sm, true);
            if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
                NucleusLogger.DATASTORE_RETRIEVE.debug((Object)LOCALISER.msg("LDAP.JNDI.getAttributes", (Object)dn, attributeNameList, (Object)""));
            }
            Attributes result = ctx.getAttributes(dn, attributeNames);
            sm.replaceFields(fieldNumbers, (FieldManager)new FetchFieldManager(sm, result));
            if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
                NucleusLogger.DATASTORE_RETRIEVE.debug((Object)LOCALISER.msg("LDAP.ExecutionTime", System.currentTimeMillis() - startTime));
            }
            if (this.storeMgr.getRuntimeManager() != null) {
                this.storeMgr.getRuntimeManager().incrementFetchCount();
            }
        }
        catch (NameNotFoundException e) {
            throw new NucleusObjectNotFoundException("Object not found", sm.getExternalObjectId(sm.getObject()));
        }
        catch (NamingException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
        finally {
            mconn.release();
        }
    }

    public Object findObject(ObjectManager om, Object id) {
        return null;
    }

    public void locateObject(StateManager sm) {
        AbstractClassMetaData cmd = sm.getClassMetaData();
        if (cmd.getIdentityType() == IdentityType.APPLICATION) {
            ManagedConnection mconn = this.storeMgr.getConnection(sm.getObjectManager());
            try {
                long startTime = System.currentTimeMillis();
                if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
                    NucleusLogger.DATASTORE_RETRIEVE.debug((Object)LOCALISER.msg("LDAP.Locate.Start", (Object)StringUtils.toJVMIDString((Object)sm.getObject()), sm.getInternalObjectId()));
                }
                DirContext ctx = (DirContext)mconn.getConnection();
                LdapName dn = LDAPUtils.getDistinguishedNameForObject(sm, true);
                if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
                    NucleusLogger.DATASTORE_RETRIEVE.debug((Object)LOCALISER.msg("LDAP.JNDI.getAttributes", (Object)dn, (Object)"none", (Object)""));
                }
                ctx.getAttributes(dn, LDAPUtils.NO_ATTRIBUTES);
                if (NucleusLogger.DATASTORE_RETRIEVE.isDebugEnabled()) {
                    NucleusLogger.DATASTORE_RETRIEVE.debug((Object)LOCALISER.msg("LDAP.ExecutionTime", System.currentTimeMillis() - startTime));
                }
                return;
            }
            catch (NameNotFoundException e) {
                throw new NucleusObjectNotFoundException("Object not found", sm.getExternalObjectId(sm.getObject()));
            }
            catch (NamingException e) {
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
            finally {
                mconn.release();
            }
        }
        if (cmd.getIdentityType() == IdentityType.DATASTORE) {
            throw new NucleusUserException(LOCALISER.msg("LDAP.DatastoreID"));
        }
    }
}

