/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.ldap.fieldmanager;

import javax.naming.directory.Attributes;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.EmbeddedMetaData;
import org.datanucleus.state.StateManagerFactory;
import org.datanucleus.store.ldap.LDAPUtils;
import org.datanucleus.store.ldap.fieldmanager.AbstractMappingStrategy;

public class EmbeddedMappingStrategy
extends AbstractMappingStrategy {
    protected EmbeddedMappingStrategy(StateManager sm, AbstractMemberMetaData mmd, Attributes attributes) {
        super(sm, mmd, attributes);
    }

    public Object fetch() {
        Object value;
        try {
            value = this.type.newInstance();
        }
        catch (InstantiationException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
        StateManager embeddedSM = this.getEmbeddedStateManager(value);
        AbstractClassMetaData embeddedCmd = embeddedSM.getClassMetaData();
        EmbeddedMetaData embeddedMetaData = this.mmd.getEmbeddedMetaData();
        AbstractMemberMetaData[] memberembededMmds = embeddedMetaData.getMemberMetaData();
        String nullIndicatorColumn = embeddedMetaData.getNullIndicatorColumn();
        String nullIndicatorValue = embeddedMetaData.getNullIndicatorValue();
        for (AbstractMemberMetaData embeddedMmd : memberembededMmds) {
            String fieldName = embeddedMmd.getName();
            String attributeName = LDAPUtils.getAttributeNameForField(embeddedMmd);
            int i = embeddedCmd.getAbsolutePositionOfMember(fieldName);
            if (fieldName.equals(embeddedMetaData.getOwnerMember())) {
                Object embeddedValue = this.sm.getObject();
                embeddedSM.replaceField(i, embeddedValue, true);
                continue;
            }
            AbstractMappingStrategy ms = AbstractMappingStrategy.findMappingStrategy(embeddedSM, embeddedMmd, this.attributes);
            Object embeddedValue = ms.fetch();
            if (nullIndicatorColumn != null && attributeName.equals(nullIndicatorColumn)) {
                if (embeddedValue == null) {
                    value = null;
                    break;
                }
                if (nullIndicatorValue != null && embeddedValue.equals(nullIndicatorValue)) {
                    value = null;
                    break;
                }
            }
            embeddedSM.replaceField(i, embeddedValue, true);
        }
        return value;
    }

    private StateManager getEmbeddedStateManager(Object value) {
        StateManager embeddedSM = this.sm.getObjectManager().findStateManager(value);
        if (embeddedSM == null) {
            embeddedSM = StateManagerFactory.newStateManagerForEmbedded((ObjectManager)this.sm.getObjectManager(), (Object)value, (boolean)false);
            int absoluteFieldNumber = this.sm.getClassMetaData().getMetaDataForMember(this.mmd.getName()).getAbsoluteFieldNumber();
            embeddedSM.addEmbeddedOwner(this.sm, absoluteFieldNumber);
            embeddedSM.setPcObjectType(1);
        }
        return embeddedSM;
    }

    public void insert(Object value) {
        AbstractMemberMetaData[] memberMetaData;
        if (value == null) {
            return;
        }
        StateManager embeddedSM = this.getEmbeddedStateManager(value);
        AbstractClassMetaData embeddedCmd = embeddedSM.getClassMetaData();
        EmbeddedMetaData embeddedMetaData = this.mmd.getEmbeddedMetaData();
        for (AbstractMemberMetaData embeddedMmd : memberMetaData = embeddedMetaData.getMemberMetaData()) {
            String fieldName = embeddedMmd.getName();
            int i = embeddedCmd.getAbsolutePositionOfMember(fieldName);
            if (fieldName.equals(embeddedMetaData.getOwnerMember())) {
                Object embeddedValue = this.sm.getObject();
                embeddedSM.replaceField(i, embeddedValue, true);
                continue;
            }
            AbstractMappingStrategy ms = AbstractMappingStrategy.findMappingStrategy(embeddedSM, embeddedMmd, this.attributes);
            Object embeddedValue = embeddedSM.provideField(i);
            ms.insert(embeddedValue);
        }
    }

    public void update(Object value) {
        AbstractMemberMetaData[] memberMetaData;
        if (value == null) {
            try {
                value = this.type.newInstance();
            }
            catch (InstantiationException e) {
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
        }
        StateManager embeddedSM = this.getEmbeddedStateManager(value);
        AbstractClassMetaData embeddedCmd = embeddedSM.getClassMetaData();
        EmbeddedMetaData embeddedMetaData = this.mmd.getEmbeddedMetaData();
        for (AbstractMemberMetaData embeddedMmd : memberMetaData = embeddedMetaData.getMemberMetaData()) {
            String fieldName = embeddedMmd.getName();
            int i = embeddedCmd.getAbsolutePositionOfMember(fieldName);
            if (fieldName.equals(embeddedMetaData.getOwnerMember())) {
                Object embeddedValue = this.sm.getObject();
                embeddedSM.replaceField(i, embeddedValue, true);
                continue;
            }
            AbstractMappingStrategy ms = AbstractMappingStrategy.findMappingStrategy(embeddedSM, embeddedMmd, this.attributes);
            Object embeddedValue = embeddedSM.provideField(i);
            ms.update(embeddedValue);
        }
    }
}

