/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.ldap;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;
import javax.transaction.xa.XAResource;
import org.datanucleus.ConnectionFactory;
import org.datanucleus.ManagedConnection;
import org.datanucleus.ManagedConnectionResourceListener;
import org.datanucleus.OMFContext;
import org.datanucleus.ObjectManager;
import org.datanucleus.PersistenceConfiguration;
import org.datanucleus.exceptions.NucleusException;

public class ConnectionFactoryImpl
implements ConnectionFactory {
    OMFContext omfContext;

    public ConnectionFactoryImpl(OMFContext omfContext, String resourceType) {
        this.omfContext = omfContext;
    }

    public ManagedConnection getConnection(ObjectManager om, Map options) {
        HashMap addedOptions = new HashMap();
        if (options != null) {
            addedOptions.putAll(options);
        }
        return this.omfContext.getConnectionManager().allocateConnection((ConnectionFactory)this, om, addedOptions);
    }

    public ManagedConnection createManagedConnection(ObjectManager om, Map transactionOptions) {
        return new ManagedConnectionImpl(om.getOMFContext(), transactionOptions);
    }

    public static class ManagedConnectionImpl
    implements ManagedConnection {
        OMFContext omf;
        Map options;
        Object conn;
        boolean locked = false;
        List listeners = new ArrayList();

        public ManagedConnectionImpl(OMFContext omf, Map options) {
            this.omf = omf;
            this.options = options;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            if (this.conn == null) {
                return;
            }
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((ManagedConnectionResourceListener)this.listeners.get(i)).managedConnectionPreClose();
            }
            try {
                try {
                    InitialDirContext ctx = (InitialDirContext)this.conn;
                    ctx.close();
                }
                catch (Exception e) {
                    throw new NucleusException(e.getMessage(), (Throwable)e);
                }
            }
            finally {
                this.conn = null;
                for (int i = 0; i < this.listeners.size(); ++i) {
                    ((ManagedConnectionResourceListener)this.listeners.get(i)).managedConnectionPostClose();
                }
            }
        }

        public void flush() {
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((ManagedConnectionResourceListener)this.listeners.get(i)).managedConnectionFlushed();
            }
        }

        public Object getConnection() {
            if (this.conn == null) {
                try {
                    PersistenceConfiguration conf = this.omf.getPersistenceConfiguration();
                    Hashtable<String, Object> env = new Hashtable<String, Object>();
                    env.put("java.naming.factory.initial", conf.getStringProperty("datanucleus.ConnectionDriverName"));
                    env.put("java.naming.provider.url", conf.getStringProperty("datanucleus.ConnectionURL"));
                    env.put("java.naming.security.principal", conf.getStringProperty("datanucleus.ConnectionUserName"));
                    env.put("java.naming.security.credentials", conf.getStringProperty("datanucleus.ConnectionPassword"));
                    if ("JNDI".equals(conf.getStringProperty("datanucleus.connectionPoolingType"))) {
                        int size;
                        env.put("com.sun.jndi.ldap.connect.pool", "true");
                        if (conf.hasProperty("datanucleus.connectionPool.maxPoolSize") && (size = conf.getIntProperty("datanucleus.connectionPool.maxPoolSize")) >= 0) {
                            env.put("com.sun.jndi.ldap.connect.pool.maxsize", new Integer(size));
                        }
                        if (conf.hasProperty("datanucleus.connectionPool.initialPoolSize") && (size = conf.getIntProperty("datanucleus.connectionPool.initialPoolSize")) >= 0) {
                            env.put("com.sun.jndi.ldap.connect.pool.initsize", new Integer(size));
                        }
                    }
                    this.conn = new InitialDirContext(env);
                }
                catch (NamingException e) {
                    throw new NucleusException(e.getMessage(), (Throwable)e);
                }
            }
            return this.conn;
        }

        public XAResource getXAResource() {
            return null;
        }

        public boolean isLocked() {
            return this.locked;
        }

        public void lock() {
            this.locked = true;
        }

        public void unlock() {
            this.locked = false;
        }

        public void release() {
        }

        public void addListener(ManagedConnectionResourceListener listener) {
            this.listeners.add(listener);
        }

        public void removeListener(ManagedConnectionResourceListener listener) {
            this.listeners.remove(listener);
        }

        public void setManagedResource() {
        }
    }
}

