/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.json.fieldmanager;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusObjectNotFoundException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.identity.IdentityUtils;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.FieldPersistenceModifier;
import org.datanucleus.metadata.FieldRole;
import org.datanucleus.metadata.JdbcType;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.query.QueryUtils;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.fieldmanager.AbstractFetchFieldManager;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.json.CloudStorageUtils;
import org.datanucleus.store.json.fieldmanager.FetchEmbeddedFieldManager;
import org.datanucleus.store.json.orgjson.JSONArray;
import org.datanucleus.store.json.orgjson.JSONException;
import org.datanucleus.store.json.orgjson.JSONObject;
import org.datanucleus.store.schema.table.MemberColumnMapping;
import org.datanucleus.store.schema.table.Table;
import org.datanucleus.store.types.SCOUtils;
import org.datanucleus.store.types.converters.MultiColumnConverter;
import org.datanucleus.store.types.converters.TypeConverter;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.TypeConversionHelper;

public class FetchFieldManager
extends AbstractFetchFieldManager {
    protected final Table table;
    protected final JSONObject jsonobj;
    protected final StoreManager storeMgr;

    public FetchFieldManager(ExecutionContext ec, AbstractClassMetaData cmd, JSONObject jsonobj, Table table) {
        super(ec, cmd);
        this.jsonobj = jsonobj;
        this.storeMgr = ec.getStoreManager();
        this.table = table;
    }

    public FetchFieldManager(ObjectProvider op, JSONObject jsonobj, Table table) {
        super(op);
        this.jsonobj = jsonobj;
        this.storeMgr = this.ec.getStoreManager();
        this.table = table;
    }

    protected MemberColumnMapping getColumnMapping(int fieldNumber) {
        return this.table.getMemberColumnMappingForMember(this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber));
    }

    public boolean fetchBooleanField(int fieldNumber) {
        String memberName = this.getColumnMapping(fieldNumber).getColumn(0).getName();
        if (this.jsonobj.isNull(memberName)) {
            return false;
        }
        try {
            return this.jsonobj.getBoolean(memberName);
        }
        catch (JSONException e) {
            return false;
        }
    }

    public byte fetchByteField(int fieldNumber) {
        String memberName = this.getColumnMapping(fieldNumber).getColumn(0).getName();
        if (this.jsonobj.isNull(memberName)) {
            return 0;
        }
        try {
            String str = this.jsonobj.getString(memberName);
            return Byte.valueOf(str);
        }
        catch (JSONException e) {
            return 0;
        }
    }

    public char fetchCharField(int fieldNumber) {
        String memberName = this.getColumnMapping(fieldNumber).getColumn(0).getName();
        if (this.jsonobj.isNull(memberName)) {
            return '\u0000';
        }
        try {
            return this.jsonobj.getString(memberName).charAt(0);
        }
        catch (JSONException e) {
            return '\u0000';
        }
    }

    public double fetchDoubleField(int fieldNumber) {
        String memberName = this.getColumnMapping(fieldNumber).getColumn(0).getName();
        if (this.jsonobj.isNull(memberName)) {
            return 0.0;
        }
        try {
            return this.jsonobj.getDouble(memberName);
        }
        catch (JSONException e) {
            return 0.0;
        }
    }

    public float fetchFloatField(int fieldNumber) {
        String memberName = this.getColumnMapping(fieldNumber).getColumn(0).getName();
        if (this.jsonobj.isNull(memberName)) {
            return 0.0f;
        }
        try {
            return (float)this.jsonobj.getDouble(memberName);
        }
        catch (JSONException e) {
            return 0.0f;
        }
    }

    public int fetchIntField(int fieldNumber) {
        String memberName = this.getColumnMapping(fieldNumber).getColumn(0).getName();
        if (this.jsonobj.isNull(memberName)) {
            return 0;
        }
        try {
            return this.jsonobj.getInt(memberName);
        }
        catch (JSONException e) {
            return 0;
        }
    }

    public long fetchLongField(int fieldNumber) {
        String memberName = this.getColumnMapping(fieldNumber).getColumn(0).getName();
        if (this.jsonobj.isNull(memberName)) {
            return 0L;
        }
        try {
            return this.jsonobj.getLong(memberName);
        }
        catch (JSONException e) {
            return 0L;
        }
    }

    public short fetchShortField(int fieldNumber) {
        String memberName = this.getColumnMapping(fieldNumber).getColumn(0).getName();
        if (this.jsonobj.isNull(memberName)) {
            return 0;
        }
        try {
            return (short)this.jsonobj.getInt(memberName);
        }
        catch (JSONException e) {
            return 0;
        }
    }

    public String fetchStringField(int fieldNumber) {
        String memberName = this.getColumnMapping(fieldNumber).getColumn(0).getName();
        if (this.jsonobj.isNull(memberName)) {
            return null;
        }
        try {
            return this.jsonobj.getString(memberName);
        }
        catch (JSONException e) {
            return null;
        }
    }

    public Object fetchObjectField(int fieldNumber) {
        AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (mmd.getPersistenceModifier() != FieldPersistenceModifier.PERSISTENT) {
            return this.op.provideField(fieldNumber);
        }
        ClassLoaderResolver clr = this.ec.getClassLoaderResolver();
        RelationType relationType = mmd.getRelationType(clr);
        if (relationType != RelationType.NONE && MetaDataUtils.getInstance().isMemberEmbedded(this.ec.getMetaDataManager(), clr, mmd, relationType, null)) {
            try {
                return this.fetchObjectFieldEmbedded(fieldNumber, mmd, clr, relationType);
            }
            catch (JSONException e) {
                throw new NucleusException(e.getMessage(), (Throwable)e);
            }
        }
        try {
            return this.fetchObjectFieldInternal(fieldNumber, mmd, clr, relationType);
        }
        catch (JSONException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
    }

    protected Object fetchObjectFieldEmbedded(int fieldNumber, AbstractMemberMetaData mmd, ClassLoaderResolver clr, RelationType relationType) throws JSONException {
        if (RelationType.isRelationSingleValued((RelationType)relationType)) {
            boolean nested = CloudStorageUtils.isMemberNested(mmd);
            AbstractClassMetaData embCmd = this.ec.getMetaDataManager().getMetaDataForClass(mmd.getType(), clr);
            ArrayList<AbstractMemberMetaData> embMmds = new ArrayList<AbstractMemberMetaData>();
            embMmds.add(mmd);
            if (nested) {
                String name;
                MemberColumnMapping mapping = this.getColumnMapping(fieldNumber);
                String string = name = mapping != null ? mapping.getColumn(0).getName() : mmd.getName();
                if (this.jsonobj.isNull(name)) {
                    return null;
                }
                JSONObject embobj = this.jsonobj.getJSONObject(name);
                NucleusLogger.PERSISTENCE.warn((Object)("Member " + mmd.getFullFieldName() + " marked as embedded NESTED; This is experimental : " + embobj));
                ObjectProvider embOP = this.ec.getNucleusContext().getObjectProviderFactory().newForEmbedded(this.ec, embCmd, this.op, fieldNumber);
                FetchEmbeddedFieldManager fetchEmbFM = new FetchEmbeddedFieldManager(embOP, embobj, embMmds, this.table);
                embOP.replaceFields(embCmd.getAllMemberPositions(), (FieldManager)fetchEmbFM);
                return embOP.getObject();
            }
            ObjectProvider embOP = this.ec.getNucleusContext().getObjectProviderFactory().newForEmbedded(this.ec, embCmd, this.op, fieldNumber);
            FetchEmbeddedFieldManager fetchEmbFM = new FetchEmbeddedFieldManager(embOP, this.jsonobj, embMmds, this.table);
            embOP.replaceFields(embCmd.getAllMemberPositions(), (FieldManager)fetchEmbFM);
            return embOP.getObject();
        }
        if (RelationType.isRelationMultiValued((RelationType)relationType)) {
            throw new NucleusUserException("Dont support embedded multi-valued field at " + mmd.getFullFieldName() + " with Excel");
        }
        return null;
    }

    protected Object fetchObjectFieldInternal(int fieldNumber, AbstractMemberMetaData mmd, ClassLoaderResolver clr, RelationType relationType) throws JSONException {
        boolean optional = false;
        if (Optional.class.isAssignableFrom(mmd.getType())) {
            if (relationType != RelationType.NONE) {
                relationType = RelationType.ONE_TO_ONE_UNI;
            }
            optional = true;
        }
        MemberColumnMapping mapping = this.getColumnMapping(fieldNumber);
        if (relationType == RelationType.NONE) {
            Class type;
            Object returnValue = null;
            if (mapping.getTypeConverter() != null) {
                TypeConverter conv = mapping.getTypeConverter();
                if (mapping.getNumberOfColumns() > 1) {
                    boolean isNull = true;
                    Object[] valuesArr = null;
                    Class[] colTypes = ((MultiColumnConverter)conv).getDatastoreColumnTypes();
                    valuesArr = colTypes[0] == Integer.TYPE ? new int[mapping.getNumberOfColumns()] : (colTypes[0] == Long.TYPE ? (Object[])new long[mapping.getNumberOfColumns()] : (colTypes[0] == Double.TYPE ? (Object[])new double[mapping.getNumberOfColumns()] : (colTypes[0] == Float.TYPE ? (Object[])new double[mapping.getNumberOfColumns()] : (colTypes[0] == String.class ? (Object[])new String[mapping.getNumberOfColumns()] : (Object[])new Object[mapping.getNumberOfColumns()]))));
                    for (int i = 0; i < mapping.getNumberOfColumns(); ++i) {
                        String colName = mapping.getColumn(i).getName();
                        if (colTypes[i] == String.class) {
                            Array.set(valuesArr, i, this.jsonobj.getString(colName));
                            continue;
                        }
                        if (colTypes[i] == Boolean.class) {
                            Array.set(valuesArr, i, this.jsonobj.getBoolean(colName));
                            continue;
                        }
                        if (colTypes[i] == Double.class) {
                            Array.set(valuesArr, i, this.jsonobj.getDouble(colName));
                            continue;
                        }
                        if (colTypes[i] == Float.class) {
                            Array.set(valuesArr, i, Float.valueOf((float)this.jsonobj.getDouble(colName)));
                            continue;
                        }
                        if (colTypes[i] == Integer.class) {
                            Array.set(valuesArr, i, this.jsonobj.getInt(colName));
                            continue;
                        }
                        if (colTypes[i] == Long.class) {
                            Array.set(valuesArr, i, this.jsonobj.getLong(colName));
                            continue;
                        }
                        if (colTypes[i] == Double.TYPE) {
                            Array.set(valuesArr, i, this.jsonobj.getDouble(colName));
                            continue;
                        }
                        if (colTypes[i] == Float.TYPE) {
                            Array.set(valuesArr, i, this.jsonobj.getDouble(colName));
                            continue;
                        }
                        if (colTypes[i] == Integer.TYPE) {
                            Array.set(valuesArr, i, this.jsonobj.getInt(colName));
                            continue;
                        }
                        if (colTypes[i] != Long.TYPE) continue;
                        Array.set(valuesArr, i, this.jsonobj.getLong(colName));
                    }
                    if (isNull) {
                        return null;
                    }
                    Object memberValue = conv.toMemberType((Object)valuesArr);
                    if (this.op != null && memberValue != null) {
                        memberValue = SCOUtils.wrapSCOField((ObjectProvider)this.op, (int)fieldNumber, (Object)memberValue, (boolean)true);
                    }
                    return memberValue;
                }
                String colName = mapping.getColumn(0).getName();
                if (this.jsonobj.isNull(colName)) {
                    return null;
                }
                Class datastoreType = this.ec.getTypeManager().getDatastoreTypeForTypeConverter(conv, mmd.getType());
                if (datastoreType == String.class) {
                    returnValue = conv.toMemberType((Object)this.jsonobj.getString(colName));
                } else if (datastoreType == Boolean.class) {
                    returnValue = conv.toMemberType((Object)this.jsonobj.getBoolean(colName));
                } else if (datastoreType == Double.class) {
                    returnValue = conv.toMemberType((Object)this.jsonobj.getDouble(colName));
                } else if (datastoreType == Float.class) {
                    returnValue = conv.toMemberType((Object)this.jsonobj.getDouble(colName));
                } else if (datastoreType == Integer.class) {
                    returnValue = conv.toMemberType((Object)this.jsonobj.getInt(colName));
                } else if (datastoreType == Long.class) {
                    returnValue = conv.toMemberType((Object)this.jsonobj.getLong(colName));
                }
                if (this.op != null) {
                    returnValue = SCOUtils.wrapSCOField((ObjectProvider)this.op, (int)mmd.getAbsoluteFieldNumber(), (Object)returnValue, (boolean)true);
                }
                return returnValue;
            }
            String colName = mapping.getColumn(0).getName();
            Class clazz = type = optional ? clr.classForName(mmd.getCollection().getElementType()) : mmd.getType();
            if (this.jsonobj.isNull(colName)) {
                return optional ? Optional.empty() : null;
            }
            if (Boolean.class.isAssignableFrom(type)) {
                boolean val = this.jsonobj.getBoolean(colName);
                return optional ? Optional.of(val) : Boolean.valueOf(val);
            }
            if (Integer.class.isAssignableFrom(type)) {
                int val = this.jsonobj.getInt(colName);
                return optional ? Optional.of(val) : Integer.valueOf(val);
            }
            if (Long.class.isAssignableFrom(type)) {
                long val = this.jsonobj.getLong(colName);
                return optional ? Optional.of(val) : Long.valueOf(val);
            }
            if (Double.class.isAssignableFrom(type)) {
                double val = this.jsonobj.getDouble(colName);
                return optional ? Optional.of(val) : Double.valueOf(val);
            }
            if (String.class.isAssignableFrom(type)) {
                String val = (String)this.jsonobj.get(colName);
                return optional ? Optional.of(val) : val;
            }
            if (Enum.class.isAssignableFrom(type)) {
                JdbcType jdbcType = TypeConversionHelper.getJdbcTypeForEnum((AbstractMemberMetaData)mmd, (FieldRole)FieldRole.ROLE_FIELD, (ClassLoaderResolver)clr);
                Object datastoreValue = null;
                datastoreValue = MetaDataUtils.isJdbcTypeNumeric((JdbcType)jdbcType) ? Integer.valueOf(this.jsonobj.getInt(colName)) : this.jsonobj.get(colName);
                datastoreValue = TypeConversionHelper.getEnumForStoredValue((AbstractMemberMetaData)mmd, (FieldRole)FieldRole.ROLE_FIELD, (Object)datastoreValue, (ClassLoaderResolver)clr);
                return optional ? Optional.of(datastoreValue) : datastoreValue;
            }
            if (BigDecimal.class.isAssignableFrom(type) || BigInteger.class.isAssignableFrom(type)) {
                Optional<Object> val = TypeConversionHelper.convertTo((Object)this.jsonobj.get(colName), (Class)type);
                return optional ? Optional.of(val) : val;
            }
            if (Collection.class.isAssignableFrom(type)) {
                Collection coll;
                try {
                    Class instanceType = SCOUtils.getContainerInstanceType((Class)type, (Boolean)(mmd.getOrderMetaData() != null ? 1 : 0));
                    coll = (Collection)instanceType.newInstance();
                }
                catch (Exception e) {
                    throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
                }
                JSONArray array = this.jsonobj.getJSONArray(colName);
                Class elementCls = null;
                if (mmd.getCollection() != null && mmd.getCollection().getElementType() != null) {
                    elementCls = clr.classForName(mmd.getCollection().getElementType());
                }
                for (int i = 0; i < array.length(); ++i) {
                    if (array.isNull(i)) {
                        coll.add(null);
                        continue;
                    }
                    Object value = array.get(i);
                    if (value instanceof JSONObject) {
                        Class cls = clr.classForName(((JSONObject)value).getString("class"), true);
                        coll.add(this.getNonpersistableObjectFromJSON((JSONObject)value, cls, clr));
                        continue;
                    }
                    if (elementCls != null) {
                        coll.add(TypeConversionHelper.convertTo((Object)value, (Class)elementCls));
                        continue;
                    }
                    coll.add(value);
                }
                Collection val = optional ? (coll == null ? Optional.empty() : Optional.of(coll)) : coll;
                return this.op != null ? SCOUtils.wrapSCOField((ObjectProvider)this.op, (int)mmd.getAbsoluteFieldNumber(), (Object)val, (boolean)true) : val;
            }
            if (Map.class.isAssignableFrom(mmd.getType())) {
                Map map;
                try {
                    Class instanceType = SCOUtils.getContainerInstanceType((Class)mmd.getType(), (Boolean)false);
                    map = (Map)instanceType.newInstance();
                }
                catch (Exception e) {
                    throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
                }
                JSONObject mapValue = this.jsonobj.getJSONObject(colName);
                Iterator keyIter = mapValue.keys();
                Class keyCls = null;
                if (mmd.getMap() != null && mmd.getMap().getKeyType() != null) {
                    keyCls = clr.classForName(mmd.getMap().getKeyType());
                }
                Class valCls = null;
                if (mmd.getMap() != null && mmd.getMap().getValueType() != null) {
                    valCls = clr.classForName(mmd.getMap().getValueType());
                }
                while (keyIter.hasNext()) {
                    Object jsonVal;
                    Object jsonKey;
                    Object key = jsonKey = keyIter.next();
                    if (keyCls != null) {
                        key = TypeConversionHelper.convertTo(jsonKey, (Class)keyCls);
                    }
                    Object val = jsonVal = mapValue.get((String)key);
                    if (jsonVal instanceof JSONObject) {
                        Class cls = clr.classForName(((JSONObject)jsonVal).getString("class"), true);
                        val = this.getNonpersistableObjectFromJSON((JSONObject)jsonVal, cls, clr);
                    } else if (valCls != null) {
                        val = TypeConversionHelper.convertTo((Object)jsonVal, (Class)valCls);
                    }
                    map.put(key, val);
                }
                if (this.op != null) {
                    SCOUtils.wrapSCOField((ObjectProvider)this.op, (int)mmd.getAbsoluteFieldNumber(), (Object)map, (boolean)true);
                }
                return map;
            }
            if (mmd.getType().isArray()) {
                JSONArray arrayJson = this.jsonobj.getJSONArray(colName);
                Object array = Array.newInstance(mmd.getType().getComponentType(), arrayJson.length());
                for (int i = 0; i < arrayJson.length(); ++i) {
                    if (arrayJson.isNull(i)) {
                        Array.set(array, i, null);
                        continue;
                    }
                    Object value = arrayJson.get(i);
                    if (value instanceof JSONObject) {
                        JSONObject valueJson = (JSONObject)value;
                        Class valueCls = clr.classForName(valueJson.getString("class"));
                        Array.set(array, i, this.getNonpersistableObjectFromJSON((JSONObject)value, valueCls, clr));
                        continue;
                    }
                    Array.set(array, i, TypeConversionHelper.convertTo((Object)value, mmd.getType().getComponentType()));
                }
                return array;
            }
            boolean useLong = MetaDataUtils.isJdbcTypeNumeric((JdbcType)mapping.getColumn(0).getJdbcType());
            TypeConverter strConv = this.ec.getNucleusContext().getTypeManager().getTypeConverterForType(mmd.getType(), String.class);
            TypeConverter longConv = this.ec.getNucleusContext().getTypeManager().getTypeConverterForType(mmd.getType(), Long.class);
            if (useLong && longConv != null) {
                returnValue = longConv.toMemberType((Object)this.jsonobj.getLong(colName));
            } else if (!useLong && strConv != null) {
                returnValue = strConv.toMemberType(this.jsonobj.get(colName));
            } else if (!useLong && longConv != null) {
                returnValue = longConv.toMemberType((Object)this.jsonobj.getLong(colName));
            } else {
                Object value = this.jsonobj.get(colName);
                if (value instanceof JSONObject) {
                    Class cls = clr.classForName(((JSONObject)value).getString("class"), true);
                    returnValue = this.getNonpersistableObjectFromJSON((JSONObject)value, cls, clr);
                } else {
                    returnValue = TypeConversionHelper.convertTo((Object)this.jsonobj.get(colName), (Class)mmd.getType());
                }
            }
            if (this.op != null) {
                SCOUtils.wrapSCOField((ObjectProvider)this.op, (int)mmd.getAbsoluteFieldNumber(), (Object)returnValue, (boolean)true);
            }
            return returnValue;
        }
        if (RelationType.isRelationSingleValued((RelationType)relationType)) {
            String colName = mapping.getColumn(0).getName();
            if (this.jsonobj.isNull(colName)) {
                return optional ? Optional.empty() : null;
            }
            String idStr = (String)this.jsonobj.get(colName);
            Object obj = null;
            Class memberType = optional ? clr.classForName(mmd.getCollection().getElementType()) : mmd.getType();
            AbstractClassMetaData memberCmd = this.ec.getMetaDataManager().getMetaDataForClass(memberType, clr);
            try {
                obj = memberCmd.usesSingleFieldIdentityClass() && idStr.indexOf(58) > 0 ? IdentityUtils.getObjectFromPersistableIdentity((String)idStr, (AbstractClassMetaData)memberCmd, (ExecutionContext)this.ec) : IdentityUtils.getObjectFromIdString((String)idStr, (AbstractClassMetaData)memberCmd, (ExecutionContext)this.ec, (boolean)true);
                return optional ? Optional.of(obj) : obj;
            }
            catch (NucleusObjectNotFoundException nfe) {
                NucleusLogger.GENERAL.warn((Object)("Object=" + this.op + " field=" + mmd.getFullFieldName() + " has id=" + idStr + " but could not instantiate object with that identity"));
                return optional ? Optional.empty() : null;
            }
        }
        if (RelationType.isRelationMultiValued((RelationType)relationType)) {
            String colName = mapping.getColumn(0).getName();
            if (this.jsonobj.isNull(colName)) {
                return null;
            }
            if (mmd.hasCollection()) {
                List newColl;
                Collection coll;
                JSONArray array = (JSONArray)this.jsonobj.get(colName);
                try {
                    Class instanceType = SCOUtils.getContainerInstanceType((Class)mmd.getType(), (Boolean)(mmd.getOrderMetaData() != null ? 1 : 0));
                    coll = (Collection)instanceType.newInstance();
                }
                catch (Exception e) {
                    throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
                }
                boolean changeDetected = false;
                AbstractClassMetaData elementCmd = mmd.getCollection().getElementClassMetaData(this.ec.getClassLoaderResolver());
                for (int i = 0; i < array.length(); ++i) {
                    String idStr = (String)array.get(i);
                    try {
                        Object element = null;
                        element = elementCmd.usesSingleFieldIdentityClass() && idStr.indexOf(58) > 0 ? IdentityUtils.getObjectFromPersistableIdentity((String)idStr, (AbstractClassMetaData)elementCmd, (ExecutionContext)this.ec) : IdentityUtils.getObjectFromIdString((String)idStr, (AbstractClassMetaData)elementCmd, (ExecutionContext)this.ec, (boolean)true);
                        coll.add(element);
                        continue;
                    }
                    catch (NucleusObjectNotFoundException nfe) {
                        changeDetected = true;
                    }
                }
                if (coll instanceof List && mmd.getOrderMetaData() != null && mmd.getOrderMetaData().getOrdering() != null && !mmd.getOrderMetaData().getOrdering().equals("#PK") && (newColl = QueryUtils.orderCandidates((List)((List)coll), (Class)clr.classForName(mmd.getCollection().getElementType()), (String)mmd.getOrderMetaData().getOrdering(), (ExecutionContext)this.ec, (ClassLoaderResolver)clr)).getClass() != coll.getClass()) {
                    coll.clear();
                    coll.addAll(newColl);
                }
                if (this.op != null) {
                    coll = (Collection)SCOUtils.wrapSCOField((ObjectProvider)this.op, (int)mmd.getAbsoluteFieldNumber(), (Object)coll, (boolean)true);
                    if (changeDetected) {
                        this.op.makeDirty(mmd.getAbsoluteFieldNumber());
                    }
                }
                return coll;
            }
            if (mmd.hasArray()) {
                JSONArray jsonArr = (JSONArray)this.jsonobj.get(colName);
                Object array = Array.newInstance(mmd.getType().getComponentType(), jsonArr.length());
                boolean changeDetected = false;
                int pos = 0;
                AbstractClassMetaData elementCmd = mmd.getCollection().getElementClassMetaData(this.ec.getClassLoaderResolver());
                for (int i = 0; i < jsonArr.length(); ++i) {
                    try {
                        String idStr = (String)jsonArr.get(i);
                        Object element = null;
                        element = elementCmd.usesSingleFieldIdentityClass() && idStr.indexOf(58) > 0 ? IdentityUtils.getObjectFromPersistableIdentity((String)idStr, (AbstractClassMetaData)elementCmd, (ExecutionContext)this.ec) : IdentityUtils.getObjectFromIdString((String)idStr, (AbstractClassMetaData)elementCmd, (ExecutionContext)this.ec, (boolean)true);
                        Array.set(array, pos++, element);
                        continue;
                    }
                    catch (NucleusObjectNotFoundException nfe) {
                        changeDetected = true;
                    }
                }
                if (changeDetected) {
                    if (pos < Array.getLength(array)) {
                        Object arrayOld = array;
                        array = Array.newInstance(mmd.getType().getComponentType(), pos);
                        for (int j = 0; j < pos; ++j) {
                            Array.set(array, j, Array.get(arrayOld, j));
                        }
                    }
                    if (this.op != null) {
                        array = SCOUtils.wrapSCOField((ObjectProvider)this.op, (int)mmd.getAbsoluteFieldNumber(), (Object)array, (boolean)true);
                        if (changeDetected) {
                            this.op.makeDirty(mmd.getAbsoluteFieldNumber());
                        }
                    }
                }
                return array;
            }
            if (mmd.hasMap()) {
                Map map;
                JSONObject mapVal = (JSONObject)this.jsonobj.get(colName);
                try {
                    Class instanceType = SCOUtils.getContainerInstanceType((Class)mmd.getType(), (Boolean)false);
                    map = (Map)instanceType.newInstance();
                }
                catch (Exception e) {
                    throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
                }
                AbstractClassMetaData keyCmd = mmd.getMap().getKeyClassMetaData(clr);
                AbstractClassMetaData valCmd = mmd.getMap().getValueClassMetaData(clr);
                boolean changeDetected = false;
                Iterator keyIter = mapVal.keys();
                while (keyIter.hasNext()) {
                    Object val;
                    Object key;
                    boolean valSet;
                    boolean keySet;
                    block111: {
                        block110: {
                            keySet = true;
                            valSet = true;
                            Object jsonKey = keyIter.next();
                            key = null;
                            if (keyCmd != null) {
                                try {
                                    String idStr = (String)jsonKey;
                                    if (keyCmd.usesSingleFieldIdentityClass() && idStr.indexOf(58) > 0) {
                                        key = IdentityUtils.getObjectFromPersistableIdentity((String)idStr, (AbstractClassMetaData)keyCmd, (ExecutionContext)this.ec);
                                        break block110;
                                    }
                                    key = IdentityUtils.getObjectFromIdString((String)idStr, (AbstractClassMetaData)keyCmd, (ExecutionContext)this.ec, (boolean)true);
                                }
                                catch (NucleusObjectNotFoundException nfe) {
                                    changeDetected = true;
                                    keySet = false;
                                }
                            } else {
                                Class keyCls = this.ec.getClassLoaderResolver().classForName(mmd.getMap().getKeyType());
                                key = TypeConversionHelper.convertTo(jsonKey, (Class)keyCls);
                            }
                        }
                        Object jsonVal = mapVal.get((String)key);
                        val = null;
                        if (valCmd != null) {
                            try {
                                String idStr = (String)jsonVal;
                                if (valCmd.usesSingleFieldIdentityClass() && idStr.indexOf(58) > 0) {
                                    val = IdentityUtils.getObjectFromPersistableIdentity((String)idStr, (AbstractClassMetaData)valCmd, (ExecutionContext)this.ec);
                                    break block111;
                                }
                                val = IdentityUtils.getObjectFromIdString((String)idStr, (AbstractClassMetaData)valCmd, (ExecutionContext)this.ec, (boolean)true);
                            }
                            catch (NucleusObjectNotFoundException nfe) {
                                changeDetected = true;
                                valSet = false;
                            }
                        } else {
                            Class valCls = this.ec.getClassLoaderResolver().classForName(mmd.getMap().getValueType());
                            val = TypeConversionHelper.convertTo((Object)jsonVal, (Class)valCls);
                        }
                    }
                    if (!keySet || !valSet) continue;
                    map.put(key, val);
                }
                if (this.op != null) {
                    map = (Map)SCOUtils.wrapSCOField((ObjectProvider)this.op, (int)mmd.getAbsoluteFieldNumber(), (Object)map, (boolean)true);
                    if (changeDetected) {
                        this.op.makeDirty(mmd.getAbsoluteFieldNumber());
                    }
                }
                return map;
            }
        }
        throw new NucleusException("Dont currently support field " + mmd.getFullFieldName() + " of type " + mmd.getTypeName());
    }

    private Object getNonpersistableObjectFromJSON(final JSONObject jsonobj, final Class cls, ClassLoaderResolver clr) {
        if (cls.getName().equals("com.google.appengine.api.users.User")) {
            return this.getComGoogleAppengineApiUsersUserFromJSON(jsonobj, cls, clr);
        }
        if (cls.getName().equals("com.google.appengine.api.datastore.Key")) {
            return this.getComGoogleAppengineApiDatastoreKeyFromJSON(jsonobj, cls, clr);
        }
        try {
            return AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        Constructor c = ClassUtils.getConstructorWithArguments((Class)cls, (Class[])new Class[0]);
                        c.setAccessible(true);
                        Object obj = c.newInstance(new Object[0]);
                        String[] fieldNames = JSONObject.getNames(jsonobj);
                        for (int i = 0; i < jsonobj.length(); ++i) {
                            if (fieldNames[i].equals("class")) continue;
                            Field field = cls.getField(fieldNames[i]);
                            field.setAccessible(true);
                            field.set(obj, jsonobj.get(fieldNames[i]));
                        }
                        return obj;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return null;
                    }
                }
            });
        }
        catch (SecurityException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    protected Object getComGoogleAppengineApiUsersUserFromJSON(JSONObject jsonobj, Class cls, ClassLoaderResolver clr) {
        String email = null;
        String authDomain = null;
        try {
            email = jsonobj.getString("email");
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            authDomain = jsonobj.getString("authDomain");
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return ClassUtils.newInstance((Class)cls, (Class[])new Class[]{String.class, String.class}, (Object[])new String[]{email, authDomain});
    }

    protected Object getComGoogleAppengineApiDatastoreKeyFromJSON(JSONObject jsonobj, Class cls, ClassLoaderResolver clr) {
        try {
            Object parent = null;
            if (jsonobj.has("parent") && !jsonobj.isNull("parent")) {
                JSONObject parentobj = jsonobj.getJSONObject("parent");
                parent = this.getNonpersistableObjectFromJSON(parentobj, clr.classForName(jsonobj.getString("class")), clr);
            }
            if (jsonobj.has("appId")) {
                String appId = jsonobj.getString("appId");
                String kind = jsonobj.getString("kind");
                Class keyFactory = clr.classForName("com.google.appengine.api.datastore.KeyFactory", cls.getClassLoader(), false);
                if (parent != null) {
                    return ClassUtils.getMethodForClass((Class)keyFactory, (String)"createKey", (Class[])new Class[]{cls, String.class, String.class}).invoke(null, parent, kind, appId);
                }
                return ClassUtils.getMethodForClass((Class)keyFactory, (String)"createKey", (Class[])new Class[]{String.class, String.class}).invoke(null, kind, appId);
            }
            long id = jsonobj.getLong("id");
            String kind = jsonobj.getString("kind");
            Class keyFactory = clr.classForName("com.google.appengine.api.datastore.KeyFactory", cls.getClassLoader(), false);
            if (parent != null) {
                return ClassUtils.getMethodForClass((Class)keyFactory, (String)"createKey", (Class[])new Class[]{cls, String.class, Long.TYPE}).invoke(null, parent, kind, id);
            }
            return ClassUtils.getMethodForClass((Class)keyFactory, (String)"createKey", (Class[])new Class[]{String.class, Long.TYPE}).invoke(null, kind, id);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

