/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.json;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.FetchPlan;
import org.datanucleus.ObjectManager;
import org.datanucleus.PersistenceConfiguration;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.store.FieldValues;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.json.AmazonS3Utils;
import org.datanucleus.store.json.JSONLogger;
import org.datanucleus.store.json.JsonPersistenceHandler;
import org.datanucleus.store.json.fieldmanager.FetchFieldManager;
import org.datanucleus.store.json.fieldmanager.InsertFieldManager;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class AmazonS3PersistenceHandler
extends JsonPersistenceHandler {
    AmazonS3PersistenceHandler(StoreManager storeMgr) {
        super(storeMgr);
    }

    public void insertObject(StateManager sm) {
        this.storeMgr.assertReadOnlyForUpdateOfObject(sm);
        Properties options = new Properties();
        ((Hashtable)options).put("org.datanucleus.store.json.url", "/");
        ManagedConnection mconn = this.storeMgr.getConnection(sm.getObjectManager(), (Map)options);
        URLConnection conn = (URLConnection)mconn.getConnection();
        this.createBucket(conn, this.getHeaderForBucket());
        int[] fieldNumbers = sm.getClassMetaData().getAllMemberPositions();
        ((Hashtable)options).put("org.datanucleus.store.json.url", this.getURLPath(sm));
        mconn = this.storeMgr.getConnection(sm.getObjectManager(), (Map)options);
        conn = (URLConnection)mconn.getConnection();
        JSONObject jsonobj = new JSONObject();
        sm.provideFields(fieldNumbers, (FieldManager)new InsertFieldManager(sm, jsonobj));
        sm.provideFields(sm.getClassMetaData().getPKMemberPositions(), (FieldManager)new InsertFieldManager(sm, jsonobj));
        this.write("PUT", conn.getURL().getPath(), conn, jsonobj, this.getHeaders("PUT", options));
    }

    protected void createBucket(URLConnection conn, Map headers) {
        try {
            if (JSONLogger.LOGGER.isDebugEnabled()) {
                JSONLogger.LOGGER.debug((Object)"Creating bucket. ");
            }
            HttpURLConnection http = (HttpURLConnection)conn;
            Iterator iterator = headers.keySet().iterator();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                String value = (String)headers.get(key);
                http.setRequestProperty(key, value);
            }
            http.setRequestProperty("Content-Length", "0");
            http.setDoOutput(true);
            http.setRequestMethod("PUT");
            http.setReadTimeout(10000);
            http.setConnectTimeout(10000);
            http.connect();
            int code = http.getResponseCode();
            if (code >= 400) {
                int r;
                StringBuffer sb = new StringBuffer();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                while ((r = http.getErrorStream().read(buffer)) != -1) {
                    baos.write(buffer, 0, r);
                }
                sb.append(new String(baos.toByteArray()));
                http.getErrorStream().close();
                throw new NucleusDataStoreException("HTTP Error code: " + code + " " + http.getResponseMessage() + " error: " + sb.toString());
            }
            if (code >= 300) {
                throw new NucleusDataStoreException("Redirect not supported. HTTP Error code: " + code + " " + http.getResponseMessage());
            }
        }
        catch (IOException e) {
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
    }

    protected Map getHeaders(String httpVerb, Map options) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Date", AmazonS3Utils.getHTTPDate());
        String contentMD5 = "";
        String contentType = "";
        PersistenceConfiguration conf = this.storeMgr.getOMFContext().getPersistenceConfiguration();
        String urlStr = conf.getStringProperty("datanucleus.ConnectionURL");
        String awsKey = conf.getStringProperty("datanucleus.ConnectionUserName");
        String awsSecretKey = conf.getStringProperty("datanucleus.ConnectionPassword");
        try {
            urlStr = urlStr.substring(urlStr.indexOf(this.storeMgr.getStoreManagerKey() + ":") + this.storeMgr.getStoreManagerKey().length() + 1);
            headers.put("Host", this.getBucket() + "." + new URL(urlStr).getHost());
            String path = "/" + this.getBucket();
            if (options.containsKey("org.datanucleus.store.json.url")) {
                if (!options.get("org.datanucleus.store.json.url").toString().startsWith("/")) {
                    path = path + "/";
                }
                path = options.get("org.datanucleus.store.json.url").toString().indexOf("?") > -1 ? path + options.get("org.datanucleus.store.json.url").toString().substring(0, options.get("org.datanucleus.store.json.url").toString().indexOf("?")) : path + options.get("org.datanucleus.store.json.url").toString();
            } else {
                path = path + new URL(urlStr).getPath();
            }
            String stringToSign = httpVerb + "\n" + contentMD5 + "\n" + contentType + "\n" + headers.get("Date") + "\n" + path;
            headers.put("Authorization", "AWS " + awsKey + ":" + AmazonS3Utils.hmac(awsSecretKey, stringToSign));
        }
        catch (MalformedURLException e) {
            throw new NucleusException(e.getMessage(), (Throwable)e);
        }
        return headers;
    }

    protected Map getHeaderForBucket() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Date", AmazonS3Utils.getHTTPDate());
        String contentMD5 = "";
        String contentType = "";
        String httpVerb = "PUT";
        PersistenceConfiguration conf = this.storeMgr.getOMFContext().getPersistenceConfiguration();
        String urlStr = conf.getStringProperty("datanucleus.ConnectionURL");
        String awsKey = conf.getStringProperty("datanucleus.ConnectionUserName");
        String awsSecretKey = conf.getStringProperty("datanucleus.ConnectionPassword");
        try {
            urlStr = urlStr.substring(urlStr.indexOf(this.storeMgr.getStoreManagerKey() + ":") + this.storeMgr.getStoreManagerKey().length() + 1);
            headers.put("Host", this.getBucket() + "." + new URL(urlStr).getHost());
            String stringToSign = httpVerb + "\n" + contentMD5 + "\n" + contentType + "\n" + headers.get("Date") + "\n" + "/" + this.getBucket() + "/";
            headers.put("Authorization", "AWS " + awsKey + ":" + AmazonS3Utils.hmac(awsSecretKey, stringToSign));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return headers;
    }

    public List getObjectsOfCandidateType(ObjectManager om, ManagedConnection mconn, Class candidateClass, boolean ignoreCache, Map options) {
        ArrayList<Object> results = new ArrayList<Object>();
        try {
            JSONArray jsonarray;
            URLConnection conn = (URLConnection)mconn.getConnection();
            ClassLoaderResolver clr = om.getClassLoaderResolver();
            final AbstractClassMetaData cmd = om.getMetaDataManager().getMetaDataForClass(candidateClass, clr);
            try {
                HttpURLConnection http = (HttpURLConnection)conn;
                Map headers = this.getHeaders("GET", options);
                Iterator iterator = headers.keySet().iterator();
                while (iterator.hasNext()) {
                    String key = (String)iterator.next();
                    String value = (String)headers.get(key);
                    http.setRequestProperty(key, value);
                }
                http.setDoInput(true);
                http.setRequestMethod("GET");
                http.setReadTimeout(10000);
                http.setConnectTimeout(10000);
                http.connect();
                int code = http.getResponseCode();
                if (code == 404) {
                    return Collections.EMPTY_LIST;
                }
                this.handleHTTPErrorCode(http);
                StringBuffer sb = new StringBuffer();
                if (http.getContentLength() > 0) {
                    for (int i = 0; i < http.getContentLength(); ++i) {
                        sb.append((char)http.getInputStream().read());
                    }
                } else {
                    int r;
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    byte[] buffer = new byte[1024];
                    while ((r = http.getInputStream().read(buffer)) != -1) {
                        baos.write(buffer, 0, r);
                    }
                    sb.append(new String(baos.toByteArray()));
                }
                http.getInputStream().close();
                String contentType = http.getHeaderField("content-type");
                if (contentType != null && (contentType.equalsIgnoreCase("application/xml") || contentType.equalsIgnoreCase("text/xml"))) {
                    Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(sb.toString().getBytes()));
                    NodeList list = doc.getElementsByTagName("Contents");
                    HashSet<JSONObject> set = new HashSet<JSONObject>();
                    for (int i = 0; i < list.getLength(); ++i) {
                        String key;
                        Element el = (Element)list.item(i);
                        JSONObject object = new JSONObject();
                        String keyText = el.getElementsByTagName("Key").item(0).getTextContent();
                        if (keyText.indexOf("/") < 1 || (key = keyText.substring(keyText.indexOf("/", 1) + 1)).length() < 1) continue;
                        String className = keyText.substring(0, keyText.indexOf("/"));
                        object.put("class", className);
                        object.put(cmd.getPrimaryKeyMemberNames()[0], key);
                        set.add(object);
                    }
                    jsonarray = new JSONArray(set);
                } else {
                    jsonarray = new JSONArray(sb.toString());
                }
            }
            catch (IOException e) {
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
            catch (JSONException e) {
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
            catch (SAXException e) {
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
            catch (ParserConfigurationException e) {
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
            for (int i = 0; i < jsonarray.length(); ++i) {
                final JSONObject json = jsonarray.getJSONObject(i);
                results.add(om.findObjectUsingAID(clr.classForName(cmd.getFullClassName()), new FieldValues(){

                    public void fetchFields(StateManager sm) {
                        sm.replaceFields(cmd.getPKMemberPositions(), (FieldManager)new FetchFieldManager(sm, json));
                    }

                    public void fetchNonLoadedFields(StateManager sm) {
                        sm.replaceNonLoadedFields(cmd.getPKMemberPositions(), (FieldManager)new FetchFieldManager(sm, json));
                    }

                    public FetchPlan getFetchPlanForLoading() {
                        return null;
                    }
                }, ignoreCache, true));
            }
        }
        catch (JSONException je) {
            je.printStackTrace();
        }
        return results;
    }

    public String getURLPathForQuery(AbstractClassMetaData acmd) {
        String url = acmd.getValueForExtension("url");
        if (url == null) {
            url = acmd.getFullClassName();
        }
        url = "?prefix=" + url;
        return url;
    }

    private String getBucket() {
        PersistenceConfiguration conf = this.storeMgr.getOMFContext().getPersistenceConfiguration();
        return conf.getStringProperty("datanucleus.json.amazons3.bucket");
    }
}

