/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.json;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.transaction.xa.XAResource;
import org.datanucleus.ConnectionFactory;
import org.datanucleus.ManagedConnection;
import org.datanucleus.ManagedConnectionResourceListener;
import org.datanucleus.OMFContext;
import org.datanucleus.ObjectManager;
import org.datanucleus.PersistenceConfiguration;
import org.datanucleus.exceptions.NucleusDataStoreException;

public class ConnectionFactoryImpl
implements ConnectionFactory {
    public static final String STORE_JSON_URL = "org.datanucleus.store.json.url";
    OMFContext omfContext;

    public ConnectionFactoryImpl(OMFContext omfContext, String resourceType) {
        this.omfContext = omfContext;
    }

    public ManagedConnection getConnection(ObjectManager om, Map options) {
        HashMap addedOptions = new HashMap();
        if (options != null) {
            addedOptions.putAll(options);
        }
        return this.omfContext.getConnectionManager().allocateConnection((ConnectionFactory)this, om, addedOptions);
    }

    public ManagedConnection createManagedConnection(ObjectManager om, Map transactionOptions) {
        return new ManagedConnectionImpl(om.getOMFContext(), transactionOptions);
    }

    public static class ManagedConnectionImpl
    implements ManagedConnection {
        OMFContext omf;
        Map options;

        public ManagedConnectionImpl(OMFContext omf, Map options) {
            this.omf = omf;
            this.options = options;
        }

        public void addListener(ManagedConnectionResourceListener listener) {
        }

        public void close() {
        }

        public void flush() {
        }

        public Object getConnection() {
            PersistenceConfiguration conf = this.omf.getPersistenceConfiguration();
            String urlStr = conf.getStringProperty("datanucleus.ConnectionURL");
            urlStr = urlStr.substring(urlStr.indexOf("json:") + 5);
            if (this.options.containsKey(ConnectionFactoryImpl.STORE_JSON_URL)) {
                urlStr = urlStr + this.options.get(ConnectionFactoryImpl.STORE_JSON_URL);
            }
            try {
                URL url = new URL(urlStr);
                return url.openConnection();
            }
            catch (MalformedURLException e) {
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
            }
        }

        public XAResource getXAResource() {
            return null;
        }

        public boolean isLocked() {
            return false;
        }

        public void lock() {
        }

        public void release() {
        }

        public void removeListener(ManagedConnectionResourceListener listener) {
        }

        public void setManagedResource() {
        }

        public void unlock() {
        }
    }
}

