/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.jpa;

import java.util.Map;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.LoadState;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.ProviderUtil;
import org.datanucleus.jpa.EntityManagerFactoryImpl;
import org.datanucleus.jpa.JPAAdapter;
import org.datanucleus.jpa.exceptions.NoPersistenceUnitException;
import org.datanucleus.jpa.exceptions.NoPersistenceXmlException;
import org.datanucleus.jpa.exceptions.NotProviderException;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.ObjectProvider;

public class PersistenceProviderImpl
implements PersistenceProvider,
ProviderUtil {
    public EntityManagerFactory createContainerEntityManagerFactory(PersistenceUnitInfo unitInfo, Map properties) {
        try {
            EntityManagerFactoryImpl emf = new EntityManagerFactoryImpl(unitInfo, properties);
            return emf;
        }
        catch (NotProviderException npe) {
            return null;
        }
        catch (NoPersistenceUnitException npue) {
            return null;
        }
        catch (NoPersistenceXmlException npxe) {
            return null;
        }
    }

    public EntityManagerFactory createEntityManagerFactory(String unitName, Map properties) {
        try {
            EntityManagerFactoryImpl emf = new EntityManagerFactoryImpl(unitName, properties);
            return emf;
        }
        catch (NotProviderException npe) {
            return null;
        }
        catch (NoPersistenceUnitException npue) {
            return null;
        }
        catch (NoPersistenceXmlException npxe) {
            return null;
        }
    }

    public LoadState isLoadedWithoutReference(Object entity, String memberName) {
        if (entity == null) {
            return LoadState.UNKNOWN;
        }
        JPAAdapter adapter = new JPAAdapter();
        ExecutionContext ec = adapter.getExecutionContext(entity);
        if (ec == null) {
            return LoadState.UNKNOWN;
        }
        ObjectProvider sm = ec.findObjectProvider(entity);
        if (sm == null) {
            return LoadState.UNKNOWN;
        }
        String[] loadedFields = sm.getLoadedFieldNames();
        if (loadedFields != null) {
            for (int i = 0; i < loadedFields.length; ++i) {
                if (!loadedFields[i].equals(memberName)) continue;
                return LoadState.LOADED;
            }
        }
        return LoadState.NOT_LOADED;
    }

    public LoadState isLoadedWithReference(Object entity, String memberName) {
        return this.isLoadedWithoutReference(entity, memberName);
    }

    public LoadState isLoaded(Object entity) {
        if (entity == null) {
            return LoadState.UNKNOWN;
        }
        return null;
    }

    public ProviderUtil getProviderUtil() {
        return this;
    }
}

