/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.geospatial.rdbms.mapping.pg2mysql;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.schema.SQLTypeInfo;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.store.types.geospatial.rdbms.adapter.MySQLSpatialTypeInfo;
import org.datanucleus.store.types.geospatial.rdbms.mapping.mysql.MySQLSpatialColumnMapping;
import org.postgis.Geometry;
import org.postgis.Version;
import org.postgis.binary.BinaryParser;
import org.postgis.binary.BinaryWriter;

public class GeometryColumnMapping
extends MySQLSpatialColumnMapping {
    protected final BinaryWriter writer = new BinaryWriter();
    protected final BinaryParser parser = new BinaryParser();
    private static final SQLTypeInfo typeInfo = (SQLTypeInfo)MySQLSpatialTypeInfo.TYPEINFO_PROTOTYPE.clone();

    public GeometryColumnMapping(JavaTypeMapping mapping, RDBMSStoreManager storeMgr, Column col) {
        super(mapping, storeMgr, col);
    }

    public int getJDBCType() {
        return typeInfo.getDataType();
    }

    public SQLTypeInfo getTypeInfo() {
        return typeInfo;
    }

    public Object getObject(ResultSet rs, int exprIndex) {
        Geometry value;
        try {
            byte[] mysqlBinary = rs.getBytes(exprIndex);
            if (rs.wasNull() || mysqlBinary == null) {
                value = null;
            } else {
                value = this.parser.parse(this.mysqlBinaryToWkb(mysqlBinary));
                value.setSrid(this.mysqlBinaryToSrid(mysqlBinary));
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(this.failureMessage("getObject", exprIndex, e), (Throwable)e);
        }
        return value;
    }

    public void setObject(PreparedStatement ps, int exprIndex, Object value) {
        try {
            if (value == null) {
                ps.setNull(exprIndex, this.getTypeInfo().getDataType(), this.getTypeInfo().getTypeName());
            } else {
                Geometry geom = (Geometry)value;
                int srid = geom.getSrid();
                if (0 < srid || 0 == srid && 2 > Version.MAJOR) {
                    geom.srid = 1 < Version.MAJOR ? 0 : -1;
                }
                byte[] wkb = this.writer.writeBinary(geom, (byte)1);
                if (srid > 0) {
                    geom.srid = srid;
                }
                ps.setBytes(exprIndex, this.wkbToMysqlBinary(wkb, srid));
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(this.failureMessage("setObject", value, e), (Throwable)e);
        }
    }

    static {
        typeInfo.setTypeName("GEOMETRY");
        typeInfo.setLocalTypeName("GEOMETRY");
    }
}

