/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.geospatial.rdbms.mapping;

import java.awt.geom.Ellipse2D;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.ExecutionContext;
import org.datanucleus.NucleusContext;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.mapping.java.SingleFieldMultiMapping;
import org.datanucleus.store.rdbms.table.Table;

public class Ellipse2dFloatMapping
extends SingleFieldMultiMapping {
    public void initialize(AbstractMemberMetaData fmd, Table table, ClassLoaderResolver clr) {
        super.initialize(fmd, table, clr);
        this.addColumns();
    }

    public void initialize(RDBMSStoreManager storeMgr, String type) {
        super.initialize(storeMgr, type);
        this.addColumns();
    }

    protected void addColumns() {
        this.addColumns(ClassNameConstants.FLOAT);
        this.addColumns(ClassNameConstants.FLOAT);
        this.addColumns(ClassNameConstants.FLOAT);
        this.addColumns(ClassNameConstants.FLOAT);
    }

    public Class getJavaType() {
        return Ellipse2D.Float.class;
    }

    public Object getValueForColumnMapping(NucleusContext nucleusCtx, int index, Object value) {
        Ellipse2D.Float el = (Ellipse2D.Float)value;
        if (index == 0) {
            return el.getX();
        }
        if (index == 1) {
            return el.getY();
        }
        if (index == 2) {
            return el.getWidth();
        }
        if (index == 3) {
            return el.getHeight();
        }
        throw new IndexOutOfBoundsException();
    }

    public void setObject(ExecutionContext ec, PreparedStatement ps, int[] exprIndex, Object value) {
        Ellipse2D.Float ellipse = (Ellipse2D.Float)value;
        if (ellipse == null) {
            for (int i = 0; i < exprIndex.length; ++i) {
                this.getColumnMapping(i).setObject(ps, exprIndex[i], null);
            }
        } else {
            this.getColumnMapping(0).setFloat(ps, exprIndex[0], ellipse.x);
            this.getColumnMapping(1).setFloat(ps, exprIndex[1], ellipse.y);
            this.getColumnMapping(2).setFloat(ps, exprIndex[2], ellipse.width);
            this.getColumnMapping(3).setFloat(ps, exprIndex[3], ellipse.height);
        }
    }

    public Object getObject(ExecutionContext ec, ResultSet resultSet, int[] exprIndex) {
        if (this.getColumnMapping(0).getObject(resultSet, exprIndex[0]) == null) {
            return null;
        }
        float x = this.getColumnMapping(0).getFloat(resultSet, exprIndex[0]);
        float y = this.getColumnMapping(1).getFloat(resultSet, exprIndex[1]);
        float width = this.getColumnMapping(2).getFloat(resultSet, exprIndex[2]);
        float height = this.getColumnMapping(3).getFloat(resultSet, exprIndex[3]);
        return new Ellipse2D.Float(x, y, width, height);
    }
}

