/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.geospatial.rdbms.mapping;

import java.awt.geom.CubicCurve2D;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.ExecutionContext;
import org.datanucleus.NucleusContext;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.mapping.java.SingleFieldMultiMapping;
import org.datanucleus.store.rdbms.table.Table;

public class CubicCurve2dFloatMapping
extends SingleFieldMultiMapping {
    public void initialize(AbstractMemberMetaData fmd, Table table, ClassLoaderResolver clr) {
        super.initialize(fmd, table, clr);
        this.addColumns();
    }

    public void initialize(RDBMSStoreManager storeMgr, String type) {
        super.initialize(storeMgr, type);
        this.addColumns();
    }

    protected void addColumns() {
        this.addColumns(ClassNameConstants.FLOAT);
        this.addColumns(ClassNameConstants.FLOAT);
        this.addColumns(ClassNameConstants.FLOAT);
        this.addColumns(ClassNameConstants.FLOAT);
        this.addColumns(ClassNameConstants.FLOAT);
        this.addColumns(ClassNameConstants.FLOAT);
        this.addColumns(ClassNameConstants.FLOAT);
        this.addColumns(ClassNameConstants.FLOAT);
    }

    public Class getJavaType() {
        return CubicCurve2D.Float.class;
    }

    public Object getValueForColumnMapping(NucleusContext nucleusCtx, int index, Object value) {
        CubicCurve2D.Float cc = (CubicCurve2D.Float)value;
        if (index == 0) {
            return cc.getX1();
        }
        if (index == 1) {
            return cc.getY1();
        }
        if (index == 2) {
            return cc.getCtrlX1();
        }
        if (index == 3) {
            return cc.getCtrlY1();
        }
        if (index == 4) {
            return cc.getCtrlX2();
        }
        if (index == 5) {
            return cc.getCtrlY2();
        }
        if (index == 6) {
            return cc.getX2();
        }
        if (index == 7) {
            return cc.getY2();
        }
        throw new IndexOutOfBoundsException();
    }

    public void setObject(ExecutionContext ec, PreparedStatement ps, int[] exprIndex, Object value) {
        CubicCurve2D.Float cubicCurve = (CubicCurve2D.Float)value;
        if (cubicCurve == null) {
            for (int i = 0; i < exprIndex.length; ++i) {
                this.getColumnMapping(i).setObject(ps, exprIndex[i], null);
            }
        } else {
            this.getColumnMapping(0).setFloat(ps, exprIndex[0], cubicCurve.x1);
            this.getColumnMapping(1).setFloat(ps, exprIndex[1], cubicCurve.y1);
            this.getColumnMapping(2).setFloat(ps, exprIndex[2], cubicCurve.ctrlx1);
            this.getColumnMapping(3).setFloat(ps, exprIndex[3], cubicCurve.ctrly1);
            this.getColumnMapping(4).setFloat(ps, exprIndex[4], cubicCurve.ctrlx2);
            this.getColumnMapping(5).setFloat(ps, exprIndex[5], cubicCurve.ctrly2);
            this.getColumnMapping(6).setFloat(ps, exprIndex[6], cubicCurve.x2);
            this.getColumnMapping(7).setFloat(ps, exprIndex[7], cubicCurve.y2);
        }
    }

    public Object getObject(ExecutionContext ec, ResultSet resultSet, int[] exprIndex) {
        if (this.getColumnMapping(0).getObject(resultSet, exprIndex[0]) == null) {
            return null;
        }
        float x1 = this.getColumnMapping(0).getFloat(resultSet, exprIndex[0]);
        float y1 = this.getColumnMapping(1).getFloat(resultSet, exprIndex[1]);
        float ctrlx1 = this.getColumnMapping(2).getFloat(resultSet, exprIndex[2]);
        float ctrly1 = this.getColumnMapping(3).getFloat(resultSet, exprIndex[3]);
        float ctrlx2 = this.getColumnMapping(4).getFloat(resultSet, exprIndex[4]);
        float ctrly2 = this.getColumnMapping(5).getFloat(resultSet, exprIndex[5]);
        float x2 = this.getColumnMapping(6).getFloat(resultSet, exprIndex[6]);
        float y2 = this.getColumnMapping(7).getFloat(resultSet, exprIndex[7]);
        return new CubicCurve2D.Float(x1, y1, ctrlx1, ctrly1, ctrlx2, ctrly2, x2, y2);
    }
}

