/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.geospatial.rdbms.mapping.pg2postgis;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.mapping.column.AbstractColumnMapping;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.schema.SQLTypeInfo;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.store.types.geospatial.rdbms.adapter.PostGISTypeInfo;
import org.postgis.Geometry;
import org.postgis.PGgeometry;

public class GeometryColumnMapping
extends AbstractColumnMapping {
    private static final SQLTypeInfo typeInfo = (SQLTypeInfo)PostGISTypeInfo.TYPEINFO_PROTOTYPE.clone();

    public GeometryColumnMapping(JavaTypeMapping mapping, RDBMSStoreManager storeMgr, Column col) {
        super(storeMgr, mapping);
        this.column = col;
        this.initialize();
    }

    private void initialize() {
        this.initTypeInfo();
    }

    public int getJDBCType() {
        return typeInfo.getDataType();
    }

    public SQLTypeInfo getTypeInfo() {
        return typeInfo;
    }

    public Object getObject(ResultSet rs, int exprIndex) {
        Geometry value;
        try {
            Object result = rs.getObject(exprIndex);
            value = rs.wasNull() || result == null ? null : ((PGgeometry)result).getGeometry();
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(this.failureMessage("getObject", exprIndex, e), (Throwable)e);
        }
        return value;
    }

    public void setObject(PreparedStatement ps, int exprIndex, Object value) {
        try {
            if (value == null) {
                ps.setNull(exprIndex, this.getTypeInfo().getDataType(), this.getTypeInfo().getTypeName());
            } else {
                PGgeometry obj = new PGgeometry((Geometry)value);
                ps.setObject(exprIndex, obj);
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(this.failureMessage("setObject", value, e), (Throwable)e);
        }
    }

    static {
        typeInfo.setLocalTypeName("GEOMETRY");
    }
}

